/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.MetaDataUtil;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.DescribeTable;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.TableNameHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;

public class SqlDescribeTable
extends ObjectDepthFirst
implements IXDBSql,
IExecutable {
    private XDBSessionContext client;
    private String tableName;

    public SqlDescribeTable(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    public Object visit(DescribeTable describeTable, Object object) {
        Object var3_3 = null;
        describeTable.f0.accept(this, object);
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        describeTable.f1.accept(tableNameHandler, object);
        this.tableName = tableNameHandler.getTableName();
        return var3_3;
    }

    public long getCost() {
        return 1L;
    }

    public LockSpecification getLockSpecs() {
        LockSpecification lockSpecification = new LockSpecification(new Vector(), new Vector());
        return lockSpecification;
    }

    public Collection getNodeList() {
        return Collections.EMPTY_LIST;
    }

    public ExecutionResult execute(Engine engine) throws Exception {
        if (this.client.getSysDatabase().isTableExists(this.tableName)) {
            return ExecutionResult.createResultSetResult(27, MetaDataUtil.getDescribeTable(this.tableName, this.client));
        }
        if (this.client.getSysDatabase().isViewExists(this.tableName)) {
            return ExecutionResult.createResultSetResult(27, MetaDataUtil.getDescribeView(this.tableName, this.client));
        }
        XDBServerException xDBServerException = new XDBServerException("Object " + this.tableName + " has not been found in database " + this.client.getDBName());
        throw xDBServerException;
    }

    public boolean needCoordinatorConnection() {
        return false;
    }
}

