/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.MultinodeExecutor;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncCreateTablespace;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.CreateTablespace;
import com.edb.gridsql.parser.core.syntaxtree.NodeListOptional;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.NodeToken;
import com.edb.gridsql.parser.core.syntaxtree.TablespaceLocation;
import com.edb.gridsql.parser.core.syntaxtree.stringLiteral;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCreateTableSpace
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlCreateTableSpace.class);
    private XDBSessionContext client;
    private SysDatabase database;
    private String tablespaceName;
    private HashMap<DBNode, String> locations;
    private HashMap<DBNode, String> statements = null;
    private HashMap<DBNode, String> rollbackStatements = null;

    public SqlCreateTableSpace(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public Object visit(CreateTablespace createTablespace, Object object) {
        this.tablespaceName = (String)createTablespace.f2.accept(new IdentifierHandler(), object);
        createTablespace.f3.accept(this, object);
        createTablespace.f4.accept(this, object);
        return null;
    }

    @Override
    public Object visit(TablespaceLocation tablespaceLocation, Object object) {
        Collection<DBNode> collection;
        String string = (String)tablespaceLocation.f1.accept(this, object);
        Collection<DBNode> collection2 = this.database.getDBNodeList();
        switch (tablespaceLocation.f3.which) {
            default: {
                collection = collection2;
            }
            case 1: 
        }
        collection = new ArrayList<DBNode>(collection2.size());
        NodeSequence nodeSequence = (NodeSequence)tablespaceLocation.f3.choice;
        NodeToken object22 = (NodeToken)nodeSequence.elementAt(1);
        int n = Integer.parseInt(object22.tokenImage);
        collection.add(this.database.getDBNode(n));
        for (Object e : ((NodeListOptional)nodeSequence.elementAt((int)2)).nodes) {
            NodeSequence nodeSequence2 = (NodeSequence)e;
            n = Integer.parseInt(((NodeToken)nodeSequence2.nodes.get((int)1)).tokenImage);
            collection.add(this.database.getDBNode(n));
        }
        if (this.locations == null) {
            this.locations = new HashMap();
        }
        for (DBNode dBNode : collection) {
            if (this.locations.put(dBNode, string) == null) continue;
            throw new XDBServerException("Duplicate NodeID: " + dBNode.getNodeId());
        }
        return null;
    }

    @Override
    public Object visit(stringLiteral stringLiteral2, Object object) {
        return stringLiteral2.f0.tokenImage;
    }

    public String getName() {
        return this.tablespaceName;
    }

    public Map<DBNode, String> getLocations() {
        return this.locations;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return this.locations.keySet();
    }

    @Override
    public boolean isPrepared() {
        return this.statements != null;
    }

    @Override
    public void prepare() throws Exception {
        if (this.client.getCurrentUser().getUserClass() != 0) {
            throw new XDBSecurityException("Only DBA user can create tablespaces");
        }
        if (MetaData.getMetaData().hasTablespace(this.tablespaceName)) {
            throw new XDBServerException("Tablespace \"" + this.tablespaceName + "\" already exists");
        }
        this.statements = new HashMap();
        this.rollbackStatements = new HashMap();
        for (Map.Entry<DBNode, String> entry : this.locations.entrySet()) {
            DBNode dBNode = entry.getKey();
            String string = "CREATE TABLESPACE " + IdentifierHandler.quote(this.tablespaceName + "_" + dBNode.getNodeId()) + " LOCATION " + entry.getValue();
            this.statements.put(dBNode, string);
            this.rollbackStatements.put(dBNode, "DROP TABLESPACE " + IdentifierHandler.quote(this.tablespaceName + "_" + dBNode.getNodeId()));
        }
    }

    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        MultinodeExecutor multinodeExecutor = this.client.getMultinodeExecutor(this.getNodeList());
        SyncCreateTablespace syncCreateTablespace = new SyncCreateTablespace(this);
        MetaData metaData = MetaData.getMetaData();
        metaData.beginTransaction();
        try {
            syncCreateTablespace.execute(this.client);
            multinodeExecutor.executeCommand(this.statements, true);
            metaData.commitTransaction(syncCreateTablespace);
        }
        catch (Exception exception) {
            logger.catching(exception);
            metaData.rollbackTransaction();
            try {
                multinodeExecutor.executeCommand(this.rollbackStatements, true);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            logger.throwing(exception);
            throw exception;
        }
        return ExecutionResult.createSuccessResult(12);
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

