/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncAlterOwner;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysUser;
import com.edb.gridsql.parser.SqlAlterTable;
import com.edb.gridsql.parser.core.syntaxtree.OwnerDef;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;

public class SqlAlterOwner
extends ObjectDepthFirst
implements IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterOwner.class);
    private XDBSessionContext client;
    private SysDatabase database;
    private SqlAlterTable parent;
    private SysUser user = null;
    private boolean prepared = false;

    public SqlAlterOwner(SqlAlterTable sqlAlterTable, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
        this.parent = sqlAlterTable;
    }

    public Object visit(OwnerDef ownerDef, Object object) {
        Object var3_3 = null;
        if (ownerDef.f1.which == 1) {
            this.user = this.database.getSysUser((String)ownerDef.f1.accept(new IdentifierHandler(), object));
        }
        return var3_3;
    }

    public SqlAlterTable getParent() {
        return this.parent;
    }

    public SysUser getUser() {
        return this.user;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws Exception {
        if (!this.isPrepared()) {
            if (this.getParent().getTable().getParentTable() != null) {
                throw new XDBServerException("Owner of child table can not be changed");
            }
            if (this.client.getCurrentUser().getUserClass() != 0 && this.client.getCurrentUser() != this.parent.getTable().getOwner()) {
                XDBSecurityException xDBSecurityException = new XDBSecurityException("Only DBA or owner can change table ownership");
                logger.throwing(xDBSecurityException);
                throw xDBSecurityException;
            }
            if (this.user != null && this.user.getUserClass() == 2) {
                XDBSecurityException xDBSecurityException = new XDBSecurityException("STANDARD user can not own table");
                logger.throwing(xDBSecurityException);
                throw xDBSecurityException;
            }
            this.prepared = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        SyncAlterOwner syncAlterOwner = new SyncAlterOwner(this);
        MetaData metaData = MetaData.getMetaData();
        metaData.beginTransaction();
        try {
            syncAlterOwner.execute(this.client);
            metaData.commitTransaction(syncAlterOwner);
        }
        catch (Exception exception) {
            logger.catching(exception);
            metaData.rollbackTransaction();
            throw exception;
        }
        ExecutionResult executionResult = null;
        return executionResult;
    }
}

