/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.SyncAlterTableCheck;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.SqlAlterTable;
import com.edb.gridsql.parser.core.syntaxtree.CheckDef;
import com.edb.gridsql.parser.core.syntaxtree.Constraint;
import com.edb.gridsql.parser.core.syntaxtree.SQLComplexExpression;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.QueryConditionHandler;
import com.edb.gridsql.parser.handler.QueryTreeTracker;

public class SqlAlterAddCheck
extends ObjectDepthFirst
implements IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterAddCheck.class);
    private XDBSessionContext client;
    private SqlAlterTable parent;
    private String constraintName = null;
    private String checkDef;
    private String[] commands;

    public SqlAlterAddCheck(SqlAlterTable sqlAlterTable, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.parent = sqlAlterTable;
    }

    public Object visit(Constraint constraint, Object object) {
        this.constraintName = (String)constraint.f1.accept(new IdentifierHandler(), object);
        return null;
    }

    public Object visit(SQLComplexExpression sQLComplexExpression, Object object) {
        QueryConditionHandler queryConditionHandler = new QueryConditionHandler(new Command(4, this, new QueryTreeTracker(), this.client));
        sQLComplexExpression.accept(queryConditionHandler, object);
        this.checkDef = queryConditionHandler.aRootCondition.getCondString();
        return null;
    }

    public Object visit(CheckDef checkDef, Object object) {
        this.checkDef = checkDef.f2.str;
        return null;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getCheckDef() {
        return this.checkDef;
    }

    public SqlAlterTable getParent() {
        return this.parent;
    }

    public boolean isPrepared() {
        return this.commands != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws Exception {
        this.parent.getTable().checkPermission(this.client.getCurrentUser(), (short)6);
        if (this.constraintName == null) {
            this.constraintName = "CHK_" + this.parent.getTableName().toUpperCase();
        }
        String string = "ADD CONSTRAINT " + IdentifierHandler.quote(this.constraintName) + " CHECK (" + this.checkDef + ")";
        this.parent.addCommonCommand(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult execute(Engine engine) throws Exception {
        if (this.commands != null && this.commands.length != 0) {
            engine.executeDDLOnMultipleNodes(this.commands, this.parent.getNodeList(), (IMetaDataUpdate)new SyncAlterTableCheck(this), this.client);
        }
        ExecutionResult executionResult = null;
        return executionResult;
    }
}

