/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.Scheduler;
import com.edb.gridsql.parser.SqlCreateTable;
import com.edb.gridsql.parser.SqlCreateTableColumn;

public class SyncTempCreateTable
implements IMetaDataUpdate {
    private XDBSessionContext client;
    private SysDatabase database;
    SqlCreateTable aSqlCreateTable;
    SysTable createdTable;
    static final int MIN_TEMP_TABLE_ID = 0x7FFFF000;
    static final int MAX_TEMP_TABLE_ID = Integer.MAX_VALUE;
    static final int MIN_COLUMN_ID = 0x7FFFF000;
    static final int MAX_COLUMNID = Integer.MAX_VALUE;
    static int tempTableID = 0x7FFFF000;
    static int tempColumnID = 0x7FFFF000;

    public SyncTempCreateTable(SqlCreateTable sqlCreateTable) {
        this.aSqlCreateTable = sqlCreateTable;
    }

    public void execute(XDBSessionContext xDBSessionContext) throws Exception {
        this.client = xDBSessionContext;
        this.database = MetaData.getMetaData().getSysDatabase(xDBSessionContext.getDBName());
        int n = this.getNextTempTableID(this.database);
        SysTable sysTable = new SysTable(this.database, n, this.aSqlCreateTable.getTableName(), 0L, this.aSqlCreateTable.getPartScheme(), this.aSqlCreateTable.partColumn, xDBSessionContext.getCurrentUser(), -1, -1, null);
        int n2 = -1;
        for (SqlCreateTableColumn sqlCreateTableColumn : this.aSqlCreateTable.columnDefinitions) {
            SysColumn sysColumn = new SysColumn(sysTable, this.getNextColumnID(), ++n2, sqlCreateTableColumn.columnName, sqlCreateTableColumn.getColumnType(), sqlCreateTableColumn.getColumnLength() > 0 ? sqlCreateTableColumn.getColumnLength() : 0, sqlCreateTableColumn.getColumnScale() > 0 ? sqlCreateTableColumn.getColumnScale() : 0, sqlCreateTableColumn.getColumnPrecision() > 0 ? sqlCreateTableColumn.getColumnPrecision() : 0, sqlCreateTableColumn.isnullable != 0, sqlCreateTableColumn.isSerial(), sqlCreateTableColumn.rebuildString(), 1.0, "");
            sysTable.addSysColumn(sysColumn);
        }
        sysTable.setPartitionMap(this.aSqlCreateTable.getPartitionMap());
        this.createdTable = sysTable;
        this.database.addSysTempTable(sysTable);
        this.refresh();
        sysTable.refreshAssociatedInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        Scheduler scheduler = this.database.getScheduler();
        synchronized (scheduler) {
            this.database.getLm().add(this.createdTable, this.client);
        }
    }

    private int getNextTempTableID(SysDatabase sysDatabase) {
        int n = 0;
        n = tempTableID++;
        if (tempTableID >= Integer.MAX_VALUE) {
            tempTableID = 0x7FFFF000;
            n = 0x7FFFF000;
        }
        int n2 = 0;
        while (sysDatabase.getSysTable(n) != null) {
            ++n;
            if (tempTableID >= Integer.MAX_VALUE) {
                tempTableID = 0x7FFFF000;
                n = 0x7FFFF000;
            }
            if (++n2 <= 4095) continue;
            throw new XDBServerException("Out of temp table name space");
        }
        tempTableID = n;
        return n;
    }

    private int getNextColumnID() {
        if (tempColumnID >= Integer.MAX_VALUE) {
            tempColumnID = 0x7FFFF000;
            return tempColumnID;
        }
        return ++tempColumnID;
    }
}

