/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.engine.loader.EDBWriter;
import com.edb.gridsql.engine.loader.INodeWriter;
import com.edb.gridsql.engine.loader.INodeWriterFactory;
import com.edb.gridsql.engine.loader.Loader;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDBWriterFactory
implements INodeWriterFactory {
    private NodeDBConnectionInfo[] nodeDBConnectionInfos;
    private String template;
    private Map<String, String> params;

    @Override
    public INodeWriter createWriter(int n) throws IOException {
        if (this.nodeDBConnectionInfos == null) {
            throw new IOException("Can not create Writer: no database connection info");
        }
        for (NodeDBConnectionInfo nodeDBConnectionInfo : this.nodeDBConnectionInfos) {
            if (nodeDBConnectionInfo.getNodeID() != n) continue;
            return new EDBWriter(nodeDBConnectionInfo, this.template, this.params);
        }
        throw new IOException("Can not create Writer: no database connection info for Node " + n);
    }

    @Override
    public void close() {
    }

    @Override
    public NodeDBConnectionInfo[] getNodeConnectionInfos() {
        return this.nodeDBConnectionInfos;
    }

    @Override
    public void setNodeConnectionInfos(NodeDBConnectionInfo[] nodeDBConnectionInfoArray) {
        this.nodeDBConnectionInfos = nodeDBConnectionInfoArray;
    }

    @Override
    public void setParams(Loader.DATA_SOURCE dATA_SOURCE, Map<String, String> map) {
        this.template = dATA_SOURCE == Loader.DATA_SOURCE.CSV ? Props.XDB_LOADER_EDBWRITER_CSV_TEMPLATE : Props.XDB_LOADER_EDBWRITER_TEMPLATE;
        this.params = map;
    }
}

