/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.common.util;

import com.edb.gridsql.common.ColumnMetaData;
import com.edb.gridsql.common.ResultSetImpl;
import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.SQLErrorHandler;
import com.edb.gridsql.common.util.XDBServerPropNames;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.ExecutableRequest;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.engine.datatypes.BooleanType;
import com.edb.gridsql.engine.datatypes.IntegerType;
import com.edb.gridsql.engine.datatypes.LongType;
import com.edb.gridsql.engine.datatypes.ShortType;
import com.edb.gridsql.engine.datatypes.TimestampType;
import com.edb.gridsql.engine.datatypes.VarcharType;
import com.edb.gridsql.engine.datatypes.XData;
import com.edb.gridsql.engine.io.DataTypes;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysConstraint;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysForeignKey;
import com.edb.gridsql.metadata.SysIndex;
import com.edb.gridsql.metadata.SysIndexKey;
import com.edb.gridsql.metadata.SysReference;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysUser;
import com.edb.gridsql.metadata.SysView;
import com.edb.gridsql.metadata.SysViewColumns;
import com.edb.gridsql.metadata.scheduler.Scheduler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataUtil
implements XDBServerPropNames {
    private static final XLogger logger = XLogger.getLogger("Server");
    public static final String GET_CATALOGS = "getCatalogs";
    public static final String GET_COLUMNS = "getColumns";
    public static final String GET_DESCRIBE_TABLE = "getDescribeTable";
    public static final String GET_TABLES = "getTables";
    public static final String GET_STATEMENTS = "getStatements";
    public static final String GET_PRIMARY_KEY = "getPrimaryKey";
    public static final String GET_INDEX_INFO = "getIndexInfo";
    public static final String GET_IMPORTED_KEYS = "getImportedKeys";
    public static final String GET_EXPORTED_KEYS = "getExportedKeys";
    public static final String GET_CROSS_REFERENCE = "getCrossReference";
    public static final String GET_TABLE_TYPES = "getTableTypes";
    public static final String GET_TYPE_INFO = "getTypeInfo";

    private MetaDataUtil() {
    }

    public static ResultSet getInfo(String string, XDBSessionContext xDBSessionContext) throws SQLException {
        String[] stringArray = MetaDataUtil.parseParams(string);
        String string2 = stringArray[0];
        try {
            if (string2.equals(GET_CATALOGS)) {
                return MetaDataUtil.getCatalogs();
            }
            if (string2.equals(GET_COLUMNS)) {
                MetaDataUtil.checkParamCount(stringArray, 4);
                return MetaDataUtil.getColumns(stringArray[1], stringArray[2], stringArray[3], stringArray[4], xDBSessionContext);
            }
            if (string2.equals(GET_DESCRIBE_TABLE)) {
                MetaDataUtil.checkParamCount(stringArray, 1);
                return MetaDataUtil.getDescribeTable(stringArray[1], xDBSessionContext);
            }
            if (string2.equals(GET_TABLES)) {
                MetaDataUtil.checkParamCount(stringArray, 3);
                HashSet<String> hashSet = null;
                if (stringArray.length > 4) {
                    hashSet = new HashSet<String>();
                    for (int i = 4; i < stringArray.length; ++i) {
                        String string3 = stringArray[i].trim().toUpperCase();
                        if (!"TABLE".equals(string3) && !"VIEW".equals(string3) && !"LOCAL TEMPORARY".equals(string3)) continue;
                        hashSet.add(string3);
                    }
                    if (hashSet.isEmpty()) {
                        hashSet = null;
                    }
                }
                return MetaDataUtil.getTables(stringArray[1], stringArray[2], stringArray[3], hashSet, xDBSessionContext);
            }
            if (string2.equals(GET_STATEMENTS)) {
                return MetaDataUtil.getStatements(xDBSessionContext);
            }
            if (string2.equals(GET_PRIMARY_KEY)) {
                MetaDataUtil.checkParamCount(stringArray, 3);
                return MetaDataUtil.getPrimaryKey(stringArray[1], stringArray[2], stringArray[3]);
            }
            if (string2.equals(GET_INDEX_INFO)) {
                MetaDataUtil.checkParamCount(stringArray, 5);
                return MetaDataUtil.getIndexInfo(stringArray[1], stringArray[2], stringArray[3], "true".equalsIgnoreCase(stringArray[4]), "true".equalsIgnoreCase(stringArray[5]));
            }
            if (string2.equals(GET_IMPORTED_KEYS)) {
                MetaDataUtil.checkParamCount(stringArray, 3);
                return MetaDataUtil.getImportedKeys(stringArray[1], stringArray[2], stringArray[3]);
            }
            if (string2.equals(GET_EXPORTED_KEYS)) {
                MetaDataUtil.checkParamCount(stringArray, 3);
                return MetaDataUtil.getExportedKeys(stringArray[1], stringArray[2], stringArray[3]);
            }
            if (string2.equals(GET_CROSS_REFERENCE)) {
                MetaDataUtil.checkParamCount(stringArray, 3);
                return MetaDataUtil.getCrossReference(stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6]);
            }
            if (string2.equals(GET_TABLE_TYPES)) {
                return MetaDataUtil.getTableTypes();
            }
            if (string2.equals(GET_TYPE_INFO)) {
                return MetaDataUtil.getTypeInfo();
            }
        }
        catch (SQLException sQLException) {
            logger.catching(sQLException);
            throw sQLException;
        }
        catch (Exception exception) {
            logger.catching(exception);
            throw SQLErrorHandler.getError(6000, "metadata info error");
        }
        return null;
    }

    private static String[] parseParams(String string) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.indexOf("|");
        while (n2 >= 0) {
            String string2 = string.substring(n, n2);
            arrayList.add("null".equals(string2) ? null : string2);
            n = n2 + 1;
            n2 = string.indexOf("|", n);
        }
        arrayList.add(string.substring(n));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void checkParamCount(String[] stringArray, int n) throws SQLException {
        if (stringArray.length <= n) {
            throw new SQLException("Invalid command parameters");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet getStatements(XDBSessionContext xDBSessionContext) throws SQLException {
        if (logger.isDebugEnabled()) {
            Scheduler scheduler = xDBSessionContext.getSysDatabase().getScheduler();
            synchronized (scheduler) {
                logger.debug(xDBSessionContext.getSysDatabase().getLm().dumpLockManager());
            }
        }
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("REQUEST_ID", "REQUEST_ID", 0, 4, 0, 0, "STATEMENTS", 0, false), new ColumnMetaData("SESSION_ID", "SESSION_ID", 0, 4, 0, 0, "STATEMENTS", 0, false), new ColumnMetaData("SUBMIT_TIME", "SUBMIT_TIME", 0, 93, 0, 0, "STATEMENTS", 0, false), new ColumnMetaData("STATUS", "STATUS", 1, 1, 0, 0, "STATEMENTS", 0, false), new ColumnMetaData("STATEMENT", "STATEMENT", 8192, 12, 0, 0, "STATEMENTS", 0, false), new ColumnMetaData("NODES", "NODES", 1024, 12, 0, 0, "STATEMENTS", 0, false), new ColumnMetaData("CURRENT_STEP", "CURRENT_STEP", 8192, 12, 0, 0, "STATEMENTS", 0, false)};
        Vector<XData[]> vector = new Vector<XData[]>();
        for (Map.Entry<ExecutableRequest, XDBSessionContext> entry : xDBSessionContext.getRequests().entrySet()) {
            vector.add(new XData[]{new IntegerType(entry.getKey().getRequestID()), new IntegerType(entry.getValue().getSessionID()), new TimestampType(new Timestamp(entry.getKey().getSubmitTime()), null), new VarcharType("" + entry.getKey().getStatus()), new VarcharType(entry.getKey().getStatement()), new VarcharType(null), new VarcharType(null)});
        }
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    private static ResultSet getTables(String string, String string2, String string3, Collection collection, XDBSessionContext xDBSessionContext) throws SQLException {
        Iterator<Object> iterator;
        TreeMap<String, XData[]> treeMap;
        Object object2;
        short s = 0;
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("TABLE_CAT", "TABLE_CAT", 20, 12, 0, 0, null, s, false), new ColumnMetaData("TABLE_SCHEM", "TABLE_SCHEM", 20, 12, 0, 0, null, s, false), new ColumnMetaData("TABLE_NAME", "TABLE_NAME", 25, 12, 0, 0, null, s, false), new ColumnMetaData("TABLE_TYPE", "TABLE_TYPE", 10, 12, 0, 0, null, s, false), new ColumnMetaData("REMARKS", "REMARKS", 10, 12, 0, 0, null, s, false), new ColumnMetaData("TYPE_CAT", "TYPE_CAT", 10, 12, 0, 0, null, s, false), new ColumnMetaData("TYPE_SCHEM", "TYPE_SCHEM", 10, 12, 0, 0, null, s, false), new ColumnMetaData("TYPE_NAME", "TYPE_NAME", 10, 12, 0, 0, null, s, false), new ColumnMetaData("SELF_REFERENCING_COL_NAME", "SELF_REFERENCING_COL_NAME", 10, 12, 0, 0, null, s, false), new ColumnMetaData("REF_GENERATION", "REF_GENERATION", 10, 12, 0, 0, null, s, false)};
        Vector<XData[]> vector = new Vector<XData[]>();
        if (collection == null || collection.contains("TABLE")) {
            object2 = MetaDataUtil.getMatchingTables(MetaDataUtil.getMatchingDatabases(string), string3);
            treeMap = new TreeMap<String, XData[]>();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                SysTable object3 = iterator.next();
                treeMap.put(object3.getTableName(), new XData[]{new VarcharType(object3.getSysDatabase().getDbname()), new VarcharType(null), new VarcharType(object3.getTableName()), new VarcharType("TABLE"), new VarcharType(null), new VarcharType(null), new VarcharType(null), new VarcharType(null), new VarcharType(null), new VarcharType(null)});
            }
            for (XData[] xDataArray : treeMap.values()) {
                vector.add(xDataArray);
            }
        }
        if (collection == null || collection.contains("VIEW")) {
            object2 = MetaDataUtil.getMatchingViews(MetaDataUtil.getMatchingDatabases(string), string3);
            treeMap = new TreeMap();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                SysView sysView = (SysView)iterator.next();
                treeMap.put(sysView.getViewName(), new XData[]{new VarcharType(sysView.getSysDatabase().getDbname()), new VarcharType(null), new VarcharType(sysView.getViewName()), new VarcharType("VIEW"), new VarcharType(null), new VarcharType(null), new VarcharType(null), new VarcharType(null), new VarcharType(null), new VarcharType(null)});
            }
            for (XData[] xDataArray : treeMap.values()) {
                vector.add(xDataArray);
            }
        }
        if ((collection == null || collection.contains("LOCAL TEMPORARY")) && MetaDataUtil.getMatchingDatabases(string).contains(xDBSessionContext.getSysDatabase())) {
            object2 = MetaDataUtil.getMatchingTempTables(xDBSessionContext, string3);
            treeMap = new TreeMap(object2);
            for (Map.Entry entry : treeMap.entrySet()) {
                vector.add(new XData[]{new VarcharType(xDBSessionContext.getDBName()), new VarcharType(null), new VarcharType((String)entry.getKey()), new VarcharType("LOCAL TEMPORARY"), new VarcharType(null), new VarcharType(null), new VarcharType(null), new VarcharType(null), new VarcharType(null), new VarcharType(null)});
            }
        }
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    public static ResultSet getShowTables(String string, XDBSessionContext xDBSessionContext) throws SQLException {
        String string2 = "*";
        String string3 = "*";
        if (string.length() > 0) {
            String[] stringArray = MetaDataUtil.parseParams(string);
            if (stringArray.length > 1) {
                string2 = stringArray[0];
            }
            if (stringArray.length > 2) {
                string3 = stringArray[1];
            }
        }
        boolean bl = string2.equals("*") || string3.equals("*") || string3.equals("%");
        short s = 0;
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("TABLE_NAME", "TABLE", 25, 12, 0, 0, string3, s, false), new ColumnMetaData("TABLE_PARTITIONING_COLUMN", "TABLE_PARTITIONING_COLUMN", 25, 12, 0, 0, string3, s, false), new ColumnMetaData("TABLE_NODES", "TABLE_NODES", 1024, 12, 0, 0, string3, s, false)};
        SysDatabase sysDatabase = null;
        ArrayList<SysTable> arrayList = null;
        SysTable sysTable22 = null;
        Vector<XData[]> vector = new Vector<XData[]>();
        sysDatabase = MetaData.getMetaData().getSysDatabase(xDBSessionContext.getDBName());
        Iterator<DBNode> iterator = null;
        DBNode dBNode = null;
        String string4 = "";
        arrayList = new ArrayList<SysTable>(sysDatabase.getSysTables());
        TreeMap<String, XData[]> treeMap = new TreeMap<String, XData[]>();
        for (String xDataArray : xDBSessionContext.getTempTableNames()) {
            arrayList.add(sysDatabase.getSysTable(xDataArray));
        }
        for (SysTable sysTable22 : arrayList) {
            if (!bl && sysTable22.getTableName().toUpperCase().indexOf(string3.toUpperCase()) < 0) continue;
            try {
                sysTable22.checkPermission(xDBSessionContext.getCurrentUser(), (short)0);
            }
            catch (XDBSecurityException xDBSecurityException) {
                continue;
            }
            iterator = sysTable22.getNodeList().iterator();
            string4 = "";
            while (iterator.hasNext()) {
                dBNode = iterator.next();
                string4 = string4 + dBNode.getNodeId();
                if (!iterator.hasNext()) continue;
                string4 = string4 + ',';
            }
            treeMap.put(sysTable22.getTableName(), new XData[]{new VarcharType(sysTable22.getTableName()), new VarcharType(sysTable22.getPartitionColumn()), new VarcharType(string4)});
        }
        for (XData[] xDataArray : treeMap.values()) {
            vector.add(xDataArray);
        }
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    private static ResultSet getColumns(String string, String string2, String string3, String string4, XDBSessionContext xDBSessionContext) throws SQLException {
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{};
        Vector<XData[]> vector = new Vector<XData[]>();
        try {
            Iterator iterator;
            short s = 0;
            columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("TABLE_CAT", "TABLE_CAT", 255, 12, 0, 0, null, s, false), new ColumnMetaData("TABLE_SCHEM", "TABLE_SCHEM", 255, 12, 0, 0, null, s, false), new ColumnMetaData("TABLE_NAME", "TABLE_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("COLUMN_NAME", "COLUMN_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("DATA_TYPE", "DATA_TYPE", 0, 5, 0, 0, null, s, false), new ColumnMetaData("TYPE_NAME", "TYPE_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("COLUMN_SIZE", "COLUMN_SIZE", 0, 4, 0, 0, null, s, false), new ColumnMetaData("BUFFER_LENGTH", "BUFFER_LENGTH", 0, 4, 0, 0, null, s, false), new ColumnMetaData("DECIMAL_DIGITS", "DECIMAL_DIGITS", 0, 4, 0, 0, null, s, false), new ColumnMetaData("NUM_PREC_RADIX", "NUM_PREC_RADIX", 0, 4, 0, 0, null, s, false), new ColumnMetaData("NULLABLE", "NULLABLE", 0, 4, 0, 0, null, s, false), new ColumnMetaData("REMARKS", "REMARKS", 255, 12, 0, 0, null, s, false), new ColumnMetaData("COLUMN_DEF", "COLUMN_DEF", 255, 12, 0, 0, null, s, false), new ColumnMetaData("SQL_DATA_TYPE", "SQL_DATA_TYPE", 0, 4, 0, 0, null, s, false), new ColumnMetaData("SQL_DATETIME_SUB", "SQL_DATETIME_SUB", 0, 4, 0, 0, null, s, false), new ColumnMetaData("CHAR_OCTET_LENGTH", "CHAR_OCTET_LENGTH", 0, 4, 0, 0, null, s, false), new ColumnMetaData("ORDINAL_POSITION", "ORDINAL_POSITION", 0, 4, 0, 0, null, s, false), new ColumnMetaData("IS_NULLABLE", "IS_NULLABLE", 3, 12, 0, 0, null, s, false), new ColumnMetaData("SCOPE_CATLOG", "SCOPE_CATLOG", 255, 12, 0, 0, null, s, false), new ColumnMetaData("SCOPE_SCHEMA", "SCOPE_SCHEMA", 255, 12, 0, 0, null, s, false), new ColumnMetaData("SCOPE_TABLE", "SCOPE_TABLE", 255, 12, 0, 0, null, s, false), new ColumnMetaData("SOURCE_DATA_TYPE", "SOURCE_DATA_TYPE", 255, 12, 0, 0, null, s, false)};
            Pattern pattern = Pattern.compile(MetaDataUtil.patternToRegexp(string4), 2);
            Collection<SysTable> collection = MetaDataUtil.getMatchingTables(MetaDataUtil.getMatchingDatabases(string), string3);
            TreeMap<String, SysTable> treeMap = new TreeMap<String, SysTable>();
            for (SysTable object2 : collection) {
                iterator = object2;
                treeMap.put(((SysTable)((Object)iterator)).getTableName(), (SysTable)((Object)iterator));
            }
            for (SysTable sysTable : treeMap.values()) {
                iterator = sysTable;
                for (SysColumn sysColumn : ((SysTable)((Object)iterator)).getColumns()) {
                    SysColumn sysColumn2 = sysColumn;
                    if ("xrowid".equals(sysColumn2.getColName()) || !pattern.matcher(sysColumn2.getColName()).matches()) continue;
                    vector.add(new XData[]{new VarcharType(((SysTable)((Object)iterator)).getSysDatabase().getDbname()), new VarcharType(null), new VarcharType(((SysTable)((Object)iterator)).getTableName()), new VarcharType(sysColumn2.getColName()), new ShortType((short)sysColumn2.getColType()), new VarcharType(DataTypes.getJavaTypeDesc(sysColumn2.getColType())), new IntegerType(sysColumn2.getColLength()), new IntegerType(sysColumn2.getColLength()), new IntegerType(sysColumn2.getColScale()), new IntegerType(10), new IntegerType(sysColumn2.isNullable() ? 1 : 0), new VarcharType(sysColumn2.getColName()), new VarcharType(null), new IntegerType(null), new IntegerType(null), new IntegerType(sysColumn2.getColLength()), new IntegerType(sysColumn2.getColSeq()), new VarcharType(sysColumn2.isNullable() ? "YES" : "NO"), new VarcharType(null), new VarcharType(null), new VarcharType(null), new VarcharType(null)});
                }
            }
            Collection<SysView> collection2 = MetaDataUtil.getMatchingViews(MetaDataUtil.getMatchingDatabases(string), string3);
            TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                Object object = (SysView)iterator.next();
                treeMap2.put(((SysView)object).getViewName(), object);
            }
            for (Object object : treeMap2.values()) {
                for (SysViewColumns sysViewColumns : ((SysView)object).getViewColumns()) {
                    if (!pattern.matcher(sysViewColumns.getViewColumn()).matches()) continue;
                    vector.add(new XData[]{new VarcharType(((SysView)object).getSysDatabase().getDbname()), new VarcharType(null), new VarcharType(((SysView)object).getViewName()), new VarcharType(sysViewColumns.getViewColumn()), new ShortType((short)sysViewColumns.getColtype()), new VarcharType(DataTypes.getJavaTypeDesc(sysViewColumns.getColtype())), new IntegerType(sysViewColumns.getCollength()), new IntegerType(sysViewColumns.getCollength()), new IntegerType(sysViewColumns.getColscale()), new IntegerType(10), new IntegerType(null), new VarcharType(sysViewColumns.getViewColumn()), new VarcharType(null), new IntegerType(null), new IntegerType(null), new IntegerType(sysViewColumns.getCollength()), new IntegerType(null), new VarcharType(null), new VarcharType(null), new VarcharType(null), new VarcharType(null), new VarcharType(null)});
                }
            }
        }
        catch (Exception exception) {
            String string5 = exception != null ? exception.getMessage() : null;
            logger.catching(exception);
            throw SQLErrorHandler.getError(6000, string5);
        }
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    public static ResultSet getDescribeView(String string, XDBSessionContext xDBSessionContext) throws SQLException {
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{};
        Vector<XData[]> vector = new Vector<XData[]>();
        short s = 0;
        columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("VIEW_TEXT", "VIEW_TEXT", 255, 12, 0, 0, null, s, false), new ColumnMetaData("VIEW_COLUMN", "VIEW_COLUMN", 255, 12, 0, 0, null, s, false)};
        SysView sysView = xDBSessionContext.getSysDatabase().getSysView(string);
        String string2 = sysView.getViewText();
        String string3 = "";
        if (sysView.getViewColumns() != null && sysView.getViewColumns().size() > 0) {
            Iterator<SysViewColumns> iterator = sysView.getViewColumns().iterator();
            while (iterator.hasNext()) {
                SysViewColumns sysViewColumns;
                SysViewColumns sysViewColumns2 = sysViewColumns = iterator.next();
                string3 = string3 + sysViewColumns2.getViewColumn() + ", ";
            }
            string3 = string3.substring(0, string3.length() - 2);
        }
        vector.add(new XData[]{new VarcharType(string2), new VarcharType(string3)});
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    public static ResultSet getDescribeTable(String string, XDBSessionContext xDBSessionContext) throws SQLException {
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{};
        Vector<XData[]> vector = new Vector<XData[]>();
        try {
            Vector<SysColumn> vector2 = new Vector<SysColumn>();
            short s = 0;
            columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("COLUMN_NAME", "COLUMN_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("SQL_DATA_TYPE", "SQL_DATA_TYPE", 0, 4, 0, 0, null, s, false), new ColumnMetaData("TYPE_NAME", "TYPE_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("IS_NULLABLE", "IS_NULLABLE", 3, 12, 0, 0, null, s, false), new ColumnMetaData("KEY", "KEY", 3, 12, 0, 0, null, s, false), new ColumnMetaData("DEFAULT", "DEFAULT", 255, 12, 0, 0, null, s, false)};
            SysTable sysTable = xDBSessionContext.getSysDatabase().getSysTable(string);
            sysTable.checkPermission(xDBSessionContext.getCurrentUser(), (short)0);
            vector2.addAll(sysTable.getColumns());
            List<SysColumn> list = sysTable.getPrimaryKey();
            Hashtable<SysColumn, SysColumn> hashtable = sysTable.getReferringSys_ReferrencedColumns_Map();
            for (int i = 0; i < vector2.size(); ++i) {
                Object object;
                SysColumn sysColumn = (SysColumn)vector2.get(i);
                String string2 = "NO";
                String string3 = "";
                String string4 = sysColumn.getColName().toUpperCase().trim();
                if (list != null && list.size() > 0) {
                    for (SysColumn sysColumn2 : list) {
                        string3 = sysColumn2.getColName().toUpperCase().trim();
                        if (!string4.equals(string3)) continue;
                        string2 = "P";
                    }
                }
                if (hashtable != null && hashtable.size() > 0) {
                    object = hashtable.elements();
                    while (object.hasMoreElements()) {
                        SysColumn sysColumn2;
                        sysColumn2 = object.nextElement();
                        string3 = sysColumn2.getColName().toUpperCase().trim();
                        if (!string4.equals(string3)) continue;
                        if (string2.equals("NO")) {
                            string2 = "R";
                            continue;
                        }
                        string2 = string2 + " + R";
                    }
                }
                object = DataTypes.getJavaTypeDesc(sysColumn);
                if (sysColumn.getColType() == 2 || sysColumn.getColType() == 3) {
                    object = object + "(" + sysColumn.getColPrecision() + "," + sysColumn.getColScale() + ")";
                } else if (sysColumn.getColType() == 7 || sysColumn.getColType() == 6 || sysColumn.getColType() == 1 || sysColumn.getColType() == 12) {
                    object = object + "(" + sysColumn.getColLength() + ")";
                }
                if (sysColumn.isSerial()) {
                    object = (String)object + " SERIAL";
                }
                vector.add(new XData[]{new VarcharType(sysColumn.getColName()), new ShortType((short)sysColumn.getColType()), new VarcharType((String)object), new VarcharType(sysColumn.isNullable() ? "YES" : "NO"), new VarcharType(string2), new VarcharType(sysColumn.getDefaultExpr())});
            }
        }
        catch (Exception exception) {
            String string5 = exception != null ? exception.getMessage() : null;
            logger.catching(exception);
            throw SQLErrorHandler.getError(6000, string5);
        }
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    public static ResultSet getCatalogs() {
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("TABLE_CAT", "TABLE_CAT", 250, 12, 0, 0, null, 0, false)};
        TreeSet<String> treeSet = new TreeSet<String>();
        for (SysDatabase object : MetaData.getMetaData().getSysDatabases()) {
            treeSet.add(object.getDbname());
        }
        Vector vector = new Vector(treeSet.size());
        for (String string : treeSet) {
            vector.add(new XData[]{new VarcharType(string)});
        }
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    public static ResultSet getCatalogsExt() {
        short s = 0;
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("DATABASE", "DATABASE", 250, 12, 0, 0, null, s, false), new ColumnMetaData("STATUS", "STATUS", 10, 12, 0, 0, null, s, false), new ColumnMetaData("NODES", "NODES", 1024, 12, 0, 0, null, s, false)};
        Vector<XData[]> vector = new Vector<XData[]>();
        for (SysDatabase sysDatabase : MetaData.getMetaData().getSysDatabases()) {
            if (sysDatabase.getDbname().equalsIgnoreCase(Props.XDB_ADMIN_DATABASE)) continue;
            Iterator<DBNode> iterator = sysDatabase.getDBNodeList().iterator();
            String string = "";
            if (!iterator.hasNext()) {
                string = " ";
            }
            while (iterator.hasNext()) {
                DBNode dBNode = iterator.next();
                string = string + dBNode.getNode().getNodeid();
                if (!iterator.hasNext()) continue;
                string = string + ',';
            }
            vector.add(new XData[]{new VarcharType(sysDatabase.getDbname()), new VarcharType(sysDatabase.isStarted() ? "Started" : "Down"), new VarcharType(string)});
        }
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    public static ResultSet getPrimaryKey(String string, String string2, String string3) {
        short s = 0;
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("TABLE_CAT", "TABLE_CAT", 255, 12, 0, 0, null, s, false), new ColumnMetaData("TABLE_SCHEM", "TABLE_SCHEM", 255, 12, 0, 0, null, s, false), new ColumnMetaData("TABLE_NAME", "TABLE_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("COLUMN_NAME", "COLUMN_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("KEY_SEQ", "KEY_SEQ", 0, 5, 0, 0, null, s, false), new ColumnMetaData("PK_NAME", "PK_NAME", 255, 12, 0, 0, null, s, false)};
        Vector<XData[]> vector = new Vector<XData[]>();
        Collection<SysTable> collection = MetaDataUtil.getMatchingTables(MetaDataUtil.getMatchingDatabases(string), string3);
        for (SysTable sysTable : collection) {
            short s2 = 0;
            SysIndex sysIndex = sysTable.getPrimaryIndex();
            if (sysIndex == null) continue;
            List<SysColumn> list = sysIndex.getKeyColumns();
            for (SysColumn sysColumn : list) {
                s2 = (short)(s2 + 1);
                vector.add(new XData[]{new VarcharType(sysTable.getSysDatabase().getDbname()), new VarcharType(null), new VarcharType(sysTable.getTableName()), new VarcharType(sysColumn.getColName()), new ShortType(s2), new VarcharType(sysIndex.idxname)});
            }
        }
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    public static ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) {
        short s = 0;
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("TABLE_CAT", "TABLE_CAT", 255, 12, 0, 0, null, s, false), new ColumnMetaData("TABLE_SCHEM", "TABLE_SCHEM", 255, 12, 0, 0, null, s, false), new ColumnMetaData("TABLE_NAME", "TABLE_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("NON_UNIQUE", "NON_UNIQUE", 0, 16, 0, 0, null, s, false), new ColumnMetaData("INDEX_QUALIFIER", "INDEX_QUALIFIER", 255, 12, 0, 0, null, s, false), new ColumnMetaData("INDEX_NAME", "INDEX_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("TYPE", "TYPE", 0, 5, 0, 0, null, s, false), new ColumnMetaData("ORDINAL_POSITION", "ORDINAL_POSITION", 0, 5, 0, 0, null, s, false), new ColumnMetaData("COLUMN_NAME", "COLUMN_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("ASC_OR_DESC", "ASC_OR_DESC", 255, 12, 0, 0, null, s, false), new ColumnMetaData("CARDINALITY", "CARDINALITY", 0, 4, 0, 0, null, s, false), new ColumnMetaData("PAGES", "PAGES", 0, 4, 0, 0, null, s, false), new ColumnMetaData("FILTER_CONDITION", "FILTER_CONDITION", 255, 12, 0, 0, null, s, false)};
        Vector<XData[]> vector = new Vector<XData[]>();
        Collection<SysTable> collection = MetaDataUtil.getMatchingTables(MetaDataUtil.getMatchingDatabases(string), string3);
        for (SysTable sysTable : collection) {
            List<SysConstraint> list = sysTable.getConstraintList();
            for (SysConstraint sysConstraint : list) {
                boolean bl3 = false;
                if (sysConstraint.getConstType() == 'R') {
                    bl3 = true;
                }
                SysIndex sysIndex = sysTable.getSysIndex(sysConstraint.getIdxID());
                List<SysIndexKey> list2 = sysIndex.getIndexKeys();
                for (SysIndexKey sysIndexKey : list2) {
                    String string4 = new String("A");
                    if (sysIndexKey.idxascdesc == 1) {
                        string4 = "D";
                    }
                    vector.add(new XData[]{new VarcharType(sysTable.getSysDatabase().getDbname()), new VarcharType(string2), new VarcharType(sysTable.getTableName()), new BooleanType(bl3), new VarcharType(""), new VarcharType(sysIndex.idxname), new ShortType(0), new ShortType((short)sysIndexKey.idxkeyseq), new VarcharType(sysIndexKey.sysColumn.getColName()), new VarcharType(string4), new IntegerType(0), new IntegerType(0), new VarcharType("")});
                }
            }
        }
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    public static ResultSet getImportedKeys(String string, String string2, String string3) {
        short s = 0;
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("PKTABLE_CAT", "PKTABLE_CAT", 255, 12, 0, 0, null, s, false), new ColumnMetaData("PKTABLE_SCHEM", "PKTABLE_SCHEM", 255, 12, 0, 0, null, s, false), new ColumnMetaData("PKTABLE_NAME", "PKTABLE_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("PKCOLUMN_NAME", "PKCOLUMN_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("FKTABLE_CAT", "FKTABLE_CAT", 255, 12, 0, 0, null, s, false), new ColumnMetaData("FKTABLE_SCHEM", "FKTABLE_SCHEM", 255, 12, 0, 0, null, s, false), new ColumnMetaData("FKTABLE_NAME", "FKTABLE_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("FKCOLUMN_NAME", "FKCOLUMN_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("KEY_SEQ", "KEY_SEQ", 0, 5, 0, 0, null, s, false), new ColumnMetaData("UPDATE_RULE", "UPDATE_RULE", 0, 5, 0, 0, null, s, false), new ColumnMetaData("DELETE_RULE", "DELETE_RULE", 0, 5, 0, 0, null, s, false), new ColumnMetaData("FK_NAME", "FK_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("PK_NAME", "PK_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("DEFERRABILITY", "DEFERRABILITY", 0, 5, 0, 0, null, s, false)};
        Vector<XData[]> vector = new Vector<XData[]>();
        Collection<SysTable> collection = MetaDataUtil.getMatchingTables(MetaDataUtil.getMatchingDatabases(string), string3);
        for (SysTable sysTable : collection) {
            for (SysConstraint sysConstraint : sysTable.getConstraintList()) {
                if (sysConstraint.getConstType() != 'R') continue;
                SysIndex sysIndex = sysTable.getSysIndex(sysConstraint.getIdxID());
                Enumeration enumeration = sysTable.getSysDatabase().getAllTables();
                while (enumeration.hasMoreElements()) {
                    SysTable sysTable2 = (SysTable)enumeration.nextElement();
                    Vector<SysReference> vector2 = sysTable2.getSysReferences();
                    for (SysReference sysReference : vector2) {
                        if (sysConstraint != sysReference.getConstraint()) continue;
                        SysIndex sysIndex2 = sysTable2.getSysIndex(sysReference.getRefIdxID());
                        Vector vector3 = sysReference.getForeignKeys();
                        short s2 = 0;
                        for (SysForeignKey sysForeignKey : vector3) {
                            s2 = (short)(s2 + 1);
                            vector.add(new XData[]{new VarcharType(sysTable.getSysDatabase().getDbname()), new VarcharType(string2), new VarcharType(sysTable2.getTableName()), new VarcharType(sysTable2.getSysColumn(sysForeignKey.getRefcolid()).getColName()), new VarcharType(sysTable.getSysDatabase().getDbname()), new VarcharType(string2), new VarcharType(sysTable.getTableName()), new VarcharType(sysTable.getSysColumn(sysForeignKey.getColid()).getColName()), new ShortType(s2), new ShortType(1), new ShortType(1), new VarcharType(sysIndex.idxname), new VarcharType(sysIndex2.idxname), new ShortType(6)});
                        }
                    }
                }
            }
        }
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    public static ResultSet getExportedKeys(String string, String string2, String string3) {
        short s = 0;
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("PKTABLE_CAT", "PKTABLE_CAT", 255, 12, 0, 0, null, s, false), new ColumnMetaData("PKTABLE_SCHEM", "PKTABLE_SCHEM", 255, 12, 0, 0, null, s, false), new ColumnMetaData("PKTABLE_NAME", "PKTABLE_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("PKCOLUMN_NAME", "PKCOLUMN_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("FKTABLE_CAT", "FKTABLE_CAT", 255, 12, 0, 0, null, s, false), new ColumnMetaData("FKTABLE_SCHEM", "FKTABLE_SCHEM", 255, 12, 0, 0, null, s, false), new ColumnMetaData("FKTABLE_NAME", "FKTABLE_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("FKCOLUMN_NAME", "FKCOLUMN_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("KEY_SEQ", "KEY_SEQ", 0, 5, 0, 0, null, s, false), new ColumnMetaData("UPDATE_RULE", "UPDATE_RULE", 0, 5, 0, 0, null, s, false), new ColumnMetaData("DELETE_RULE", "DELETE_RULE", 0, 5, 0, 0, null, s, false), new ColumnMetaData("FK_NAME", "FKCOLUMN_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("PK_NAME", "PKCOLUMN_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("DEFERRABILITY", "DEFERRABILITY", 0, 5, 0, 0, null, s, false)};
        Vector<XData[]> vector = new Vector<XData[]>();
        Collection<SysTable> collection = MetaDataUtil.getMatchingTables(MetaDataUtil.getMatchingDatabases(string), string3);
        for (SysTable sysTable : collection) {
            for (SysReference sysReference : sysTable.getSysReferences()) {
                Vector vector2 = sysReference.getForeignKeys();
                for (SysForeignKey sysForeignKey : vector2) {
                    SysColumn sysColumn = sysForeignKey.getReferencedSysColumn(sysTable.getSysDatabase());
                    SysColumn sysColumn2 = sysForeignKey.getReferringSysColumn(sysTable.getSysDatabase());
                    vector.add(new XData[]{new VarcharType(sysTable.getSysDatabase().getDbname()), new VarcharType(""), new VarcharType(sysTable.getTableName()), new VarcharType(sysColumn.getColName()), new VarcharType(sysTable.getSysDatabase().getDbname()), new VarcharType(""), new VarcharType(sysColumn2.getSysTable().getTableName()), new VarcharType(sysColumn2.getColName()), new ShortType((short)sysColumn.getColSeq()), new ShortType(1), new ShortType(1), new VarcharType(sysReference.getConstraint().getConstName()), new VarcharType(sysColumn.getSysTable().getSysIndex((int)sysReference.getRefIdxID()).idxname), new ShortType(6)});
                }
            }
        }
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    public static ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) {
        short s = 0;
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("PKTABLE_CAT", "PKTABLE_CAT", 255, 12, 0, 0, null, s, false), new ColumnMetaData("PKTABLE_SCHEM", "PKTABLE_SCHEM", 255, 12, 0, 0, null, s, false), new ColumnMetaData("PKTABLE_NAME", "PKTABLE_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("PKCOLUMN_NAME", "PKCOLUMN_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("FKTABLE_CAT", "FKTABLE_CAT", 255, 12, 0, 0, null, s, false), new ColumnMetaData("FKTABLE_SCHEM", "FKTABLE_SCHEM", 255, 12, 0, 0, null, s, false), new ColumnMetaData("FKTABLE_NAME", "FKTABLE_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("FKCOLUMN_NAME", "FKCOLUMN_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("KEY_SEQ", "KEY_SEQ", 0, 5, 0, 0, null, s, false), new ColumnMetaData("UPDATE_RULE", "UPDATE_RULE", 0, 5, 0, 0, null, s, false), new ColumnMetaData("DELETE_RULE", "DELETE_RULE", 0, 5, 0, 0, null, s, false), new ColumnMetaData("FK_NAME", "FK_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("PK_NAME", "PK_NAME", 255, 12, 0, 0, null, s, false), new ColumnMetaData("DEFERRABILITY", "DEFERRABILITY", 0, 5, 0, 0, null, s, false)};
        Vector<XData[]> vector = new Vector<XData[]>();
        Collection<SysTable> collection = MetaDataUtil.getMatchingTables(MetaDataUtil.getMatchingDatabases(string), string3);
        Collection<SysTable> collection2 = MetaDataUtil.getMatchingTables(MetaDataUtil.getMatchingDatabases(string4), string6);
        ArrayList<SysConstraint> arrayList = new ArrayList<SysConstraint>();
        ArrayList<SysConstraint> arrayList2 = new ArrayList<SysConstraint>();
        for (SysTable sysTable : collection) {
            arrayList.addAll(sysTable.getConstraintList());
        }
        for (SysTable sysTable : collection2) {
            arrayList2.addAll(sysTable.getConstraintList());
        }
        for (SysTable sysTable : collection) {
            for (SysReference sysReference : sysTable.getSysReferences()) {
                for (SysTable sysTable2 : collection2) {
                    for (SysReference sysReference2 : sysTable2.getSysFkReferenceList()) {
                        if (sysReference2 != sysReference) continue;
                        Vector vector2 = sysReference2.getForeignKeys();
                        for (SysForeignKey sysForeignKey : vector2) {
                            vector.add(new XData[]{new VarcharType(sysTable.getSysDatabase().getDbname()), new VarcharType(null), new VarcharType(sysTable.getTableName()), new VarcharType(sysTable.getSysColumn(sysForeignKey.getRefcolid()).getColName()), new VarcharType(sysTable2.getSysDatabase().getDbname()), new VarcharType(null), new VarcharType(sysTable2.getTableName()), new VarcharType(sysTable2.getSysColumn(sysForeignKey.getColid()).getColName()), new ShortType((short)sysForeignKey.fkeyseq), new ShortType(1), new ShortType(1), new VarcharType(sysReference2.getConstraint().getConstName()), new VarcharType(sysTable.getSysIndex((int)sysReference.getRefIdxID()).idxname), new ShortType(6)});
                        }
                    }
                }
            }
        }
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    private static ResultSet getTableTypes() {
        short s = 0;
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("TABLE_TYPE", "TABLE_TYPE", 0, 12, 0, 0, null, s, false)};
        Vector<XData[]> vector = new Vector<XData[]>(3);
        vector.add(new XData[]{new VarcharType("TABLE")});
        vector.add(new XData[]{new VarcharType("VIEW")});
        vector.add(new XData[]{new VarcharType("LOCAL TEMPORARY")});
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    public static ResultSet getTypeInfo() {
        short s = 0;
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("TYPE_NAME", "TYPE_NAME", 0, 12, 0, 0, null, s, false), new ColumnMetaData("DATA_TYPE", "DATA_TYPE", 0, 5, 0, 0, null, s, false), new ColumnMetaData("PRECISION", "PRECISION", 0, 4, 0, 0, null, s, false), new ColumnMetaData("LITERAL_PREFIX", "LITERAL_PREFIX", 0, 12, 0, 0, null, s, false), new ColumnMetaData("LITERAL_SUFFIX", "LITERAL_SUFFIX", 0, 12, 0, 0, null, s, false), new ColumnMetaData("CREATE_PARAMS", "CREATE_PARAMS", 0, 12, 0, 0, null, s, false), new ColumnMetaData("NULLABLE", "NULLABLE", 0, 5, 0, 0, null, s, false), new ColumnMetaData("CASE_SENSITIVE", "CASE_SENSITIVE", 0, 16, 0, 0, null, s, false), new ColumnMetaData("SEARCHABLE", "SEARCHABLE", 0, 5, 0, 0, null, s, false), new ColumnMetaData("UNSIGNED_ATTRIBUTE", "UNSIGNED_ATTRIBUTE", 0, 16, 0, 0, null, s, false), new ColumnMetaData("FIXED_PREC_SCALE", "FIXED_PREC_SCALE", 0, 16, 0, 0, null, s, false), new ColumnMetaData("AUTO_INCREMENT", "AUTO_INCREMENT", 0, 16, 0, 0, null, s, false), new ColumnMetaData("LOCAL_TYPE_NAME", "LOCAL_TYPE_NAME", 0, 12, 0, 0, null, s, false), new ColumnMetaData("MINIMUM_SCALE", "MINIMUM_SCALE", 0, 5, 0, 0, null, s, false), new ColumnMetaData("MAXIMUM_SCALE", "MAXIMUM_SCALE", 0, 5, 0, 0, null, s, false), new ColumnMetaData("SQL_DATA_TYPE", "SQL_DATA_TYPE", 0, 4, 0, 0, null, s, false), new ColumnMetaData("SQL_DATETIME_SUB", "SQL_DATETIME_SUB", 0, 4, 0, 0, null, s, false), new ColumnMetaData("NUM_PREC_RADIX", "NUM_PREC_RADIX", 0, 4, 0, 0, null, s, false)};
        Vector<XData[]> vector = new Vector<XData[]>(20);
        vector.add(new XData[]{new VarcharType("BOOLEAN"), new ShortType(16), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(false), new BooleanType(false), new BooleanType(false), new VarcharType(null), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("CHAR"), new ShortType(1), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(true), new ShortType(3), new BooleanType(false), new BooleanType(false), new BooleanType(false), new VarcharType(null), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("NCHAR"), new ShortType(1), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(true), new ShortType(3), new BooleanType(false), new BooleanType(false), new BooleanType(false), new VarcharType(null), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("DATE"), new ShortType(91), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(false), new BooleanType(false), new BooleanType(false), new VarcharType(null), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("DECIMAL"), new ShortType(3), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(false), new BooleanType(true), new BooleanType(false), new VarcharType("DEC"), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("DOUBLE PRECISION"), new ShortType(8), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(false), new BooleanType(true), new BooleanType(false), new VarcharType("DOUBLE PRECISION"), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("FLOAT"), new ShortType(6), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(false), new BooleanType(true), new BooleanType(false), new VarcharType("FLOAT"), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("INTEGER"), new ShortType(4), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(false), new BooleanType(false), new BooleanType(false), new VarcharType("INT"), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("NUMERIC"), new ShortType(2), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(false), new BooleanType(true), new BooleanType(false), new VarcharType(null), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("FIXED"), new ShortType(3), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(false), new BooleanType(true), new BooleanType(false), new VarcharType(null), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("REAL"), new ShortType(7), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(false), new BooleanType(true), new BooleanType(false), new VarcharType(null), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("SERIAL"), new ShortType(4), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(true), new BooleanType(false), new BooleanType(true), new VarcharType("SERIAL"), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("BIGSERIAL"), new ShortType(-5), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(true), new BooleanType(false), new BooleanType(true), new VarcharType("BIGSERIAL"), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("SMALLINT"), new ShortType(5), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(false), new BooleanType(false), new BooleanType(false), new VarcharType(null), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("BIGINT"), new ShortType(-5), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(false), new BooleanType(false), new BooleanType(false), new VarcharType("BIGINT"), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("TIME"), new ShortType(92), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(false), new BooleanType(false), new BooleanType(false), new VarcharType(null), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("TIMESTAMP"), new ShortType(93), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(false), new ShortType(2), new BooleanType(false), new BooleanType(false), new BooleanType(false), new VarcharType(null), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        vector.add(new XData[]{new VarcharType("VARCHAR"), new ShortType(12), null, new VarcharType(null), new VarcharType(null), new VarcharType(null), new ShortType(1), new BooleanType(true), new ShortType(3), new BooleanType(false), new BooleanType(false), new BooleanType(false), new VarcharType(null), new ShortType(null), new ShortType(null), new LongType(null), new LongType(null), new LongType(null)});
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    public static ResultSet getShowUsers(XDBSessionContext xDBSessionContext) {
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("USER_NAME", "USER_NAME", 250, 12, 0, 0, null, 0, false), new ColumnMetaData("USER_CLASS", "USER_CLASS", 8, 12, 0, 0, null, 0, false)};
        Collection<SysUser> collection = xDBSessionContext.getSysDatabase().getSysUsers();
        Vector<XData[]> vector = new Vector<XData[]>(collection.size());
        for (SysUser sysUser : collection) {
            String string = null;
            switch (sysUser.getUserClass()) {
                case 0: {
                    string = "DBA";
                    break;
                }
                case 2: {
                    string = "STANDARD";
                    break;
                }
                case 1: {
                    string = "RESOURCE";
                }
            }
            vector.add(new XData[]{new VarcharType(sysUser.getName()), new VarcharType(string)});
        }
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    public static ResultSet getShowViews(XDBSessionContext xDBSessionContext) {
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("VIEW_NAME", "VIEW_NAME", 250, 12, 0, 0, null, 0, false)};
        Collection<SysView> collection = xDBSessionContext.getSysDatabase().getSysViews();
        Vector<XData[]> vector = new Vector<XData[]>(collection.size());
        for (SysView sysView : collection) {
            vector.add(new XData[]{new VarcharType(sysView.getViewName())});
        }
        return new ResultSetImpl(columnMetaDataArray, vector);
    }

    private static String patternToRegexp(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '%': {
                    stringBuffer.append("\\w*");
                    continue block5;
                }
                case '_': {
                    stringBuffer.append("\\w");
                    continue block5;
                }
                case '\\': {
                    if (i >= string.length() - 1) continue block5;
                    if (string.charAt(++i) == '\\') {
                        stringBuffer.append("\\");
                    }
                    stringBuffer.append(string.charAt(i));
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static Collection<SysDatabase> getMatchingDatabases(String string) {
        Collection<SysDatabase> collection = MetaData.getMetaData().getSysDatabases();
        if (string == null) {
            return collection;
        }
        ArrayList<SysDatabase> arrayList = new ArrayList<SysDatabase>(collection.size());
        Pattern pattern = Pattern.compile(MetaDataUtil.patternToRegexp(string), 2);
        for (SysDatabase sysDatabase : collection) {
            if (!pattern.matcher(sysDatabase.getDbname()).matches()) continue;
            arrayList.add(sysDatabase);
        }
        return arrayList;
    }

    private static Collection<SysTable> getMatchingTables(Collection<SysDatabase> collection, String string) {
        ArrayList<SysTable> arrayList = new ArrayList<SysTable>();
        Pattern pattern = Pattern.compile(MetaDataUtil.patternToRegexp(string), 2);
        for (SysDatabase sysDatabase : collection) {
            for (SysTable sysTable : sysDatabase.getSysTables()) {
                if (!pattern.matcher(sysTable.getTableName()).matches()) continue;
                arrayList.add(sysTable);
            }
        }
        return arrayList;
    }

    private static Collection<SysView> getMatchingViews(Collection<SysDatabase> collection, String string) {
        ArrayList<SysView> arrayList = new ArrayList<SysView>();
        Pattern pattern = Pattern.compile(MetaDataUtil.patternToRegexp(string), 2);
        for (SysDatabase sysDatabase : collection) {
            for (SysView sysView : sysDatabase.getSysViews()) {
                if (!pattern.matcher(sysView.getViewName()).matches()) continue;
                arrayList.add(sysView);
            }
        }
        return arrayList;
    }

    private static Map<String, SysTable> getMatchingTempTables(XDBSessionContext xDBSessionContext, String string) {
        HashMap<String, SysTable> hashMap = new HashMap<String, SysTable>();
        Pattern pattern = Pattern.compile(MetaDataUtil.patternToRegexp(string), 2);
        SysDatabase sysDatabase = xDBSessionContext.getSysDatabase();
        for (String string2 : xDBSessionContext.getTempTableNames()) {
            String string3 = string2;
            if (!pattern.matcher(string3).matches()) continue;
            hashMap.put(string3, sysDatabase.getSysTable(xDBSessionContext.getTempTableName(string3)));
        }
        return hashMap;
    }

    public static Properties getServerProperties() {
        Properties properties = new Properties();
        properties.put("allProceduresAreCallable", "false");
        properties.put("allTablesAreSelectable", "false");
        properties.put("dataDefinitionCausesCommit", "true");
        properties.put("dataDefinitionIgnoredInTrans", "false");
        properties.put("deletesAreDetected", "false");
        properties.put("doesMaxRowSizeIncludeBlobs", "true");
        properties.put("catalogSeparator", ":");
        properties.put("catalogTerm", "database");
        properties.put("databaseMajorVersion", "0");
        properties.put("databaseMinorVersion", "9");
        properties.put("databaseProductName", "GridSQL");
        properties.put("databaseVersion", "GridSQL 0.9");
        properties.put("defaultTransIsolation", "2");
        properties.put("extraNameCharacters", "");
        properties.put("identifierQuoteString", " ");
        properties.put("maxBinaryLiteralLength", "0");
        properties.put("maxCatalogNameLength", "0");
        properties.put("maxCharLiteralLength", "0");
        properties.put("maxColumnNameLength", "0");
        properties.put("maxColumnsInGroupBy", "0");
        properties.put("maxColumnsInIndex", "0");
        properties.put("maxColumnsInOrderBy", "0");
        properties.put("maxColumnsInSelect", "0");
        properties.put("maxColumnsInTable", "0");
        properties.put("maxConnections", Property.get("xdb.maxconnections", "0"));
        properties.put("maxCursorNameLength", "0");
        properties.put("maxIndexLength", "0");
        properties.put("maxProcedureNameLength", "0");
        properties.put("maxRowSize", "0");
        properties.put("maxSchemaNameLength", "0");
        properties.put("maxStatementLength", "0");
        properties.put("maxStatements", "0");
        properties.put("maxTableNameLength", "0");
        properties.put("maxTablesInSelect", "0");
        properties.put("maxUserNameLength", "30");
        properties.put("numericFunctions", "ABS,ACOS,ASIN,ATAN,ATAN2,COS,COT,DEGREES,EXP,FLOOR,LOG,MOD,PI,RADIANS,ROUND,SIGN,SIN,SQRT,TAN");
        properties.put("procedureTerm", "procedure");
        properties.put("resultSetHoldability", "1");
        properties.put("SQLKeywords", "AFTER,BINARY,BOOLEAN,DATABASES,DBA,ESTIMATE,MODIFY,NODE,NODES,OWNER,PARENT,PARTITION,PARTITIONING,PASSWORD,PERCENT,PUBLIC,RENAME,REPLICATED,RESOURCE,SAMPLE,SERIAL,SHOW,STANDARD,STAT,STATISTICS,TABLES,TEMP,TRAN,UNSIGNED,ZEROFILL");
        properties.put("SQLStateType", "0");
        properties.put("schemaTerm", "schema");
        properties.put("searchStringEscape", "\\");
        properties.put("StringFunctions", "ASCII,INDEX,LENGTH,LOWER,LTRIM,REPLACE,RPAD,RTRIM,SUBSTR,TRIM,UPPER");
        properties.put("SystemFunctions", "");
        properties.put("TimeDateFunctions", "CURRENT_TIME,CURRENT_DATE,CURRENT_TIMESTAMP");
        properties.put("insertsAreDetected", "false");
        properties.put("catalogAtStart", "true");
        properties.put("readOnly", "false");
        properties.put("locatorsUpdateCopy", "true");
        properties.put("nullPlusNonNullIsNull", "true");
        properties.put("nullsSortedAtEnd", "" + (Props.XDB_COMBINED_RESULTSET_SORT_NULLS_STYLE == 1));
        properties.put("nullsSortedAtStart", "" + (Props.XDB_COMBINED_RESULTSET_SORT_NULLS_STYLE == 0));
        properties.put("nullsSortedHigh", "" + (Props.XDB_COMBINED_RESULTSET_SORT_NULLS_STYLE == 2));
        properties.put("nullsSortedLow", "" + (Props.XDB_COMBINED_RESULTSET_SORT_NULLS_STYLE == 3));
        properties.put("othersDeletesVisible", "false");
        properties.put("othersInsetrsVisible", "false");
        properties.put("othersUpdatesVisible", "false");
        properties.put("ownDeletesVisible", "true");
        properties.put("ownInsetrsVisible", "true");
        properties.put("ownUpdatesVisible", "true");
        properties.put("storesLowercaseIdentifiers", "false");
        properties.put("storesLowercaseQuotedIdentifiers", "false");
        properties.put("storesMixedcaseIdentifiers", "true");
        properties.put("storesMixedcaseQuotedIdentifiers", "true");
        properties.put("storesUppercaseIdentifiers", "false");
        properties.put("storesUppercaseQuotedIdentifiers", "false");
        properties.put("supportsAnsi92EntryLevel", "true");
        properties.put("supportsAnsi92Intermediate", "falsee");
        properties.put("supportsAnsi92Full", "false");
        properties.put("supportsAlterTableAddColumn", "true");
        properties.put("supportsAlterTableDropColumn", "true");
        properties.put("supportsBatchUpdates", "true");
        properties.put("supportsCatalogsInDML", "false");
        properties.put("supportsCatalogsInIndexDefs", "false");
        properties.put("supportsCatalogsInPrivilegeDefs", "false");
        properties.put("supportsCatalogsInProcedureCalls", "false");
        properties.put("supportsCatalogsInTableDefs", "false");
        properties.put("supportsColumnAliasing", "true");
        properties.put("supportsConvert", "true");
        properties.put("supportsCoreSQLGrammar", "true");
        properties.put("supportsCorellatedSubqueries", "true");
        properties.put("supportsDDLAndDMLInTransactions", "true");
        properties.put("supportsDMLInTransactionsOnly", "false");
        properties.put("supportsDifferentTableCorellationNames", "false");
        properties.put("supportsExpressionsInOrderBy", "true");
        properties.put("supportsExtendedSQLGrammar", "false");
        properties.put("supportsFullOuterJoins", "false");
        properties.put("supportsGetGeneratedKeys", "false");
        properties.put("supportsGroupBy", "true");
        properties.put("supportsGroupByBeyondSelect", "false");
        properties.put("supportsGroupByUnrelated", "false");
        properties.put("supportsIntegrityEnhancementFacility", "false");
        properties.put("supportsLikeEscapeClause", "false");
        properties.put("supportsLimitedOuterJoins", "true");
        properties.put("supportsMinimumSQLGrammar", "true");
        properties.put("supportsMixedCaseIdentifiers", "true");
        properties.put("supportsMixedCaseQuotedIdentifiers", "false");
        properties.put("supportsMultipleOpenResults", "true");
        properties.put("supportsMultipleResultSets", "false");
        properties.put("supportsMultipleTransactions", "true");
        properties.put("supportsNamedParameters", "false");
        properties.put("supportsNonNullableColumns", "true");
        properties.put("supportsOpenCursorsAcrossCommit", "true");
        properties.put("supportsOpenCursorsAcrossRollback", "true");
        properties.put("supportsOpenStatementsAcrossCommit", "true");
        properties.put("supportsOpenStatementsAcrossRollback", "true");
        properties.put("supportsOrderByUnrelated", "true");
        properties.put("supportsOuterJoins", "true");
        properties.put("supportsPositionedDelete", "false");
        properties.put("supportsPositionedUpdate", "false");
        properties.put("supportsResultSetConcurrency.1003.1007", "true");
        properties.put("supportsResultSetHoldability.1", "true");
        properties.put("supportsResultSetType.1003", "true");
        properties.put("supportsSavepoints", "true");
        properties.put("supportsSchemasInDML", "false");
        properties.put("supportsSchemasInIndexDefs", "false");
        properties.put("supportsSchemasInPrivilegeDefs", "false");
        properties.put("supportsSchemasInProcedureCalls", "false");
        properties.put("supportsSchemasInTableDefs", "false");
        properties.put("supportsSelectForUpdate", "false");
        properties.put("supportsStatementPooling", "false");
        properties.put("supportsStoredProcedures", "false");
        properties.put("supportsSubqueriesInComparisons", "true");
        properties.put("supportsSubqueriesInExists", "true");
        properties.put("supportsSubqueriesInIns", "true");
        properties.put("supportsSubqueriesInQuantifieds", "true");
        properties.put("supportsTableCorellationNames", "true");
        properties.put("supportsTransactionIsolationLevel.8", "true");
        properties.put("supportsTransactions", "true");
        properties.put("supportsUnion", "true");
        properties.put("supportsUnionAll", "true");
        properties.put("updatesAreDetected", "false");
        properties.put("usesLocalFilePerTable", "false");
        properties.put("usesLocalFiles", "false");
        return properties;
    }
}

