package com.softviewtech.jbillboard;

/**
 * Title:        mosaic
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:      SoftView Technology
 * @author
 * @version 1.0
 */

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.awt.event.*;
import java.beans.*;

class FilePreviewer extends JComponent implements PropertyChangeListener {
    ImageIcon thumbnail = null;
    File f = null;

    public FilePreviewer(JFileChooser fc) {
        setPreferredSize(new Dimension(100, 50));
        fc.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if(f != null) {
            ImageIcon tmpIcon = new ImageIcon(f.getPath());
            if(tmpIcon.getIconWidth() > 90) {
                thumbnail = new ImageIcon(
                    tmpIcon.getImage().getScaledInstance(90, -1,
                                                         Image.SCALE_DEFAULT));
            } else {
                thumbnail = tmpIcon;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if(prop == JFileChooser.SELECTED_FILE_CHANGED_PROPERTY) {
            f = (File) e.getNewValue();
            if(isShowing()) {
                loadImage();
                repaint();
            }
        }
    }

    public void paint(Graphics g) {
        if(thumbnail == null) {
            loadImage();
        }
        if(thumbnail != null) {
            int x = getWidth()/2 - thumbnail.getIconWidth()/2;
            int y = getHeight()/2 - thumbnail.getIconHeight()/2;
            if(y < 0) {
                y = 0;
            }

            if(x < 5) {
                x = 5;
            }
            thumbnail.paintIcon(this, g, x, y);
        }
    }
}
