<%
    /**********************************************************/
    /*****  Category Information Page (TEMPLATE=CATLIST)  *****/
    /*****  Show a list of sub-categories or items        *****/ 
    /*****  under this category.                          *****/
    /**********************************************************/
%>

<% 
    /****************************************/
    /******* Variables Initialization *******/
    /****************************************/

    String cat_name="", leaf_cat="N";
    if (id == 0)
    {
      cat_name = "List of Main Categories";
      leaf_cat = "N";
    }
    else
    {
      Category this_cat = CategoryBean.getCategory(id, language);
      cat_name = this_cat.getCatName();
      leaf_cat = this_cat.getLeafCat();
    }

    /*** Get list of sub-categories or items under this category. ***/
    int num_of_row=0;
    if (leaf_cat.equals("Y"))
    {
      ItemBean.refreshList(id, language);
      num_of_row = ItemBean.getListSize();
    }
    else
    {
      CategoryBean.refreshList(id, language); 
      num_of_row = CategoryBean.getListSize();
    }
%>


<table border="0" width="100%" cellspacing="5" cellpadding="0">
  <tr>
    <td valign="top" align="left" colspan="2">
      <font size="4" face="Arial"><strong><%= cat_name %></strong></font>
    </td>
  </tr>

<%
      /**************************************/
      /***** Sub-category or Item List ******/
      /**************************************/

    for (int i=0; i<num_of_row; i++)
    {
      String name = "", link="";
      if (leaf_cat.equals("Y"))
      {
        Item item = ItemBean.getItemAt(i);
        name = item.getItemName();
        link = new String("Product.jsp?Type=ITEM&ID=" + item.getItemID());
      }
      else
      {
        Category subcat = CategoryBean.getCategoryAt(i); 
        name = subcat.getCatName();
        link = new String("Product.jsp?Type=CAT&ID=" + subcat.getCatID());
      }

      String num = Integer.toString(i+1);
%>
  <tr>
    <td valign="top" align="left"><%= num %>.&nbsp;</td>
    <td valign="top" align="left" width="2000"><a href="<%= link %>"><%= name %></a></td>
  </tr>
<%
    }
%>
 

</table>
