<%@ page language="java" import="com.kplab.webeasy.Util, com.kplab.webeasy.MemberBean.*"
    contentType="text/html" %>

<jsp:useBean id="MemberBean" scope="session" class="com.kplab.webeasy.MemberBean" />

<%
//    response.setHeader("Pragma", "no-cache");
//    response.setHeader("Cache-Control", "no-cache");
//    response.setHeader("Expires", "0");
%>
          
<html>
<head>
<title>123-WebEasy Member Management</title>
<meta http-equiv="Content-Type" content="text/html">
</head>

<%! int MAX_PER_PAGE = 20; %>
<%! int DISPLAY_LANG = 1;  %>
<% 
    /****************************************/
    /******* Variables Initialization *******/
    /****************************************/

    String from      = request.getParameter("from");
    String to        = request.getParameter("to");

    int num_of_match=0, display_index=0;
    boolean first_call=true;
    if (request.getParameter("num_of_match") == null ||
        request.getParameter("display_index") == null)
    {
      /* First Call */
      /* Get the number of members with UserID between FROM and TO inclusively. */
      num_of_match    = MemberBean.getCount(from, to);
      display_index   = 0;
      first_call      = true;
    }
    else
    {
      try {
        num_of_match  = Integer.parseInt(request.getParameter("num_of_match"));
        display_index = Integer.parseInt(request.getParameter("display_index"));
      }
      catch (Exception e) {
        %>The page you selected does not exist.<%
        return;
      }
      first_call      = false;
    }

    /***** Retrieve list of members. *****/
    MemberBean.refreshList(first_call, from, to, MAX_PER_PAGE);
    int list_size     = MemberBean.getListSize();
%>



<body background="../images/bg.gif" bgcolor="white" marginheight="0" marginwidth="0"
      topmargin="5" leftmargin="5">

<font color="#800080" size="5" face="Arial"><strong>List Member</strong></font>

<%
    /***********************************/
    /***** Number of members found *****/
    /***********************************/

    if (list_size == 0)
    {
%>
      <p>Sorry, no records meet your selection criteria.</p>
<%
    }
    else
    {
%>
      <p>Total <%= Integer.toString(num_of_match) %> records are found.</p>

<%
    /*******************************/
    /******* List of members *******/
    /*******************************/
%>
      <form action="ListMember.jsp" method="POST">
      <table border="1" width="100%" cellspacing="2" cellpadding="3">

      <tr>
        <td align="center">No.</td>
        <td align="center">User-ID</td>
        <td align="center">Password</td>
        <td align="center">First name</td>
        <td align="center">Last name</td>
        <td align="center">Year of Birth</td>
        <td align="center">Gender</td>
        <td align="center">Language</td>
        <td align="center">Country</td>
        <td align="center">Occupation</td>
        <td align="center">Income range</td>
        <td align="center">Education</td>
        <td align="center">Household Size</td>
        <td align="center">E-mail Address</td>
        <td align="center">Hint Question</td>
        <td align="center">Hint Answer</td>
      </tr>

<%
      String last_user_id = null;
      for (int i=0; i<list_size; i++)
      {
        display_index++;
        Member user       = MemberBean.getMemberAt(i);
        String user_id    = user.getUserID();
        String password   = user.getPassword();
        String firstname  = user.getFirstName();
        String lastname   = user.getLastName();
        String birthyear  = user.getBirthYear();
        String gender     = user.getGender(DISPLAY_LANG);
        String language   = user.getLanguage(DISPLAY_LANG);
        String country    = user.getCountry(DISPLAY_LANG);
        String occupation = user.getOccupation(DISPLAY_LANG);
        String income     = user.getIncome(DISPLAY_LANG);
        String education  = user.getEducation(DISPLAY_LANG);
        String household  = user.getHousehold(DISPLAY_LANG);
        String email      = Util.encodeHTML(user.getEmail());
        String question   = Util.encodeHTML(user.getQuestion());
        String answer     = Util.encodeHTML(user.getAnswer());

        if (Util.isMissing(user_id))    user_id = "---";
        if (Util.isMissing(password))   password = "---";
        if (Util.isMissing(firstname))  firstname = "---";
        if (Util.isMissing(lastname))   lastname = "---";
        if (Util.isMissing(birthyear))  birthyear = "---";
        if (Util.isMissing(gender))     gender = "---";
        if (Util.isMissing(language))   language = "---";
        if (Util.isMissing(country))    country = "---";
        if (Util.isMissing(occupation)) occupation = "---";
        if (Util.isMissing(income))     income = "---";
        if (Util.isMissing(education))  education = "---";
        if (Util.isMissing(household))  household = "---";
        if (Util.isMissing(email))      email = "---";
        if (Util.isMissing(question))   question = "---";
        if (Util.isMissing(answer))     answer = "---";
%>
        <tr>
          <td align="center" nowrap><%= display_index %></td>
          <td align="center" nowrap><%= user_id    %></td>
          <td align="center" nowrap><%= password   %></td>
          <td align="center" nowrap><%= firstname  %></td>
          <td align="center" nowrap><%= lastname   %></td>
          <td align="center" nowrap><%= birthyear  %></td>
          <td align="center" nowrap><%= gender     %></td>
          <td align="center" nowrap><%= language   %></td>
          <td align="center" nowrap><%= country    %></td>
          <td align="center" nowrap><%= occupation %></td>
          <td align="center" nowrap><%= income     %></td>
          <td align="center" nowrap><%= education  %></td>
          <td align="center" nowrap><%= household  %></td>
          <td align="center" nowrap><%= email      %></td>
          <td align="center" nowrap><%= question   %></td>
          <td align="center" nowrap><%= answer     %></td>
        </tr>
<%
        last_user_id = user_id;
      }

      if (MemberBean.getMoreAvailable())
      {
        from = last_user_id;
        String s_match = Integer.toString(num_of_match);
        String s_index = Integer.toString(display_index);
%>
        <input type="hidden" name="num_of_match" value="<%= s_match %>">
        <input type="hidden" name="display_index" value="<%= s_index %>">
        <input type="hidden" name="from" value="<%= from %>">
        <input type="hidden" name="to" value="<%= to %>">

        <tr>
          <td align="left" colspan="16"><input type="submit" value="Next Page">
            <a href="index.html">Exit</a>
          </td>
        </tr>
<%
      }
%>

      </table>
      </form>
<%
    }
%>

</body>
</html>
