/*
 * Decompiled with CFR 0.152.
 */
package com.jeans.trayicon;

import com.jeans.trayicon.TrayBalloonEvent;
import com.jeans.trayicon.TrayBalloonListener;
import com.jeans.trayicon.TrayDummyComponent;
import com.jeans.trayicon.TrayIconCallback;
import com.jeans.trayicon.TrayIconException;
import com.jeans.trayicon.TrayIconKeeper;
import com.jeans.trayicon.TrayIconPopup;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.PixelGrabber;
import java.util.Enumeration;
import java.util.Vector;

public class WindowsTrayIcon {
    public static final String TRAY_VERSION = "1.7.9b";
    private static TrayIconKeeper m_Keeper;
    private static TrayDummyComponent m_Dummy;
    private static MouseListener m_MouseHook;
    private static Window m_CurrentWindow;
    public static final int BALLOON_NONE = 0;
    public static final int BALLOON_INFO = 1;
    public static final int BALLOON_WARNING = 2;
    public static final int BALLOON_ERROR = 3;
    public static final int BALLOON_NOSOUND = 16;
    public static final int UNICODE_CONV_BALLOON = 2;
    public static final int UNICODE_CONV_SUPPORT = 1;
    public static final int NOERR = 0;
    public static final int NOTIFYPROCERR = -1;
    public static final int TOOMANYICONS = -2;
    public static final int NOTENOUGHMEM = -3;
    public static final int WRONGICONID = -4;
    public static final int DLLNOTFOUND = -5;
    public static final int NOVMS = -6;
    public static final int ERRTHREAD = -7;
    public static final int METHODID = -8;
    public static final int NOLISTENER = -9;
    public static final int JNIERR = -10;
    public static final int ERRORBALLOON = -18;
    public static final int FLASHW_STOP = 0;
    public static final int FLASHW_CAPTION = 1;
    public static final int FLASHW_TRAY = 2;
    public static final int FLASHW_ALL = 3;
    public static final int FLASHW_TIMER = 4;
    public static final int FLASHW_TIMERNOFG = 12;
    public static final int WIN_VER_UNKNOWN = 0;
    public static final int WIN_VER_WIN32 = 1;
    public static final int WIN_VER_95 = 2;
    public static final int WIN_VER_98 = 3;
    public static final int WIN_VER_ME = 4;
    public static final int WIN_VER_NT = 5;
    public static final int WIN_VER_2K = 6;
    public static final int WIN_VER_XP = 7;
    public static final int WIN_VER_NET = 8;
    private int m_ID;
    private TrayIconPopup m_Popup;
    private Vector m_ActList;
    private Vector m_MouseList;
    private Vector m_BalloonList;
    private static TrayIconCallback m_WMessageCallback;
    private static final int MOUSE_BTN_UP = 1;
    private static final int MOUSE_BTN_DOUBLE = 2;
    static final int POPUP_TYPE_ITEM = 0;
    static final int POPUP_TYPE_SEPARATOR = 1;
    static final int POPUP_TYPE_CHECKBOX = 2;
    static final int POPUP_TYPE_INIT_LEVEL = 3;
    static final int POPUP_TYPE_DONE_LEVEL = 4;
    static final int POPUP_MODE_ENABLE = 1;
    static final int POPUP_MODE_CHECK = 2;
    static final int POPUP_MODE_DEFAULT = 4;

    public static void initTrayIcon(String string) {
        WindowsTrayIcon.initTrayIcon(string, new WindowsTrayIcon());
    }

    public static void cleanUp() {
        if (m_Keeper != null) {
            m_Keeper.doNotify();
            m_Keeper = null;
        }
        WindowsTrayIcon.termTrayIcon();
    }

    public WindowsTrayIcon(Image image, int n, int n2) throws TrayIconException, InterruptedException {
        this.m_ID = WindowsTrayIcon.getFreeId();
        if (this.m_ID == -2) {
            throw new TrayIconException("Too many icons allocated");
        }
        if (this.m_ID == -5) {
            throw new TrayIconException("Error initializing native code DLL");
        }
        if (this.m_ID == -1) {
            throw new TrayIconException("Error setting up Windows notify procedure");
        }
        this.setImage(image, n, n2);
    }

    public void setImage(Image image, int n, int n2) throws TrayIconException, InterruptedException {
        try {
            int[] nArray = new int[n * n2];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
            pixelGrabber.grabPixels();
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                this.freeIcon();
                throw new TrayIconException("Error loading icon image");
            }
            WindowsTrayIcon.setIconData(this.m_ID, n, n2, nArray);
        }
        catch (InterruptedException interruptedException) {
            this.freeIcon();
            throw interruptedException;
        }
        catch (NullPointerException nullPointerException) {
            this.freeIcon();
            throw nullPointerException;
        }
    }

    public void setVisible(boolean bl) {
        WindowsTrayIcon.showIcon(this.m_ID, bl);
    }

    public boolean isVisible() {
        return WindowsTrayIcon.testVisible(this.m_ID) == 1;
    }

    public void setToolTipText(String string) {
        WindowsTrayIcon.setToolTip(this.m_ID, string);
    }

    public void showBalloon(String string, String string2, int n, int n2) throws TrayIconException {
        if (WindowsTrayIcon.showBalloon(this.m_ID, string, string2, n, n2) == 0) {
            throw new TrayIconException("Error showing Balloon message");
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.m_ActList == null) {
            this.m_ActList = new Vector();
            WindowsTrayIcon.clickEnable(this, this.m_ID, true);
        }
        this.m_ActList.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_ActList.removeElement(actionListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.m_MouseList == null) {
            this.m_MouseList = new Vector();
            WindowsTrayIcon.clickEnable(this, this.m_ID, true);
        }
        this.m_MouseList.addElement(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.m_MouseList.removeElement(mouseListener);
    }

    public void addBalloonListener(TrayBalloonListener trayBalloonListener) {
        if (this.m_BalloonList == null) {
            this.m_BalloonList = new Vector();
            WindowsTrayIcon.clickEnable(this, this.m_ID, true);
        }
        this.m_BalloonList.addElement(trayBalloonListener);
    }

    public void removeBalloonListener(TrayBalloonListener trayBalloonListener) {
        this.m_BalloonList.removeElement(trayBalloonListener);
    }

    public void setPopup(TrayIconPopup trayIconPopup) {
        if (trayIconPopup == null) {
            this.m_Popup = null;
            WindowsTrayIcon.initPopup(this.m_ID, -1);
        } else {
            if (this.m_Popup == null) {
                WindowsTrayIcon.clickEnable(this, this.m_ID, true);
            }
            int n = trayIconPopup.getNbLevels();
            WindowsTrayIcon.initPopup(this.m_ID, n);
            trayIconPopup.setTrayIcon(this, this.m_ID, -1);
            this.m_Popup = trayIconPopup;
        }
    }

    public void freeIcon() {
        WindowsTrayIcon.clickEnable(this, this.m_ID, false);
        WindowsTrayIcon.freeIcon(this.m_ID);
    }

    public static native void setAlwaysOnTop(Component var0, boolean var1);

    public static native void enableUnicodeConversion(int var0, boolean var1);

    public static native boolean hasUnicodeConversion(int var0);

    public static native boolean supportsBalloonMessages();

    public static native int getLastError();

    public static native boolean isRunning(String var0);

    public static native int sendWindowsMessage(String var0, int var1);

    public static void setWindowsMessageCallback(TrayIconCallback trayIconCallback) {
        m_WMessageCallback = trayIconCallback;
    }

    public static void keepAlive() {
        if (m_Keeper == null) {
            m_Keeper = new TrayIconKeeper();
            m_Keeper.start();
        }
    }

    public static void flashWindow(Frame frame) throws TrayIconException {
        WindowsTrayIcon.flashWindow(frame, 15, 0, 0);
    }

    public static void flashWindow(Frame frame, int n, int n2, int n3) throws TrayIconException {
        WindowsTrayIcon.flashWindow(frame.getTitle(), n, n2, n3);
    }

    public static void flashWindow(String string, int n, int n2, int n3) throws TrayIconException {
        if (!WindowsTrayIcon.flashWindowImpl(string, n, n2, n3)) {
            throw new TrayIconException("Flash window not supported");
        }
    }

    public static native boolean flashWindowImpl(String var0, int var1, int var2, int var3);

    public static void setCurrentWindow(Window window) {
        m_CurrentWindow = window;
    }

    public static native String getWindowsVersionString();

    public static native int getWindowsVersion();

    public static boolean supportsBallonInfo() {
        int n = WindowsTrayIcon.getWindowsVersion();
        return n >= 6;
    }

    private WindowsTrayIcon() {
    }

    public static TrayDummyComponent getDummyComponent() {
        if (m_Dummy == null) {
            m_Dummy = new TrayDummyComponent();
        }
        return m_Dummy;
    }

    private void notifyMouseListeners(int n, int n2, int n3, int n4) {
        Object object;
        Object object2;
        boolean bl;
        int n5 = (n2 & 2) != 0 ? 2 : 1;
        boolean bl2 = bl = (n2 & 1) != 0;
        if (this.m_ActList != null && n5 == 1 && !bl) {
            ActionEvent actionEvent = null;
            actionEvent = n == 0 ? new ActionEvent(this, 0, "Left") : (n == 1 ? new ActionEvent(this, 0, "Right") : new ActionEvent(this, 0, "Middle"));
            object2 = this.m_ActList.elements();
            while (object2.hasMoreElements()) {
                object = (ActionListener)object2.nextElement();
                object.actionPerformed(actionEvent);
            }
        }
        if (this.m_MouseList != null) {
            int n6 = 0;
            n6 = n == 0 ? (n6 |= 0x10) : (n == 1 ? (n6 |= 8) : (n6 |= 4));
            object2 = new MouseEvent(WindowsTrayIcon.getDummyComponent(), 0, 0L, n6, n3, n4, n5, n == 1);
            object = this.m_MouseList.elements();
            while (object.hasMoreElements()) {
                MouseListener mouseListener = (MouseListener)object.nextElement();
                if (bl) {
                    mouseListener.mouseReleased((MouseEvent)object2);
                    continue;
                }
                mouseListener.mousePressed((MouseEvent)object2);
            }
        }
    }

    private void notifyBalloonListeners(int n) {
        if (this.m_BalloonList != null) {
            TrayBalloonEvent trayBalloonEvent = new TrayBalloonEvent(n);
            Enumeration enumeration = this.m_BalloonList.elements();
            while (enumeration.hasMoreElements()) {
                TrayBalloonListener trayBalloonListener = (TrayBalloonListener)enumeration.nextElement();
                trayBalloonListener.balloonChanged(trayBalloonEvent);
            }
        }
    }

    private void notifyMenuListeners(int n) {
        if (this.m_Popup != null) {
            this.m_Popup.onSelected(n);
        }
    }

    private static int callWindowsMessage(int n) {
        if (m_WMessageCallback != null) {
            return m_WMessageCallback.callback(n);
        }
        return 0;
    }

    private static void callMouseHook(int n, int n2) {
        if (m_MouseHook != null) {
            MouseEvent mouseEvent = new MouseEvent(WindowsTrayIcon.getDummyComponent(), 0, 0L, 0, n, n2, 1, true);
            m_MouseHook.mousePressed(mouseEvent);
        }
    }

    void modifyPopup(int n, int n2, boolean bl) {
        WindowsTrayIcon.modifyPopup(this.m_ID, n, n2, bl);
    }

    static native void initPopup(int var0, int var1);

    static native int subPopup(int var0, int var1, String var2, int var3, int var4);

    private static native void modifyPopup(int var0, int var1, int var2, boolean var3);

    private static native int getFreeId();

    private static native void setIconData(int var0, int var1, int var2, int[] var3);

    private static native void showIcon(int var0, boolean var1);

    private static native int testVisible(int var0);

    private static native void clickEnable(WindowsTrayIcon var0, int var1, boolean var2);

    private static native void setToolTip(int var0, String var1);

    private static native void freeIcon(int var0);

    private static native void detectAllClicks(int var0);

    public static native void initJAWT();

    public static native void initHook();

    public static native void setMouseHookEnabled(int var0);

    public static void setMouseClickHook(MouseListener mouseListener) {
        m_MouseHook = mouseListener;
        WindowsTrayIcon.setMouseHookEnabled(mouseListener == null ? 0 : 1);
    }

    private static native void initTrayIcon(String var0, WindowsTrayIcon var1);

    private static native int showBalloon(int var0, String var1, String var2, int var3, int var4);

    private static native void termTrayIcon();

    public static Window getCurrentWindow() {
        return m_CurrentWindow;
    }

    static {
        String string;
        boolean bl = false;
        String string2 = System.getProperty("java.version");
        if (string2.length() >= 3 && !(string = string2.substring(0, 3)).equals("1.1")) {
            System.loadLibrary("lib/MM3-TrayIcon");
            bl = true;
        }
        if (!bl) {
            System.out.println("Wrong Java VM version: " + string2);
            System.exit(-1);
        }
    }
}

