/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.FontNameRenderer;
import com.borland.dbswing.JdbCheckBox;
import com.borland.dbswing.JdbLabel;
import com.borland.dbswing.RepeatButton;
import com.borland.dbswing.Res;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

class FontChooserDialog
extends JDialog
implements ActionListener,
ItemListener {
    JPanel mainPanel = new JPanel();
    JComboBox fontNameComboBox = new JComboBox();
    JdbLabel fontNameLabel = new JdbLabel();
    JComboBox fontSizeComboBox = new JComboBox();
    JdbLabel fontSizeLabel = new JdbLabel();
    Border border1;
    TitledBorder titledBorder1;
    JTextArea sampleTextArea = new JTextArea(null){

        public boolean isFocusTraversable() {
            return false;
        }
    };
    JPanel samplePanel = new JPanel();
    JPanel fontNamePanel = new JPanel();
    JPanel fontSizePanel = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    GridLayout gridLayout3 = new GridLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JdbCheckBox localFontCheckBox = new JdbCheckBox();
    JScrollPane jScrollPane1 = new JScrollPane();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel mainFontPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel innerButtonPanel = new JPanel();
    RepeatButton okButton = new RepeatButton();
    RepeatButton cancelButton = new RepeatButton();
    GridLayout gridLayout1 = new GridLayout();
    JPanel outerButtonPanel = new JPanel();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    JLabel fillerLabel = new JLabel();
    private GraphicsEnvironment graphicsEnvironment;
    private boolean okPressed = false;

    public FontChooserDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            frame.setCursor(Cursor.getPredefinedCursor(3));
            this.jbInit();
            this.pack();
            this.fillFontNames();
            this.setSelectedFont(this.sampleTextArea.getFont());
            this.setDefaultCloseOperation(2);
            this.fontSizeComboBox.setSelectedItem(Float.toString(this.sampleTextArea.getFont().getSize2D()));
        }
        catch (Exception ex) {
            DBExceptionHandler.handleException(ex);
        }
        frame.setCursor(Cursor.getPredefinedCursor(0));
    }

    public FontChooserDialog() {
        this((Frame)null, "", true);
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEtchedBorder();
        this.titledBorder1 = new TitledBorder(this.border1, Res.bundle.getString(35));
        this.gridLayout1.setHgap(5);
        this.gridLayout1.setColumns(2);
        this.gridLayout2.setRows(2);
        this.gridLayout2.setColumns(1);
        this.gridLayout3.setRows(2);
        this.gridLayout3.setColumns(1);
        this.innerButtonPanel.setLayout(this.gridLayout1);
        this.fontNamePanel.setLayout(this.gridLayout2);
        this.fontSizePanel.setLayout(this.gridLayout3);
        this.cancelButton.setTextWithMnemonic(Res.bundle.getString(32));
        this.cancelButton.setRepeat(false);
        this.cancelButton.setDefaultButton(true);
        this.cancelButton.addActionListener(this);
        this.okButton.setTextWithMnemonic(Res.bundle.getString(31));
        this.okButton.setRepeat(false);
        this.okButton.addActionListener(this);
        this.mainFontPanel.setLayout(this.gridBagLayout1);
        this.sampleTextArea.setEditable(false);
        this.sampleTextArea.setRows(3);
        this.sampleTextArea.setHighlighter(null);
        this.sampleTextArea.setBorder(null);
        this.sampleTextArea.setText(Res.bundle.getString(37));
        this.sampleTextArea.setBackground(UIManager.getColor("TextArea.background"));
        this.sampleTextArea.setForeground(UIManager.getColor("TextArea.foreground"));
        this.sampleTextArea.setLineWrap(true);
        this.fontNameLabel.setTextWithMnemonic(Res.bundle.getString(38));
        this.fontNameComboBox.addItemListener(this);
        this.fontNameComboBox.setLightWeightPopupEnabled(false);
        this.fontNameComboBox.setRenderer(new FontNameRenderer());
        this.fontSizeLabel.setTextWithMnemonic(Res.bundle.getString(39));
        this.fontSizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"8.0", "10.0", "12.0", "14.0", "16.0", "18.0", "24.0", "36.0", "48.0"}));
        this.fontSizeComboBox.setEditable(true);
        this.fontSizeComboBox.addItemListener(this);
        this.jScrollPane1.setBorder(BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createLoweredBevelBorder()));
        this.jScrollPane1.getViewport().add((Component)this.sampleTextArea, null);
        this.mainFontPanel.add((Component)this.fontNamePanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.fontNamePanel.add(this.fontNameLabel);
        this.fontNamePanel.add(this.fontNameComboBox);
        this.mainFontPanel.add((Component)this.fontSizePanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.fontSizePanel.add(this.fontSizeLabel);
        this.fontSizePanel.add(this.fontSizeComboBox);
        this.outerButtonPanel.add((Component)this.innerButtonPanel, null);
        this.innerButtonPanel.add((Component)this.okButton, null);
        this.innerButtonPanel.add((Component)this.cancelButton, null);
        this.getContentPane().add((Component)this.mainFontPanel, "North");
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.outerButtonPanel, "South");
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.cancelButton || e2.getSource() == this.okButton) {
            this.okPressed = e2.getSource() == this.okButton;
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e2) {
        block9: {
            if (e2.getSource() == this.fontSizeComboBox) {
                if (e2.getID() != 2) {
                    try {
                        float size = Float.parseFloat(this.fontSizeComboBox.getSelectedItem().toString());
                        if ((double)size > 0.0 && (double)size < 300.0) {
                            this.sampleTextArea.setFont(this.sampleTextArea.getFont().deriveFont(size));
                            this.sampleTextArea.repaint();
                            break block9;
                        }
                        this.fontSizeComboBox.setSelectedIndex(0);
                    }
                    catch (NumberFormatException ex) {
                        this.fontSizeComboBox.setSelectedIndex(0);
                    }
                }
            } else if (e2.getSource() == this.fontNameComboBox && e2.getID() != 2) {
                Font sizelessFont = (Font)this.fontNameComboBox.getSelectedItem();
                String fontName = sizelessFont.getFontName().toUpperCase();
                if (fontName.indexOf(Res.bundle.getString(40).toUpperCase()) != -1 && !sizelessFont.isBold()) {
                    sizelessFont = sizelessFont.deriveFont(1);
                }
                if (fontName.indexOf(Res.bundle.getString(41).toUpperCase()) != -1 && !sizelessFont.isItalic()) {
                    sizelessFont = sizelessFont.isBold() ? sizelessFont.deriveFont(3) : sizelessFont.deriveFont(2);
                }
                this.sampleTextArea.setFont(sizelessFont.deriveFont(Float.parseFloat(this.fontSizeComboBox.getSelectedItem().toString())));
                this.sampleTextArea.getFont().canDisplay('a');
                this.sampleTextArea.repaint();
            }
        }
        this.updateOkButton();
    }

    void updateOkButton() {
        boolean okState = true;
        Object selectedItem = null;
        selectedItem = this.fontSizeComboBox.getSelectedItem();
        if (selectedItem != null && selectedItem instanceof String && ((String)selectedItem).length() == 0) {
            okState = false;
        }
        if (okState != this.okButton.isEnabled()) {
            this.okButton.setEnabled(okState);
        }
        if (okState) {
            this.cancelButton.setDefaultButton(false);
            this.okButton.setDefaultButton(true);
        } else {
            this.okButton.setDefaultButton(false);
            this.cancelButton.setDefaultButton(true);
        }
    }

    public void setAllowAnyFontSize(boolean allowAnyFontSize) {
        this.fontSizeComboBox.setEditable(allowAnyFontSize);
    }

    public boolean isAllowAnyFontSize() {
        return this.fontSizeComboBox.isEditable();
    }

    public void setSampleText(String text) {
        this.sampleTextArea.setText(text);
    }

    public String getSampleText() {
        return this.sampleTextArea.getText();
    }

    public void setAvailableFonts(Font[] availableFonts) {
        this.fontNameComboBox.setModel(new DefaultComboBoxModel<Font>(availableFonts));
    }

    public Font[] getAvailableFonts() {
        Font[] items = new Font[this.fontNameComboBox.getItemCount()];
        for (int itemNo = 0; itemNo < items.length; ++itemNo) {
            items[itemNo] = (Font)this.fontNameComboBox.getItemAt(itemNo);
        }
        return items;
    }

    public void setFontSizes(String[] fontSizes) {
        this.fontSizeComboBox.setModel(new DefaultComboBoxModel<String>(fontSizes));
    }

    public String[] getFontSizes() {
        String[] items = new String[this.fontSizeComboBox.getItemCount()];
        for (int itemNo = 0; itemNo < items.length; ++itemNo) {
            items[itemNo] = this.fontSizeComboBox.getItemAt(itemNo).toString();
        }
        return items;
    }

    private void fillFontNames() {
        if (this.graphicsEnvironment == null) {
            this.graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        }
        this.fontNameComboBox.setModel(new DefaultComboBoxModel<Font>(this.graphicsEnvironment.getAllFonts()));
    }

    public void setSelectedFont(Font selectedFont) {
        String fontName = selectedFont.getFontName();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.fontNameComboBox.getModel();
        for (int index = 0; index < model.getSize(); ++index) {
            Font availFont = (Font)model.getElementAt(index);
            if (!availFont.equals(selectedFont) && (availFont.getFontName().toUpperCase().indexOf(fontName.toUpperCase()) == -1 || selectedFont.isBold() != (availFont.isBold() || availFont.getFontName().toUpperCase().indexOf(Res.bundle.getString(40).toUpperCase()) != -1) || selectedFont.isItalic() != (availFont.isItalic() || availFont.getFontName().toUpperCase().indexOf(Res.bundle.getString(41).toUpperCase()) != -1))) continue;
            this.fontNameComboBox.setSelectedIndex(index);
            break;
        }
        this.fontSizeComboBox.setSelectedItem(Float.toString(selectedFont.getSize2D()));
        this.sampleTextArea.setFont(selectedFont.deriveFont(selectedFont.getSize2D()));
        this.sampleTextArea.getFont().canDisplay('a');
        this.sampleTextArea.repaint();
    }

    public Font getSelectedFont() {
        return this.sampleTextArea.getFont();
    }

    public boolean isOKPressed() {
        return this.okPressed;
    }
}

