/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBDesignTimeSupport;
import com.borland.dbswing.DBRuntimeEvent;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetAware;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.dataset.Store;
import com.borland.jb.util.EventMulticaster;
import java.awt.Component;
import java.beans.Beans;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.ChangeListener;

public class DBRuntimeSupport {
    private static DBRuntimeSupport runtimeSupport;
    private HashMap compBinderMap = new HashMap();
    private HashMap dataSetMap = new HashMap();
    private HashMap dataStoreMap = new HashMap();
    private transient EventMulticaster changeListeners;
    private boolean rebuildDataSetCache = true;
    private boolean rebuildDataStoreCache = true;
    private DataSet[] dataSets;
    private Object[] dataStores;

    protected DBRuntimeSupport() {
    }

    public static DBRuntimeSupport getInstance() {
        if (runtimeSupport == null) {
            runtimeSupport = Beans.isDesignTime() ? new DBDesignTimeSupport() : new DBRuntimeSupport();
        }
        return runtimeSupport;
    }

    public int getComponentCount() {
        return this.compBinderMap.size();
    }

    public int getDataSetCount() {
        return this.dataSetMap.size();
    }

    public int getDataStoreCount() {
        return this.dataStoreMap.size();
    }

    public boolean containsComponent(Component component) {
        return this.compBinderMap.containsKey(component);
    }

    public DataSet getDataSet(Component component) {
        return ((DataSetAware)this.compBinderMap.get(component)).getDataSet();
    }

    public DataSetAware getDataSetAware(Component component) {
        return (DataSetAware)this.compBinderMap.get(component);
    }

    public void addComponent(Component component, DataSetAware dataSetAware) {
        if (dataSetAware != null) {
            this.compBinderMap.put(component, dataSetAware);
            DataSet dataSet = dataSetAware.getDataSet();
            if (dataSet != null) {
                Store store;
                int dataSetCount = 1;
                if (this.dataSetMap.containsKey(dataSet)) {
                    dataSetCount += ((Integer)this.dataSetMap.get(dataSet)).intValue();
                }
                this.dataSetMap.put(dataSet, new Integer(dataSetCount));
                if (dataSetCount == 1) {
                    this.rebuildDataSetCache = true;
                }
                if (dataSet instanceof StorageDataSet && (store = ((StorageDataSet)dataSet).getStore()) != null && store.getClass().getName().equals("com.borland.datastore.DataStore")) {
                    int storeCount = 1;
                    if (this.dataStoreMap.containsKey(store)) {
                        storeCount += ((Integer)this.dataStoreMap.get(store)).intValue();
                    }
                    this.dataStoreMap.put(store, new Integer(storeCount));
                    if (storeCount == 1) {
                        this.rebuildDataStoreCache = true;
                    }
                }
            }
            this.fireChangeEvent();
        }
    }

    public DataSetAware removeComponent(Component component) {
        DataSetAware dataSetAware = (DataSetAware)this.compBinderMap.remove(component);
        DataSet dataSet = dataSetAware.getDataSet();
        if (dataSet != null && this.dataSetMap.containsKey(dataSet)) {
            Store store;
            int dataSetCount = (Integer)this.dataSetMap.get(dataSet);
            if (dataSetCount == 1) {
                this.dataSetMap.remove(dataSet);
                this.rebuildDataSetCache = true;
            } else {
                this.dataSetMap.put(dataSet, new Integer(dataSetCount - 1));
            }
            if (dataSet instanceof StorageDataSet && (store = ((StorageDataSet)dataSet).getStore()) != null && store.getClass().getName().equals("com.borland.datastore.DataStore") && this.dataStoreMap.containsKey(store)) {
                int storeCount = (Integer)this.dataStoreMap.get(store);
                if (storeCount == 1) {
                    this.dataStoreMap.remove(store);
                    this.rebuildDataStoreCache = true;
                } else {
                    this.dataStoreMap.put(store, new Integer(storeCount - 1));
                }
            }
        }
        this.fireChangeEvent();
        return dataSetAware;
    }

    public Iterator getComponentIterator() {
        return this.compBinderMap.keySet().iterator();
    }

    public Iterator getDataBinderIterator() {
        return this.compBinderMap.values().iterator();
    }

    public Iterator getDataSetIterator() {
        return this.dataSetMap.keySet().iterator();
    }

    public Iterator getDataStoreIterator() {
        return this.dataStoreMap.keySet().iterator();
    }

    public Component[] getComponents() {
        Component[] components = new Component[this.getComponentCount()];
        Iterator componentIterator = this.getComponentIterator();
        int index = 0;
        while (componentIterator.hasNext()) {
            components[index] = (Component)componentIterator.next();
            ++index;
        }
        return components;
    }

    public DataSetAware[] getDataBinders() {
        DataSetAware[] dataSetAware = new DataSetAware[this.getComponentCount()];
        Iterator dataSetAwareIterator = this.getDataBinderIterator();
        int index = 0;
        while (dataSetAwareIterator.hasNext()) {
            dataSetAware[index] = (DataSetAware)dataSetAwareIterator.next();
            ++index;
        }
        return dataSetAware;
    }

    public DataSet[] getDataSets() {
        if (this.rebuildDataSetCache) {
            this.dataSets = new DataSet[this.getDataSetCount()];
            Iterator dataSetIterator = this.getDataSetIterator();
            int index = 0;
            while (dataSetIterator.hasNext()) {
                this.dataSets[index] = (DataSet)dataSetIterator.next();
                ++index;
            }
            this.rebuildDataSetCache = false;
        }
        return this.dataSets;
    }

    public Object[] getDataStores() {
        if (this.rebuildDataStoreCache) {
            this.dataStores = new Object[this.getDataStoreCount()];
            Iterator dataStoreIterator = this.getDataStoreIterator();
            int index = 0;
            while (dataStoreIterator.hasNext()) {
                this.dataStores[index] = dataStoreIterator.next();
                ++index;
            }
            this.rebuildDataStoreCache = false;
        }
        return this.dataStores;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners = EventMulticaster.add(this.changeListeners, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners = EventMulticaster.remove(this.changeListeners, listener);
    }

    private void fireChangeEvent() {
        if (this.changeListeners != null) {
            this.changeListeners.dispatch(new DBRuntimeEvent(this));
        }
    }
}

