function dataIn() {
  switchInOut('data', 'seldata[]');
}

function dataOut() {
  switchInOut('seldata[]', 'data');
}

function dataUpDown(pOffset) {
  var Elem = formByName('import').elements['seldata[]'];
  var J = pOffset;
  var L = Elem.options.length;
  if (pOffset < 0) {
    J = 0;
    L += pOffset;
  }
  for (var I = J; I < L; I++) {
    var Opt1 = Elem.options[I];
    var Opt2 = Elem.options[I - pOffset];
    if (Opt1.selected) {
      Elem.options[I] = new Option(Opt2.text, Opt2.value, false, Opt2.selected);
      Elem.options[I - pOffset] = new Option(Opt1.text, Opt1.value, false, Opt1.selected);
      break;
    }
  }
}

function doConfirmAction(pTab, pAction, pMsg, pIndex) {
  loadPageConfirm(pMsg, '&action=' + pAction + '&index=' + pIndex + '&tab=' + pTab);
}

function doConfirmActionDeleteCategory(pMsg) {
  if (formByName('index').elements['index'].selectedIndex > 0 && confirm(pMsg))
    submitAndAction('index', 'delete');
}

function doConfirmActionRemovePerson(pMsg, pSubIndex) {
  if (confirm(pMsg)) {
    formByName('details').elements['subindex'].value = pSubIndex;
    submitAndAction('details', 'removeperson');
  }
}

function doConfirmActionRemoveCompany(pMsg, pSubIndex) {
  if (confirm(pMsg)) {
    formByName('details').elements['subindex'].value = pSubIndex;
    submitAndAction('details', 'removecompany');
  }
}

function doConfirmActionResetSettings(pMsg) {
  loadPageConfirm(pMsg, '&page=settings&action=reset');
}

function doPopupActionAddCompany(pSubIndex) {
  formByName('details').elements['subindex'].value = pSubIndex;
  submitAndAction('details', 'addcompany');
  hidePopup();
}

function doPopupActionAddPerson(pSubIndex) {
  formByName('details').elements['subindex'].value = pSubIndex;
  submitAndAction('details', 'addperson');
  hidePopup();
}

function doPopupConfirmActionPublish(pType, pMsg, pIndex) {
  loadPageConfirm(pMsg, '&action=publish&index=' + pIndex + '&owner=' + encodeURIComponent(getSelectSelValue(formByName('popup').elements['owner'])) + '&tab=' + pType);
  hidePopup();
}

function doPopupSearchAddCompany() {
  viewPopup('plain.php?umi=org_contacts&page=addcompany.pop', 'query=' + encodeURIComponent(formByName('popup_search').elements['query'].value));
}

function doPopupSearchAddPerson() {
  viewPopup('plain.php?umi=org_contacts&page=addperson.pop', 'query=' + encodeURIComponent(formByName('popup_search').elements['query'].value));
}

function getDynCompany(pKeyPress) {
  var Form = formByName('details').elements;
  focusDynText(Form['dyn_company'], Form['company'], pKeyPress);
  if (pKeyPress || getHtml('dyn_company') == '')
    doHttpRequest('plain.php?umi=org_contacts&page=company.dyn', 'showDynCompany', '', 'name=' + encodeURIComponent(Form['company'].value));
  else
    displayElemById('dyn_company', 'inline');
}

function goCreateCustomerCompany(pIndex) {
  go('index.php?umi=crm_customers&page=details&company=' + pIndex + '&name=' + encodeURIComponent(formByName('details').elements['name'].value));
}

function goCreateCustomerPerson(pIndex) {
  var Form = formByName('details').elements;
  go('index.php?umi=crm_customers&page=details&name=' + encodeURIComponent(Form['firstname'].value + ' ' + Form['lastname'].value) + '&person=' + pIndex);
}

function goCreateMessage() {
  var List = formByName('details').elements['email'].value.split(/\n/);
  go('index.php?umi=col_messages&page=edit&email=' + (List.length == 0 ? '' : encodeURIComponent(List[0])));
}

function goCreateSupplierCompany(pIndex) {
  go('index.php?umi=erp_suppliers&page=details&company=' + pIndex + '&name=' + encodeURIComponent(formByName('details').elements['name'].value));
}

function goCreateSupplierPerson(pIndex) {
  var Form = formByName('details').elements;
  go('index.php?umi=erp_suppliers&page=details&name=' + encodeURIComponent(Form['firstname'].value + ' ' + Form['lastname'].value) + '&person=' + pIndex);
}

function goWebsite() {
  var S = formByName('details').elements['website'].value;
  if (S != '')
    goBlank(S);
}

function hideDynCompany() {
  hideDynBox('dyn_company');
}

function selAllImport() {
  selAll(formByName('import').elements['index[]']);
}

function selAllSelCat() {
  selAll(formByName('details').elements['selcat[]']);
}

function selAllSettingsCompanies() {
  selAll(formByName('settings').elements['companies[]']);
}

function selAllSettingsPeople() {
  selAll(formByName('settings').elements['people[]']);
}

function selSort(pObj) {
  if (getSelectSelValue(pObj) == '')
    pObj.selectedIndex = 0;
  else
    submitForm('view');
}

function setDynCompany(pIndex, pName) {
  var Form = formByName('details').elements;
  Form['dyn_company'].value = pIndex;
  Form['company'].value = pName;
  Form['company'].style.borderBottomColor = '#308030';
}

function setDynImport(pValue, pParam) {
  if (pValue != '')
    setHtml(pValue, 'import_title');
  _ImportCount--;
  if (_ImportCount == 0) {
    window.setTimeout('hidePopup();', 500);
    loadPage('');
  }
}

function showDynCompany(pValue, pParam) {
  showDynBox(pValue, 'dyn_company', formByName('details').elements['company'].offsetWidth);
}

function showPopupImport(pValue, pParam) {
  showPopup(pValue, pParam);
  elementById('popup_modal').onclick = null;
  _ImportCount = pParam[3].length;
  for (var I = 0; I < pParam[3].length; I++)
    doHttpRequest('plain.php?umi=org_contacts&page=import_' + (pParam[2] == 0 ? 'person' : 'company') + '.dyn', 'setDynImport', '', 'dest=' + encodeURIComponent(pParam[0]) + '&index=' + pParam[3][I] + '&datafile=' + pParam[1]);
}

function submitImport() {
  var Elem = formByName('import').elements['seldata[]'].options;
  for (var I = 0; I < Elem.length; I++)
    Elem[I].selected = true;
  showIndicator();
}

function switchInOut(pFrom, pTo) {
  var Form = formByName('import').elements;
  Form[pTo].selectedIndex = -1;
  for (var I = 0; I < Form[pFrom].options.length; I++) {
    var Elem = Form[pFrom].options[I];
    if (Elem.selected) {
      if (pTo != 'data' || Elem.value != '_')
        Form[pTo].options[Form[pTo].options.length] = new Option(Elem.text, Elem.value, false, true);
      if (pFrom != 'data' || Elem.value != '_') {
        Form[pFrom].options[I] = null;
        I--;
      }
    }
  }
}

function updatePerson() {
  with (formByName('details'))
    setHtml(htmlcode(elements['firstname'].value + ' ' + elements['lastname'].value), 'title');
}

function viewPopupAddCompany() {
  viewPopup('plain.php?umi=org_contacts&page=addcompany.pop', '');
}

function viewPopupAddPerson() {
  viewPopup('plain.php?umi=org_contacts&page=addperson.pop', '');
}

function viewPopupHistoryCompany(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=org_contacts_companies&index=' + pIndex);
}

function viewPopupHistoryPerson(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=org_contacts_people&index=' + pIndex);
}

function viewPopupImport(pMsg, pDest, pDataFile, pType) {
  if (confirm(pMsg)) {
    showIndicatorPopup();
    var Form = formByName('import').elements;
    var List = new Array(pDest, pDataFile, pType, getAllOptSelValues(Form['index[]']));
    doHttpRequest('plain.php?umi=org_contacts&page=import.pop', 'showPopupImport', List, '');
  }
}

function viewPopupPublish(pType, pIndex) {
  viewPopup('plain.php?umi=org_contacts&page=publish.pop', 'index=' + pIndex + '&type=' + pType);
}