function calcOutput(pObj, pReload) {
  with (formByName('details'))
    setHtml(elements['output'].value * elements['target'].value, 'calc');
  if (pReload)
    submitForm('details');
}

function doActionAddOrder(pObj) {
  var S = getSelectSelValue(pObj);
  if (S == '')
    pObj.selectedIndex = 0;
  else
    submitAndAction('details', 'add');
}

function doConfirmAction(pAction, pMsg, pStorage, pIndex) {
  loadPageConfirm(pMsg, '&action=' + pAction + '&index=' + pIndex + '&storage=' + pStorage);
}

function doConfirmActionCancelOrder(pMsg, pSubIndex) {
  if (confirm(pMsg)) {
    formByName('details').elements['subindex'].value = pSubIndex;
    submitAndAction('details', 'cancelorder');
  }
}

function doConfirmActionCancelOrder2(pMsg, pIndex) {
  loadPageConfirm(pMsg, '&page=orders&action=cancel&index=' + pIndex);
}

function doConfirmActionDeleteCategory(pMsg) {
  if (formByName('index').elements['category'].selectedIndex > 0 && confirm(pMsg))
    submitAndAction('index', 'delete');
}

function doConfirmActionRemoveFile(pMsg, pSubIndex) {
  if (confirm(pMsg)) {
    formByName('details').elements['subindex'].value = pSubIndex;
    submitAndAction('details', 'removefile');
  }
}

function doConfirmActionRemoveItem(pMsg, pIndex) {
  if (confirm(pMsg)) {
    formByName('details').elements['index'].value = pIndex;
    submitAndAction('details', 'remove');
  }
}

function doConfirmActionRemoveSupplier(pMsg, pSubIndex) {
  if (confirm(pMsg)) {
    formByName('details').elements['subindex'].value = pSubIndex;
    submitAndAction('details', 'removesupplier');
  }
}

function doConfirmActionResetSettings(pMsg) {
  loadPageConfirm(pMsg, '&page=settings&action=reset');
}

function doConfirmActionStorages(pAction, pMsg, pIndex) {
  loadPageConfirm(pMsg, '&page=storages&action=' + pAction + '&index=' + pIndex);
}

function doConfirmActionTemplates(pAction, pMsg, pIndex) {
  loadPageConfirm(pMsg, '&page=templates&action=' + pAction + '&index=' + pIndex);
}

function doIndexConfirmAction(pAction, pMsg, pStorage) {
  doConfirmAction(pAction, pMsg, pStorage, getOptSelValue(formByName('index').elements['index']));
}

function doIndexConfirmActionStorages(pAction, pMsg) {
  doConfirmActionStorages(pAction, pMsg, getOptSelValue(formByName('index').elements['index']));
}

function doIndexConfirmActionTemplates(pAction, pMsg) {
  doConfirmActionTemplates(pAction, pMsg, getOptSelValue(formByName('index').elements['index']));
}

function doPopupActionAddFile(pSubIndex) {
  formByName('details').elements['subindex'].value = pSubIndex;
  submitAndAction('details', 'addfile');
  hidePopup();
}

function doPopupActionAddSupplier(pSubIndex) {
  formByName('details').elements['subindex'].value = pSubIndex;
  submitAndAction('details', 'addsupplier');
  hidePopup();
}

function doPopupActionScanSerials() {
  var List = formByName('popup').elements['serials'].value.replace(/[,\r\t]/g, '').split("\n");
  var List2 = new Array();
  for (var I = 0; I < List.length; I++)
    if (List[I] != '')
      List2.push(List[I]);
  formByName('details').elements['serials'].value = List2.join(', ');
  hidePopup();
}

function doPopupActionSelItems(pItemsFile) {
  var List = getAllOptSelValues(formByName('popup').elements['selitems']);
  if (List.length > 0)
    doHttpRequest('plain.php?umi=erp_stockcalc&page=selitems.do', 'retSubmitForm', 'details', 'itemsfile=' + pItemsFile + '&selitems=' + encodeURIComponent(List.join('|')));
}

function doPopupActionSelSerials() {
  formByName('details').elements['serials'].value = getAllOptSelValues(formByName('popup').elements['selserials']).join(', ');
  hidePopup();
}

function doPopupActionSelSerialsRegProduction(pSubIndex) {
  var List = getAllOptSelValues(formByName('popup').elements['selserials']);
  var Form = formByName('details').elements;
  var Elem;
  var I = 0;
  while (Elem = Form['serials2[' + pSubIndex + '_' + I + ']']) {
    Elem.value = List.length > I ? List[I] : '';
    I++;
  }
  hidePopup();
}

function doPopupSearchAddFile() {
  viewPopup('plain.php?umi=erp_stockcalc&page=addfile.pop', 'query=' + encodeURIComponent(formByName('popup_search').elements['query'].value));
}

function doPopupSearchAddSupplier() {
  viewPopup('plain.php?umi=erp_stockcalc&page=addsupplier.pop', 'query=' + encodeURIComponent(formByName('popup_search').elements['query'].value));
}

function doPopupSearchSelItems(pItemsFile) {
  with (formByName('popup_search'))
    viewPopup('plain.php?umi=erp_stockcalc&page=selitems.pop', 'itemsfile=' + pItemsFile + '&query=' + encodeURIComponent(elements['query'].value) + '&storage=' + getSelectSelValue(elements['storage']));
}

function doPromptActionRenameSerial(pMsg, pSerial) {
  var S = prompt(pMsg, pSerial);
  if (S != null && S != '') {
    var Form = formByName('details').elements;
    Form['newserial'].value = S;
    Form['oldserial'].value = pSerial;
    submitAndAction('details', 'renameserial');
  }
}

function doPromptActionResetPrice(pMsg, pSubIndex) {
  var S = prompt(pMsg, '');
  if (S != null && S != '') {
    var Form = formByName('details').elements;
    Form['resetprice'].value = S;
    Form['subindex'].value = pSubIndex;
    submitAndAction('details', 'resetprice');
  }
}

function doPromptActionSetInfo(pMsg) {
  var Form = formByName('details').elements;
  var Elem = Form['info'];
  if (getSelectSelValue(Elem) == '')
    Elem.selectedIndex = 0;
  else {
    var S = prompt(pMsg, '');
    if (S == null)
      Elem.selectedIndex = 0;
    else {
      Form['action'].value = 'setinfo';
      Form['input'].value = S;
      submitForm('details');
    }
  }
}

function doPromptActionSetMailDate(pMsg, pIndex) {
  var S = prompt(pMsg, '');
  if (S != null && S != '')
    loadPage('&page=printouts&action=setmaildate&date=' + encodeURIComponent(S) + '&index=' + pIndex);
}

function focusNextSerial(pId) {
  if (_KeyCode == 13)
    formByName('details').elements['serials[' + pId + ']'].select();
}

function getDynItem(pKeyPress) {
  var Form = formByName('details').elements;
  focusDynText(Form['subitem'], Form['dyn_item'], pKeyPress);
  if (pKeyPress || getHtml('dyn_item') == '')
    doHttpRequest('plain.php?umi=erp_stockcalc&page=item.dyn', 'showDynItem', '', 'name=' + encodeURIComponent(Form['dyn_item'].value));
  else
    displayElemById('dyn_item', 'inline');
}

function getDynManufacturer(pKeyPress) {
  var Form = formByName('details').elements;
  if (pKeyPress || getHtml('dyn_manufacturer') == '')
    doHttpRequest('plain.php?umi=erp_stockcalc&page=manufacturer.dyn', 'showDynManufacturer', '', 'name=' + encodeURIComponent(Form['manufacturer'].value));
  else
    displayElemById('dyn_manufacturer', 'inline');
}

function getDynPreview(pIndex) {
  if (elementById('index_preview').style.display != 'none')
    doHttpRequest('plain.php?umi=erp_stockcalc&page=preview.dyn', 'setHtml', 'index_preview', 'index=' + pIndex);
}

function getDynScan(pMsg) {
  var S = formByName('popup').elements['barcode'].value
  if (S != '')
    doHttpRequest('plain.php?umi=erp_stockcalc&page=scan.dyn', 'setDynScan', pMsg, 'barcode=' + encodeURIComponent(S));
}

function getDynStorage(pKeyPress) {
  var Form = formByName('details').elements;
  focusDynText(Form['storage'], Form['dyn_storage'], pKeyPress);
  if (pKeyPress || getHtml('dyn_storage') == '')
    doHttpRequest('plain.php?umi=erp_stockcalc&page=storage.dyn', 'showDynStorage', '', 'name=' + encodeURIComponent(Form['dyn_storage'].value));
  else
    displayElemById('dyn_storage', 'inline');
}

function getDynSupplier(pKeyPress) {
  var Form = formByName('details').elements;
  focusDynText(Form['supplier'], Form['dyn_supplier'], pKeyPress);
  if (pKeyPress || getHtml('dyn_supplier') == '')
    doHttpRequest('plain.php?umi=erp_stockcalc&page=supplier.dyn', 'showDynSupplier', '', 'name=' + encodeURIComponent(Form['dyn_supplier'].value));
  else
    displayElemById('dyn_supplier', 'inline');
}

function goAssignedUser() {
  var S = getSelectSelValue(formByName('details').elements['assigneduser']);
  if (S != '')
    go('index.php?umi=admin_users&page=details&id=' + encodeURIComponent(S));
}

function goPreviewTemplate() {
  go('plain.php?umi=erp_stockcalc&page=print.pdf&template=' + getOptSelValue(formByName('index').elements['index']));
}

function goStorage() {
  var S = formByName('details').elements['storage'].value;
  if (S != '')
    loadPage('&page=details_storage&index=' + S);
}

function hideDynItem() {
  hideDynBox('dyn_item');
}

function hideDynManufacturer() {
  hideDynBox('dyn_manufacturer');
}

function hideDynStorage() {
  hideDynBox('dyn_storage');
}

function hideDynSupplier() {
  hideDynBox('dyn_supplier');
}

function selCategory() {
  var Form = formByName('index').elements;
  var Elem = Form['category'];
  if (Elem.selectedIndex > 0) {
    Form['action'].value = 'update';
    Form['update'].value = Form['label1'].value;
    Form['original'].value = Form['number'].value = getSelectSelValue(Elem);
    Form['name'].value = Elem.options[Elem.selectedIndex].text;
  } else {
    Form['action'].value = 'add';
    Form['update'].value = Form['label2'].value;
    Form['original'].value = Form['number'].value = '';
    Form['name'].value = '';
  }
}

function selTemplate(pObj) {
  if (getSelectSelValue(pObj) == '')
    pObj.selectedIndex = 0;
  else
    submitForm('printout');
}

function setDynItem(pIndex, pUseSerials, pName) {
  var Form = formByName('details').elements;
  Form['subitem'].value = pIndex;
  Form['dyn_item'].value = pName;
  Form['dyn_item'].style.borderBottomColor = '#308030';
  displayElemById('serials', pUseSerials == '0' ? 'none' : 'table-row');
}

function setDynManufacturer(pName) {
  formByName('details').elements['manufacturer'].value = pName;
}

function setDynScan(pValue, pMsg) {
  if (pValue == -1)
    window.alert(pMsg);
  else {
    loadPage('&page=details_item&index=' + pValue);
    hidePopup();
  }
}

function setDynStorage(pIndex, pName) {
  var Form = formByName('details').elements;
  Form['storage'].value = pIndex;
  Form['dyn_storage'].value = pName;
  Form['dyn_storage'].style.borderBottomColor = '#308030';
}

function setDynSupplier(pIndex, pName) {
  var Form = formByName('details').elements;
  Form['supplier'].value = pIndex;
  Form['dyn_supplier'].value = pName;
  Form['dyn_supplier'].style.borderBottomColor = '#308030';
}

function showDynItem(pValue, pParam) {
  showDynBox(pValue, 'dyn_item', formByName('details').elements['dyn_item'].offsetWidth);
}

function showDynManufacturer(pValue, pParam) {
  showDynBox(pValue, 'dyn_manufacturer', formByName('details').elements['manufacturer'].offsetWidth);
}

function showDynStorage(pValue, pParam) {
  showDynBox(pValue, 'dyn_storage', formByName('details').elements['dyn_storage'].offsetWidth);
}

function showDynSupplier(pValue, pParam) {
  showDynBox(pValue, 'dyn_supplier', formByName('details').elements['dyn_supplier'].offsetWidth);
}

function showPopupScanSerials(pValue, pParam) {
  showPopup(pValue, pParam);
  with (formByName('popup').elements['serials']) {
    value = formByName('details').elements['serials'].value.replace(/\s*,\s*/g, "\n");
    if (value != '')
      value += "\n";
    focus();
  }
}

function showPopupSelSerials(pValue, pParam) {
  showPopup(pValue, pParam);
  setAllOptSelValues(formByName('popup').elements['selserials'], formByName('details').elements['serials'].value.replace(/\s*,\s*/g, ',').split(','));
}

function showPopupSelSerialsRegProduction(pValue, pSubIndex) {
  showPopup(pValue, '');
  var List = new Array();
  var Elem;
  var I = 0;
  while (Elem = formByName('details').elements['serials2[' + pSubIndex + '_' + I + ']']) {
    List.push(Elem.value);
    I++;
  }
  setAllOptSelValues(formByName('popup').elements['selserials'], List);
}

function updateFile(pObj) {
  with (formByName('details').elements['title'])
    if (value == '') {
      var S = pObj.value;
      var I = S.lastIndexOf('/');
      if (I == -1)
        I = S.lastIndexOf('\\');
      if (I != -1)
        S = S.substr(I + 1, S.length - I);
      value = S;
    }
}

function viewInfoBoxSupplier() {
  var S = formByName('details').elements['supplier'].value;
  if (S != '-1')
    viewInfoBox('supplier' + S, 'plain.php?umi=erp_suppliers&page=supplier.info', 'index=' + S);
}

function viewInfoBoxSupplier2() {
  var S = getSelectSelValue(formByName('details').elements['supplier']);
  if (S != '-1')
    viewInfoBox('supplier' + S, 'plain.php?umi=erp_suppliers&page=supplier.info', 'index=' + S);
}

function viewInfoBoxUser(pId) {
  if (pId != '')
    viewInfoBox('user' + pId, 'plain.php?umi=admin_users&page=user.info', 'id=' + encodeURIComponent(pId));
}

function viewInfoBoxUser2() {
  viewInfoBoxUser(getSelectSelValue(formByName('details').elements['assigneduser']));
}

function viewPopupAddFile() {
  viewPopup('plain.php?umi=erp_stockcalc&page=addfile.pop', '');
}

function viewPopupAddSupplier() {
  viewPopup('plain.php?umi=erp_stockcalc&page=addsupplier.pop', '');
}

function viewPopupBarcode() {
  var S = formByName('details').elements['barcode'].value;
  if (S != '')
    viewPopup('plain.php?umi=erp_stockcalc&page=barcode.pop', 'data=' + encodeURIComponent(S));
}

function viewPopupHistoryItem(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=erp_stockcalc_items&index=' + pIndex);
}

function viewPopupHistoryStorage(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=erp_stockcalc_storages&index=' + pIndex);
}

function viewPopupHistoryTemplate(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=erp_stockcalc_templates&index=' + pIndex);
}

function viewPopupScan() {
  viewPopup('plain.php?umi=erp_stockcalc&page=scan.pop', '');
}

function viewPopupScanSerials() {
  doHttpRequest('plain.php?umi=erp_stockcalc&page=scanserials.pop', 'showPopupScanSerials', '', '');
}

function viewPopupSelItems(pItemsFile) {
  viewPopup('plain.php?umi=erp_stockcalc&page=selitems.pop', 'itemsfile=' + pItemsFile);
}

function viewPopupSelSerials(pIndex) {
  showIndicatorPopup();
  doHttpRequest('plain.php?umi=erp_stockcalc&page=selserials.pop', 'showPopupSelSerials', '', 'index=' + pIndex);
}

function viewPopupSelSerialsRegProduction(pIndex, pSubIndex) {
  showIndicatorPopup();
  doHttpRequest('plain.php?umi=erp_stockcalc&page=selserials.pop', 'showPopupSelSerialsRegProduction', pSubIndex, 'index=' + pIndex + '&subindex=' + pSubIndex);
}