function doConfirmAction(pAction, pMsg, pIndex) {
  loadPageConfirm(pMsg, '&action=' + pAction + '&index=' + pIndex);
}

function doConfirmActionDeleteGroup(pMsg) {
  if (formByName('index').elements['index'].selectedIndex > 0 && confirm(pMsg))
    submitAndAction('index', 'delete');
}

function doConfirmActionDeleteJournal(pMsg, pSubIndex) {
  if (confirm(pMsg)) {
    formByName('details').elements['subindex'].value = pSubIndex;
    submitAndAction('details', 'deletejournal');
  }
}

function doConfirmActionRemoveFile(pMsg, pSubIndex) {
  if (confirm(pMsg)) {
    formByName('details').elements['subindex'].value = pSubIndex;
    submitAndAction('details', 'removefile');
  }
}

function doConfirmActionRemovePerson(pMsg, pSubIndex) {
  if (confirm(pMsg)) {
    formByName('details').elements['subindex'].value = pSubIndex;
    submitAndAction('details', 'removeperson');
  }
}

function doConfirmActionResetSettings(pMsg) {
  loadPageConfirm(pMsg, '&page=settings&action=reset');
}

function doIndexConfirmAction(pAction, pMsg) {
  doConfirmAction(pAction, pMsg, getOptSelValue(formByName('index').elements['index']));
}

function doPopupActionAddFile(pSubIndex) {
  formByName('details').elements['subindex'].value = pSubIndex;
  submitAndAction('details', 'addfile');
  hidePopup();
}

function doPopupActionAddPerson(pSubIndex) {
  formByName('details').elements['subindex'].value = pSubIndex;
  submitAndAction('details', 'addperson');
  hidePopup();
}

function doPopupSearchAddFile() {
  viewPopup('plain.php?umi=crm_customers&page=addfile.pop', 'query=' + encodeURIComponent(formByName('popup_search').elements['query'].value));
}

function doPopupSearchAddPerson() {
  viewPopup('plain.php?umi=crm_customers&page=addperson.pop', 'query=' + encodeURIComponent(formByName('popup_search').elements['query'].value));
}

function editContact() {
  displayElemById('contact', 'none');
  displayElemById('edit', 'block');
}

function getDynContact(pKeyPress) {
  var Form = formByName('details').elements;
  if (pKeyPress) {
    Form['company'].value = '';
    Form['person'].value = '';
    Form['dyn_contact'].style.borderBottomColor = Form['dyn_contact'].value == '' ? '#CACACA' : '#B03030';
  }
  if (Form['dyn_contact'].value != '')
    chgBgClr(Form['dyn_contact'], Form['company'].value == '' && Form['person'].value == '' ? '#F0D0D0' : '#D0F0D0');
  if (pKeyPress || getHtml('dyn_contact') == '')
    doHttpRequest('plain.php?umi=crm_customers&page=contact.dyn', 'showDynContact', '', 'name=' + encodeURIComponent(Form['dyn_contact'].value));
  else
    displayElemById('dyn_contact', 'inline');
}


function getDynPreview(pIndex) {
  if (elementById('index_preview').style.display != 'none')
    doHttpRequest('plain.php?umi=crm_customers&page=preview.dyn', 'setHtml', 'index_preview', 'index=' + pIndex);
}

function goAssignedUser() {
  var S = getSelectSelValue(formByName('details').elements['assigneduser']);
  if (S != '')
    go('index.php?umi=admin_users&page=details&id=' + encodeURIComponent(S));
}

function goContact() {
  var Form = formByName('details').elements;
  var S = Form['person'].value;
  if (S == '') {
    S = Form['company'].value;
    if (S != '')
      go('index.php?umi=org_contacts&page=details_company&index=' + S);
  } else
    go('index.php?umi=org_contacts&page=details_person&index=' + S);
}

function hideDynContact() {
  hideDynBox('dyn_contact');
}

function replyEntry(pLabel, pContact, pSubject) {
  var Form = formByName('details').elements;
  with (Form['contact'])
    for (var I = 0; I < options.length; I++)
      if (options[I].value == pContact) {
        selectedIndex = I;
        break;
      }
  Form['label'].selectedIndex = pLabel;
  Form['subject'].value = pSubject;
  Form['text'].focus();
}

function selAllSelGroups() {
  selAll(formByName('details').elements['selgroups[]']);
}

function selAllSettingsCompanies() {
  selAll(formByName('settings').elements['companies[]']);
}

function selAllSettingsPeople() {
  selAll(formByName('settings').elements['people[]']);
}

function setDynContact(pIndexPerson, pIndexCompany, pName) {
  var Form = formByName('details').elements;
  Form['person'].value = pIndexPerson;
  Form['company'].value = pIndexCompany;
  Form['dyn_contact'].value = pName;
  Form['dyn_contact'].style.borderBottomColor = '#308030';
}

function showDynContact(pValue, pParam) {
  showDynBox(pValue, 'dyn_contact', formByName('details').elements['dyn_contact'].offsetWidth);
}

function updateFile(pObj) {
  with (formByName('details').elements['title'])
    if (value == '') {
      var S = pObj.value;
      var I = S.lastIndexOf('/');
      if (I == -1)
        I = S.lastIndexOf('\\');
      if (I != -1)
        S = S.substr(I + 1, S.length - I);
      value = S;
    }
}

function viewInfoBoxUser(pId) {
  if (pId != '')
    viewInfoBox('user' + pId, 'plain.php?umi=admin_users&page=user.info', 'id=' + encodeURIComponent(pId));
}

function viewInfoBoxUser2() {
  viewInfoBoxUser(getSelectSelValue(formByName('details').elements['assigneduser']));
}

function viewPopupAddFile() {
  viewPopup('plain.php?umi=crm_customers&page=addfile.pop', '');
}

function viewPopupAddPerson() {
  viewPopup('plain.php?umi=crm_customers&page=addperson.pop', '');
}

function viewPopupHistory(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=crm_customers_customers&index=' + pIndex);
}