function calcNumbers(pObj, pIndex) {
  with (formByName('details')) {
    var ElemSP = elements['sellingprice[]'][pIndex];
    var ElemPP = elements['purchaseprice[]'][pIndex];
    var ElemD = elements['discount[]'][pIndex];
    var ElemM = elements['markup'][pIndex];
    if (typeof(ElemSP) == 'undefined') {
      ElemSP = elements['sellingprice[]'];
      ElemPP = elements['purchaseprice[]'];
      ElemD = elements['discount[]'];
      ElemM = elements['markup'];
    }
  }
  if (pObj.name == 'markup')
    ElemSP.value = Math.round(ElemPP.value * (1 + (ElemPP.value < 0 ? - ElemM.value : ElemM.value) / 100) / (1 - ElemD.value / 100) * 100) / 100;
  else
    ElemM.value = ElemPP.value == 0 ? 0 : Math.round((ElemSP.value * (1 - ElemD.value / 100) - ElemPP.value) / Math.abs(ElemPP.value) * 10000) / 100;
}

function doActionAddDelivery(pObj, pPattern) {
  var S = getSelectSelValue(pObj);
  if (S == '')
    pObj.selectedIndex = 0;
  else {
    if (pPattern != '')
      try {
        var List = pPattern.split('|');
        eval("formByName('details').elements['invoicenum'].value = pObj.options[pObj.selectedIndex].text.replace(" + List[1] + ', List[0]);');
      } catch (Err) {}
    submitAndAction('details', 'add');
  }
}

function doConfirmAction(pTab, pAction, pMsg, pIndex) {
  loadPageConfirm(pMsg, '&action=' + pAction + '&index=' + pIndex + '&tab=' + pTab);
}

function doConfirmActionDeletePrintout(pMsg, pIndex) {
  loadPageConfirm(pMsg, '&page=printouts&action=delete&index=' + pIndex);
}

function doConfirmActionRemoveItem(pMsg, pIndex) {
  if (confirm(pMsg)) {
    formByName('details').elements['subindex'].value = pIndex;
    submitAndAction('details', 'remove');
  }
}

function doConfirmActionTemplates(pAction, pMsg, pIndex) {
  loadPageConfirm(pMsg, '&page=templates&action=' + pAction + '&index=' + pIndex);
}

function doIndexConfirmAction(pTab, pAction, pMsg) {
  doConfirmAction(pTab, pAction, pMsg, getOptSelValue(formByName('index').elements['index']));
}

function doIndexConfirmActionTemplates(pAction, pMsg) {
  doConfirmActionTemplates(pAction, pMsg, getOptSelValue(formByName('index').elements['index']));
}

function doPopupActionEditItem(pItemsFile, pIndex) {
  with (formByName('popup'))
    doHttpRequest('plain.php?umi=crm_billing&page=edititem.do', 'retSubmitForm', 'details', 'index=' + pIndex + '&itemsfile=' + pItemsFile + '&name=' + encodeURIComponent(elements['name'].value) + '&itemnum=' + encodeURIComponent(elements['itemnum'].value) + '&manufacturer=' + encodeURIComponent(elements['manufacturer'].value) + '&quantity=' + getSelectSelValue(elements['quantity']) + '&taxrate=' + elements['taxrate'].value + '&useserials=' + (elements['useserials'].checked ? elements['useserials'].value : ''));
}

function doPopupActionEditText(pItemsFile, pIndex) {
  with (formByName('popup')) {
    var S = elements['text'].value;
    if (S != '')
      doHttpRequest('plain.php?umi=crm_billing&page=edittext.do', 'retSubmitForm', 'details', 'index=' + pIndex + '&itemsfile=' + pItemsFile + '&text=' + encodeURIComponent(S) + '&variant=' + elements['variant'].value);
  }
}

function doPopupActionRetOffer(pItemsFile, pIndex) {
  var List = getAllOptSelValues(formByName('popup').elements['selitems']);
  if (List.length > 0)
    doHttpRequest('plain.php?umi=crm_billing&page=retoffer.do', 'retPopupActionRet', 'ordernum', 'index=' + pIndex + '&itemsfile=' + pItemsFile + '&selitems=' + encodeURIComponent(List.join('|')));
}

function doPopupActionRetOrder(pItemsFile, pIndex) {
  var List = getAllOptSelValues(formByName('popup').elements['selitems']);
  if (List.length > 0)
    doHttpRequest('plain.php?umi=crm_billing&page=retorder.do', 'retPopupActionRet', 'deliverynum', 'index=' + pIndex + '&itemsfile=' + pItemsFile + '&selitems=' + encodeURIComponent(List.join('|')));
}

function doPopupActionRetRequest(pItemsFile, pIndex) {
  var List = getAllOptSelValues(formByName('popup').elements['selitems']);
  if (List.length > 0)
    doHttpRequest('plain.php?umi=crm_billing&page=retrequest.do', 'retPopupActionRet', 'quotationnum', 'index=' + pIndex + '&itemsfile=' + pItemsFile + '&selitems=' + encodeURIComponent(List.join('|')));
}

function doPopupActionSelItems(pItemsFile) {
  var List = getAllOptSelValues(formByName('popup').elements['selitems']);
  if (List.length > 0)
    doHttpRequest('plain.php?umi=crm_billing&page=selitems.do', 'retSubmitForm', 'details', 'itemsfile=' + pItemsFile + '&selitems=' + encodeURIComponent(List.join('|')));
}

function doPopupActionSelSerials(pSubIndex) {
  var List = getAllOptSelValues(formByName('popup').elements['selserials']);
  var Form = formByName('details').elements;
  var Elem;
  var I = 0;
  while (Elem = Form['serials[' + pSubIndex + '_' + I + ']']) {
    Elem.value = List.length > I ? List[I] : '';
    I++;
  }
  hidePopup();
}

function doPopupSearchSelItems(pItemsFile) {
  with (formByName('popup_search'))
    viewPopup('plain.php?umi=crm_billing&page=selitems.pop', 'itemsfile=' + pItemsFile + '&query=' + encodeURIComponent(elements['query'].value) + '&storage=' + getSelectSelValue(elements['storage']));
}

function doPopupSelectRetOffer(pItemsFile) {
  with (formByName('popup_select'))
    viewPopup('plain.php?umi=crm_billing&page=retoffer.pop', 'itemsfile=' + pItemsFile + '&index=' + getSelectSelValue(elements['index']));
}

function doPopupSelectRetOrder(pItemsFile) {
  with (formByName('popup_select'))
    viewPopup('plain.php?umi=crm_billing&page=retorder.pop', 'itemsfile=' + pItemsFile + '&index=' + getSelectSelValue(elements['index']));
}

function doPopupSelectRetRequest(pItemsFile) {
  with (formByName('popup_select'))
    viewPopup('plain.php?umi=crm_billing&page=retrequest.pop', 'itemsfile=' + pItemsFile + '&index=' + getSelectSelValue(elements['index']));
}

function doPromptActionSetMailDate(pMsg, pIndex) {
  var S = prompt(pMsg, '');
  if (S != null && S != '')
    loadPage('&page=printouts&action=setmaildate&date=' + encodeURIComponent(S) + '&index=' + pIndex);
}

function dragEndMoveItem(pIndex, pInvoice) {
  if (_DragParam != '' && _DragParam != pIndex) {
    with (formByName('details').elements[pInvoice ? 'deliveries' : 'order']) {
      var List = value.split('|');
      var I = -1;
      var J = -1;
      for (var H = 0; H < List.length; H++)
        if (List[H] == pIndex)
          I = H;
        else if (List[H] == _DragParam)
          J = H;
      if (I != -1 && J != -1) {
        if (I > J) {
          List.splice(J, 0, List[I]);
          List.splice(I + 1, 1)
        } else {
          List.splice(J + 1, 0, List[I]);
          List.splice(I, 1)
        }
        value = List.join('|');
      }
    }

    var Elem1 = elementById('item' + pIndex);
    var Elem2 = elementById('item' + _DragParam);
    Elem1.parentNode.insertBefore(Elem1, I > J ? Elem2 : Elem2.nextSibling);
    var ChildrenRows = childrenElem(Elem1.parentNode, 'TR');
    I = 1;
    for (J = 1; J < ChildrenRows.length; J++) {
      var ChildCol = childElem(ChildrenRows[J], 'TD', false);
      if (ChildCol != null && ChildCol.firstChild.nodeType == 3) {
        ChildCol.firstChild.nodeValue = I;
        I++;
      }
    }
  }
}

function dragOutMoveItem(pObj) {
  pObj.style.cursor = 'move';
}

function dragOverMoveItem(pObj) {
  if (_DragAction.match(/^dragEndMoveItem/))
    pObj.style.cursor = 'url(bin/crm/billing/img/dragmove.ico),move';
}

function dragStartMoveItem(pIndex, pInvoice) {
  chgBgTxtClr(childElem(elementById('item' + pIndex), 'TD', false), '#303080', 'white');
  _DragNoAction = "chgBgTxtClr(childElem(elementById('item" + pIndex + "'), 'TD', false), 'transparent', '#202020');";
  _DragAction = "dragEndMoveItem('" + pIndex + "', " + (pInvoice ? 'true' : 'false') + ');' + _DragNoAction;
}

function dragStopMoveItem(pIndex) {
  if (_DragAction.match(/^dragEndMoveItem/))
    _DragParam = pIndex;
}

function focusNextSerial(pId) {
  if (_KeyCode == 13)
    with (formByName('details').elements['serials[' + pId + ']'])
      select();
}

function getDynCustomer(pKeyPress) {
  var Form = formByName('details').elements;
  focusDynText(Form['customer'], Form['dyn_customer'], pKeyPress);
  if (pKeyPress || getHtml('dyn_customer') == '')
    doHttpRequest('plain.php?umi=crm_billing&page=customer.dyn', 'showDynCustomer', '', 'name=' + encodeURIComponent(Form['dyn_customer'].value));
  else
    displayElemById('dyn_customer', 'inline');
}

function goPreviewTemplate() {
  go('plain.php?umi=crm_billing&page=print.pdf&template=' + getOptSelValue(formByName('index').elements['index']));
}

function hideDynCustomer() {
  hideDynBox('dyn_customer');
}

function retPopupActionRet(pValue, pName) {
  var List = pValue.split("\n");
  var Form = formByName('details').elements;
  with (Form['customer'])
    if (value == '-1')
      value = List[0];
  if (List[2] != '')
    try {
      var List2 = List[2].split('|');
      eval("Form[pName].value = List[1].replace(" + List2[1] + ', List2[0]);');
    } catch (Err) {}
  submitForm('details');
  hidePopup();
}

function selTemplate(pObj) {
  if (getSelectSelValue(pObj) == '')
    pObj.selectedIndex = 0;
  else
    submitForm('printout');
}

function setDynCustomer(pIndex, pName) {
  var Form = formByName('details').elements;
  Form['customer'].value = pIndex;
  Form['dyn_customer'].value = pName;
  Form['dyn_customer'].style.borderBottomColor = '#308030';
}

function showDynCustomer(pValue, pParam) {
  showDynBox(pValue, 'dyn_customer', formByName('details').elements['dyn_customer'].offsetWidth);
}

function showPopupSelSerials(pValue, pSubIndex) {
  showPopup(pValue, '');
  var List = new Array();
  var Elem;
  var I = 0;
  while (Elem = formByName('details').elements['serials[' + pSubIndex + '_' + I + ']']) {
    List.push(Elem.value);
    I++;
  }
  setAllOptSelValues(formByName('popup').elements['selserials'], List);
}

function viewInfoBoxCustomer(pIndex) {
  if (pIndex != '-1')
    viewInfoBox('customer' + pIndex, 'plain.php?umi=crm_customers&page=customer.info', 'index=' + pIndex);
}

function viewInfoBoxCustomer2() {
  viewInfoBoxCustomer(formByName('details').elements['customer'].value);
}

function viewInfoBoxUser(pId) {
  if (pId != '')
    viewInfoBox('user' + pId, 'plain.php?umi=admin_users&page=user.info', 'id=' + encodeURIComponent(pId));
}

function viewInfoBoxUser2() {
  viewInfoBoxUser(getSelectSelValue(formByName('details').elements['assigneduser']));
}

function viewPopupHistoryInvoice(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=crm_billing_invoices&index=' + pIndex);
}

function viewPopupHistoryOffer(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=crm_billing_offers&index=' + pIndex);
}

function viewPopupHistoryOrder(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=crm_billing_orders&index=' + pIndex);
}

function viewPopupHistoryRequest(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=crm_billing_requests&index=' + pIndex);
}

function viewPopupEditItem(pItemsFile, pIndex) {
  viewPopup('plain.php?umi=crm_billing&page=edititem.pop', 'index=' + pIndex + '&itemsfile=' + pItemsFile);
}

function viewPopupEditText(pItemsFile, pIndex) {
  viewPopup('plain.php?umi=crm_billing&page=edittext.pop', 'index=' + pIndex + '&itemsfile=' + pItemsFile);
}

function viewPopupHistoryTemplate(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=crm_billing_templates&index=' + pIndex);
}

function viewPopupRetOffer(pItemsFile) {
  viewPopup('plain.php?umi=crm_billing&page=retoffer.pop', 'itemsfile=' + pItemsFile);
}

function viewPopupRetOrder(pItemsFile) {
  viewPopup('plain.php?umi=crm_billing&page=retorder.pop', 'itemsfile=' + pItemsFile);
}

function viewPopupRetRequest(pItemsFile) {
  viewPopup('plain.php?umi=crm_billing&page=retrequest.pop', 'itemsfile=' + pItemsFile);
}

function viewPopupSelItems(pItemsFile) {
  viewPopup('plain.php?umi=crm_billing&page=selitems.pop', 'itemsfile=' + pItemsFile);
}

function viewPopupSelSerials(pIndex, pSubIndex) {
  showIndicatorPopup();
  doHttpRequest('plain.php?umi=crm_billing&page=selserials.pop', 'showPopupSelSerials', pSubIndex, 'index=' + pIndex + '&subindex=' + pSubIndex);
}