function dataIn() {
  switchInOut('data', 'seldata[]');
}

function dataOut() {
  switchInOut('seldata[]', 'data');
}

function dataUpDown(pOffset) {
  var Elem = formByName('import').elements['seldata[]'];
  var J = pOffset;
  var L = Elem.options.length;
  if (pOffset < 0) {
    J = 0;
    L += pOffset;
  }
  for (var I = J; I < L; I++) {
    var Opt1 = Elem.options[I];
    var Opt2 = Elem.options[I - pOffset];
    if (Opt1.selected) {
      Elem.options[I] = new Option(Opt2.text, Opt2.value, false, Opt2.selected);
      Elem.options[I - pOffset] = new Option(Opt1.text, Opt1.value, false, Opt1.selected);
      break;
    }
  }
}

function doConfirmAction(pTab, pAction, pMsg, pIndex) {
  loadPageConfirm(pMsg, '&action=' + pAction + '&index=' + pIndex + '&tab=' + pTab);
}

function doConfirmActionRemovePerson(pMsg, pIndex, pSubIndex) {
  loadPageConfirm(pMsg, '&page=details_company&action=removeperson&index=' + pIndex + '&subindex=' + pSubIndex);
}

function doConfirmActionRemoveCompany(pMsg, pIndex, pSubIndex) {
  loadPageConfirm(pMsg, '&page=details_person&action=removecompany&index=' + pIndex + '&subindex=' + pSubIndex);
}

function doConfirmActionResetSettings(pMsg) {
  loadPageConfirm(pMsg, '&page=settings&action=reset');
}

function doPopupActionAddCompany(pIndex, pSubIndex) {
  loadPage('&page=details_person&action=addcompany&index=' + pIndex + '&subindex=' + pSubIndex);
  hidePopup();
}

function doPopupActionAddPerson(pIndex, pSubIndex) {
  loadPage('&page=details_company&action=addperson&index=' + pIndex + '&subindex=' + pSubIndex);
  hidePopup();
}

function doPopupConfirmActionPublish(pType, pMsg, pIndex) {
  loadPageConfirm(pMsg, '&action=publish&index=' + pIndex + '&owner=' + encodeURIComponent(getSelectSelValue(formByName('popup').elements['owner'])) + '&tab=' + pType);
  hidePopup();
}

function doPopupSearchAddCompany(pIndex) {
  viewPopup('plain.php?umi=org_contacts&page=addcompany.pop', 'index=' + pIndex + '&query=' + encodeURIComponent(formByName('popup_search').elements['query'].value));
}

function doPopupSearchAddPerson(pIndex) {
  viewPopup('plain.php?umi=org_contacts&page=addperson.pop', 'index=' + pIndex + '&query=' + encodeURIComponent(formByName('popup_search').elements['query'].value));
}

function getDynCompany() {
  var Form = formByName('details').elements;
  Form['dyn_company'].value = '';
  var S = Form['company'].value;
  if (S == '')
    displayElemById('ok', 'inline');
  else {
    displayElemById('ok', 'none');
    doHttpRequest('plain.php?umi=org_contacts&page=company.dyn', 'showDynCompany', '', 'name=' + encodeURIComponent(S));
  }
}

function hideDynCompany() {
  window.setTimeout("displayElemById('dyn_company', 'none');", 300);
}

function selAllImport() {
  selAll(formByName('import').elements['index[]']);
}

function selAllSettingsCompanies() {
  selAll(formByName('settings').elements['companies[]']);
}

function selAllSettingsPeople() {
  selAll(formByName('settings').elements['people[]']);
}

function selSort(pObj) {
  if (getSelectSelValue(pObj) == '')
    pObj.selectedIndex = 0;
  else
    submitForm('view');
}

function setDynCompany(pIndex, pName) {
  var Form = formByName('details').elements;
  Form['dyn_company'].value = pIndex;
  Form['company'].value = pName;
  displayElemById('ok', 'inline');
}

function setDynImport(pValue, pParam) {
  if (pValue != '')
    setHtml(pValue, 'import_title');
  _ImportCount--;
  if (_ImportCount == 0) {
    loadPage('');
    window.setTimeout('hidePopup();', 1000);
  }
}

function showDynCompany(pValue, pParam) {
  setHtml(pValue, 'dyn_company');
  displayElemById('dyn_company', pValue == '' ? 'none' : 'block');
  var I = formByName('details').elements['company'].offsetWidth;
  if (I < 360)
    I = 360;
  elementById('dyn_company').style.width = I + 'px';
}

function showPopupImport(pValue, pParam) {
  showPopup(pValue, pParam);
  elementById('popup_modal').onclick = null;
  _ImportCount = pParam[3].length;
  for (var I = 0; I < pParam[3].length; I++)
    doHttpRequest('plain.php?umi=org_contacts&page=import_' + (pParam[2] == 0 ? 'person' : 'company') + '.dyn', 'setDynImport', '', 'dest=' + encodeURIComponent(pParam[0]) + '&index=' + pParam[3][I] + '&datafile=' + pParam[1]);
}

function submitImport() {
  var Elem = formByName('import').elements['seldata[]'].options;
  for (var I = 0; I < Elem.length; I++)
    Elem[I].selected = true;
  showIndicator();
}

function switchInOut(pFrom, pTo) {
  var Form = formByName('import').elements;
  Form[pTo].selectedIndex = -1;
  for (var I = 0; I < Form[pFrom].options.length; I++) {
    var Elem = Form[pFrom].options[I];
    if (Elem.selected) {
      if (pTo != 'data' || Elem.value != '_')
        Form[pTo].options[Form[pTo].options.length] = new Option(Elem.text, Elem.value, false, true);
      if (pFrom != 'data' || Elem.value != '_') {
        Form[pFrom].options[I] = null;
        I--;
      }
    }
  }
}

function updatePerson() {
  with (formByName('details'))
    setHtml(htmlcode(elements['firstname'].value + ' ' + elements['lastname'].value), 'title');
}

function viewPopupAddCompany(pIndex) {
  viewPopup('plain.php?umi=org_contacts&page=addcompany.pop', 'index=' + pIndex);
}

function viewPopupAddPerson(pIndex) {
  viewPopup('plain.php?umi=org_contacts&page=addperson.pop', 'index=' + pIndex);
}

function viewPopupHistoryCompany(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=org_contacts_companies&index=' + pIndex);
}

function viewPopupHistoryPerson(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=org_contacts_people&index=' + pIndex);
}

function viewPopupImport(pMsg, pDest, pDataFile, pType) {
  if (confirm(pMsg)) {
    showIndicatorPopup();
    var Form = formByName('import').elements;
    var List = new Array(pDest, pDataFile, pType, getAllOptSelValues(Form['index[]']));
    doHttpRequest('plain.php?umi=org_contacts&page=import.pop', 'showPopupImport', List, '');
  }
}

function viewPopupPublish(pType, pIndex) {
  viewPopup('plain.php?umi=org_contacts&page=publish.pop', 'index=' + pIndex + '&type=' + pType);
}