function checkIndex() {
  return getOptSelValue(formByName('index').elements['index[]']) != '';
}

function doConfirmActionAccounts(pAction, pMsg, pIndex) {
  loadPageConfirm(pMsg, '&page=accounts&action=' + pAction + '&index=' + pIndex);
}

function doConfirmActionDeleteMessage(pMsg, pFolder, pIndex) {
  loadPageConfirm(pMsg, '&action=delete&folder=' + pFolder + '&index[]=' + pIndex);
}

function doConfirmActionFolders(pAction, pMsg, pIndex) {
  loadPageConfirm(pMsg, '&page=folders&action=' + pAction + '&index=' + pIndex);
}

function doConfirmActionRemoveAttach(pMsg, pSubIndex) {
  if (confirm(pMsg)) {
    formByName('details').elements['subindex'].value = pSubIndex;  
    submitAndAction('details', 'removeattach');
  }
}

function doConfirmActionResetSettings(pMsg) {
  loadPageConfirm(pMsg, '&page=settings&action=reset');
}

function doConfirmActionTemplates(pAction, pMsg, pIndex) {
  loadPageConfirm(pMsg, '&page=templates&action=' + pAction + '&index=' + pIndex);
}

function doIndexAction(pAction) {
  var S = getOptSelValue(formByName('index').elements['index[]']);
  if (S != '')
    if (pAction == 'edit')
      loadPage('&page=edit&index=' + S);
    else if (pAction == 'reply')
      loadPage('&page=edit&template=' + S);
    else if (pAction == 'forward')
      loadPage('&page=edit&template=' + S + '&type=2');
    else
      loadPage('&page=details_message&index=' + S);
}

function doIndexActionMarkRead() {
  if (checkIndex())
    submitAndAction('index', 'markread');
}

function doIndexConfirmActionDelete(pMsg) {
  if (checkIndex() && confirm(pMsg))
    submitAndAction('index', 'delete');
}

function doIndexConfirmActionAccounts(pAction, pMsg) {
  doConfirmActionAccounts(pAction, pMsg, getOptSelValue(formByName('index').elements['index']));
}

function doIndexConfirmActionFolders(pAction, pMsg) {
  doConfirmActionFolders(pAction, pMsg, getOptSelValue(formByName('index').elements['index']));
}

function doIndexConfirmActionTemplates(pAction, pMsg) {
  doConfirmActionTemplates(pAction, pMsg, getOptSelValue(formByName('index').elements['index']));
}

function doPopupActionAdb(pAdrList) {
  var List = getAllOptSelValues(formByName('popup').elements['contacts']);
  if (List.length > 0) {
    with (formByName('details').elements[pAdrList]) {
      if (value != '')
        value += ', ';
      value += List.join(', ');
    }
    hidePopup();
  }
}

function doPopupActionMove(pIndex, pFolder) {
  loadPage('&action=move&folder=' + pFolder + '&index[]=' + pIndex + '&p=');
  hidePopup();
}

function doPopupActionMoveIndex(pFolder) {
  with (formByName('index')) {
    elements['action'].value = 'move';
    elements['folder'].value = pFolder;
    elements['p'].value = '';
  }
  submitForm('index');
  hidePopup();
}

function doPopupConfirmActionPublishFolder(pMsg, pIndex) {
  loadPageConfirm(pMsg, '&page=folders&action=publish&index=' + pIndex + '&owner=' + encodeURIComponent(getSelectSelValue(formByName('popup').elements['owner'])));
  hidePopup();
}

function doPopupConfirmActionPublishTemplate(pMsg, pIndex) {
  loadPageConfirm(pMsg, '&page=templates&action=publish&index=' + pIndex + '&owner=' + encodeURIComponent(getSelectSelValue(formByName('popup').elements['owner'])));
  hidePopup();
}

function doPopupSearchAdb(pAdrList) {
  with (formByName('popup_search'))
    viewPopup('plain.php?umi=col_messages&page=adb.pop', 'adrlist=' + pAdrList + '&query=' + encodeURIComponent(elements['query'].value) + '&type=' + getSelectSelValue(elements['type']));
}

function dragEndMoveMessage(pIndex, pOwner) {
  if (_DragParam != '') {
    var List = _DragParam.split("\n");
    if (pOwner == '_private' || List[1] == '_public' || pOwner == List[1])
      loadPage('&action=move&folder=' + List[0] + '&index[]=' + pIndex);
  }
}

function dragOutMoveMessage(pObj) {
  with (pObj.style) {
    cursor = 'default';
    fontWeight = 'normal';
  }
  var Childern = childrenElem(pObj, 'TD');
  childElem(Childern.length == 0 ? pObj : Childern[1], 'A').style.cursor = 'pointer';
}

function dragOverMoveMessage(pObj, pIndex) {
  if (_DragAction.match(/^dragEndMoveMessage/)) {
    with (pObj.style) {
      cursor = 'url(bin/col/messages/img/dragmove.ico),move';
      fontWeight = 'bold';
      var Childern = childrenElem(pObj, 'TD');
      childElem(Childern.length == 0 ? pObj : Childern[1], 'A').style.cursor = cursor;
    }
    var Elem = elementById('mentree' + pIndex);
    if (Elem != null && Elem.style.display == 'none')
      expcolElem('mentree' + pIndex, 'table-row', 'f');
  }
}

function dragStartMoveMessage(pIndex, pOwner, pFlag) {
  _DragAction = "dragEndMoveMessage('" + pIndex + "', '" + pOwner +  "');";
  getElemBody().style.cursor = 'url(bin/col/messages/img/dragmessage' + pFlag + '.ico),move';
}

function dragStopMoveMessage(pIndex, pOwner) {
  if (_DragAction.match(/^dragEndMoveMessage/))
    _DragParam = pIndex + "\n" + pOwner;
}

function expcolCcBcc() {
  var S = elementById('cc').style.display == 'none' ? 'table-row' : 'none';
  displayElemById('cc', S);
  displayElemById('bcc', S);
}

function getDynParent(pKeyPress) {
  var Form = formByName('details').elements;
  var S = Form['dyn_parent'].value;
  if (pKeyPress) {
    Form['parent'].value = '';
    displayElemById('ok', S == '' ? 'inline' : 'none');
  }
  doHttpRequest('plain.php?umi=col_messages&page=parent.dyn', 'showDynParent', '', 'index=' + Form['index'].value + '&name=' + encodeURIComponent(S));
}

function getDynPreviewMessage(pIndex) {
  if (elementById('index_preview').style.display != 'none')
    doHttpRequest('plain.php?umi=col_messages&page=preview_message.dyn', 'showDynPreviewMessage', 'index_preview', 'index=' + pIndex);
}

function getDynPreviewTemplate(pIndex) {
  if (elementById('index_preview').style.display != 'none')
    doHttpRequest('plain.php?umi=col_messages&page=preview_template.dyn', 'showDynPreviewTemplate', 'index_preview', 'index=' + pIndex);
}

function getDynTemplate(pObj) {
  var S = getSelectSelValue(pObj);
  if (S != '')
    doHttpRequest('plain.php?umi=col_messages&page=template.dyn', 'setDynTemplate', '', 'index=' + S);
  pObj.selectedIndex = 0;
}

function goParentFolder() {
  var S = formByName('details').elements['parent'].value;
  if (S != '')
    loadPage('&page=details_folder&index=' + S);
}

function hideDynParent() {
  window.setTimeout("displayElemById('dyn_parent', 'none');", 300);
}

function setDynCheckMail(pValue, pMsg) {
  var List = pValue.split("\n");
  _CheckMailCountMsg += parseInt(List[0]);
  setHtml(List[1], 'checkmail_name');
  _CheckMailCount--;
  if (_CheckMailCount == 0) {
    window.setTimeout('hidePopup();', 1000);
    if (_CheckMailCountMsg > 0)
      loadPageConfirm(pMsg.replace(/%s/, _CheckMailCountMsg), '');
  }
}

function setDynParent(pIndex, pName) {
  var Form = formByName('details').elements;
  Form['parent'].value = pIndex;
  Form['dyn_parent'].value = pName;
  displayElemById('ok', 'inline');
}

function setDynTemplate(pValue, pParam) {
  insertText(formByName('details').elements['text'], pValue, '');
}

function showDynParent(pValue, pParam) {
  setHtml(pValue, 'dyn_parent');
  displayElemById('dyn_parent', pValue == '' ? 'none' : 'block');
  var I = formByName('details').elements['dyn_parent'].offsetWidth;
  if (I < 360)
    I = 360;
  elementById('dyn_parent').style.width = I + 'px';
}

function showDynPreviewMessage(pValue, pId) {
  setHtml(pValue, pId);
  var Elem = elementById('preview_text');
  Elem.style.height = (Elem.offsetHeight + elementById('index_preview').offsetHeight - elementById('preview_content').offsetHeight - 8) + 'px';
}

function showDynPreviewTemplate(pValue, pId) {
  showDynPreviewMessage(pValue, pId);
}

function showPopupCheckMail(pValue, pParam) {
  showPopup(pValue, pParam);
  elementById('popup_modal').onclick = null;
  var List = pParam[1].split('|');
  _CheckMailCount = List.length;
  _CheckMailCountMsg = 0;
  for (var I = 0; I < List.length; I++)
    doHttpRequest('plain.php?umi=col_messages&page=checkmail.dyn', 'setDynCheckMail', pParam[0], 'index=' + List[I]);
}

function updateProtocol(pObj, pMsg) {
  with (pObj) {
    if (selectedIndex == options.length - 1) {
      var S = prompt(pMsg, options[selectedIndex].value);
      if (S == null)
        selectedIndex = options.defaultSelected;
      else
        options[length - 1] = new Option(S, S, false, true);
    }
    formByName('details').elements['port'].value = options[selectedIndex].value == 'imap' ? '60' : '110';
  }
}

function viewPopupCheckMail(pMsg, pAccounts) {
  showIndicatorPopup();
  var List = new Array(pMsg, pAccounts);
  doHttpRequest('plain.php?umi=col_messages&page=checkmail.pop', 'showPopupCheckMail', List, '');
}

function viewPopupAdb(pAdrList) {
  viewPopup('plain.php?umi=col_messages&page=adb.pop', 'adrlist=' + pAdrList);
}

function viewPopupHistoryAccount(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=col_messages_accounts&index=' + pIndex);
}

function viewPopupHistoryFolder(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=col_messages_folders&index=' + pIndex);
}

function viewPopupHistoryMessage(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=col_messages_messages&index=' + pIndex);
}

function viewPopupHistoryTemplate(pIndex) {
  viewPopup('plain.php?page=history.pop', 'entity=col_messages_templates&index=' + pIndex);
}

function viewPopupMove(pIndex) {
  viewPopup('plain.php?umi=col_messages&page=move.pop', 'index=' + pIndex);
}

function viewPopupMoveIndex(pFolder) {
  if (checkIndex())
    viewPopup('plain.php?umi=col_messages&page=moveindex.pop', 'folder=' + pFolder);
}

function viewPopupPublishFolder(pIndex) {
  viewPopup('plain.php?umi=col_messages&page=publish_folder.pop', 'index=' + pIndex);
}

function viewPopupPublishTemplate(pIndex) {
  viewPopup('plain.php?umi=col_messages&page=publish_template.pop&index=' + pIndex, '');
}