/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.windows;

import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.windows.WToolkit;
import sun.java2d.opengl.WGLGraphicsConfig;

public class WindowsFlags {
    private static boolean ddEnabled;
    private static boolean ddSet;
    private static boolean ddOffscreenEnabled;
    private static boolean ddVramForced;
    private static boolean ddLockEnabled;
    private static boolean ddLockSet;
    private static boolean gdiBlitEnabled;
    private static boolean ddBlitEnabled;
    private static boolean ddScaleEnabled;
    private static boolean d3dEnabled;
    private static boolean d3dVerbose;
    private static boolean d3dSet;
    private static boolean oglEnabled;
    private static boolean oglVerbose;
    private static boolean translAccelEnabled;
    private static boolean offscreenSharingEnabled;
    private static boolean accelReset;
    private static boolean checkRegistry;
    private static boolean disableRegistry;
    private static boolean magPresent;
    private static boolean setHighDPIAware;
    private static int d3dTexBpp;
    private static String javaVersion;

    private static native boolean initNativeFlags();

    public static void initFlags() {
    }

    private static boolean getBooleanProp(String string, boolean bl) {
        String string2 = System.getProperty(string);
        boolean bl2 = bl;
        if (string2 != null) {
            if (string2.equals("true") || string2.equals("t") || string2.equals("True") || string2.equals("T") || string2.equals("")) {
                bl2 = true;
            } else if (string2.equals("false") || string2.equals("f") || string2.equals("False") || string2.equals("F")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    private static boolean isBooleanPropTrueVerbose(String string) {
        String string2 = System.getProperty(string);
        return string2 != null && (string2.equals("True") || string2.equals("T"));
    }

    private static int getIntProp(String string, int n) {
        String string2 = System.getProperty(string);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    private static boolean getPropertySet(String string) {
        String string2 = System.getProperty(string);
        return string2 != null;
    }

    private static void initJavaFlags() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                magPresent = WindowsFlags.getBooleanProp("javax.accessibility.screen_magnifier_present", false);
                ddEnabled = !WindowsFlags.getBooleanProp("sun.java2d.noddraw", magPresent);
                ddSet = WindowsFlags.getPropertySet("sun.java2d.noddraw");
                ddOffscreenEnabled = WindowsFlags.getBooleanProp("sun.java2d.ddoffscreen", !magPresent);
                ddVramForced = WindowsFlags.getBooleanProp("sun.java2d.ddforcevram", false);
                ddLockEnabled = WindowsFlags.getBooleanProp("sun.java2d.ddlock", false);
                ddBlitEnabled = WindowsFlags.getBooleanProp("sun.java2d.ddblit", !magPresent);
                ddScaleEnabled = WindowsFlags.getBooleanProp("sun.java2d.ddscale", false);
                d3dEnabled = WindowsFlags.getBooleanProp("sun.java2d.d3d", !magPresent);
                oglEnabled = WindowsFlags.getBooleanProp("sun.java2d.opengl", false);
                if (oglEnabled) {
                    oglVerbose = WindowsFlags.isBooleanPropTrueVerbose("sun.java2d.opengl");
                    if (WGLGraphicsConfig.isWGLAvailable()) {
                        ddEnabled = false;
                        d3dEnabled = false;
                    } else {
                        if (oglVerbose) {
                            System.out.println("Could not enable OpenGL pipeline (WGL not available)");
                        }
                        oglEnabled = false;
                    }
                }
                gdiBlitEnabled = WindowsFlags.getBooleanProp("sun.java2d.gdiBlit", true);
                d3dSet = WindowsFlags.getPropertySet("sun.java2d.d3d");
                if (d3dSet) {
                    d3dVerbose = WindowsFlags.isBooleanPropTrueVerbose("sun.java2d.d3d");
                }
                translAccelEnabled = WindowsFlags.getBooleanProp("sun.java2d.translaccel", false);
                if (translAccelEnabled) {
                    ddVramForced = true;
                    if (!d3dSet && !magPresent) {
                        d3dEnabled = true;
                        d3dSet = true;
                    }
                }
                offscreenSharingEnabled = WindowsFlags.getBooleanProp("sun.java2d.offscreenSharing", false);
                accelReset = WindowsFlags.getBooleanProp("sun.java2d.accelReset", false);
                checkRegistry = WindowsFlags.getBooleanProp("sun.java2d.checkRegistry", false);
                disableRegistry = WindowsFlags.getBooleanProp("sun.java2d.disableRegistry", false);
                javaVersion = System.getProperty("java.version");
                if (javaVersion == null) {
                    javaVersion = "default";
                } else {
                    int n = javaVersion.indexOf(45);
                    if (n >= 0) {
                        javaVersion = javaVersion.substring(0, n);
                    }
                }
                d3dTexBpp = WindowsFlags.getIntProp("sun.java2d.d3dtexbpp", 32);
                ddLockSet = WindowsFlags.getPropertySet("sun.java2d.ddlock");
                String string = System.getProperty("sun.java2d.dpiaware");
                if (string != null) {
                    setHighDPIAware = string.equalsIgnoreCase("true");
                } else {
                    String string2 = System.getProperty("sun.java.launcher", "unknown");
                    setHighDPIAware = string2.equalsIgnoreCase("SUN_STANDARD");
                }
                return null;
            }
        });
    }

    public static boolean isDDEnabled() {
        return ddEnabled;
    }

    public static boolean isDDOffscreenEnabled() {
        return ddOffscreenEnabled;
    }

    public static boolean isDDVramForced() {
        return ddVramForced;
    }

    public static boolean isDDLockEnabled() {
        return ddLockEnabled;
    }

    public static boolean isDDLockSet() {
        return ddLockSet;
    }

    public static boolean isDDBlitEnabled() {
        return ddBlitEnabled;
    }

    public static boolean isDDScaleEnabled() {
        return ddScaleEnabled;
    }

    public static boolean isD3DEnabled() {
        return d3dEnabled;
    }

    public static boolean isD3DSet() {
        return d3dSet;
    }

    public static boolean isD3DVerbose() {
        return d3dVerbose;
    }

    public static int getD3DTexBpp() {
        return d3dTexBpp;
    }

    public static boolean isGdiBlitEnabled() {
        return gdiBlitEnabled;
    }

    public static boolean isTranslucentAccelerationEnabled() {
        return d3dEnabled;
    }

    public static boolean isOffscreenSharingEnabled() {
        return offscreenSharingEnabled;
    }

    public static boolean isMagPresent() {
        return magPresent;
    }

    public static boolean isOGLEnabled() {
        return oglEnabled;
    }

    public static boolean isOGLVerbose() {
        return oglVerbose;
    }

    static {
        WToolkit.loadLibraries();
        WindowsFlags.initJavaFlags();
        WindowsFlags.initNativeFlags();
    }
}

