; CommOp.nsi
;
; This script is CommOp Install make file

; The name of the installer
Name "Comm Operator"
Caption "Comm Operator"
; The file to write
OutFile "CommOp.exe"

LicenseText "End User License Agreement "
LicenseData "License.txt"

; The default installation directory
InstallDir $PROGRAMFILES\5dtool

; The text to prompt the user to enter a directory
DirText "This will install the Comm Operator on your computer. Choose a directory"

; The stuff to install
Section "ThisNameIsIgnoredSoWhyBother?"
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  ; Put file there
  File .\files\*.*
  CreateDirectory $SMPROGRAMS\5dtool
  CreateShortCut "$SMPROGRAMS\5dtool\Comm Operator.lnk" "$INSTDIR\CommOp.exe" ""
  WriteINIStr "$SMPROGRAMS\5dtool\5dtool Home Page.url" "InternetShortcut" "URL" "http://www.5dtool.com/"
  CreateShortCut "$SMPROGRAMS\5dtool\Comm Operator Manual.lnk" "$INSTDIR\CommOp.chm" ""

  CreateShortCut "$DESKTOP\CommOp.lnk" "$INSTDIR\CommOp.exe" ""


  WriteRegDWORD HKLM "Software\5dtool\CommOp" "CurrentType" 0
  WriteRegDWORD HKLM "Software\5dtool\CommOp" "CurDisplayType" 0
  WriteRegDWORD HKLM "Software\5dtool\CommOp" "ShowSendData" 1
  WriteRegDWORD HKLM "Software\5dtool\CommOp" "ShowTime" 1

  WriteRegStr HKLM "Software\5dtool\CommOp" "InstanceSendData"  '"Input Instance",String,""'
  WriteRegStr HKLM "Software\5dtool\CommOp" "PortSetting" "Default, COM1, 9600, 8, 0, 0, 0, 1024, 1024"

  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\5dtool" "DisplayName" "Comm Operator(remove only)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\5dtool" "UninstallString" '"$INSTDIR\uninstall.exe"'

  WriteUninstaller "uninstall.exe"
  CreateShortCut "$SMPROGRAMS\5dtool\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0

SectionEnd ; end the section

; uninstall stuff

UninstallText "This will uninstall Comm Operator. Hit next to continue."

; special uninstall section.
Section "Uninstall"
  ; remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\5dtool"
  DeleteRegKey HKLM SOFTWARE\5dtool
  ; remove files
  Delete $INSTDIR\CommOp.exe
  ; MUST REMOVE UNINSTALLER, too
  Delete $INSTDIR\*.*
  ; remove shortcuts, if any.
  Delete "$SMPROGRAMS\5dtool\*.*"
  Delete "$DESKTOP\CommOp.lnk" 
  ; remove directories used.
  RMDir "$SMPROGRAMS\5dtool"
  RMDir "$INSTDIR"
SectionEnd

; eof
