// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SRVControl.pas' rev: 6.00

#ifndef SRVControlHPP
#define SRVControlHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Forms.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Srvcontrol
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum SRVControl__1 { srvblLeft, srvblTop, srvblRight, srvblBottom };
#pragma option pop

typedef Set<SRVControl__1, srvblLeft, srvblBottom>  TSRVBoundLines;

typedef Byte TSRVColorSteps;

#pragma option push -b-
enum TSRVGradientStyle { gsLeft, gsTop, gsRight, gsBottom };
#pragma option pop

#pragma pack(push, 4)
struct TSRVSelection
{
	int StartPos;
	int EndPos;
} ;
#pragma pack(pop)

typedef void __fastcall (__closure *TSRVCtrlPaintPage)(System::TObject* Sender, const Types::TRect &R, Graphics::TCanvas* Canvas);

class DELPHICLASS TSRVCustomControl;
class PASCALIMPLEMENTATION TSRVCustomControl : public Controls::TCustomControl 
{
	typedef Controls::TCustomControl inherited;
	
private:
	bool FMouseIn;
	bool FDrawOnPrint;
	Classes::TNotifyEvent FOnMouseLeave;
	Classes::TNotifyEvent FOnMouseEnter;
	
protected:
	Classes::TAlignment FAlignment;
	void __fastcall SetAlignment(Classes::TAlignment Value);
	MESSAGE void __fastcall CMTextChanged(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall CMMouseEnter(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall CMMouseLeave(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMSize(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall CMFocusChanged(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall CMParentColorChanged(Messages::TMessage &Message);
	
public:
	int ScreenOffX;
	int ScreenOffY;
	float ScaleX;
	float ScaleY;
	bool ParentSRV;
	__fastcall virtual TSRVCustomControl(Classes::TComponent* AOwner);
	__property Classes::TAlignment Alignment = {read=FAlignment, write=SetAlignment, nodefault};
	__property bool DrawOnPrint = {read=FDrawOnPrint, write=FDrawOnPrint, default=1};
	__property bool MouseIn = {read=FMouseIn, nodefault};
	__property Classes::TNotifyEvent OnMouseEnter = {read=FOnMouseLeave, write=FOnMouseLeave};
	__property Classes::TNotifyEvent OnMouseLeave = {read=FOnMouseLeave, write=FOnMouseLeave};
public:
	#pragma option push -w-inl
	/* TCustomControl.Destroy */ inline __fastcall virtual ~TSRVCustomControl(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TSRVCustomControl(HWND ParentWindow) : Controls::TCustomControl(ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TSRVWinControl;
class PASCALIMPLEMENTATION TSRVWinControl : public Controls::TWinControl 
{
	typedef Controls::TWinControl inherited;
	
private:
	bool FMouseIn;
	bool FDrawOnPrint;
	Classes::TNotifyEvent FOnMouseEnter;
	Classes::TNotifyEvent FOnMouseLeave;
	
protected:
	Graphics::TColor FEnabledBorderColor;
	Graphics::TColor FDisabledBorderColor;
	Graphics::TColor FMouseInBorderColor;
	Graphics::TColor FFocusedBorderColor;
	int FEnabledBorderWidth;
	int FDisabledBorderWidth;
	int FMouseInBorderWidth;
	int FFocusedBorderWidth;
	void __fastcall SetEnabledBorderColor(Graphics::TColor Value);
	void __fastcall SetDisabledBorderColor(Graphics::TColor Value);
	void __fastcall SetEnabledBorderWidth(int Value);
	void __fastcall SetDisabledBorderWidth(int Value);
	void __fastcall SetMouseInBorderColor(Graphics::TColor Value);
	void __fastcall SetMouseInBorderWidth(int Value);
	void __fastcall SetFocusedBorderColor(Graphics::TColor Value);
	void __fastcall SetFocusedBorderWidth(int Value);
	HIDESBASE MESSAGE void __fastcall CMMouseEnter(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall CMMouseLeave(Messages::TMessage &Message);
	
public:
	int ScreenOffX;
	int ScreenOffY;
	float ScaleX;
	float ScaleY;
	bool ParentSRV;
	__fastcall virtual TSRVWinControl(Classes::TComponent* AOwner);
	__property Font ;
	__property Graphics::TColor EnabledBorderColor = {read=FEnabledBorderColor, write=SetEnabledBorderColor, default=12558207};
	__property int EnabledBorderWidth = {read=FEnabledBorderWidth, write=SetEnabledBorderWidth, default=1};
	__property Graphics::TColor DisabledBorderColor = {read=FDisabledBorderColor, write=SetDisabledBorderColor, default=12114135};
	__property int DisabledBorderWidth = {read=FDisabledBorderWidth, write=SetDisabledBorderWidth, default=1};
	__property bool MouseIn = {read=FMouseIn, nodefault};
	__property Graphics::TColor MouseInBorderColor = {read=FMouseInBorderColor, write=SetMouseInBorderColor, default=255};
	__property int MouseInBorderWidth = {read=FMouseInBorderWidth, write=SetMouseInBorderWidth, default=1};
	__property Graphics::TColor FocusedBorderColor = {read=FFocusedBorderColor, write=SetFocusedBorderColor, default=16711680};
	__property int FocusedBorderWidth = {read=FFocusedBorderWidth, write=SetFocusedBorderWidth, default=1};
	__property bool DrawOnPrint = {read=FDrawOnPrint, write=FDrawOnPrint, default=1};
	__property Classes::TNotifyEvent OnMouseEnter = {read=FOnMouseLeave, write=FOnMouseLeave};
	__property Classes::TNotifyEvent OnMouseLeave = {read=FOnMouseLeave, write=FOnMouseLeave};
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TSRVWinControl(HWND ParentWindow) : Controls::TWinControl(ParentWindow) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TWinControl.Destroy */ inline __fastcall virtual ~TSRVWinControl(void) { }
	#pragma option pop
	
};


class DELPHICLASS TSRVEditControl;
class PASCALIMPLEMENTATION TSRVEditControl : public TSRVWinControl 
{
	typedef TSRVWinControl inherited;
	
protected:
	virtual int __fastcall GetSelLength(void);
	virtual int __fastcall GetSelStart(void);
	virtual void __fastcall SetSelLength(int Value);
	virtual void __fastcall SetSelStart(int Value);
	void __fastcall AdjustHeight(void);
	virtual Types::TPoint __fastcall GetCaretPos();
	MESSAGE void __fastcall WMSetFont(Messages::TWMSetFont &Message);
	HIDESBASE MESSAGE void __fastcall CMFontChanged(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall CMEnter(Messages::TWMNoParams &Message);
	
public:
	__fastcall virtual TSRVEditControl(Classes::TComponent* AOwner);
	void __fastcall SelectAll(void);
	__property Font ;
	__property PopupMenu ;
	__property Types::TPoint CaretPos = {read=GetCaretPos};
	__property int SelLength = {read=GetSelLength, write=SetSelLength, nodefault};
	__property int SelStart = {read=GetSelStart, write=SetSelStart, nodefault};
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TSRVEditControl(HWND ParentWindow) : TSRVWinControl(ParentWindow) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TWinControl.Destroy */ inline __fastcall virtual ~TSRVEditControl(void) { }
	#pragma option pop
	
};


class DELPHICLASS TSRVRenderControl;
class PASCALIMPLEMENTATION TSRVRenderControl : public TSRVWinControl 
{
	typedef TSRVWinControl inherited;
	
protected:
	Controls::TWinControl* FDisplay;
	#pragma pack(push, 1)
	Types::TRect FDisplayRect;
	#pragma pack(pop)
	
	#pragma pack(push, 1)
	Types::TRect FSourceRect;
	#pragma pack(pop)
	
	#pragma pack(push, 1)
	Types::TRect FDestinationRect;
	#pragma pack(pop)
	
	virtual bool __fastcall GetRenderVisible(void);
	virtual void __fastcall SetRenderVisible(bool Value);
	virtual void __fastcall SetDisplay(Controls::TWinControl* Value);
	virtual void __fastcall SetDisplayRect(const Types::TRect &Value);
	virtual void __fastcall SetSourceRect(const Types::TRect &Value);
	virtual void __fastcall SetDestinationRect(const Types::TRect &Value);
	
public:
	__fastcall virtual TSRVRenderControl(Classes::TComponent* AOwner);
	__property Types::TRect DisplayRect = {read=FDisplayRect, write=SetDisplayRect};
	__property Types::TRect SourceRect = {read=FSourceRect, write=SetSourceRect};
	__property Types::TRect DestinationRect = {read=FDestinationRect, write=SetDestinationRect};
	__property Controls::TWinControl* Display = {read=FDisplay, write=SetDisplay};
	__property bool RenderVisible = {read=GetRenderVisible, write=SetRenderVisible, nodefault};
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TSRVRenderControl(HWND ParentWindow) : TSRVWinControl(ParentWindow) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TWinControl.Destroy */ inline __fastcall virtual ~TSRVRenderControl(void) { }
	#pragma option pop
	
};


class DELPHICLASS TSRVCanvasControl;
class PASCALIMPLEMENTATION TSRVCanvasControl : public Controls::TGraphicControl 
{
	typedef Controls::TGraphicControl inherited;
	
private:
	Classes::TAlignment FAlignment;
	bool FMouseIn;
	bool FDrawOnPrint;
	Classes::TNotifyEvent FOnMouseEnter;
	Classes::TNotifyEvent FOnMouseLeave;
	TSRVCtrlPaintPage FOnPaint;
	void __fastcall SetAlignment(Classes::TAlignment Value);
	
protected:
	MESSAGE void __fastcall MouseEnter(Messages::TMessage &Message);
	MESSAGE void __fastcall MouseLeave(Messages::TMessage &Message);
	MESSAGE void __fastcall WMSize(Messages::TMessage &Message);
	MESSAGE void __fastcall CMDialogChar(Messages::TWMKey &Message);
	MESSAGE void __fastcall CMTextChanged(Messages::TMessage &Message);
	
public:
	int ScreenOffX;
	int ScreenOffY;
	float ScaleX;
	float ScaleY;
	bool ParentSRV;
	__fastcall virtual TSRVCanvasControl(Classes::TComponent* AOwner);
	virtual void __fastcall Invalidate(void);
	virtual void __fastcall PaintTo(unsigned DC, int X, int Y);
	__property Classes::TAlignment Alignment = {read=FAlignment, write=SetAlignment, default=0};
	__property bool DrawOnPrint = {read=FDrawOnPrint, write=FDrawOnPrint, default=1};
	__property bool MouseIn = {read=FMouseIn, nodefault};
	
__published:
	__property TSRVCtrlPaintPage OnPaint = {read=FOnPaint, write=FOnPaint};
	__property Classes::TNotifyEvent OnMouseEnter = {read=FOnMouseEnter, write=FOnMouseEnter};
	__property Classes::TNotifyEvent OnMouseLeave = {read=FOnMouseLeave, write=FOnMouseLeave};
public:
	#pragma option push -w-inl
	/* TGraphicControl.Destroy */ inline __fastcall virtual ~TSRVCanvasControl(void) { }
	#pragma option pop
	
};


class DELPHICLASS TSRVGraphicControl;
class PASCALIMPLEMENTATION TSRVGraphicControl : public Controls::TGraphicControl 
{
	typedef Controls::TGraphicControl inherited;
	
private:
	bool FMouseIn;
	bool FAutoSize;
	Classes::TAlignment FAlignment;
	bool FDrawOnPrint;
	Graphics::TColor FForegroundColor;
	Graphics::TColor FBackgroundColor;
	int FOffset;
	Classes::TNotifyEvent FOnMouseEnter;
	Classes::TNotifyEvent FOnMouseLeave;
	HIDESBASE void __fastcall SetAutoSize(bool Value);
	void __fastcall SetAlignment(Classes::TAlignment Value);
	void __fastcall SetOffset(int Value);
	void __fastcall SetForegroundColor(Graphics::TColor Value);
	void __fastcall SetBackgroundColor(Graphics::TColor Value);
	
protected:
	MESSAGE void __fastcall MouseEnter(Messages::TMessage &Message);
	MESSAGE void __fastcall MouseLeave(Messages::TMessage &Message);
	MESSAGE void __fastcall WMSize(Messages::TMessage &Message);
	MESSAGE void __fastcall CMDialogChar(Messages::TWMKey &Message);
	MESSAGE void __fastcall CMTextChanged(Messages::TMessage &Message);
	void __fastcall Realign(void);
	
public:
	int ScreenOffX;
	int ScreenOffY;
	float ScaleX;
	float ScaleY;
	bool ParentSRV;
	__fastcall virtual TSRVGraphicControl(Classes::TComponent* AOwner);
	virtual void __fastcall PaintTo(unsigned DC, int X, int Y);
	__property bool AutoSize = {read=FAutoSize, write=SetAutoSize, default=1};
	__property Classes::TAlignment Alignment = {read=FAlignment, write=SetAlignment, default=0};
	__property bool DrawOnPrint = {read=FDrawOnPrint, write=FDrawOnPrint, default=1};
	__property Graphics::TColor ForegroundColor = {read=FForegroundColor, write=SetForegroundColor, default=16777215};
	__property Graphics::TColor BackgroundColor = {read=FBackgroundColor, write=SetBackgroundColor, default=8920080};
	__property int Offset = {read=FOffset, write=SetOffset, default=1};
	__property bool MouseIn = {read=FMouseIn, nodefault};
	
__published:
	__property Classes::TNotifyEvent OnMouseEnter = {read=FOnMouseEnter, write=FOnMouseEnter};
	__property Classes::TNotifyEvent OnMouseLeave = {read=FOnMouseLeave, write=FOnMouseLeave};
public:
	#pragma option push -w-inl
	/* TGraphicControl.Destroy */ inline __fastcall virtual ~TSRVGraphicControl(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const int SRV_FLAG_COLOR = 0x21a221;
static const int SRV_FACE_START = 0xffffff;
static const int SRV_FACE_END = 0xe7ebef;
static const int SRV_ENABLED_BORDER = 0x80501f;
static const int SRV_DISABLED_BORDER = 0xbfc8cf;
static const int SRV_BORDER_COLOR = 0xb8d8d7;
static const Shortint SRV_BORDER_WIDTH = 0x1;
static const int SRV_CAPTION_COLOR = 0xd05300;
static const Shortint SRV_CAPTION_OFFSET = 0xa;
static const Shortint SRV_CORNERS_OFFSET = 0xa;
static const Shortint SRV_MAX_BORDER_WIDTH = 0xa;
static const Shortint SRV_MIN_BORDER_WIDTH = 0x1;
static const Shortint SRV_MAX_CAPTION_OFFSET = 0x1e;
static const Shortint SRV_MIN_CAPTION_OFFSET = 0x1;
static const Shortint SRV_MAX_CORNERS_OFFSET = 0x1e;
static const Shortint SRV_MIN_CORNERS_OFFSET = 0x1;
static const int SRV_BORDER_ENABLED = 0xbf9f7f;
static const int SRV_BORDER_DISABLED = 0xb8d8d7;
static const int SRV_BORDER_MOUSEIN = 0xff;
static const int SRV_BORDER_FOCUSED = 0xff0000;
static const Shortint SRV_ENABLED_WIDTH = 0x1;
static const Shortint SRV_DISABLED_WIDTH = 0x1;
static const Shortint SRV_MOUSEIN_WIDTH = 0x1;
static const Shortint SRV_FOCUSED_WIDTH = 0x1;
static const Shortint SRV_MAX_SRV_ENABLED_WIDTH = 0x3;
static const Shortint SRV_MIN_SRV_ENABLED_WIDTH = 0x0;
static const Shortint SRV_MAX_SRV_DISABLED_WIDTH = 0x3;
static const Shortint SRV_MIN_SRV_DISABLED_WIDTH = 0x0;
static const Shortint SRV_MAX_SRV_MOUSEIN_WIDTH = 0x3;
static const Shortint SRV_MIN_SRV_MOUSEIN_WIDTH = 0x0;
static const Shortint SRV_MAX_SRV_FOCUSED_WIDTH = 0x3;
static const Shortint SRV_MIN_SRV_FOCUSED_WIDTH = 0x0;
static const bool SRV_AUTO_SIZE = true;
#define SRV_CAPTION_ALIGNMENT (Classes::TAlignment)(0)
static const int SRV_FOREGROUND_COLOR = 0xffffff;
static const int SRV_BACKGROUND_COLOR = 0x881c10;
static const Shortint SRV_OFFSET = 0x1;
extern PACKAGE int Alignments[3];
extern PACKAGE void __fastcall Frame3D(Graphics::TCanvas* Canvas, Types::TRect &Rect, Graphics::TColor TopColor, Graphics::TColor BottomColor, int Width);
extern PACKAGE void __fastcall DrawLine(Graphics::TCanvas* ACanvas, int X1, int Y1, int X2, int Y2);
extern PACKAGE void __fastcall DrawBoundLines(Graphics::TCanvas* ACanvas, TSRVBoundLines ABoundLines, const Graphics::TColor AColor, const Types::TRect &R)/* overload */;
extern PACKAGE void __fastcall DrawGradient(int Width, int Height, Graphics::TColor StartColor, Graphics::TColor EndColor, TSRVColorSteps ColorSteps, TSRVGradientStyle Style, bool Dithered, Graphics::TMetafile* &Metafile)/* overload */;
extern PACKAGE void __fastcall PaintText(Controls::TControl* Parent, Graphics::TCanvas* Canvas, AnsiString AText, Graphics::TFont* AFont, bool Enabled, bool ShowAccelChar, Types::TRect &Rect, int Flags)/* overload */;
extern PACKAGE void __fastcall DrawGradientToCanvas(int Width, int Height, Graphics::TColor StartColor, Graphics::TColor EndColor, TSRVColorSteps ColorSteps, TSRVGradientStyle Style, bool Dithered, Graphics::TCanvas* Canvas)/* overload */;
extern PACKAGE void __fastcall PaintFlag(Graphics::TColor Color, Graphics::TCanvas* Canvas);
extern PACKAGE void __fastcall PaintGrayed(Graphics::TColor Color, Graphics::TCanvas* Canvas);
extern PACKAGE void __fastcall PaintBorder(Graphics::TColor Color, Graphics::TCanvas* Canvas);
extern PACKAGE void __fastcall PaintPress(Graphics::TColor Color, Graphics::TCanvas* Canvas);
extern PACKAGE void __fastcall PaintDisabled(Graphics::TColor Color, Graphics::TCanvas* Canvas);

}	/* namespace Srvcontrol */
using namespace Srvcontrol;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SRVControl
