unit MainFrm;

interface
{$I RV_Defs.inc}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RVScroll, RichView, RVStyle,
  {$IFDEF RICHVIEWDEF4}
  ImgList,
  {$ENDIF}
  MMSystem, ExtCtrls, SclRView;

type
  TfrmMain = class(TForm)
    rvs: TRVStyle;
    rvTop: TRichView;
    rvsForDemos: TRVStyle;
    il: TImageList;
    srv: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure rvJump(Sender: TObject; id: Integer);
    procedure rvRVMouseMove(Sender: TObject; id: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;


{ Constants for text styles, rvsForDemos.TextStyles }
const sncomNormal = 0;
      sncomHeading = 1;
      sncomKeyword = 2;
      sncomMarked = 3;

{ Constants for text styles, rvs.TextStyles }
const snNormal  = 0;
      snHeading = 1;
      snExit    = 3;
      snJump    = 4;

implementation

uses PopupFrm,
     Demo1Frm, Demo2Frm, Demo3Frm,
     Demo4Frm, Demo5Frm, Demo6Frm,
     Demo7Frm;
{$R *.DFM}
{-----------------------------------------------------}
procedure TfrmMain.FormCreate(Sender: TObject);
begin
  srv.SetMargin(0, 0, 0, 0);

  rvTop.BackgroundBitmap := srv.RVBackgroundBitmap;
  rvTop.AddNL(' ', snNormal, 1);
  rvTop.AddNL('RichView Demos', snHeading, 1);
  rvTop.AddNL(' ', snNormal, 1);
  rvTop.Format;
  rvTop.Height := rvTop.DocumentHeight;

  srv.RichViewEdit.AddNL('Click links for demos, click balls for hints', snNormal, 1);
  srv.RichViewEdit.AddHotspotExTag('', 0,1,il, 1, 1);
  srv.RichViewEdit.Add('1. ', snNormal);
  srv.RichViewEdit.AddTag('"Checkpoints"', snJump, 1);
  srv.RichViewEdit.AddHotspotExTag('', 0,1,il, 1, 2);
  srv.RichViewEdit.Add('2. ', snNormal);
  srv.RichViewEdit.AddTag('Customizing Styles', snJump, 2);
  srv.RichViewEdit.AddHotspotExTag('', 0,1,il, 1, 3);
  srv.RichViewEdit.Add('3. ', snNormal);
  srv.RichViewEdit.AddTag('Query Summary', snJump, 3);
  srv.RichViewEdit.AddHotspotExTag('', 0,1,il, 1, 4);
  srv.RichViewEdit.Add('4. ', snNormal);
  srv.RichViewEdit.AddTag('Interactive document', snJump, 4);
  srv.RichViewEdit.AddHotspotExTag('', 0,1,il, 1, 5);
  srv.RichViewEdit.Add('5. ', snNormal);
  srv.RichViewEdit.AddTag('Chat Simulation', snJump, 5);
  srv.RichViewEdit.AddHotspotExTag('', 0,1,il, 1, 6);
  srv.RichViewEdit.Add('6. ', snNormal);
  srv.RichViewEdit.AddTag('Credits Demo', snJump, 6);
  srv.RichViewEdit.AddHotspotExTag('', 0,1,il, 1, 7);
  srv.RichViewEdit.Add('7. ', snNormal);
  srv.RichViewEdit.AddTag('Search and mark', snJump, 7);
  srv.RichViewEdit.AddBreakEx(2, rvbsLine, clGreen);
  srv.RichViewEdit.AddNL('Exit', snExit, 1);
  srv.RichViewEdit.Format;
end;
{-----------------------------------------------------}
procedure TfrmMain.rvJump(Sender: TObject; id: Integer);
var ItemNo, StyleNo, ItemTag: Integer;
    frm: TFrmPopup;
    frmDemo: TForm;
begin
  ItemNo  := srv.RichViewEdit.GetJumpPointItemNo(id);
  StyleNo := srv.RichViewEdit.GetItemStyle(ItemNo);
  ItemTag := srv.RichViewEdit.GetItemTag(ItemNo);
  if StyleNo=rvsHotspot then begin
    frm := TFrmPopup.Create(Self);
    frm.ShowTopic(ItemTag);
    end
  else begin
    frmDemo := nil;
    case ItemTag of
      1: frmDemo := TfrmDemo1.Create(Application);
      2: frmDemo := TfrmDemo2.Create(Application);
      3: frmDemo := TfrmDemo3.Create(Application);
      4: frmDemo := TfrmDemo4.Create(Application);
      5: frmDemo := TfrmDemo5.Create(Application);
      6: frmDemo := TfrmDemo6.Create(Application);
      7: frmDemo := TfrmDemo7.Create(Application);      
      0: Close;
    end;
    if frmDemo<>nil then begin
      frmDemo.ShowModal;
      frmDemo.Free;
    end;
  end;
end;
{-----------------------------------------------------}
procedure TfrmMain.rvRVMouseMove(Sender: TObject; id: Integer);
begin
  if id<>-1 then
    PlaySound(PChar(ExtractFilePath(Application.ExeName)+'UCS.wav'),
              0,SND_ASYNC or SND_FILENAME);
end;

end.
