unit Demo3Frm;

interface
{$I RV_Defs.inc}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, RVStyle, RVScroll, RichView,
  {$IFDEF RICHVIEWDEF4}
  ImgList,
  {$ENDIF}
  ExtCtrls, SclRView;

type
  TfrmDemo3 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    Page4: TTabSheet;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    Label3: TLabel;
    Edit2: TEdit;
    RadioGroup1: TRadioGroup;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    Memo1: TMemo;
    Label4: TLabel;
    il: TImageList;
    srv: TSRichViewEdit;
    procedure Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure rvClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure BuildSummary;
  end;


implementation
uses MainFrm;
{$R *.DFM}

procedure TfrmDemo3.BuildSummary;
const OffOn: array [Boolean] of String = ('Off', 'On');
      Checks: array [Boolean] of Integer = (1, 2);
begin
  srv.RichViewEdit.Clear;
  srv.RichViewEdit.AddNL('Query', sncomHeading,1);

  srv.RichViewEdit.AddBulletEx('', 0, il, 0);
  srv.RichViewEdit.Add('Edit1: ', sncomKeyword);
  srv.RichViewEdit.Add(Edit1.Text, sncomNormal);

  srv.RichViewEdit.AddBulletEx('', 0, il, 0);
  srv.RichViewEdit.Add('Edit2: ', sncomKeyword);
  srv.RichViewEdit.Add(Edit2.Text, sncomNormal);

  srv.RichViewEdit.AddBreakEx(1, rvbsLine, clRed);

  if RadioGroup1.ItemIndex<>-1 then begin
    srv.RichViewEdit.AddBulletEx('', 3, il, 0);
    srv.RichViewEdit.Add('Menu: ', sncomKeyword);
    srv.RichViewEdit.Add(RadioGroup1.Items[RadioGroup1.ItemIndex], sncomNormal);
  end;

  srv.RichViewEdit.AddBreakEx(1, rvbsLine, clRed);

  srv.RichViewEdit.AddNL('Check1: ', sncomKeyword, 0);
  srv.RichViewEdit.AddBulletEx('', Checks[Checkbox1.Checked], il, -1);
  srv.RichViewEdit.Add(OffOn[Checkbox1.Checked], sncomNormal);

  srv.RichViewEdit.AddNL('Check2: ', sncomKeyword, 0);
  srv.RichViewEdit.AddBulletEx('', Checks[Checkbox2.Checked], il, -1);
  srv.RichViewEdit.Add(OffOn[Checkbox2.Checked], sncomNormal);

  srv.RichViewEdit.AddNL('Check3: ', sncomKeyword, 0);
  srv.RichViewEdit.AddBulletEx('', Checks[Checkbox3.Checked], il, -1);
  srv.RichViewEdit.Add(OffOn[Checkbox3.Checked], sncomNormal);

  srv.RichViewEdit.AddBreakEx(1, rvbsLine, clRed);

  srv.RichViewEdit.AddBulletEx('', 0, il, 0);
  srv.RichViewEdit.Add('Memo1: ',sncomKeyword);
  srv.RichViewEdit.AddTextNL(Memo1.Lines.Text,sncomNormal, -1, 0);
  srv.RichViewEdit.Format;
end;

procedure TfrmDemo3.Change(Sender: TObject);
begin
  BuildSummary;
end;

procedure TfrmDemo3.FormCreate(Sender: TObject);
begin
  srv.SetMargin(5, 5, 5, 5);

  BuildSummary;
end;

procedure TfrmDemo3.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then Close;
end;

procedure TfrmDemo3.rvClick(Sender: TObject);
begin
  if not srv.RichViewEdit.SelectionExists then
    Application.MessageBox('This RichView only for view, do not click it', 'Info',
                         MB_OK or MB_ICONEXCLAMATION);
end;

end.
