unit Unit1;

interface

{------------------------------------------------------------------------------}
{ Important settings:
    rvoTagsArePChars in srv.RichViewEdit.Options
{------------------------------------------------------------------------------}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, RVStyle, RVScroll, RichView, RVEdit, SclRView;

type
  TForm1 = class(TForm)
    RVStyle1: TRVStyle;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    Button3: TButton;
    Label3: TLabel;
    srv: TSRichViewEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure RichViewEdit1Change(Sender: TObject);
  private
    { Private declarations }
    LastNameItemNo,          // Storing LastItem no is not necessary,
    LastDateItemNo: Integer; // but increases efficiency
    Freeze: Boolean;
    procedure InsertField(const field, value: String; var LastItemNo: Integer);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;



implementation

procedure GetFieldItemNo(rv: TCustomRichView; const field: String; var ItemNo: Integer);
var i: Integer;
begin
  if (ItemNo>=0) and (ItemNo<rv.ItemCount) and
     (PChar(rv.GetItemTag(ItemNo)) = field) then
    exit;
  ItemNo := -1;
  for i := 0 to rv.ItemCount-1 do
    if PChar(rv.GetItemTag(i)) = field then begin
      ItemNo := i;
      exit;
    end;
end;

function GetFieldValue(rv: TCustomRichView; const field: String;
                       var LastItemNo: Integer): String;
begin
  GetFieldItemNo(rv, field, LastItemNo);
  if LastItemNo>=0 then
    Result := rv.GetItemText(LastItemNo)
  else
    Result := '';
end;

procedure SetFieldValue(rv: TCustomRichViewEdit; const field, value: String;
                        var LastItemNo: Integer);
begin
  GetFieldItemNo(rv, field, LastItemNo);
  if LastItemNo>=0 then
    rv.SetItemTextEd(LastItemNo, value);
end;


{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  srv.SetMargin(25, 25, 25, 25);
  srv.RichViewEdit.Clear;
  srv.RichViewEdit.AddNL('Insert fields here',0,0);
  srv.RichViewEdit.Format;
end;

procedure TForm1.InsertField(const field, value: String; var LastItemNo: Integer);
var StyleNo: Integer;
begin
  if GetFieldValue(srv.RichViewEdit, field, LastItemNo)<>'' then begin
    Application.MessageBox('Field already exists!','',0);
    exit;
  end;
  StyleNo := srv.RichViewEdit.CurParaStyleNo;
  srv.RichViewEdit.CurTextStyleNo := 6;
  srv.RichViewEdit.InsertStringTag(value, Integer(StrNew(PChar(field))));
  srv.RichViewEdit.CurTextStyleNo := StyleNo;
  srv.RichViewEdit.SetFocus;
end;


procedure TForm1.Button1Click(Sender: TObject);

begin
  InsertField('name', Edit1.Text, LastNameItemNo);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  InsertField('date', Edit2.Text, LastDateItemNo);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  srv.RichViewEdit.ApplyTextStyle(0);
  srv.RichViewEdit.SetFocus;
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  if Freeze then
    exit;
  Freeze := True;
  try
    SetFieldValue(srv.RichViewEdit, 'name', Edit1.Text, LastNameItemNo);
  finally
    Freeze := False;
  end;
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
  if Freeze then
    exit;
  Freeze := True;
  try
    SetFieldValue(srv.RichViewEdit, 'date', Edit2.Text, LastDateItemNo);
  finally
    Freeze := False;
  end;
end;

procedure TForm1.RichViewEdit1Change(Sender: TObject);
var s: String;
begin
  if Freeze then
    exit;
  Freeze := True;
  try
    s := GetFieldValue(srv.RichViewEdit, 'name', LastNameItemNo);
    if s<>'' then
      Edit1.Text := s;
    s := GetFieldValue(srv.RichViewEdit, 'date', LastDateItemNo);
    if s<>'' then
      Edit2.Text := s;
  finally
    Freeze := False;
  end;      
end;



end.
