unit MFAddButton;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtDlgs;

type
  TFAddButton = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    ButCaption: TEdit;
    ButName: TEdit;
    ButEnabled: TCheckBox;
    ButDown: TCheckBox;
    ButGrouped: TCheckBox;
    ButWrap: TCheckBox;
    Button1: TButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    ButImage: TComboBox;
    OpenPictureDialog1: TOpenPictureDialog;
    Button2: TButton;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure ButImageDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FAddButton: TFAddButton;

implementation

uses MFInsertControls;

{$R *.DFM}

procedure TFAddButton.Button1Click(Sender: TObject);
var
     b : TBitmap;
begin
  if OpenPictureDialog1.Execute then
    begin
      b := TBitmap.Create;
      b.LoadFromFile(OpenPictureDialog1.FileName);
      ButImage.Items.Append(IntToStr(ButImage.Items.Count + 1));
      ButImage.ItemIndex := FInsertControls.ListImageTB.Add(b, nil);
      b.Free;
    end;
end;

procedure TFAddButton.ButImageDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
     b : TBitmap;
     r : TRect;
     w, h :Integer;
begin
  b := TBitmap.Create;
  FInsertControls.ListImageTB.GetBitmap(Index, b);
  h := Rect.Bottom - Rect.Top - 2;
  w := Round(h * b.Width / b.Height);
  r := Bounds(Rect.Left, Rect.Top, w, h);
  ButImage.Canvas.Brush.Color := ButImage.Color;
  ButImage.Canvas.FillRect(r);
  ButImage.Canvas.StretchDraw(r, b);
  ButImage.Canvas.Font.Assign(ButImage.Font);
  ButImage.Canvas.TextOut(r.Right + 5, r.Top + 5, IntToStr(Index));
  b.Free;
end;

procedure TFAddButton.Button2Click(Sender: TObject);
var
     NewString: string;
     ClickedOK: Boolean;
begin
  NewString := IntToStr(FInsertControls.ListImageTB.Width);
  ClickedOK := InputQuery('Input Width', 'Prompt', NewString);
  if ClickedOK then
    FInsertControls.ListImageTB.Width := StrToInt(NewString);
end;

procedure TFAddButton.Button3Click(Sender: TObject);
var
     NewString: string;
     ClickedOK: Boolean;
begin
  NewString := IntToStr(FInsertControls.ListImageTB.Height);
  ClickedOK := InputQuery('Input Height', 'Prompt', NewString);
  if ClickedOK then
    FInsertControls.ListImageTB.Height := StrToInt(NewString);
end;

end.
