
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Design-time support for RichViewActions         }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit rvActionsReg;

interface

{$I RV_Defs.inc}
{$I RichViewActions.inc}

// do not remove the dot below, if you are not sure...
{.$DEFINE RVAUSEHTMLLIST}

uses
  Classes,
  Windows,
  SysUtils,
  Messages,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  Menus,
  StdCtrls,
  ExtCtrls,
  ActnList,
  Registry,
  RichViewActions,
  {$IFDEF USEGLYFX}
  dmActionsGlyFX,
  {$ELSE}
  dmActions,
  {$ENDIF}
  {$IFDEF USERVADDICT3}
  dmActionsAddict3,
  {$ENDIF}
  {$IFDEF RVAUSEHTMLLIST}
  dmActionsEx, RVAHTMLList,
  {$ENDIF}
  {$IFDEF RICHVIEWDEF6}
  DesignEditors, DesignIntf,
  {$ELSE}
  DsgnIntf,
  {$ENDIF}
  RVADsgn
  ;

procedure Register;

implementation
                                                   
procedure SaveVersion;
var reg: TRegistry;
begin
  reg := TRegistry.Create;
  try
    reg.OpenKey('Software\TRichView', True);
    reg.WriteString('Actions_Version', 'v1.69.1');
    reg.WriteString('Actions_Download', 'http://www.trichview.com/resources/actions/richviewactions.zip');
    reg.CloseKey;
  except
  end;
  reg.Free;
end;

procedure Register;
begin
  SaveVersion;

  RegisterActions('RVE Custom', [TrvActionEvent], nil);

  RegisterActions('RVE File', [
    TrvActionNew,  TrvActionOpen, TrvActionSave, TrvActionExport, TrvActionSaveAs,
    TrvActionPrintPreview, TrvActionPrint, TrvActionQuickPrint, TrvActionPageSetup
    ], TrvActionsResource);

  RegisterActions('RVE Edit', [

    TrvActionCut, TrvActionCopy, TrvActionPaste, TrvActionPasteSpecial, TrvActionUndo, TrvActionRedo,
    TrvActionSelectAll,
    TrvActionFind, TrvActionFindNext, TrvActionReplace,
    TrvActionCharCase
    ], TrvActionsResource);

  RegisterActions('RVE Text', [
    TrvActionFonts, TrvActionFontEx,
    TrvActionFontBold, TrvActionFontItalic,
    TrvActionFontUnderline, TrvActionFontStrikeout,
    TrvActionFontGrow, TrvActionFontShrink,
    TrvActionFontGrowOnePoint, TrvActionFontShrinkOnePoint,
    TrvActionFontAllCaps, TrvActionFontOverline,
    TrvActionFontColor, TrvActionFontBackColor,
    TrvActionSubscript, TrvActionSuperscript
    ], TrvActionsResource);

  RegisterActions('RVE Paragraph', [
    TrvActionParagraph, TrvActionParaBorder,
    TrvActionWordWrap,
    TrvActionAlignLeft, TrvActionAlignRight, TrvActionAlignCenter, TrvActionAlignJustify,
    TrvActionIndentInc, TrvActionIndentDec,
    TrvActionParaColor,
    TrvActionLineSpacing100, TrvActionLineSpacing150, TrvActionLineSpacing200
    ], TrvActionsResource);

  RegisterActions('RVE List', [
    TrvActionParaList, TrvActionParaBullets, TrvActionParaNumbering
    ], TrvActionsResource);

  RegisterActions('RVE BiDi', [
    TrvActionTextRTL, TrvActionTextLTR,
    TrvActionParaRTL, TrvActionParaLTR
    ], TrvActionsResource);

  {$IFDEF RVAUSEHTMLLIST}
  RegisterActions('RVE List', [
    TrvActionParaListHTML
    ], TrvActionsResource);
  {$ENDIF}

  RegisterActions('RVE Insert', [
    TrvActionInsertFile, TrvActionInsertPicture, TrvActionInsertHLine,
    TrvActionInsertHyperlink, TrvActionInsertSymbol, TrvActionInsertText
    ], TrvActionsResource);

  RegisterActions('RVE Miscellaneous', [
    TrvActionColor, TrvActionBackground, TrvActionFillColor,
    TrvActionInsertPageBreak, TrvActionRemovePageBreak,
    TrvActionItemProperties, TrvActionShowSpecialCharacters
    ], TrvActionsResource);


  RegisterActions('RVE Table', [
    TrvActionInsertTable, TrvActionTableInsertRowsBelow, TrvActionTableInsertRowsAbove,
    TrvActionTableInsertColLeft, TrvActionTableInsertColRight,
    TrvActionTableDeleteRows, TrvActionTableDeleteCols, TrvActionTableDeleteTable,
    TrvActionTableMergeCells, TrvActionTableSplitCells,
    TrvActionTableSelectTable, TrvActionTableSelectRows, TrvActionTableSelectCols,
    TrvActionTableSelectCell,
    TrvActionTableCellVAlignTop, TrvActionTableCellVAlignMiddle,
    TrvActionTableCellVAlignBottom, TrvActionTableCellVAlignDefault,
    TrvActionTableCellLeftBorder, TrvActionTableCellRightBorder,
    TrvActionTableCellTopBorder, TrvActionTableCellBottomBorder,
    TrvActionTableCellAllBorders, TrvActionTableCellNoBorders,

    TrvActionTableProperties, TrvActionTableGrid
    ], TrvActionsResource);

  {$IFDEF USERVADDICT3}
  RegisterActions('RVE Spell Check',
    [TrvActionAddictSpell3, TrvActionAddictThesaurus3],
    TrvActionsResourceAddict3);
  {$ENDIF}

  RegisterComponents('RichView', [TRVAControlPanel,
    {$IFDEF USETB2K}TRVATBPopupMenu, {$ENDIF}
    {$IFDEF USETBX}TRVATBXPopupMenu, {$ENDIF}
    {$IFDEF USESPTBX}TRVASPTBXPopupMenu, {$ENDIF}
    TRVAPopupMenu]);

end;


end.