
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Functions for localization                      }
{                                                       }
{       Copyright (c) 2002-2003, Sergey Tkachenko       }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit RVALocalize;

{$I RV_Defs.inc}
{$I RichViewActions.inc}

{-------------------------------------------------------------------------------

 How to create localization for another language (for example, Greek)
 1. Copy RVAL_EngUS.pas to RVAL_Greek.pas (where Greek - a name of your language)
 2. Include this new unit in uses clause of this file.
 3. Translate all entries in Messages array in RVAL_Greek.pas
 4. In the initialization section of RVAL_Greek.pas, change a call of
    RVA_RegisterLanguage:
    RVA_RegisterLanguage('Greek', GREEK_CHARSET, @Messages);
    (see help on TFontCharset for a list of charset values)
 5. Remove call of RVA_SwitchLanguage from initialization section
 6. If you want to share your translation with other users,
    send your file to svt@trichview.com

-------------------------------------------------------------------------------}

interface
uses Windows, SysUtils, Classes, Graphics, RVClasses,
     {$IFDEF RICHVIEWDEF2009}
     RVALUTF8_EngUS,
     RVALUTF8_Rus,
     RVALUTF8_Sv,
     RVALUTF8_NorBok,
     RVALUTF8_De,
     RVALUTF8_Ita,
     RVALUTF8_Fr,
     RVALUTF8_PtBr,
     RVALUTF8_Czech,
     RVALUTF8_Dutch,
     RVALUTF8_Slovak,
     RVALUTF8_Farsi,
     RVALUTF8_Lith,
     RVALUTF8_Esp,
     RVALUTF8_Ukr,
     RVALUTF8_Turkish,
     RVALUTF8_Blr,
     RVALUTF8_ChsZh,
     RVALUTF8_Hun,
     RVALUTF8_Polish,
     RVALUTF8_ChineseBig5,
     RVALUTF8_Rom
     {$ELSE}
     RVAL_EngUS,
     RVAL_Rus,
     RVAL_Sv,
     RVAL_NorBok,
     RVAL_De,
     RVAL_Ita,
     RVAL_Fr,
     RVAL_PtBr,
     RVAL_Czech,
     RVAL_Dutch,
     RVAL_Slovak,
     RVAL_Farsi,
     RVAL_Lith,
     RVAL_Esp,
     RVAL_Ukr,
     RVAL_Turkish,
     RVAL_Blr,
     RVAL_ChsZh,
     RVAL_Hun,
     RVAL_Polish,
     RVAL_ChineseBig5,
     RVAL_Rom
     {$ENDIF}
     { add your unit here }
     ;

type
  TColorRecord = record
    Name: PChar;
    Color: TColor;
  end;

const ColorCount = 40;
      Colors : array[0..ColorCount - 1] of TColorRecord = (
        (Name: 'Black'; Color: $000000),
        (Name: 'Brown'; Color: $003399),
        (Name: 'Olive Green'; Color: $003333),
        (Name: 'Dark Green'; Color: $003300),
        (Name: 'Dark Teal'; Color: $663300),
        (Name: 'Dark blue'; Color: $800000),
        (Name: 'Indigo'; Color: $993333),
        (Name: 'Gray-80%'; Color: $333333),

        (Name: 'Dark Red'; Color: $000080),
        (Name: 'Orange'; Color: $0066FF),
        (Name: 'Dark Yellow'; Color: $008080),
        (Name: 'Green'; Color: $008000),
        (Name: 'Teal'; Color: $808000),
        (Name: 'Blue'; Color: $FF0000),
        (Name: 'Blue-Gray'; Color: $996666),
        (Name: 'Gray-50%'; Color: $808080),

        (Name: 'Red'; Color: $0000FF),
        (Name: 'Light Orange'; Color: $0099FF),
        (Name: 'Lime'; Color: $00CC99),
        (Name: 'Sea Green'; Color: $669933),
        (Name: 'Aqua'; Color: $CCCC33),
        (Name: 'Light Blue'; Color: $FF6633),
        (Name: 'Violet'; Color: $800080),
        (Name: 'Grey-40%'; Color: $969696),

        (Name: 'Pink'; Color: $FF00FF),
        (Name: 'Gold'; Color: $00CCFF),
        (Name: 'Yellow'; Color: $00FFFF),
        (Name: 'Bright Green'; Color: $00FF00),
        (Name: 'Turquoise'; Color: $FFFF00),
        (Name: 'Sky Blue'; Color: $FFCC00),
        (Name: 'Plum'; Color: $663399),
        (Name: 'Gray-25%'; Color: $C0C0C0),

        (Name: 'Rose'; Color: $CC99FF),
        (Name: 'Tan'; Color: $99CCFF),
        (Name: 'Light Yellow'; Color: $99FFFF),
        (Name: 'Light Green'; Color: $CCFFCC),
        (Name: 'Light Turquoise'; Color: $FFFFCC),
        (Name: 'Pale Blue'; Color: $FFCC99),
        (Name: 'Lavender'; Color: $FF99CC),
        (Name: 'White'; Color: $FFFFFF)
        );

type
  TRVAMessageID = (
    rvam_Empty,
    // menus
    rvam_menu_File, rvam_menu_Edit, rvam_menu_Format, rvam_menu_Font,
    rvam_menu_Para, rvam_menu_Insert, rvam_menu_Table, rvam_menu_Window,
    rvam_menu_Help, rvam_menu_Exit, rvam_menu_View, rvam_menu_Tools,
    rvam_menu_FontSize, rvam_menu_FontStyle, rvam_menu_TableSelect,
    rvam_menu_TableCellAlign, rvam_menu_TableCellBorders,
    // actions
    rvam_act_New, rvam_act_NewH,
    rvam_act_Open, rvam_act_OpenH,
    rvam_act_Save, rvam_act_SaveH,
    rvam_act_SaveAs, rvam_act_SaveAsH,
    rvam_act_Export, rvam_act_ExportH,
    rvam_act_Preview, rvam_act_PreviewH,
    rvam_act_Print, rvam_act_PrintH,
    rvam_act_QuickPrint, rvam_act_QuickPrintH,
    rvam_act_PageSetup, rvam_act_PageSetupH,
    rvam_act_Cut, rvam_act_CutH,
    rvam_act_Copy, rvam_act_CopyH,
    rvam_act_Paste, rvam_act_PasteH,
    rvam_act_PasteSpecial, rvam_act_PasteSpecialH,
    rvam_act_SelectAll, rvam_act_SelectAllH,
    rvam_act_Undo, rvam_act_UndoH,
    rvam_act_Redo, rvam_act_RedoH,
    rvam_act_Find, rvam_act_FindH,
    rvam_act_FindNext, rvam_act_FindNextH,
    rvam_act_Replace, rvam_act_ReplaceH,
    rvam_act_InsertFile, rvam_act_InsertFileH,
    rvam_act_InsertPicture, rvam_act_InsertPictureH,
    rvam_act_InsertHLine, rvam_act_InsertHLineH,
    rvam_act_Hyperlink, rvam_act_HyperlinkH,
    rvam_act_InsertSymbol, rvam_act_InsertSymbolH,
    rvam_act_ParaList, rvam_act_ParaListH,
    rvam_act_Bullets, rvam_act_BulletsH,
    rvam_act_Numbering, rvam_act_NumberingH,
    rvam_act_Color, rvam_act_ColorH,
    rvam_act_FillColor, rvam_act_FillColorH,
    rvam_act_InsertPageBreak, rvam_act_InsertPageBreakH,
    rvam_act_RemovePageBreak, rvam_act_RemovePageBreakH,
    rvam_act_ItemProperties, rvam_act_ItemPropertiesH,
    rvam_act_Background, rvam_act_BackgroundH,
    rvam_act_Paragraph, rvam_act_ParagraphH,
    rvam_act_IndentInc, rvam_act_IndentIncH,
    rvam_act_IndentDec, rvam_act_IndentDecH,
    rvam_act_WordWrap, rvam_act_WordWrapH,
    rvam_act_AlignLeft, rvam_act_AlignLeftH,
    rvam_act_AlignRight, rvam_act_AlignRightH,
    rvam_act_AlignCenter, rvam_act_AlignCenterH,
    rvam_act_AlignJustify, rvam_act_AlignJustifyH,
    rvam_act_ParaColor, rvam_act_ParaColorH,
    rvam_act_LS100, rvam_act_LS100H,
    rvam_act_LS150, rvam_act_LS150H,
    rvam_act_LS200, rvam_act_LS200H,
    rvam_act_ParaBorder, rvam_act_ParaBorderH,
    rvam_act_InsertTable, rvam_act_InsertTableH,
    rvam_act_TableInsertRowsAbove, rvam_act_TableInsertRowsAboveH,
    rvam_act_TableInsertRowsBelow, rvam_act_TableInsertRowsBelowH,
    rvam_act_TableInsertColsLeft, rvam_act_TableInsertColsLeftH,
    rvam_act_TableInsertColsRight, rvam_act_TableInsertColsRightH,
    rvam_act_TableDeleteRows, rvam_act_TableDeleteRowsH,
    rvam_act_TableDeleteCols, rvam_act_TableDeleteColsH,
    rvam_act_TableDeleteTable, rvam_act_TableDeleteTableH,
    rvam_act_TableMergeCells, rvam_act_TableMergeCellsH,
    rvam_act_TableSplitCells, rvam_act_TableSplitCellsH,
    rvam_act_TableSelectTable, rvam_act_TableSelectTableH,
    rvam_act_TableSelectRows, rvam_act_TableSelectRowsH,
    rvam_act_TableSelectCols, rvam_act_TableSelectColsH,
    rvam_act_TableSelectCell, rvam_act_TableSelectCellH,
    rvam_act_TableCellVAlignTop, rvam_act_TableCellVAlignTopH,
    rvam_act_TableCellVAlignMiddle, rvam_act_TableCellVAlignMiddleH,
    rvam_act_TableCellVAlignBottom, rvam_act_TableCellVAlignBottomH,
    rvam_act_TableCellVAlignDefault, rvam_act_TableCellVAlignDefaultH,
    rvam_act_TableProperties, rvam_act_TablePropertiesH,
    rvam_act_TableGrid, rvam_act_TableGridH,
    rvam_act_TableCellLeftBorder, rvam_act_TableCellLeftBorderH,
    rvam_act_TableCellRightBorder, rvam_act_TableCellRightBorderH,
    rvam_act_TableCellTopBorder, rvam_act_TableCellTopBorderH,
    rvam_act_TableCellBottomBorder, rvam_act_TableCellBottomBorderH,
    rvam_act_TableCellAllBorders, rvam_act_TableCellAllBordersH,
    rvam_act_TableCellNoBorders, rvam_act_TableCellNoBordersH,
    rvam_act_Font, rvam_act_FontH,
    rvam_act_Bold, rvam_act_BoldH,
    rvam_act_Italic, rvam_act_ItalicH,
    rvam_act_Underline, rvam_act_UnderlineH,
    rvam_act_StrikeOut, rvam_act_StrikeOutH,
    rvam_act_FontGrow, rvam_act_FontGrowH,
    rvam_act_FontShrink, rvam_act_FontShrinkH,
    rvam_act_FontGrow1Pt, rvam_act_FontGrow1PtH,
    rvam_act_FontShrink1Pt, rvam_act_FontShrink1PtH,
    rvam_act_AllCaps, rvam_act_AllCapsH,
    rvam_act_Overline, rvam_act_OverlineH,
    rvam_act_TextColor, rvam_act_TextColorH,
    rvam_act_TextBackColor, rvam_act_TextBackColorH,
    rvam_act_Spell, rvam_act_SpellH,
    rvam_act_Thesaurus, rvam_act_ThesaurusH,
    rvam_act_ParaLTR, rvam_act_ParaLTRH,
    rvam_act_ParaRTL, rvam_act_ParaRTLH,
    rvam_act_TextLTR, rvam_act_TextLTRH,
    rvam_act_TextRTL, rvam_act_TextRTLH,
    rvam_act_CharCase, rvam_act_CharCaseH,
    rvam_act_ShowSpecialCharacters, rvam_act_ShowSpecialCharactersH,
    rvam_act_Subscript, rvam_act_SubscriptH,
    rvam_act_Superscript, rvam_act_SuperscriptH,    
    // buttons
    rvam_btn_OK, rvam_btn_Cancel, rvam_btn_Close, rvam_btn_Insert,
    rvam_btn_Open, rvam_btn_Save, rvam_btn_Clear, rvam_btn_Help,
    // others
    rvam_Percents, rvam_Pixels,
    rvam_LeftSide, rvam_TopSide, rvam_RightSide, rvam_BottomSide,
    rvam_SaveChanges, rvam_Confirm, rvam_LostFormat,
    rvam_RVF,
    // error messages
    rvam_err_Title, rvam_err_ErrorLoadingFile, rvam_err_ErrorLoadingImageFile,
    rvam_err_ErrorSavingFile,
    // file filters
    rvam_flt_RVF, rvam_flt_RTF, rvam_flt_XML, rvam_flt_TextAnsi, rvam_flt_TextUnicode,
    rvam_flt_TextAuto, rvam_flt_HTMLOpen, rvam_flt_HTMLCSS, rvam_flt_HTMLPlain,
    // search and replace
    rvam_src_Complete, rvam_src_NotFound, rvam_src_1Replaced, rvam_src_NReplaced,
    rvam_src_ContinueFromStart, rvam_src_ContinueFromEnd,
    // colors
    rvam_cl_Transparent, rvam_cl_Auto,
    rvam_cl_Black, vam_cl_Brown, vam_cl_OliveGreen, rvam_cl_DarkGreen,
    rvam_cl_DarkTeal, rvam_cl_DarkBlue, rvam_cl_Indigo, rvam_cl_Gray80,
    rvam_cl_DarkRed, rvam_cl_Orange, rvam_cl_DarkYellow, rvam_cl_Green,
    rvam_cl_Teal, rvam_cl_Blue, rvam_cl_Blue_Gray, rvam_cl_Gray50,
    rvam_cl_Red, rvam_cl_LightOrange, rvam_cl_Lime, rvam_cl_SeaGreen,
    rvam_cl_Aqua, rvam_cl_LightBlue, rvam_cl_Violet, rvam_cl_Grey,
    rvam_cl_Pink, rvam_cl_Gold, rvam_cl_Yellow, rvam_cl_BrightGreen,
    rvam_cl_Turquoise, rvam_cl_SkyBlue, rvam_cl_Plum, rvam_cl_Gray25,
    rvam_cl_Rose, rvam_cl_Tan, rvam_cl_LightYellow, rvam_cl_LightGreen,
    rvam_cl_LightTurquoise, rvam_cl_PaleBlue, rvam_cl_Lavender, rvam_cl_White,
    // color picker buttons
    rvam_cpcl_Transparent, rvam_cpcl_Auto, rvam_cpcl_More, rvam_cpcl_Default,
    // background form
    rvam_back_Title, rvam_back_Color, rvam_back_Position, rvam_back_Background, rvam_back_SampleText,
    rvam_back_None, rvam_back_FullWindow, rvam_back_FixedTiles, rvam_back_Tiles,
    rvam_back_Center, rvam_back_Padding,
    // fill color form
    rvam_fillc_Title, rvam_fillc_ApplyTo, rvam_fillc_MoreColors, rvam_fillc_Padding,
    rvam_fillc_PleaseSelect,
    rvam_fillc_Text, rvam_fillc_Paragraph, rvam_fillc_Table, rvam_fillc_Cell,
    // font form
    rvam_font_Title, rvam_font_FontTab, rvam_font_LayoutTab,
    rvam_font_FontName, rvam_font_FontSize, rvam_font_FontStyle,
    rvam_font_Bold, rvam_font_Italic, rvam_font_Script, rvam_font_Color,
    rvam_font_DefaultCharset, rvam_font_Effects, rvam_font_Underline,
    rvam_font_Overline, rvam_font_Strikethrough, rvam_font_AllCaps,
    rvam_font_Sample, rvam_font_SampleText,
    rvam_font_SpacingH, rvam_font_Spacing, rvam_font_Expanded, rvam_font_Condensed,
    rvam_font_OffsetH, rvam_font_Offset, rvam_font_Down, rvam_font_Up,
    rvam_font_ScalingH, rvam_font_Scaling,
    rvam_font_ScriptH, rvam_font_SSNorm, rvam_font_SSSub, rvam_font_SSSuper,
    // 4 sides form
    rvam_4s_DefTitle, rvam_4s_Top, rvam_4s_Left, rvam_4s_Bottom, rvam_4s_Right, rvam_4s_EqualValues,
    // hyperlink form
    rvam_hl_Title, rvam_hl_GBTitle, rvam_hl_Text, rvam_hl_Target, rvam_hl_Selection,
    rvam_hl_CannotNavigate,
    rvam_hl_HypProperties,
    // hyperlink properties form
    rvam_hp_Title, rvam_hp_GBNormal, rvam_hp_GBActive,
    rvam_hp_Text, rvam_hp_TextBack,
    rvam_hp_HoverText, rvam_hp_HoverTextBack,
    rvam_hp_AsNormal,
    // insert symbol form
    rvam_is_Title, rvam_is_Font, rvam_is_Charset, rvam_is_Unicode,
    rvam_is_Block,
    rvam_is_CharCode, rvam_is_UCharCode, rvam_is_NoChar,
    // insert table form
    rvam_it_Title, rvam_it_TableSize, rvam_it_nCols, rvam_it_nRows,
    rvam_it_TableLayout, rvam_it_Autosize, rvam_it_Fit, rvam_it_Manual,
    rvam_it_Remember,
    // item properties form
    rvam_ip_Title, rvam_ip_ImageTab, rvam_ip_LayoutTab, rvam_ip_LineTab,
    rvam_ip_TableTab, rvam_ip_RowsTab, rvam_ip_CellsTab,
    rvam_ip_Preview, rvam_ip_Transparency, rvam_ip_Transparent, rvam_ip_TrColor,
    rvam_ip_Change, rvam_ip_TrAutoColor,
    rvam_ip_VAlign, rvam_ip_VAlignValue, rvam_ip_VAlign1, rvam_ip_VAlign2,
    rvam_ip_VAlign3, rvam_ip_VAlign4, rvam_ip_VAlign5,
    rvam_ip_ShiftBy,
    rvam_ip_Stretch, rvam_ip_Width, rvam_ip_Height, rvam_ip_DefaultSize,
    rvam_ip_SpacingGB, rvam_ip_Spacing, rvam_ip_Web, rvam_ip_Alt,
    rvam_ip_HorzLine, rvam_ip_HLColor, rvam_ip_HLWidth,
    rvam_ip_TableGB, rvam_ip_TableWidth, rvam_ip_TableColor, rvam_ip_CellPadding,
    rvam_ip_CellSpacing, rvam_ip_More, rvam_ip_TableBorder, rvam_ip_CellBorder,
    rvam_ip_TableBorderTitle, rvam_ip_CellBorderTitle,
    rvam_ip_TablePrinting, rvam_ip_KeepOnPage, rvam_ip_HeadingRows, rvam_ip_HeadingRowsTip,
    rvam_ip_VATop, rvam_ip_VACenter, rvam_ip_VABottom, rvam_ip_VADefault,
    rvam_ip_CellSettings, rvam_ip_CellBestWidth, rvam_ip_CellBestHeight,
    rvam_ip_CellFillColor, rvam_ip_CellBorderGB, rvam_ip_VisibleSides,
    rvam_ip_CellShadowColor, rvam_ip_CellLightColor, rvam_ip_CellBorderColor,
    rvam_ip_BackgroundImage,
    // paste special form
    rvam_ps_Title, rvam_ps_Label, rvam_ps_RTF, rvam_ps_HTML, rvam_ps_Text,
    rvam_ps_UnicodeText, rvam_ps_BMP, rvam_ps_WMF, rvam_ps_GraphicFiles,
    // list gallery form
    rvam_lg_Title, rvam_lg_BulletTab, rvam_lg_NumTab, rvam_lg_BulletGB, rvam_lg_NumGB,
    rvam_lg_Customize, rvam_lg_Reset, rvam_lg_None,
    rvam_lg_NumContinue, rvam_lg_NumReset, rvam_lg_NumCreate,
    // list gallery 2 form (HTML) -----------------------------------------------
    rvam_lg2_UpperAlpha, rvam_lg2_UpperRoman, rvam_lg2_Decimal, rvam_lg2_LowerAlpha, rvam_lg2_LowerRoman,
    rvam_lg2_Circle, rvam_lg2_Disc, rvam_lg2_Square,
    rvam_lg2_Level, rvam_lg2_StartFrom, rvam_lg2_Continue, rvam_lg2_Numbering, 
    // customize list form
    rvam_cul_Title, rvam_cul_Levels, rvam_cul_LevelCount, rvam_cul_ListProperties, rvam_cul_ListType,
    rvam_cul_ListTypeBullet, rvam_cul_ListTypeImage, rvam_cul_InsertNumberHint,
    rvam_cul_NumberFormat, rvam_cul_Number, rvam_cul_StartFrom, rvam_cul_Font,
    rvam_cul_Image, rvam_cul_BulletCharacter, rvam_cul_Bullet,
    rvam_cul_ListTextPos, rvam_cul_BulletPos, rvam_cul_NumPos, rvam_cul_ImagePos, rvam_cul_TextPos,
    rvam_cul_At, rvam_cul_LeftIndent, rvam_cul_FirstIndent, rvam_cul_FromLeftIndent,
    rvam_cul_OneLevelPreview, rvam_cul_Preview, rvam_cul_PreviewText,
    rvam_cul_Left, rvam_cul_Right, rvam_cul_Center,
    rvam_cul_LevelNo, rvam_cul_ThisLevel, rvam_cul_BulletTitle,
    // paragraph border and backgound form
    rvam_pbb_Title, rvam_pbb_BorderTab, rvam_pbb_BackgroundTab,
    rvam_pbb_Settings, rvam_pbb_Color, rvam_pbb_Width, rvam_pbb_InternalWidth,
    rvam_pbb_Offsets, rvam_pbb_Sample, rvam_pbb_BorderType,
    rvam_pbb_BTNone, rvam_pbb_BTSingle, rvam_pbb_BTDouble, rvam_pbb_BTTriple,
    rvam_pbb_BTThickInside, rvam_pbb_BTThickOutside,
    rvam_pbb_FillColor, rvam_pbb_MoreColors, rvam_pbb_Padding,
    rvam_pbb_PreviewText,
    rvam_pbb_OffsetsTitle, rvam_pbb_OffsetsGB,
    // paragraph form
    rvam_par_Title, rvam_par_Alignment, rvam_par_AlLeft, rvam_par_AlRight,
    rvam_par_AlCenter, rvam_par_AlJustify, rvam_par_Spacing,
    rvam_par_Before, rvam_par_After, rvam_par_LineSpacing, rvam_par_By,
    rvam_par_Indents, rvam_par_Left, rvam_par_Right, rvam_par_FirstLine,
    rvam_par_Indented, rvam_par_Hanging, rvam_par_Sample,
    rvam_par_LS_100, rvam_par_150, rvam_par_200,
    rvam_par_AtLeast, rvam_par_Exactly, rvam_par_Multiple,
    rvam_par_Preview,
    rvam_par_MainTab, rvam_par_TabsTab, rvam_par_TextFlowTab,
    rvam_par_TabStopPos, rvam_par_btnSet, rvam_par_Delete, rvam_par_DeleteAll,
    rvam_par_TabAlign,
    rvam_par_TabAlignLeft, rvam_par_TabAlignRight, rvam_par_TabAlignCenter,
    rvam_par_Leader, rvam_par_LeaderNone, rvam_par_TabsToBeDeleted,
    rvam_par_TabDelNone, rvam_par_TabDelAll,
    rvam_par_Pagination, rvam_par_KeepWithNext, rvam_par_KeepLinesTogether,
    // preview form
    rvam_pp_Title, rvam_pp_PageWidth, rvam_pp_FullPage, rvam_pp_Pages,
    rvam_pp_InvalidScale, rvam_pp_OfNo,
    rvam_pp_First, rvam_pp_Prior, rvam_pp_Next, rvam_pp_Last,
    // cell spacing form
    rvam_cs_Title, rvam_cs_GB, rvam_cs_BetweenCells, rvam_cs_FromTableToCell,
    rvam_cs_Vert1, rvam_cs_Horz1, rvam_cs_Vert2, rvam_cs_Horz2,
    // table borders form
    rvam_tb_Title, rvam_tb_Settings, rvam_tb_Color, rvam_tb_LightColor,
    rvam_tb_ShadowColor, rvam_tb_Width, rvam_tb_BorderType,
    rvam_tb_BTNone, rvam_tb_BTSunken, rvam_tb_BTRaised, rvam_tb_BTFlat,
    // split cells form
    rvam_spl_Title, rvam_spl_SplitTo, rvam_spl_Specified, rvam_spl_Original,
    rvam_spl_nCols, rvam_spl_nRows, rvam_spl_Merge, rvam_spl_OriginalCols,
    rvam_spl_OriginalRows,
    // add rows form
    rvam_ar_Title, rvam_ar_Prompt,
    // page setup form
    rvam_pg_Title, rvam_pg_PageTab, rvam_pg_HFTab,
    rvam_pg_MarginsMM, rvam_pg_MarginsInch, rvam_pg_Left, rvam_pg_Top, rvam_pg_Right, rvam_pg_Bottom,
    rvam_pg_MirrorMargins,
    rvam_pg_Orientation, rvam_pg_Portrait, rvam_pg_Landscape,
    rvam_pg_Paper, rvam_pg_Size, rvam_pg_Source,
    rvam_pg_Header, rvam_pg_HText, rvam_pg_HOnFirstPage, rvam_pg_HFont,
    rvam_pg_HLeft, rvam_pg_HCenter, rvam_pg_HRight,
    rvam_pg_Footer, rvam_pg_FText, rvam_pg_FOnFirstPage, rvam_pg_FFont,
    rvam_pg_FLeft, rvam_pg_FCenter, rvam_pg_FRight,
    rvam_pg_PageNumbers, rvam_pg_StartFrom,
    rvam_pg_Codes,
    // ruler
    rvam_ruler_ColumnMove, rvam_ruler_RowMove,
    rvam_ruler_FirstIndent, rvam_ruler_LeftIndent,
    rvam_ruler_HangingIndent, rvam_ruler_RightIndent,
    rvam_ruler_listlevel_Dec, rvam_ruler_listlevel_Inc,
    rvam_ruler_MarginBottom, rvam_ruler_MarginLeft, rvam_ruler_MarginRight, rvam_ruler_MarginTop,
    rvam_ruler_tab_Left, rvam_ruler_tab_Right, rvam_ruler_tab_Center,
    rvam_ruler_tab_Decimal,
    // spelling check and thesaurus
    rvam_spell_Synonyms, rvam_spell_IgnoreAll, rvam_spell_AddToDictionary
     );
  TRVAMessages = array [TRVAMessageID] of PChar;
  PRVAMessages = ^TRVAMessages;

  TRVALanguageName = type String;


procedure RVA_RegisterLanguage(const LanguageName: TRVALanguageName;
  Charset: TFontCharset; Messages: PRVAMessages; const HelpFile: String = '');

function RVA_GetCharset: TFontCharset;
function RVA_GetS(MsgID: TRVAMessageID): String;
function RVA_GetSH(MsgID: TRVAMessageID): String;
function RVA_GetPC(MsgID: TRVAMessageID): PChar;
function RVA_GetLanguageName: TRVALanguageName;
function RVA_GetHelpFile: String;
procedure RVA_SwitchLanguage(const LanguageName: TRVALanguageName);
procedure RVA_EnumLanguages(Proc: TGetStrProc);
procedure RVA_FillLanguageList(sl: TStrings);

implementation

var Languages: TRVList = nil;
    LanguageIndex: Integer;

type
  TRVALanguageInfo = class
    public
      LanguageName: TRVALanguageName;
      Charset: TFontCharset;
      Messages: PRVAMessages;
      HelpFile: String;
  end;

procedure RVA_RegisterLanguage(const LanguageName: TRVALanguageName;
  Charset: TFontCharset; Messages: PRVAMessages; const HelpFile: String = '');
var LInfo: TRVALanguageInfo;
begin
  if Languages=nil then
    Languages := TRVList.Create;
  LInfo := TRVALanguageInfo.Create;
  LInfo.LanguageName := LanguageName;
  LInfo.Charset      := Charset;
  LInfo.Messages     := Messages;
  LInfo.HelpFile     := HelpFile;
  Languages.Add(LInfo);
  if LanguageIndex<0 then
    LanguageIndex := Languages.Count-1;
end;

function RVA_GetCharset: TFontCharset;
begin
  if LanguageIndex<0 then
    Result := DEFAULT_CHARSET
  else
    Result := TRVALanguageInfo(Languages[LanguageIndex]).Charset;
end;

function RVA_GetS(MsgID: TRVAMessageID): String;
begin
  Result := TRVALanguageInfo(Languages[LanguageIndex]).Messages[MsgId];
end;

function RVA_GetSH(MsgID: TRVAMessageID): String;
begin
  Result := ' '+String(TRVALanguageInfo(Languages[LanguageIndex]).Messages[MsgId])+' ';
end;

function RVA_GetPC(MsgID: TRVAMessageID): PChar;
begin
  Result := TRVALanguageInfo(Languages[LanguageIndex]).Messages[MsgId];
end;

procedure RVA_SwitchLanguage(const LanguageName: TRVALanguageName);
var i,r: Integer;
begin
  r := -1;
  for i := 0 to Languages.Count-1 do
    if LanguageName = TRVALanguageInfo(Languages[i]).LanguageName then begin
      r := i;
      break;
    end;
  if r<0 then
    raise Exception.Create('Invalid language: '+LanguageName);
  LanguageIndex := r;

  for i := 0 to ColorCount-1 do
    Colors[i].Name := PChar(RVA_GetPC(TRVAMessageID(ord(rvam_cl_Black)+i)));
end;

function RVA_GetLanguageName: TRVALanguageName;
begin
  if LanguageIndex<0 then
    Result := ''
  else
    Result := TRVALanguageInfo(Languages[LanguageIndex]).LanguageName;
end;

function RVA_GetHelpFile: String;
begin
  if LanguageIndex<0 then
    Result := ''
  else
    Result := TRVALanguageInfo(Languages[LanguageIndex]).HelpFile;
end;

procedure RVA_EnumLanguages(Proc: TGetStrProc);
var i: Integer;
begin
  for i := 0 to Languages.Count-1 do
    Proc(TRVALanguageInfo(Languages[i]).LanguageName);
end;

procedure RVA_FillLanguageList(sl: TStrings);
var i: Integer;
begin
  sl.Clear;
  for i := 0 to Languages.Count-1 do
    sl.Add(TRVALanguageInfo(Languages[i]).LanguageName);
end;


initialization

finalization
  Languages.Free;
  Languages := nil;
  LanguageIndex := -1;

end.
