//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RVStyle"
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichViewEdit1->Clear();
  RichViewEdit1->AddNLWTag("M",1,0,0);
  RichViewEdit1->AddNLWTag("=||m",0,-1,0);
  RichViewEdit1->AddNLWTag("i,j",3,-1,0);
  RichViewEdit1->AddNLWTag("||",0,-1,0);
  // Note: rvoTagsArePChars in Options
  RichViewEdit1->AddNLWTag("n",2, -1, (int)StrNew(L"m")); // double scripts are only as
    // an example here. They are too imperfect -
    // they assume that superscript text is narrower
    // (or at least not very wider)
    // than subscript
  RichViewEdit1->Format();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RVStyle1DrawStyleText(TRVStyle *Sender,
  const TRVRawByteString s, TCanvas *Canvas, int StyleNo, int SpaceBefore, int Left,
  int Top, int Width, int Height, TRVTextDrawStates DrawState,
    bool &DoDefault)
{
  switch (StyleNo)
  {
    case 1: // dot
    {
      // displaying small circle in the right top corner of item
      // and allowing default drawing of item text
      if (DrawState.Contains(rvtsItemEnd) && s.Length()>0)
      {
        Canvas->Pen->Color = Sender->TextStyles->Items[1]->Color;
        Canvas->Ellipse(Left+Width-2,Top-2,Left+Width+2,Top+2);
      }
      break;
    }
    case 2: // double scripts
    {
        // displaying tag string as superscript
        // and allowing default drawing of item text (subscript)
        if (DrawState.Contains(rvtsItemStart) && s.Length()>0)
        {
          wchar_t* UpperText =
            (wchar_t*)(((TCustomRVFormattedData*)(Sender->RVData))->GetItemTag(Sender->ItemNo));
          if (UpperText)
            Canvas->TextOut(Left,Top-Height+5, UpperText);
        }
    }
  }
}
//---------------------------------------------------------------------------