/*------------------------------------------------------------------------------}

  Very simple template editor for "mail merging"
  It loads and saves a template in TEMPLATE.RVF.

  See mail merging application in the same directory - MAILMERGE.

  Main settings:
  - since field names are stored in tags (see the help topic about tags)
    as strings, rvoTagsArePChars is included in Options of rve.
  - this demo uses a predefined set of styles (right click richviews,
    choose "Settings" from the context menu, choose "Use a predefined
    set of styles"). That means - only two text styles (see below) will be used.
  - rve.Style has two styles:
    0th style - normal text,
    1st - field code (bold, with background, protected)

------------------------------------------------------------------------------*/
#include <vcl\vcl.h>
#pragma hdrstop

#include "TEMainFrm.h"
//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  rve->LoadRVF(ExtractFilePath(Application->ExeName)+"template.rvf");
  rve->Format();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button4Click(TObject *Sender)
{
  rve->SaveRVF(ExtractFilePath(Application->ExeName)+"template.rvf", false);
}
//---------------------------------------------------------------------------
/*
  Inserting a field "code". Text of this item does not matter, but tag
  is important and equal to "code".
  Since rvprDoNotAutoSwitch is in Protection of the 1st text style,
  a current style will be switched back to previous value after insertion.
*/

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  rve->CurTextStyleNo = 1;
  rve->InsertStringTag("Code", (int)StrNew("code"));
  rve->SetFocus();
}
//---------------------------------------------------------------------------
/*
  Inserting a field "name".
*/
void __fastcall TForm1::Button2Click(TObject *Sender)
{
  rve->CurTextStyleNo = 1;
  rve->InsertStringTag("Name", (int)StrNew("name"));
  rve->SetFocus();
}
//---------------------------------------------------------------------------