from pychartdir import *


def legendpos(legendPos, filename) :

	#The data for the chart
	data0 = [100, 125, 245.78, 147, 67]
	data1 = [85, 156, 179.5, 211, 123]
	data2 = [97, 187, 156, 237, 157]
	labels = ["Mon", "Tue", "Wed", "Thu", "Fri"]

	#Create a XYChart object of size 300 x 300
	c = XYChart(300, 300)

	#Set the plot area at (50, 40) and of size 240 x 200
	c.setPlotArea(50, 40, 240, 200)

	if legendPos == 0 :
		#add legends on the top of the chart (60, 10) using horizontal layout.
		#set the font to 8 points, and hide the legend box boundary (Transparent)
		c.addLegend(60, 10, 0, "", 8).setBackground(Transparent, Transparent)
	elif legendPos == 1 :
		#add legends on the top of the plot area (60, 28) using horizontal layout
		#set the font to 8 points, and hide the legend box boundary (Transparent)
		c.addLegend(60, 28, 0, "", 8).setBackground(Transparent, Transparent)
		#reserve 20 pixels at the top of the plot area to ensure the legend keys
		#will not overlap with the charts
		c.yAxis().setTopMargin(20)
	else :
		#add legends on the bottom of the chart (60, 260) using horizontal layout
		#set the font to 8 points, and hide the legend box boundary (Transparent)
		c.addLegend(60, 260, 0, "", 8).setBackground(Transparent, Transparent)
		
	#Add a title to the y-axis
	c.yAxis().setTitle("Throughput (MBytes Per Hour)")

	#Set the labels on the x axis
	c.xAxis().setLabels(labels)

	#Use non-indented x-axis layout
	c.xAxis().setIndent(0)

	#Add 3 differnet layers using the given data sets
	c.addLineLayer(data0, 0x4040ff, "Server 1").setLineWidth(3)
	c.addBarLayer(data1, 0xff8080, "Server 2").set3D()
	c.addAreaLayer(data2, 0x80ff80, "Server 3").set3D()

	#output the chart
	c.makeChart(filename)
	

def main() :

	legendpos(0, "legendpos0.png")
	legendpos(1, "legendpos1.png")
	legendpos(2, "legendpos2.png")


if __name__ == '__main__':
    main()
    