use perlchartdir;


sub main
{
	#The data for the line chart
	my $NoValue = $perlchartdir::NoValue;
	my $data = [25, 18, 9, 4, 5, 8, 14, 20, 40, 92, 75, 88, 75, 
		58, 90, 95, 83, 75, 70, 66, 46, $NoValue, $NoValue, $NoValue, $NoValue];

	#The labels for the line chart
	my $labels = ["0", "", "", "3", "", "", "6", "", "", "9", "", "", 
		"12", "", "", "15", "", "", "18", "", "", "21", "", "", "24"];
	
	#First, create a XYChart of size 250 pixels x 250 pixels
	my $c = new XYChart(250, 250);

	#Set the plotarea at (30, 20) and of 200 pixel (w) x 200 pixels (h)
	$c->setPlotArea(30, 20, 200, 200);

	#Add a line chart layer using the supplied data
	$c->addLineLayer($data);

	#Set the x axis labels using the supplied labels
	$c->xAxis()->setLabels($labels);

	#output the chart as a PNG file
	$c->makeChart("simpleline.png");
}


main();
