use perlchartdir;

sub anglepie
{
	my ($angle, $clockwise, $filename) = @_;

	#The data for the pie chart
	my $data = [ 25, 18, 15, 12, 8, 30, 35 ];

	#The labels for the pie chart
	my $labels = [ "Labor", "Licenses", "Taxes", "Legal",
		"Insurance", "Facilities", "Production" ];
	
	#First, create a PieChart of size 280 pixels x 240 pixels
	my $c = new PieChart(280, 240);

	#Set the center of the pie at (140, 130) and the radius to 80 pixels
	$c->setPieSize(140, 130, 80);
	
	#add a title to the pie to show the start angle and direction
	$c->addTitle(sprintf("Start Angle = %d degrees\nDirection = %s", 
		$angle, (($clockwise and "Clockwise") or "AntiClockwise")));
	
	#Set the pie start angle and direction
	$c->setStartAngle($angle, $clockwise);

	#Draw the pie in 3D
	$c->set3D();

	#Set the pie data and the pie labels
	$c->setData($data, $labels);

	#Explode the 1st sector
	$c->sector(0)->setExplode();

	#output the chart
	$c->makeChart($filename);
}

anglepie(0, 1, "angle0pie.png");
anglepie(90, 0, "angle_90pie.png");

    