/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import symantec.itools.awt.ButtonBase;
import symantec.itools.lang.OS;

public class DirectionButton
extends ButtonBase {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    private int direction;
    private int left;
    private int right;
    private int top;
    private int bottom;
    private int indent;
    private Polygon poly;

    public DirectionButton() {
        this(0);
    }

    public DirectionButton(int d) {
        this.direction = d;
        this.left = 0;
        this.right = 0;
        this.bottom = 0;
        this.indent = 0;
        this.poly = null;
    }

    public void setDirection(int d) {
        this.direction = d;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setArrowIndent(int ai) {
        this.indent = ai;
        this.invalidate();
    }

    public int getArrowIndent() {
        return this.indent;
    }

    public void shrinkTriangle(int l, int r, int t, int b) {
        this.left = l;
        this.right = r;
        this.top = t;
        this.bottom = b;
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.updatePolygon();
        if (this.isEnabled()) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.gray);
        }
        g.fillPolygon(this.poly);
    }

    public Dimension preferredSize() {
        Dimension s = this.size();
        return new Dimension(Math.max(s.width, this.minimumSize().width), Math.max(s.height, this.minimumSize().height));
    }

    void updatePolygon() {
        Dimension s = this.size();
        this.poly = new Polygon();
        int centerHorizontal = s.width / 2 + this.pressedAdjustment;
        int centerVertical = s.height / 2 + this.pressedAdjustment;
        int topSide = this.top + this.bevel * 2 + this.pressedAdjustment + this.indent;
        int bottomSide = s.height - this.bottom - this.bevel * 2 + this.pressedAdjustment - this.indent;
        int leftSide = this.left + this.bevel * 2 + this.pressedAdjustment + this.indent;
        int rightSide = s.width - this.right - this.bevel * 2 + this.pressedAdjustment - this.indent;
        switch (this.direction) {
            case 2: {
                if (OS.isMacintosh()) {
                    this.poly.addPoint(centerHorizontal - 1, topSide - 1);
                    this.poly.addPoint(leftSide - 1, bottomSide - 2);
                    this.poly.addPoint(rightSide - 2, bottomSide - 2);
                    return;
                }
                this.poly.addPoint(centerHorizontal, topSide);
                this.poly.addPoint(leftSide, bottomSide);
                this.poly.addPoint(rightSide, bottomSide);
                return;
            }
            case 3: {
                if (OS.isMacintosh()) {
                    this.poly.addPoint(centerHorizontal - 1, bottomSide);
                    this.poly.addPoint(leftSide - 1, topSide);
                    this.poly.addPoint(rightSide - 1, topSide);
                    return;
                }
                this.poly.addPoint(centerHorizontal, bottomSide);
                this.poly.addPoint(leftSide, topSide);
                this.poly.addPoint(rightSide, topSide);
                return;
            }
            case 0: {
                if (OS.isMacintosh()) {
                    this.poly.addPoint(leftSide - 2, centerVertical - 1);
                    this.poly.addPoint(rightSide - 2, topSide - 1);
                    this.poly.addPoint(rightSide - 2, bottomSide - 1);
                    return;
                }
                this.poly.addPoint(leftSide, centerVertical);
                this.poly.addPoint(rightSide, topSide);
                this.poly.addPoint(rightSide, bottomSide);
                return;
            }
            case 1: {
                if (OS.isMacintosh()) {
                    this.poly.addPoint(rightSide - 1, centerVertical - 1);
                    this.poly.addPoint(leftSide, topSide - 1);
                    this.poly.addPoint(leftSide, bottomSide - 2);
                    return;
                }
                this.poly.addPoint(rightSide, centerVertical);
                this.poly.addPoint(leftSide, topSide);
                this.poly.addPoint(leftSide, bottomSide);
                return;
            }
        }
    }
}

