/*
 * Decompiled with CFR 0.152.
 */
package GenCns.GenJava;

import GenCns.GenJava.BackupManager;
import GenCns.GenJava.GenArchive;
import GenCns.GenJava.GenCategoryManager;
import GenCns.GenJava.GenericCategory;
import GenCns.GenJava.GenericException;
import GenCns.GenJava.HHMgr;
import GenCns.GenJava.PalmBaseManager;
import GenCns.GenJava.PalmData;
import GenCns.GenJava.PalmRecord;
import GenCns.GenJava.PcManager;
import java.io.IOException;
import java.util.Vector;
import palm.conduit.Log;
import palm.conduit.SyncProperties;

public class GenericSynchronizer {
    public static boolean m_bDebug = false;
    public static final int SYNC_CHECK_LEVEL_BASE = 0;
    public static final int ATTR_PC_MULTIPLE = 1;
    public static final int ATTR_HH_MULTIPLE = 65536;
    public static final int HH_ATTR_DELETED = 65536;
    public static final int HH_ATTR_ARCHIVED = 131072;
    public static final int HH_ATTR_MODIFIED = 262144;
    public static final int HH_ATTR_NEW = 524288;
    public static final int HH_ATTR_NONE = 0x200000;
    public static final int HH_ATTR_NO_REC = 0x400000;
    public static final int PC_ATTR_DELETED = 1;
    public static final int PC_ATTR_ARCHIVED = 2;
    public static final int PC_ATTR_MODIFIED = 4;
    public static final int PC_ATTR_NEW = 8;
    public static final int PC_ATTR_NONE = 32;
    public static final int PC_ATTR_NO_REC = 64;
    public static final int ATTR_NOT_EQUAL = 0x10000000;
    public static final int ATTR_EQUAL = 0x20000000;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_DELETE_PC = 1;
    public static final int ACTION_ARCHIVE_PC = 2;
    public static final int ACTION_DELETE_HH = 4;
    public static final int ACTION_ARCHIVE_HH_ON_PC = 8;
    public static final int ACTION_ADD_PC_TO_HH = 16;
    public static final int ACTION_ADD_HH_TO_PC = 32;
    public static final int ACTION_WRITE_HH_TO_PC = 64;
    public static final int ACTION_WRITE_PC_TO_HH = 128;
    public static final int ACTION_FAST_DOUBLE_MODIFY = 256;
    public static final int ACTION_FAST_HH_ARCHIVE_DOUBLE_MODIFY = 512;
    public static final int ACTION_FAST_PC_ARCHIVE_DOUBLE_MODIFY = 1024;
    public static final int ACTION_FAST_DOUBLE_ARCHIVE_DOUBLE_MODIFY = 2048;
    public static final int ACTION_SLOW_DOUBLE_MODIFY = 8192;
    public static final int ACTION_DELETE_HH_IGNORE_ERROR = 65536;
    public static final int ACTION_SYNC_ERROR = 0x10000000;
    public static final int LOG_MOD_DELETE = 0x1000000;
    protected boolean m_bPcMoveList = false;
    protected PalmBaseManager m_pcMgr;
    protected PalmBaseManager m_hhMgr;
    protected PalmBaseManager m_backupMgr;
    protected SyncProperties m_rSyncProperties;
    protected GenericCategory[] m_pcMoveList = null;
    protected Vector m_dbArchive;
    protected String m_remoteDB = null;
    protected int m_TotRemoteDBs = 1;
    protected long m_lDatabaseFlags = 0L;
    protected int m_sCheckLevel = 0;

    public GenericSynchronizer(SyncProperties syncProperties, long l) throws GenericException {
        this.m_rSyncProperties = syncProperties;
        this.m_lDatabaseFlags = l;
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's Constructor", -1, false);
            Log.AddEntry("      Sync Properties: ", -1, false);
            Log.AddEntry("      creator ID=" + Integer.toHexString(syncProperties.creator), -1, false);
            Log.AddEntry("      dbtype=" + Integer.toHexString(syncProperties.dbType), -1, false);
        }
        this.m_dbArchive = new Vector(16);
    }

    public void perform() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's Perform: sync type=" + this.m_rSyncProperties.syncType, -1, false);
        }
        this.m_bPcMoveList = false;
        if (this.m_rSyncProperties.syncType > 7) {
            throw new GenericException(4371);
        }
        if (this.m_rSyncProperties.syncType == 6) {
            return;
        }
        this.RegisterConduit();
        try {
            int n = 0;
            while (n < this.m_TotRemoteDBs) {
                this.GetRemoteDBInfo(n);
                switch (this.m_rSyncProperties.syncType) {
                    case 0: {
                        try {
                            this.PerformFastSync();
                            break;
                        }
                        catch (GenericException genericException) {
                            if (genericException.lastError == 4389) {
                                if (this.GetSyncMode() == 2) {
                                    this.CopyHHtoPC();
                                    break;
                                }
                                if (this.GetSyncMode() != 3) break;
                                this.CopyPCtoHH();
                                break;
                            }
                            throw genericException;
                        }
                    }
                    case 1: {
                        try {
                            this.PerformSlowSync();
                            break;
                        }
                        catch (GenericException genericException) {
                            if (genericException.lastError == 4389) {
                                if (this.GetSyncMode() == 2) {
                                    this.CopyHHtoPC();
                                    break;
                                }
                                if (this.GetSyncMode() != 3) break;
                                this.CopyPCtoHH();
                                break;
                            }
                            throw genericException;
                        }
                    }
                    case 2: 
                    case 5: {
                        this.CopyHHtoPC();
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 7: {
                        this.CopyPCtoHH();
                        break;
                    }
                    case 6: {
                        break;
                    }
                    default: {
                        throw new GenericException(4370);
                    }
                }
                this.CloseManagers();
                this.closeArchives();
                ++n;
            }
        }
        catch (GenericException genericException) {
            this.UnregisterConduit(true);
            throw genericException;
        }
        this.UnregisterConduit(false);
    }

    protected int getFastHhActions(int n) {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's getFastHhActions", -1, false);
        }
        switch (n) {
            case 65600: {
                return 4;
            }
            case 65568: {
                return 5;
            }
            case 65537: {
                return 5;
            }
            case 65538: {
                return 6;
            }
            case 65540: {
                return 0x1000080;
            }
            case 65542: {
                return 6;
            }
            case 65541: {
                return 5;
            }
            case 65544: {
                return 0x10000000;
            }
            case 327744: {
                return 4;
            }
            case 327712: {
                return 5;
            }
            case 327681: {
                return 5;
            }
            case 327682: {
                return 6;
            }
            case 327684: {
                return 0x1000080;
            }
            case 327686: {
                return 6;
            }
            case 327685: {
                return 5;
            }
            case 327688: {
                return 0x10000000;
            }
            case 131136: {
                return 8;
            }
            case 131104: {
                return 9;
            }
            case 131073: {
                return 9;
            }
            case 131074: {
                return 9;
            }
            case 131076: {
                return 0x1000080;
            }
            case 131078: {
                return 6;
            }
            case 131077: {
                return 9;
            }
            case 131080: {
                return 0x10000000;
            }
            case 393280: {
                return 8;
            }
            case 393248: {
                return 9;
            }
            case 393217: {
                return 9;
            }
            case 393218: {
                return 9;
            }
            case 393220: {
                return 512;
            }
            case 393222: {
                return 2048;
            }
            case 393221: {
                return 9;
            }
            case 393224: {
                return 0x10000000;
            }
            case 262208: {
                return 32;
            }
            case 262176: {
                return 64;
            }
            case 262145: {
                return 0x1000040;
            }
            case 262146: {
                return 0x1000040;
            }
            case 262148: {
                return 256;
            }
            case 262150: {
                return 1024;
            }
            case 262149: {
                return 0x1000040;
            }
            case 262152: {
                return 0x10000000;
            }
            case 0x200040: {
                return 0x10000000;
            }
            case 0x200020: {
                return 0x10000000;
            }
            case 0x200001: {
                return 5;
            }
            case 0x200002: {
                return 6;
            }
            case 0x200004: {
                return 128;
            }
            case 0x200006: {
                return 6;
            }
            case 0x200005: {
                return 5;
            }
            case 0x200008: {
                return 128;
            }
            case 0x400040: {
                return 0x10000000;
            }
            case 0x400020: {
                return 0x10000000;
            }
            case 0x400001: {
                return 1;
            }
            case 0x400002: {
                return 2;
            }
            case 0x400004: {
                return 16;
            }
            case 0x400006: {
                return 2;
            }
            case 0x400005: {
                return 1;
            }
            case 0x400008: {
                return 16;
            }
            case 524352: {
                return 32;
            }
            case 524320: {
                return 64;
            }
            case 524289: {
                return 0x1000040;
            }
            case 524290: {
                return 0x1000040;
            }
            case 524292: {
                return 256;
            }
            case 524294: {
                return 0x1000040;
            }
            case 524293: {
                return 0x1000040;
            }
            case 524296: {
                return 0x10000000;
            }
            case 196672: {
                return 8;
            }
            case 196640: {
                return 9;
            }
            case 196609: {
                return 9;
            }
            case 196610: {
                return 9;
            }
            case 196612: {
                return 512;
            }
            case 196614: {
                return 2048;
            }
            case 196613: {
                return 9;
            }
            case 196616: {
                return 0x10000000;
            }
            case 458816: {
                return 8;
            }
            case 458784: {
                return 9;
            }
            case 458753: {
                return 9;
            }
            case 458754: {
                return 9;
            }
            case 458756: {
                return 512;
            }
            case 458758: {
                return 2048;
            }
            case 458757: {
                return 9;
            }
            case 458760: {
                return 0x10000000;
            }
        }
        return 0;
    }

    protected int getFastPcActions(int n) {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's getFastPcActions, iStatus = " + n, -1, false);
        }
        switch (n) {
            case 64: {
                return 0x10000000;
            }
            case 32: {
                return 0x10000000;
            }
            case 1: 
            case 9: {
                return 65537;
            }
            case 2: 
            case 10: {
                return 65538;
            }
            case 4: {
                return 128;
            }
            case 6: 
            case 14: {
                return 65538;
            }
            case 5: 
            case 13: {
                return 65537;
            }
            case 8: 
            case 12: {
                return 16;
            }
            case 3: {
                return 65538;
            }
            case 7: {
                return 65538;
            }
        }
        return 0;
    }

    protected int getSlowPcActions(int n) {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's getSlowPcActions", -1, false);
        }
        switch (n) {
            case 64: {
                return 0x10000000;
            }
            case 32: {
                return 128;
            }
            case 1: 
            case 9: {
                return 1;
            }
            case 2: 
            case 10: {
                return 2;
            }
            case 4: 
            case 12: {
                return 128;
            }
            case 6: 
            case 14: {
                return 2;
            }
            case 5: 
            case 13: {
                return 1;
            }
            case 8: {
                return 16;
            }
            case 3: {
                return 2;
            }
            case 7: {
                return 2;
            }
        }
        return 0;
    }

    protected int getSlowHhActions(int n) {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's getSlowHhActions for " + n, -1, false);
        }
        switch (n) {
            case 65600: {
                return 4;
            }
            case 65568: {
                return 5;
            }
            case 65537: {
                return 5;
            }
            case 65538: {
                return 6;
            }
            case 65540: {
                return 0x1000080;
            }
            case 65542: {
                return 6;
            }
            case 65541: {
                return 5;
            }
            case 65544: {
                return 0x10000000;
            }
            case 327744: {
                return 4;
            }
            case 327712: {
                return 5;
            }
            case 327681: {
                return 5;
            }
            case 327682: {
                return 6;
            }
            case 327684: {
                return 0x1000080;
            }
            case 327686: {
                return 6;
            }
            case 327685: {
                return 5;
            }
            case 327688: {
                return 0x10000000;
            }
            case 131136: {
                return 8;
            }
            case 0x20020020: {
                return 9;
            }
            case 0x20020001: {
                return 9;
            }
            case 0x20020002: {
                return 9;
            }
            case 0x20020004: {
                return 9;
            }
            case 0x20020006: {
                return 9;
            }
            case 0x20020005: {
                return 9;
            }
            case 0x20020008: {
                return 0x10000000;
            }
            case 393280: {
                return 8;
            }
            case 0x20060020: {
                return 9;
            }
            case 537264129: {
                return 9;
            }
            case 0x20060002: {
                return 9;
            }
            case 537264132: {
                return 9;
            }
            case 0x20060006: {
                return 9;
            }
            case 537264133: {
                return 9;
            }
            case 537264136: {
                return 0x10000000;
            }
            case 262208: {
                return 32;
            }
            case 0x20040020: {
                return 0;
            }
            case 537133057: {
                return 5;
            }
            case 0x20040002: {
                return 6;
            }
            case 0x20040004: {
                return 0;
            }
            case 537133062: {
                return 6;
            }
            case 537133061: {
                return 5;
            }
            case 537133064: {
                return 0x10000000;
            }
            case 0x200040: {
                return 32;
            }
            case 0x20200020: {
                return 0;
            }
            case 0x20200001: {
                return 5;
            }
            case 0x20200002: {
                return 6;
            }
            case 0x20200004: {
                return 0;
            }
            case 0x20200006: {
                return 6;
            }
            case 0x20200005: {
                return 5;
            }
            case 0x20200008: {
                return 0;
            }
            case 0x400040: {
                return 0x10000000;
            }
            case 0x400020: {
                return 16;
            }
            case 0x400001: {
                return 1;
            }
            case 0x400002: {
                return 2;
            }
            case 0x400004: {
                return 16;
            }
            case 0x400006: {
                return 2;
            }
            case 0x400005: {
                return 1;
            }
            case 0x400008: {
                return 16;
            }
            case 524352: {
                return 32;
            }
            case 0x20080020: {
                return 0x10000000;
            }
            case 537395201: {
                return 0x10000000;
            }
            case 0x20080002: {
                return 0x10000000;
            }
            case 537395204: {
                return 0x10000000;
            }
            case 537395206: {
                return 0x10000000;
            }
            case 537395205: {
                return 0x10000000;
            }
            case 0x20080008: {
                return 0x10000000;
            }
            case 0x10020020: {
                return 9;
            }
            case 0x10020001: {
                return 9;
            }
            case 0x10020002: {
                return 10;
            }
            case 268566532: {
                return 128;
            }
            case 268566534: {
                return 10;
            }
            case 268566533: {
                return 9;
            }
            case 268566536: {
                return 0x10000000;
            }
            case 268828704: {
                return 9;
            }
            case 0x10060001: {
                return 9;
            }
            case 268828674: {
                return 10;
            }
            case 268828676: {
                return 0x1002000;
            }
            case 0x10060006: {
                return 10;
            }
            case 268828677: {
                return 9;
            }
            case 268828680: {
                return 0x10000000;
            }
            case 268697632: {
                return 64;
            }
            case 0x10040001: {
                return 64;
            }
            case 268697602: {
                return 0x1000040;
            }
            case 0x10040004: {
                return 8192;
            }
            case 268697606: {
                return 8192;
            }
            case 268697605: {
                return 64;
            }
            case 268697608: {
                return 0x10000000;
            }
            case 0x10200020: {
                return 8192;
            }
            case 0x10200001: {
                return 5;
            }
            case 0x10200002: {
                return 6;
            }
            case 270532612: {
                return 128;
            }
            case 270532614: {
                return 6;
            }
            case 270532613: {
                return 5;
            }
            case 270532616: {
                return 8192;
            }
            case 268959776: {
                return 0x10000000;
            }
            case 0x10080001: {
                return 0x10000000;
            }
            case 268959746: {
                return 0x10000000;
            }
            case 268959748: {
                return 0x10000000;
            }
            case 268959750: {
                return 0x10000000;
            }
            case 268959749: {
                return 0x10000000;
            }
            case 0x10080008: {
                return 0x10000000;
            }
            case 196672: {
                return 8;
            }
            case 0x20030020: {
                return 9;
            }
            case 537067521: {
                return 9;
            }
            case 0x20030002: {
                return 9;
            }
            case 537067524: {
                return 9;
            }
            case 537067526: {
                return 9;
            }
            case 537067525: {
                return 9;
            }
            case 537067528: {
                return 0x10000000;
            }
            case 458816: {
                return 8;
            }
            case 0x20070020: {
                return 9;
            }
            case 537329665: {
                return 9;
            }
            case 0x20070002: {
                return 9;
            }
            case 537329668: {
                return 9;
            }
            case 537329670: {
                return 9;
            }
            case 537329669: {
                return 9;
            }
            case 537329672: {
                return 0x10000000;
            }
            case 268632096: {
                return 9;
            }
            case 0x10030001: {
                return 9;
            }
            case 268632066: {
                return 10;
            }
            case 268632068: {
                return 128;
            }
            case 268632070: {
                return 10;
            }
            case 268632069: {
                return 9;
            }
            case 268632072: {
                return 0x10000000;
            }
            case 268894240: {
                return 9;
            }
            case 0x10070001: {
                return 9;
            }
            case 268894210: {
                return 10;
            }
            case 268894212: {
                return 0x1002000;
            }
            case 268894214: {
                return 10;
            }
            case 268894213: {
                return 9;
            }
            case 268894216: {
                return 0x10000000;
            }
        }
        return 0;
    }

    private void PerformActions(int n, PalmRecord palmRecord, PalmRecord palmRecord2) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's PerformAction " + n, -1, false);
        }
        int n2 = 1;
        int n3 = 0;
        while (n3 < 32) {
            if ((n & n2) == n2) {
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        try {
                            this.archiveRecord(palmRecord2);
                        }
                        catch (GenericException genericException) {
                            break;
                        }
                    }
                    case 1: {
                        this.m_pcMgr.DeleteRec(palmRecord2);
                        break;
                    }
                    case 8: {
                        try {
                            this.archiveRecord(palmRecord);
                        }
                        catch (GenericException genericException) {
                            break;
                        }
                    }
                    case 4: {
                        if (palmRecord.isArchived() || palmRecord.isDeleted()) break;
                        this.m_hhMgr.DeleteRec(palmRecord);
                        break;
                    }
                    case 65536: {
                        try {
                            this.m_hhMgr.DeleteRec(palmRecord2);
                        }
                        catch (GenericException genericException) {}
                        break;
                    }
                    case 16: {
                        int n4 = palmRecord2.getId();
                        int n5 = palmRecord2.getIndex();
                        try {
                            this.m_hhMgr.addNewRecord(palmRecord2);
                            if (n4 == palmRecord2.getId()) break;
                            this.m_pcMgr.ModifyRecByIndex(n5, palmRecord2);
                        }
                        catch (GenericException genericException) {
                            Log.err("Unable to add HH record to PC DB");
                        }
                        break;
                    }
                    case 32: {
                        try {
                            this.m_pcMgr.addNewRecord(palmRecord);
                        }
                        catch (GenericException genericException) {
                            Log.err("Unable to add PC record to HH DB");
                        }
                        break;
                    }
                    case 64: {
                        this.m_pcMgr.ModifyRecByIndex(palmRecord2.getIndex(), palmRecord);
                        break;
                    }
                    case 128: {
                        this.m_hhMgr.ModifyRecByIndex(palmRecord.getIndex(), palmRecord2);
                        break;
                    }
                    case 1024: {
                        this.doFastPCArchiveDoubleModified(palmRecord, palmRecord2);
                        break;
                    }
                    case 512: {
                        this.doFastHHArchiveDoubleModified(palmRecord, palmRecord2);
                        break;
                    }
                    case 2048: {
                        this.doFastDoubleArchiveDoubleModified(palmRecord, palmRecord2);
                        break;
                    }
                    case 256: {
                        this.doFastDoubleModified(palmRecord, palmRecord2);
                        break;
                    }
                    case 8192: {
                        this.doSlowDoubleModified(palmRecord, palmRecord2);
                        break;
                    }
                    case 0x1000000: {
                        Log.out("A record for deletion was not deleted due to modifications");
                        break;
                    }
                    case 0x10000000: {
                        break;
                    }
                }
            }
            n2 *= 2;
            ++n3;
        }
    }

    private void doFastDoubleArchiveDoubleModified(PalmRecord palmRecord, PalmRecord palmRecord2) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's doFastDoubleArchiveDoubleModified", -1, false);
        }
        if (this.recordsAreEqual(palmRecord, palmRecord2)) {
            this.archiveRecord(palmRecord2);
            this.m_pcMgr.DeleteRec(palmRecord2);
        } else {
            this.archiveRecord(palmRecord2);
            this.archiveRecord(palmRecord);
            this.m_pcMgr.DeleteRec(palmRecord2);
        }
    }

    private void doFastPCArchiveDoubleModified(PalmRecord palmRecord, PalmRecord palmRecord2) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's doFastPCArchiveDoubleModified", -1, false);
        }
        if (this.recordsAreEqual(palmRecord, palmRecord2)) {
            this.archiveRecord(palmRecord2);
            this.m_pcMgr.DeleteRec(palmRecord2);
        } else {
            int n = palmRecord2.getIndex();
            palmRecord.setIndex(n);
            palmRecord.resetAttribs();
            this.m_pcMgr.ModifyRecByIndex(n, palmRecord);
            palmRecord2.setId(0);
            try {
                this.m_hhMgr.addNewRecord(palmRecord2);
            }
            catch (GenericException genericException) {
                Log.err("Unable to add PC record to HH database");
                throw new GenericException(genericException.lastError);
            }
            try {
                this.m_pcMgr.addNewRecord(palmRecord2);
            }
            catch (GenericException genericException) {
                Log.err("Unable to add HH record to PC database");
                throw new GenericException(genericException.lastError);
            }
            Log.out("Double modify");
        }
    }

    private void doFastHHArchiveDoubleModified(PalmRecord palmRecord, PalmRecord palmRecord2) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's doFastHHArchiveDoubleModified", -1, false);
        }
        if (this.recordsAreEqual(palmRecord, palmRecord2)) {
            this.archiveRecord(palmRecord2);
            this.m_pcMgr.DeleteRec(palmRecord2);
        } else {
            int n = palmRecord.getIndex();
            palmRecord.resetAttribs();
            this.m_hhMgr.ModifyRecByIndex(n, palmRecord);
            n = palmRecord2.getIndex();
            palmRecord.setIndex(n);
            palmRecord.resetAttribs();
            this.m_pcMgr.ModifyRecByIndex(n, palmRecord);
            palmRecord2.setId(0);
            try {
                this.m_hhMgr.addNewRecord(palmRecord2);
            }
            catch (GenericException genericException) {
                Log.err("Unable to add PC record to HH database");
                throw new GenericException(genericException.lastError);
            }
            try {
                this.m_pcMgr.addNewRecord(palmRecord2);
            }
            catch (GenericException genericException) {
                Log.err("Unable to add HH record to PC database");
                throw new GenericException(genericException.lastError);
            }
            Log.out("Double modify");
        }
    }

    private void doSlowDoubleModified(PalmRecord palmRecord, PalmRecord palmRecord2) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's doSlowDoubleModified", -1, false);
        }
        int n = palmRecord2.getIndex();
        palmRecord.setIndex(n);
        palmRecord.resetAttribs();
        this.m_pcMgr.ModifyRecByIndex(n, palmRecord);
        palmRecord2.setId(0);
        try {
            this.m_hhMgr.addNewRecord(palmRecord2);
        }
        catch (GenericException genericException) {
            Log.out("Unable to add PC record to HH database");
            throw new GenericException(genericException.lastError);
        }
        try {
            this.m_pcMgr.addNewRecord(palmRecord2);
        }
        catch (GenericException genericException) {
            Log.out("Unable to add HH record to PC database");
            throw new GenericException(genericException.lastError);
        }
        Log.out("Double modify");
    }

    private void doFastDoubleModified(PalmRecord palmRecord, PalmRecord palmRecord2) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's doFastDoubleModified", -1, false);
        }
        if (!this.recordsAreEqual(palmRecord, palmRecord2)) {
            this.doSlowDoubleModified(palmRecord, palmRecord2);
        }
    }

    private void archiveRecord(PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's archiveRecord", -1, false);
        }
        PalmBaseManager palmBaseManager = this.OpenArchive(palmRecord.getCategoryIndex());
        int n = palmRecord.getAttribs();
        palmBaseManager.addNewRecord(palmRecord);
        palmRecord.setAttribs(n);
    }

    private boolean isCommsError(int n) {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's isCommsError", -1, false);
        }
        boolean bl = false;
        if (n != -1 && (n & 0x2000) == 8192) {
            bl = true;
        }
        return bl;
    }

    private void CopyHHtoPC() throws GenericException {
        PalmRecord palmRecord = null;
        PalmRecord palmRecord2 = null;
        int n = 0;
        int n2 = 0;
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's CopyHHtoPC", -1, false);
        }
        this.CreateDbManagers();
        this.m_hhMgr.PreSync();
        this.m_pcMgr.PreSync();
        this.CopyAppInfoHHtoPC();
        try {
            palmRecord = this.m_hhMgr.findFirstRecByIndex();
            while (true) {
                n = 65536 * palmRecord.getStatus();
                n2 = this.findHhToPcActions(n);
                this.PerformActions(n2, palmRecord, palmRecord2);
                palmRecord = this.m_hhMgr.findNext();
            }
        }
        catch (GenericException genericException) {
            if (m_bDebug) {
                Log.AddEntry("     Saving databases", -1, false);
            }
            this.m_hhMgr.PostSync();
            this.m_pcMgr.PostSync();
            this.m_backupMgr.PostSync();
            return;
        }
    }

    private void CopyPCtoHH() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's CopyPCtoHH", -1, false);
        }
        PalmRecord palmRecord = null;
        PalmRecord palmRecord2 = null;
        int n = 0;
        int n2 = 0;
        this.CreateDbManagers();
        this.m_hhMgr.PreSync();
        this.m_pcMgr.PreSync();
        this.CopyAppInfoPCtoHH();
        try {
            palmRecord = this.m_pcMgr.findFirstRecByIndex();
            while (true) {
                n = 1 * palmRecord.getStatus();
                n2 = this.findPcToHhActions(n);
                this.PerformActions(n2, palmRecord2, palmRecord);
                palmRecord = this.m_pcMgr.findNext();
            }
        }
        catch (GenericException genericException) {
            this.m_hhMgr.PostSync();
            this.m_pcMgr.PostSync();
            this.m_backupMgr.PostSync();
            return;
        }
    }

    private void PerformSlowSync() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's PerformSlowSync", -1, false);
        }
        PalmRecord palmRecord = null;
        this.CreateDbManagers();
        this.SynchronizeAppInfo();
        this.m_hhMgr.PreSync();
        this.m_pcMgr.PreSync();
        try {
            palmRecord = this.m_hhMgr.findFirstRecByIndex();
            while (true) {
                this.SynchronizeRemoteRecord(palmRecord);
                palmRecord = this.m_hhMgr.findNext();
            }
        }
        catch (GenericException genericException) {
            try {
                palmRecord = this.m_pcMgr.findFirstPendingRec();
                while (true) {
                    this.SynchronizeLocalRecord(palmRecord);
                    palmRecord = this.m_pcMgr.findNext();
                }
            }
            catch (GenericException genericException2) {
                this.ConfirmSynchronization();
                this.m_hhMgr.PostSync();
                this.m_pcMgr.PostSync();
                this.m_backupMgr.PostSync();
                return;
            }
        }
    }

    private void PerformFastSync() throws GenericException {
        PalmRecord palmRecord = null;
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's PerformFastSync", -1, false);
        }
        this.CreateDbManagers();
        this.SynchronizeAppInfo();
        this.m_hhMgr.PreSync();
        this.m_pcMgr.PreSync();
        try {
            palmRecord = this.m_hhMgr.findFirstModifiedRec();
            while (true) {
                this.SynchronizeRemoteRecord(palmRecord);
                palmRecord = this.m_hhMgr.findNext();
            }
        }
        catch (GenericException genericException) {
            try {
                palmRecord = this.m_pcMgr.findFirstModifiedRec();
                while (true) {
                    this.SynchronizeLocalRecord(palmRecord);
                    palmRecord = this.m_pcMgr.findNext();
                }
            }
            catch (GenericException genericException2) {
                this.ConfirmSynchronization();
                this.m_hhMgr.PostSync();
                this.m_pcMgr.PostSync();
                this.m_backupMgr.PostSync();
                return;
            }
        }
    }

    private void SynchronizeRemoteRecord(PalmRecord palmRecord) throws GenericException {
        int n;
        int n2;
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's SynchronizeRemoteRecord", -1, false);
        }
        PalmRecord palmRecord2 = null;
        int n3 = 0;
        try {
            palmRecord2 = this.m_pcMgr.findRecById(palmRecord.getId(), false);
            n2 = 1 * palmRecord2.getStatus();
        }
        catch (GenericException genericException) {
            n2 = 64;
        }
        int n4 = 65536 * palmRecord.getStatus();
        if (this.m_rSyncProperties.syncType == 1) {
            if (!palmRecord.isDeleted() && n2 != 64) {
                n3 = !this.recordsAreEqual(palmRecord, palmRecord2) ? (n3 |= 0x10000000) : (n3 |= 0x20000000);
                if (!palmRecord.isModified()) {
                    try {
                        PalmRecord palmRecord3 = this.m_backupMgr.findRecById(palmRecord.getId(), false);
                        if (!this.recordsAreEqual(palmRecord, palmRecord3)) {
                            palmRecord.setIsModified(true);
                            n4 = 65536 * palmRecord.getStatus();
                        }
                    }
                    catch (GenericException genericException) {
                        palmRecord.setIsModified(true);
                        n4 = 65536 * palmRecord.getStatus();
                    }
                }
            }
            n = this.getSlowHhActions(n4 | n2 | n3);
        } else {
            n = this.getFastHhActions(n4 | n2);
        }
        this.PerformActions(n, palmRecord, palmRecord2);
    }

    private void SynchronizeLocalRecord(PalmRecord palmRecord) throws GenericException {
        PalmRecord palmRecord2;
        block3: {
            if (m_bDebug) {
                Log.AddEntry("* GenericSynchronizer's SynchronizeLocalRecord", -1, false);
            }
            palmRecord2 = null;
            try {
                palmRecord2 = this.m_hhMgr.findRecById(palmRecord.getId(), false);
            }
            catch (GenericException genericException) {
                palmRecord.setIsNew(true);
                if (genericException.lastError == 4374) break block3;
                throw new GenericException(genericException.lastError);
            }
        }
        int n = 1 * palmRecord.getStatus();
        int n2 = this.GetSyncMode() == 1 ? this.getSlowPcActions(n) : this.getFastPcActions(n);
        this.PerformActions(n2, palmRecord2, palmRecord);
    }

    protected void CreateDbManagers() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's CreateDbManagers", -1, false);
        }
        try {
            this.CreateHHManager();
        }
        catch (GenericException genericException) {
            if (genericException.lastError == 4388 && (this.getSyncMode() == 0 || this.getSyncMode() == 1)) {
                this.setSyncMode(3);
                if (m_bDebug) {
                    Log.AddEntry("     Changing sync mode to PC_TO_HH", -1, false);
                }
                throw new GenericException(4389);
            }
            throw new GenericException(genericException.lastError);
        }
        try {
            this.CreatePcManager();
        }
        catch (GenericException genericException) {
            if (m_bDebug) {
                Log.AddEntry(genericException.getMessage(), -1, false);
            }
            if (genericException.lastError == 4387 && (this.getSyncMode() == 0 || this.getSyncMode() == 1)) {
                this.setSyncMode(2);
                if (m_bDebug) {
                    Log.AddEntry("     Changing sync mode to HH_TO_PC", -1, false);
                }
                throw new GenericException(4389);
            }
            throw new GenericException(genericException.lastError);
        }
        this.CreateBackupManager();
    }

    public void setSyncMode(int n) {
        this.m_rSyncProperties.syncType = n;
        this.LogSyncMode();
    }

    void LogSyncMode() {
        if (m_bDebug) {
            switch (this.m_rSyncProperties.syncType) {
                case 1: {
                    Log.AddEntry("    * Sync Mode: Slow", -1, false);
                    break;
                }
                case 0: {
                    Log.AddEntry("    * Sync Mode: fast", -1, false);
                    break;
                }
                case 4: {
                    Log.AddEntry("    * Sync Mode: install", -1, false);
                    break;
                }
                case 7: {
                    Log.AddEntry("    * Sync Mode: profile install", -1, false);
                    break;
                }
                case 6: {
                    Log.AddEntry("    * Sync Mode: do nothing", -1, false);
                    break;
                }
                case 3: {
                    Log.AddEntry("    * Sync Mode: Pc to HH", -1, false);
                    break;
                }
                case 2: {
                    Log.AddEntry("    * Sync Mode: HH to PC", -1, false);
                    break;
                }
                case 5: {
                    Log.AddEntry("    * Sync Mode: backup", -1, false);
                    break;
                }
                default: {
                    Log.AddEntry("    * Sync Mode: unknown", -1, false);
                }
            }
        }
    }

    public int getSyncMode() {
        return this.m_rSyncProperties.syncType;
    }

    protected void CreateHHManager() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's CreateHHManager", -1, false);
        }
        if (this.m_hhMgr != null) {
            try {
                this.m_hhMgr.Close(true);
            }
            catch (GenericException genericException) {
                // empty catch block
            }
        }
        try {
            this.m_hhMgr = new HHMgr(this.m_rSyncProperties, this.m_remoteDB, this.m_lDatabaseFlags);
        }
        catch (IOException iOException) {
            throw new GenericException(4354);
        }
        this.m_hhMgr.Open();
    }

    protected void CreatePcManager() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's CreatePcManager", -1, false);
        }
        try {
            this.m_pcMgr = new PcManager(this.m_rSyncProperties, this.m_remoteDB, this.m_lDatabaseFlags);
        }
        catch (IOException iOException) {
            throw new GenericException(4354);
        }
        this.m_pcMgr.Open();
    }

    protected void CreateBackupManager() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's CreateBackupManager", -1, false);
        }
        try {
            this.m_backupMgr = new BackupManager(this.m_rSyncProperties, this.m_remoteDB, this.m_lDatabaseFlags);
        }
        catch (IOException iOException) {
            throw new GenericException(4354);
        }
        this.m_backupMgr.Open();
    }

    protected PalmBaseManager CreateArchiveManager(String string) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's CreateArchiveManager", -1, false);
        }
        try {
            GenArchive genArchive = new GenArchive(this.m_rSyncProperties, this.m_remoteDB, this.m_lDatabaseFlags);
            ((PalmBaseManager)genArchive).setLocalFileName(string);
            return genArchive;
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    void RegisterConduit() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's Register Conduit", -1, false);
        }
        Log.startSync();
    }

    void UnregisterConduit(boolean bl) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's Unregister Conduit", -1, false);
        }
        if (bl) {
            Log.abortSync();
        } else {
            Log.endSync();
        }
    }

    void GetRemoteDBInfo(int n) throws GenericException {
        this.m_remoteDB = this.m_rSyncProperties.remoteNames[n];
    }

    int GetSyncMode() throws GenericException {
        return this.m_rSyncProperties.syncType;
    }

    protected void SynchronizeAppInfo() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's SynchronizeAppInfo", -1, false);
        }
        if (!this.m_hhMgr.isAppInfoSupported() || !this.m_pcMgr.isAppInfoSupported()) {
            return;
        }
        try {
            this.m_hhMgr.PreAppInfoSync();
        }
        catch (GenericException genericException) {
            if (genericException.lastError == 4368) {
                return;
            }
            throw new GenericException(genericException.lastError);
        }
        try {
            this.m_pcMgr.PreAppInfoSync();
        }
        catch (GenericException genericException) {
            if (genericException.lastError == 4368) {
                return;
            }
            throw new GenericException(genericException.lastError);
        }
        if (this.m_hhMgr.areCategoriesSupported() && this.m_pcMgr.areCategoriesSupported()) {
            this.SynchronizeCategories();
        }
        if (this.m_hhMgr.isExtraAppInfo()) {
            if (this.m_pcMgr.isExtraAppInfo()) {
                int n;
                int n2 = this.m_pcMgr.GetExtraAppInfoSize();
                if (n2 != (n = this.m_hhMgr.GetExtraAppInfoSize())) {
                    this.m_pcMgr.SetExtraAppInfo(this.m_hhMgr.GetExtraAppInfo());
                } else {
                    byte[] byArray;
                    byte[] byArray2 = this.m_hhMgr.GetExtraAppInfo();
                    if (!PalmData.isEqual(byArray2, byArray = this.m_pcMgr.GetExtraAppInfo())) {
                        this.m_pcMgr.SetExtraAppInfo(byArray2);
                    }
                }
            } else {
                this.m_pcMgr.SetExtraAppInfo(this.m_hhMgr.GetExtraAppInfo());
            }
        } else if (this.m_pcMgr.isExtraAppInfo()) {
            this.m_hhMgr.SetExtraAppInfo(this.m_pcMgr.GetExtraAppInfo());
        }
        this.m_hhMgr.PostAppInfoSync();
        this.m_pcMgr.PostAppInfoSync();
    }

    protected void SynchronizeCategories() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's SynchronizeCategories", -1, false);
        }
        if ((this.m_lDatabaseFlags & 1L) != 1L) {
            return;
        }
        GenCategoryManager genCategoryManager = this.m_hhMgr.m_catMgr;
        if (genCategoryManager == null) {
            throw new GenericException(4399);
        }
        GenCategoryManager genCategoryManager2 = this.m_pcMgr.m_catMgr;
        if (genCategoryManager2 == null) {
            throw new GenericException(4400);
        }
        if (genCategoryManager2.equals(genCategoryManager)) {
            return;
        }
        this.SetupCategorySyncCases();
        this.RemoveDeletedCategories(genCategoryManager2, genCategoryManager, false);
        this.RemoveDeletedCategories(genCategoryManager, genCategoryManager2, true);
        this.SynchronizeHhCategories();
        this.SynchronizePcCategories();
        if (this.m_bPcMoveList) {
            this.m_pcMgr.MoveRecordCategories(this.m_pcMoveList);
        }
        GenericCategory genericCategory = null;
        try {
            genericCategory = genCategoryManager.findFirst();
            while (true) {
                genCategoryManager2.add(genericCategory);
                genericCategory = genCategoryManager.findNext();
            }
        }
        catch (GenericException genericException) {
            return;
        }
    }

    protected void SetupCategorySyncCases() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's SetupCategorySyncCases", -1, false);
        }
        if (this.m_rSyncProperties.firstDevice == 1) {
            this.m_hhMgr.m_catMgr.setAllModified();
        } else if (this.m_rSyncProperties.firstDevice == 2 && this.m_rSyncProperties.syncType == 1) {
            this.m_pcMgr.m_catMgr.setAllModified();
            this.m_hhMgr.m_catMgr.setAllModified();
        } else if (this.m_rSyncProperties.firstDevice == 2) {
            this.m_pcMgr.m_catMgr.setAllModified();
        } else if (this.m_rSyncProperties.syncType == 1) {
            this.m_hhMgr.m_catMgr.setAllModified();
        }
    }

    protected void RemoveDeletedCategories(GenCategoryManager genCategoryManager, GenCategoryManager genCategoryManager2, boolean bl) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's RemoveDeletedCategories", -1, false);
        }
        GenericCategory genericCategory = null;
        GenericCategory genericCategory2 = null;
        if (this.m_rSyncProperties.firstDevice == 2) {
            return;
        }
        try {
            genericCategory = genCategoryManager.findFirst();
            while (true) {
                if (!genericCategory.isModified()) {
                    try {
                        genericCategory2 = genCategoryManager2.findName(genericCategory.getName());
                    }
                    catch (GenericException genericException) {
                        try {
                            genericCategory2 = genCategoryManager2.findId(genericCategory.getId());
                        }
                        catch (GenericException genericException2) {
                            if (bl) {
                                this.m_hhMgr.changeCategory(genericCategory.getIndex(), 0);
                            } else {
                                this.m_pcMgr.changeCategory(genericCategory.getIndex(), 0);
                            }
                            int n = genericCategory.getIndex();
                            if (bl) {
                                Log.AddEntry("Handheld Category deleted", -1, false);
                            }
                            genCategoryManager.deleteByIndex(n);
                        }
                    }
                }
                genericCategory = genCategoryManager.findNext();
            }
        }
        catch (GenericException genericException) {
            if (genericException.isSyncError()) {
                throw new GenericException(genericException.lastError);
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void SynchronizeHhCategories() throws GenericException {
        if (GenericSynchronizer.m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's SynchronizeHhCategories", -1, false);
        }
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var4_4 = this.m_hhMgr.m_catMgr;
        var5_5 = this.m_pcMgr.m_catMgr;
        try {
            var1_1 = var4_4.findFirst();
            while (true) {
                block25: {
                    try {
                        var2_2 = var5_5.findName(var1_1.getName());
                        if (var2_2.getIndex() == var1_1.getIndex()) {
                            if (var2_2.getId() == var1_1.getId()) {
                                var5_5.deleteByIndex(var2_2.getIndex());
                                break block25;
                            }
                            try {
                                var3_3 = var5_5.findId(var1_1.getId());
                                this.m_pcMgr.changeCategory(var3_3.getIndex(), var1_1.getIndex());
                                var5_5.deleteByIndex(var3_3.getIndex());
                                var5_5.deleteByIndex(var2_2.getIndex());
                                break block25;
                            }
                            catch (GenericException var6_7) {
                                if (var6_7.lastError == 4403) {
                                    var5_5.deleteByIndex(var2_2.getIndex());
                                    break block25;
                                }
                                throw new GenericException(var6_7.lastError);
                            }
                        }
                        try {
                            var3_3 = var5_5.findId(var1_1.getId());
                            this.MoveLocalCat(var2_2, var1_1);
                            this.MoveLocalCat(var3_3, var1_1);
                            var5_5.deleteByIndex(var3_3.getIndex());
                            var5_5.deleteByIndex(var2_2.getIndex());
                        }
                        catch (GenericException var6_8) {
                            if (var6_8.lastError != 4403) {
                                throw new GenericException(var6_8.lastError);
                            }
                            this.MoveLocalCat(var2_2, var1_1);
                            var5_5.deleteByIndex(var2_2.getIndex());
                        }
                        break block25;
                    }
                    catch (GenericException var6_9) {
                        try {
                            var2_2 = var5_5.findId(var1_1.getId());
                            if (!var1_1.isModified() && var2_2.isModified()) {
                                var1_1.setName(var2_2.getName());
                            }
                            if (var2_2.getIndex() != var1_1.getIndex()) {
                                this.MoveLocalCat(var2_2, var1_1);
                            }
                            var5_5.deleteByIndex(var2_2.getIndex());
                            break block25;
                        }
                        catch (GenericException var7_11) {
                            if (var7_11.lastError != 4403) {
                                throw new GenericException(var7_11.lastError);
                            }
                            var8_12 = var1_1.getIndex();
                            var10_14 = var1_1.getName();
                            var11_15 = false;
                            var12_16 = 0;
                            ** while (var12_16 < var8_12 && !var11_15)
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        block26: {
                            try {
                                var9_13 = var4_4.getByIndex(var12_16);
                            }
                            catch (GenericException var13_17) {
                                if (var13_17.lastError != 4357) {
                                    throw new GenericException(var13_17.lastError);
                                }
                                break block26;
                            }
                            if (var9_13 != null && var10_14.equals(var9_13.getName())) {
                                this.m_hhMgr.changeCategory(var1_1.getIndex(), var9_13.getIndex());
                                var4_4.deleteByIndex(var1_1.getIndex());
                                var11_15 = true;
                            }
                        }
                        ++var12_16;
                        continue;
                    }
                }
                var1_1 = var4_4.findNext();
            }
        }
        catch (GenericException var6_10) {
            if (var6_10.lastError != 4403) {
                throw new GenericException(var6_10.lastError);
            }
            return;
        }
    }

    protected void SynchronizePcCategories() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's SynchronizePcCategories", -1, false);
        }
        GenericCategory genericCategory = null;
        GenCategoryManager genCategoryManager = this.m_hhMgr.m_catMgr;
        GenCategoryManager genCategoryManager2 = this.m_pcMgr.m_catMgr;
        try {
            genericCategory = genCategoryManager2.findFirst();
            boolean bl = false;
            while (genericCategory != null) {
                int n;
                if (m_bDebug) {
                    Log.AddEntry("      adding PC category : " + genericCategory.getName() + " to hh", -1, false);
                }
                if ((n = genCategoryManager.findFirstEmpty()) == -1) {
                    Log.AddEntry("Too many categories", 3, false);
                    this.m_pcMgr.changeCategory(genericCategory.getIndex(), 0);
                    genCategoryManager2.deleteByIndex(genericCategory.getIndex());
                    Log.AddEntry("Pc Category deleted", 4, false);
                } else {
                    int n2 = genericCategory.getIndex();
                    genericCategory.setIndex(n);
                    try {
                        genCategoryManager.add(genericCategory);
                        this.MoveLocalCat(n2, genericCategory);
                    }
                    catch (GenericException genericException) {
                        // empty catch block
                    }
                    try {
                        genCategoryManager2.deleteByIndex(n2);
                    }
                    catch (GenericException genericException) {
                        bl = true;
                    }
                }
                genericCategory = bl ? null : genCategoryManager2.findNext();
            }
        }
        catch (GenericException genericException) {
            // empty catch block
        }
    }

    protected void MoveLocalCat(GenericCategory genericCategory, GenericCategory genericCategory2) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's MoveLocalCat", -1, false);
        }
        if (this.m_pcMoveList == null) {
            this.m_pcMoveList = new GenericCategory[16];
        }
        if (genericCategory.getIndex() >= 16) {
            throw new GenericException(4357);
        }
        this.m_pcMoveList[genericCategory.getIndex()] = genericCategory2;
        this.m_bPcMoveList = true;
    }

    protected void MoveLocalCat(int n, GenericCategory genericCategory) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's MoveLocalCat by index", -1, false);
        }
        if (this.m_pcMoveList == null) {
            this.m_pcMoveList = new GenericCategory[16];
        }
        if (n >= 16) {
            throw new GenericException(4357);
        }
        this.m_pcMoveList[n] = genericCategory;
        this.m_bPcMoveList = true;
    }

    protected void CopyAppInfoHHtoPC() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's CopyAppInfoHHtoPC", -1, false);
        }
        if (!this.m_hhMgr.isAppInfoSupported()) {
            if (this.m_hhMgr.discoverIsAppInfoSupported()) {
                try {
                    byte[] byArray = null;
                    byArray = this.m_hhMgr.getAppInfo();
                    this.m_pcMgr.setAppInfo(this.m_hhMgr.getAppInfo());
                }
                catch (GenericException genericException) {
                    // empty catch block
                }
            }
            return;
        }
        this.m_pcMgr.setAppInfo(this.m_hhMgr.getAppInfo());
    }

    protected void CopyAppInfoPCtoHH() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's CopyAppInfoPCtoHH", -1, false);
        }
        if (!this.m_hhMgr.isAppInfoSupported() || !this.m_pcMgr.isAppInfoSupported()) {
            return;
        }
        this.m_hhMgr.setAppInfo(this.m_pcMgr.getAppInfo());
    }

    void ConfirmSynchronization() throws GenericException {
        PalmRecord palmRecord;
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's ConfirmSynchronization", -1, false);
        }
        try {
            this.m_hhMgr.PurgeDeletedRecs();
        }
        catch (GenericException genericException) {
            Log.err("Unable to purge HH database");
            throw new GenericException(genericException.lastError);
        }
        try {
            this.m_pcMgr.PurgeDeletedRecs();
        }
        catch (GenericException genericException) {
            Log.err("Unable to purge local database");
            throw new GenericException(genericException.lastError);
        }
        int n = this.m_hhMgr.getRecordCount();
        int n2 = this.m_pcMgr.getRecordCount();
        if (n2 == n && this.m_sCheckLevel == 0) {
            return;
        }
        Log.out("      Record count mismatch.");
        Log.out("      " + n + " HH records.");
        Log.out("      " + n2 + " Pc record.");
        int[] nArray = null;
        int[] nArray2 = null;
        nArray = this.m_hhMgr.getRecIdMap();
        nArray2 = this.m_pcMgr.getRecIdMap();
        int n3 = 0;
        while (n3 < n) {
            if (nArray[n3] != -1 && !this.isInDb(nArray2, nArray[n3])) {
                try {
                    palmRecord = this.m_hhMgr.findRecById(nArray[n3], false);
                    this.m_pcMgr.addNewRecord(palmRecord);
                }
                catch (GenericException genericException) {
                    // empty catch block
                }
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (nArray2[n4] != -1) {
                try {
                    palmRecord = this.m_pcMgr.findRecById(nArray2[n4], false);
                    int n5 = palmRecord.getId();
                    int n6 = palmRecord.getIndex();
                    this.m_hhMgr.addNewRecord(palmRecord);
                    if (n5 != palmRecord.getId()) {
                        this.m_pcMgr.ModifyRecByIndex(n6, palmRecord);
                    }
                }
                catch (GenericException genericException) {
                    // empty catch block
                }
            }
            ++n4;
        }
    }

    boolean isInDb(int[] nArray, int n) {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's isInDb(rec id = " + n, -1, false);
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                if (m_bDebug) {
                    Log.AddEntry(nArray[n2] + "      found and removed", -1, false);
                }
                nArray[n2] = -1;
                return true;
            }
            ++n2;
        }
        if (m_bDebug) {
            Log.AddEntry("      not found", -1, false);
        }
        return false;
    }

    void CloseManagers() {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's CloseManagers", -1, false);
        }
        if (this.m_hhMgr != null) {
            try {
                this.m_hhMgr.Close(true);
                this.m_hhMgr = null;
            }
            catch (GenericException genericException) {
                // empty catch block
            }
        }
        if (this.m_pcMgr != null) {
            try {
                this.m_pcMgr.Close(true);
                this.m_pcMgr = null;
            }
            catch (GenericException genericException) {
                // empty catch block
            }
        }
        if (this.m_backupMgr != null) {
            try {
                this.m_backupMgr.Close(true);
                this.m_backupMgr = null;
            }
            catch (GenericException genericException) {
                // empty catch block
            }
        }
    }

    protected PalmBaseManager OpenArchive(int n) throws GenericException {
        GenericCategory genericCategory;
        GenCategoryManager genCategoryManager;
        PalmBaseManager palmBaseManager;
        block22: {
            if (m_bDebug) {
                Log.AddEntry("* GenericSynchronizer's OpenArchive", -1, false);
            }
            palmBaseManager = null;
            if (!this.m_hhMgr.areCategoriesSupported()) {
                try {
                    palmBaseManager = (PalmBaseManager)this.m_dbArchive.elementAt(0);
                    if (palmBaseManager != null) {
                        return palmBaseManager;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    palmBaseManager = this.CreateArchiveManager(this.m_rSyncProperties.localName);
                    this.m_dbArchive.addElement(palmBaseManager);
                    try {
                        palmBaseManager.Open();
                    }
                    catch (GenericException genericException) {
                        return palmBaseManager;
                    }
                }
                catch (Throwable throwable) {
                    throw new GenericException("unknown error");
                }
                return palmBaseManager;
            }
            if (n >= 16) {
                throw new GenericException(4357);
            }
            try {
                palmBaseManager = (PalmBaseManager)this.m_dbArchive.elementAt(n);
                if (palmBaseManager != null) {
                    return palmBaseManager;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            genCategoryManager = this.m_hhMgr.m_catMgr;
            if (this.m_hhMgr.m_catMgr == null) {
                throw new GenericException(4354);
            }
            genericCategory = null;
            try {
                genericCategory = genCategoryManager.getByIndex(n);
            }
            catch (GenericException genericException) {
                if (n != 0) break block22;
                throw genericException;
            }
        }
        if (genericCategory == null) {
            n = 0;
            genericCategory = genCategoryManager.getByIndex(n);
        }
        try {
            palmBaseManager = this.CreateArchiveManager(genericCategory.getFilename());
            this.m_dbArchive.addElement(palmBaseManager);
            try {
                palmBaseManager.Open();
            }
            catch (GenericException genericException) {
                return palmBaseManager;
            }
        }
        catch (Throwable throwable) {
            throw new GenericException("unknown error");
        }
        return palmBaseManager;
    }

    void closeArchives() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericSynchronizer's closeArchives", -1, false);
        }
        PalmBaseManager palmBaseManager = null;
        int n = 0;
        while (n < 16) {
            try {
                palmBaseManager = (PalmBaseManager)this.m_dbArchive.elementAt(n);
                palmBaseManager.PostSync();
                palmBaseManager.Close(false);
            }
            catch (GenericException genericException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            ++n;
        }
        this.m_dbArchive.removeAllElements();
    }

    int findPcToHhActions(int n) {
        switch (n) {
            case 32: {
                return 16;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 16;
            }
            case 6: {
                return 2;
            }
            case 5: {
                return 1;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 16;
            }
            case 10: {
                return 2;
            }
            case 14: {
                return 2;
            }
            case 9: {
                return 1;
            }
            case 13: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 7: {
                return 2;
            }
        }
        return 0;
    }

    int findHhToPcActions(int n) {
        switch (n) {
            case 0x200000: {
                return 32;
            }
            case 65536: {
                return 0;
            }
            case 131072: {
                return 8;
            }
            case 262144: {
                return 32;
            }
            case 393216: {
                return 8;
            }
            case 327680: {
                return 0;
            }
            case 196608: {
                return 8;
            }
            case 458752: {
                return 8;
            }
        }
        return 0;
    }

    protected boolean recordsAreEqual(PalmRecord palmRecord, PalmRecord palmRecord2) throws GenericException {
        return palmRecord.equals(palmRecord2);
    }
}

