// GetDiskSerialDlg.cpp : implementation file
//

#include "stdafx.h"
#include "GetDiskSerial.h"
#include "GetDiskSerialDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGetDiskSerialDlg dialog

CGetDiskSerialDlg::CGetDiskSerialDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGetDiskSerialDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGetDiskSerialDlg)
	m_Buffer = _T("");
	m_Cylinders = _T("");
	m_DriveNumber = _T("");
	m_Heads = _T("");
	m_ModalNumber = _T("");
	m_Revision = _T("");
	m_Sectors = _T("");
	m_SerialNumber = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_DriveNumber = _T("0");


	DllInst = NULL;

}

void CGetDiskSerialDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGetDiskSerialDlg)
	DDX_Text(pDX, IDC_BUFFER, m_Buffer);
	DDX_Text(pDX, IDC_CYLINDERS, m_Cylinders);
	DDX_Text(pDX, IDC_DRIVE_NUMBER, m_DriveNumber);
	DDX_Text(pDX, IDC_HEADS, m_Heads);
	DDX_Text(pDX, IDC_MODAL_NUMBER, m_ModalNumber);
	DDX_Text(pDX, IDC_REVISION, m_Revision);
	DDX_Text(pDX, IDC_SECTORS, m_Sectors);
	DDX_Text(pDX, IDC_SERIAL_NUMBER, m_SerialNumber);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGetDiskSerialDlg, CDialog)
	//{{AFX_MSG_MAP(CGetDiskSerialDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGetDiskSerialDlg message handlers

BOOL CGetDiskSerialDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CGetDiskSerialDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CGetDiskSerialDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CGetDiskSerialDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CGetDiskSerialDlg::OnOK() 
{
UpdateData(TRUE);

char* RegCode = "xxxxx-xxxxx-xxxxx-xxxxx-xxxxx";  //Enter your Keycode

int iDrive = atoi(m_DriveNumber);

if (DllInst == NULL)
	DllInst = LoadLibrary("GetDiskSerial.dll");
if (DllInst)
	{
	GetSerialNumber = (FGetSerialNumber)GetProcAddress(DllInst,"GetSerialNumber");
	GetModelNumber = (FGetModelNumber)GetProcAddress(DllInst,"GetModelNumber");
	GetRevisionNo = (FGetRevisionNo)GetProcAddress(DllInst,"GetRevisionNo");
	GetBufferSize = (FGetBufferSize)GetProcAddress(DllInst,"GetBufferSize");
	GetCylinders = (FGetCylinders)GetProcAddress(DllInst,"GetCylinders");
	GetHeads = (FGetHeads)GetProcAddress(DllInst,"GetHeads");
	GetSectors = (FGetSectors)GetProcAddress(DllInst,"GetSectors");

	m_SerialNumber = GetSerialNumber(iDrive, RegCode);
	m_ModalNumber = GetModelNumber(iDrive, RegCode);
	m_Revision = GetRevisionNo(iDrive, RegCode);
	m_Buffer.Format("%i", GetBufferSize(iDrive, RegCode));
	m_Cylinders.Format("%i", GetCylinders(iDrive, RegCode));
	m_Heads.Format("%i", GetHeads(iDrive, RegCode));
	m_Sectors.Format("%i", GetSectors(iDrive, RegCode));

	UpdateData(FALSE);
	}
else
	{
	AfxMessageBox("GetDiskSerial.dll not found", MB_ICONEXCLAMATION);
	}
}
