unit UnitDemo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus,
  HDiskInfo; //**** Add Interface Unit ****

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Button1: TButton;
    Label9: TLabel;
    Label10: TLabel;
    Button2: TButton;
    Label8: TLabel;
    edtDrive: TEdit;
    ComboBox1: TComboBox;
    Label12: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
    procedure ClearEdit;
  public
    { Public declarations }
    MyDiskInfo: DiskInfo; //Define an new structure
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
const
  RegCode = '000000000000'; //Your Reg Code
var
  iDiskNo: Integer;
begin

  //Check DiskNo
  try
    iDiskNo := StrToInt(edtDrive.Text);
  except
    on E: Exception do begin
      ShowMessage('Please input harddisk number. (0, 1, 2, ...)');
      edtDrive.SetFocus;
      Exit;
    end;
  end;

  ClearEdit;

  //Get Action
  case ComboBox1.ItemIndex of
    0: //Get all info
      begin
        GetIdeDiskInfo(iDiskNo, MyDiskInfo, RegCode);
        Edit1.Text := MyDiskInfo.SerialNumber;
        Edit2.Text := MyDiskInfo.ModelNumber;
        Edit3.Text := MyDiskInfo.RevisionNo;
        Edit4.Text := IntToStr(MyDiskInfo.BufferSize);
        Edit5.Text := IntToStr(MyDiskInfo.Cylinders);
        Edit6.Text := IntToStr(MyDiskInfo.Heads);
        Edit7.Text := IntToStr(MyDiskInfo.Sectors);
      end;
    1: Edit1.Text := GetSerialNumber(iDiskNo, RegCode); //Direct get SerialNumber
    2: Edit2.Text := GetModelNumber(iDiskNo, RegCode); //Direct get ModalNumber
    3: Edit3.Text := GetRevisionNo(iDiskNo, RegCode); //Direct get RevisionNo
    4: Edit4.Text := IntToStr(GetBufferSize(iDiskNo, RegCode)); //Direct get BufferSize
    5: Edit5.Text := IntToStr(GetCylinders(iDiskNo, RegCode)); //Direct get Cylinders
    6: Edit6.Text := IntToStr(GetHeads(iDiskNo, RegCode)); //Direct get Heads
    7: Edit7.Text := IntToStr(GetSectors(iDiskNo, RegCode)); //Direct get Sectors
  end;
end;

procedure TForm1.ClearEdit;
//Clear edit box
begin
  Edit1.Text := '';
  Edit2.Text := '';
  Edit3.Text := '';
  Edit4.Text := '';
  Edit5.Text := '';
  Edit6.Text := '';
  Edit7.Text := '';
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Close;
end;

end.

