 REM Sic.bas v7.4a r1.0 - Symbolic Instruction Code; module 1 of 3.
 REM The public domain DOS programming interpreter.

 ' get standard include declarations
 REM $INCLUDE: 'SIC.INC'

 ' declare external procedures
 DECLARE SUB SetInt
 DECLARE SUB RestInt

 ' backwards compatible for bc 7.1 (pds)
 REM $INCLUDE: 'BC7.INC'

 ' install new interrupt service routine
 CALL SetInt

 ' declare startup error routine
 ON ERROR GOTO Error.Routine2

 ' program variables
 REDIM Commands(1 TO MaxCommands) AS STRING
 REDIM Statements(1 TO MaxStatements + 3) AS STRING

 ' program code
 REDIM GosubReturn(1 TO 10) AS INTEGER
 REDIM Program(1 TO Max.Lines) AS STRING
 REDIM LineBreak(1 TO Max.Lines) AS INTEGER

 ' variable break arrays
 REDIM VariableBreak(1 TO 26) AS INTEGER
 REDIM VariableValue(1 TO 26) AS DOUBLE
 REDIM VariableBreak2(1 TO 26) AS INTEGER
 REDIM VariableValue2(1 TO 26) AS STRING
 REDIM VariableBreak3(0 TO 26, 0 TO Max.Arrays) AS INTEGER
 REDIM VariableValue3(0 TO 26, 0 TO Max.Arrays) AS DOUBLE

 ' program data
 REDIM Arrays(0 TO 26, 0 TO Max.Arrays) AS DOUBLE
 REDIM Definitions(0 TO Max.Functions) AS STRING
 REDIM Strngs(0 TO 26) AS STRING
 REDIM Variables(0 TO 26) AS DOUBLE

 ' file areas
 REDIM Field.Array(1 TO 255) AS STRING
 REDIM File.Fields(1 TO 255) AS STRING

 ' increase stack for recursion
 STACK STACK

 ' initialize common variables
 Max.Gosubs = 10
 PageLength = 23
 Program.Name = "<none>"
 SaveOnExit = True
 StdinInput1 = False
 StdinInput2 = Nul
 StdinPrompt = True
 Token.List = " -+*/\^()[]{}<>=|&!%~?:#@`;,'" + CHR$(34)
 White.Space = CHR$(32) + CHR$(9) ' can be changed

 ' initialize default screen variables
 LastScreen1 = 0
 LastScreen2 = 1
 LastScreen3 = 0
 LastScreen4 = 0

 ' initialize local screen variables
 ScreenMode = 0
 ScreenHeight = 25
 ScreenWidth = 80

 ' check windows v7.4a 10/26/2006
 Windows.Detected = True
 InregsX.AX = &H160A
 CALL InterruptX(&H2F, InregsX, OutregsX)
 IF OutregsX.AX > 0 THEN
    InregsX.AX = &H4A33
    CALL InterruptX(&H2F, InregsX, OutregsX)
    IF OutregsX.AX = 0 THEN
       Windows.Detected = 0 ' DOS 7.00
    END IF
 END IF

 ' read error strings
 CALL Read.Config(File.Found)

 ' reseed randomizer
 RANDOMIZE TIMER

 ' get environment variables
 Var$ = ENVIRON$("SICPAGELENGTH")
 IF LEN(Var$) THEN
    Temp# = INT(VAL(Var$))
    IF Temp# > 0# AND Temp# <= 32767# THEN
       PageLength = CINT(Temp#)
    END IF
 END IF
 Var$ = ENVIRON$("SICSTDININPUT")
 IF LEN(Var$) THEN
    StdinInput1 = INT(VAL(Var$))
    StdinInput2 = Var$
 END IF
 Var$ = ENVIRON$("SICSTDINPROMPT")
 IF LEN(Var$) THEN
    StdinPrompt = False
 END IF
 Var$ = ENVIRON$("SICSAVEONEXIT")
 IF LEN(Var$) THEN
    SaveOnExit = False
 END IF

 ' read in commands
 RESTORE Command.Data
 FOR Temp = 1 TO MaxCommands
    READ Commands(Temp)
 NEXT

 ' read in statements
 RESTORE Program.Data
 FOR Temp = 1 TO MaxStatements + 3
    READ Statements(Temp)
 NEXT

 ' store basic dta
 InregsX.AX = &H2F00
 CALL InterruptX(&H21, InregsX, OutregsX)
 BASIC.DTA.SEG = OutregsX.ES
 BASIC.DTA.OFF = OutregsX.BX

 ' parse command line
 Filename = COMMAND$
 IF Filename = "/?" OR Filename = "-?" THEN
    GOTO Boot.Usage
 END IF
 IF LEN(Filename) THEN
    Program.Resume = True
    IF DIR$(Filename) = Nul THEN
       GOTO Boot.Usage
    END IF
 END IF

 REM Increase maximum file handles to 80.
 InregsX.AX = &H6200 ' get psp segment
 CALL InterruptX(&H21, InregsX, OutregsX)
 PSP.Segment = OutregsX.BX
 DEF SEG = PSP.Segment ' point to psp segment
 ' offset to the command line
 Command.Line = &H80
 ' start of command line to store file handles
 Command.Tail = Command.Line + 40
 ' reset maximum file handles plus 5 for dos to closed handles
 FOR Var = 1 TO 85
    POKE Command.Tail + Var - 1, &HFF
 NEXT
 ' copy first 6 file handles to our offset
 FOR Var = 1 TO 6
    File.Handle = PEEK(&H18 + Var - 1)
    POKE Command.Tail + Var - 1, File.Handle
 NEXT
 POKE &H32, 85 ' store maximum file handles
 POKE &H34, Command.Tail ' store offset to new file handles
 DEF SEG

 ' make operating system string
 CALL OS

 ' declare main input loop error routine
 ON ERROR GOTO Error.Routine

 ' program.resume variable:
 '   -1 = command line program
 '    0 = immediate interpreter
 '    1 = standard input program

 ' run program from command line
 IF LEN(Filename) THEN
    Program.Resume = True
    CALL New.Program
    CALL Read.Program
    Run.Type = False
    CALL Run.Program(False)
    CALL Stop.Program
 END IF

 ' run program from stdin
 CALL Read.Stdin ' v7.4a 10/26/2006

 ' display logon banner
 COLOR White, Black
 PRINT "SIC v" + Version + " r" + Release + ": ";
 PRINT "The Symbolic Instruction Code Interpreter."
 PRINT "Type 'Quit' to return to system."

 ' check read.config successful
 IF File.Found = False THEN
    COLOR Yellow, Black
    PRINT "File '"+ErrorList+"' not found. Error list truncated."
 END IF
 COLOR White, Black

 ' declare main input loop error routine
 ON ERROR GOTO Error.Routine

' enter the Sic engine
Error.Resume:
 ' check which function started Sic
 IF Program.Resume THEN
    CALL End.Program
    CALL Stop.Program
 END IF
 IF FileNumber THEN
    CLOSE #FileNumber
    FileNumber = False
 END IF

 ' declare main input loop error routine
 ON ERROR GOTO Error.Routine

 ' enter the Sic programming interface
 DO
    ' get input
    Var = ClearBreak
    Valid.Command = False
    Visible = 1
    COLOR Yellow, Black
    LOCATE , 1, 1
    PRINT ">";
    LOCATE , , 1
    Out2 = RTRIM$(KeyboardLine$)
    PRINT
    IF BreakIS THEN
       COLOR Red, Black
       PRINT "*break*"
    END IF
    IF Out2 = Nul THEN
       Valid.Command = True
    ELSE
       ' check preceding line number
       CALL Enter.Program.Line
       IF Assign THEN
          Valid.Command = True
       ELSE

          ' get environment variable
          Param2$ = Nul
          Var$ = ENVIRON$("SICCMDLINE")
          IF LEN(Var$) THEN
             Param2$ = Var$
          END IF

          ' store parameter
          Param$ = Nul
          Out3 = Out2
          Out2 = UCASE$(Out2)
          Parameter = INSTR(Out2, " ")
          IF Parameter THEN
             Param$ = MID$(Out2, Parameter + 1)
             Param2$ = MID$(Out3, Parameter + 1)
             Out2 = LEFT$(Out2, Parameter - 1)
          END IF

          ' compare to command list
          Valid.Command = False
          FOR Command.Number = 1 TO MaxCommands
             IF Out2 = Commands(Command.Number) THEN

                ' check command uses currently loaded program
                SELECT CASE Command.Number
                CASE 1, 4, 6, 8, 9, 11, 12, 13, 15, 18
                IF Program.Name = "<none>" THEN
                   COLOR White, Black
                   PRINT "No program loaded."
                   Valid.Command = True
                   EXIT FOR
                END IF
                END SELECT

                ' check command has no parameter to specify
                SELECT CASE Command.Number
                CASE 1, 3, 8, 10, 15, 16, 18
                   IF LEN(Param$) THEN
                      EXIT FOR
                   END IF
                END SELECT

                ' process command
                Valid.Command = True
                SELECT CASE Command.Number
                CASE 1 ' analyze
                   CALL Prepare.Program
                   CALL Analyze.Program
                   CALL New.Program
                   Filename = Prepare.Filename
                   CALL Read.Program
                   KILL Prepare.Filename
                CASE 2 ' files
                   CALL List.Files(Param$)
                CASE 3 ' help
                   CALL List.Help
                CASE 4 ' indent
                   CALL Indent.Program(INT(VAL(Param$)))
                CASE 5 ' kill
                   CALL Kill.Program(Param$)
                CASE 6 ' list
                   Start.Line = 1
                   CALL Count.Lines(Last.Line)
                   Stop.Line = Last.Line
                   IF LEN(Param$) THEN
                      Comma = INSTR(Param$, ",")
                      IF Comma THEN
                         Start.Line = INT(VAL(LEFT$(Param$, Comma - 1)))
                         Stop.Line = INT(VAL(MID$(Param$, Comma + 1)))
                      ELSE
                         Start.Line = INT(VAL(Param$))
                         Stop.Line = Last.Line
                      END IF
                   END IF
                   CALL List.Program(Start.Line, Stop.Line, False)
                CASE 7 ' load
                   CALL Load.Program(Param$)
                CASE 8 ' new
                   IF SaveOnExit THEN
                      CALL Save.Current
                   END IF
                   Last.Search.Line = False
                   CALL New.Program
                   Program.Name = "<none>"
                   COLOR White, Black
                   PRINT "Program cleared."
                CASE 9 ' print
                   Start.Line = 1
                   CALL Count.Lines(Last.Line)
                   Stop.Line = Last.Line
                   IF LEN(Param$) THEN
                      Comma = INSTR(Param$, ",")
                      IF Comma THEN
                         Start.Line = INT(VAL(LEFT$(Param$, Comma - 1)))
                         Stop.Line = INT(VAL(MID$(Param$, Comma + 1)))
                      ELSE
                         Start.Line = INT(VAL(Param$))
                         Stop.Line = Last.Line
                      END IF
                   END IF
                   CALL List.Program(Start.Line, Stop.Line, True)
                CASE 10 ' quit
                   CALL Quit.Program
                   END
                CASE 11 ' renumber
                   Start.Line = False
                   Increment.Value = False
                   IF LEN(Param$) THEN
                      Comma = INSTR(Param$, ",")
                      IF Comma THEN
                         Start.Line = INT(VAL(LEFT$(Param$, Comma - 1)))
                         Increment.Value = INT(VAL(MID$(Param$, Comma + 1)))
                      END IF
                   END IF
                   CALL Renumber.Program(Start.Line, Increment.Value)
                CASE 12 ' run
                   CommandLine = Param2$
                   IF LEFT$(UCASE$(Param2$), 5) = "LINE=" THEN
                      Start.Number = INT(VAL(MID$(Param2$, 6)))
                   ELSE
                      Start.Number = False
                   END IF
                   COLOR White, Black
                   PRINT "Starting program: " + Program.Name
                   Run.Type=False
                   CALL Run.Program(Start.Number)
                   COLOR White, Black
                   PRINT "Program run ended."
                CASE 13 ' save
                   CALL Save.Program(Param$)
                CASE 14 ' whatis
                   CALL Whatis.Command(Param$)
                CASE 15 ' continue
                   Run.Type=True
                   IF Run.Line > Max.Lines THEN
                      COLOR White, Black
                      PRINT "Can't continue."
                   ELSE
                      COLOR White, Black
                      PRINT "Continuing program: " + Program.Name
                      CALL Run.Program(0)
                   END IF
                CASE 16 ' debug
                   CALL Debug.Command
                CASE 17 ' shell
                   Program.Line = False
                   IF Param$ = Nul THEN
                      CALL Execute.Command("")
                   ELSE
                      X = FreeFileNumber
                      Open "sic75a.bat" For Output As #FileNumber
                      Print #FileNumber,Param$
                      Print #FileNumber,"PAUSE"
                      Print #FileNumber,"EXIT"
                      CLOSE #FileNumber
                      FileNumber = False
                      CALL Execute.Command("sic75a.bat")
                   END IF
                   COLOR White, Black
                   PRINT "Returned from DOS shell."
                CASE 18
                   CALL Search.Program
                END SELECT
                EXIT FOR
             END IF
          NEXT
       END IF
    END IF
    IF Valid.Command = False THEN
       COLOR White, Black
       PRINT "Type 'Help' for information."
    END IF
 LOOP
 END

 ' display boot usage and quit
Boot.Usage:
 COLOR White, Black
 PRINT "SIC v" + Version + " r" + Release + "; Usage:"
 COLOR Yellow, Black
 PRINT "SIC <program name>"
 COLOR Green, Black
 PRINT "   Starts SIC and runs program."
 COLOR Yellow, Black
 PRINT "TYPE <program name> | SIC"
 COLOR Green, Black
 PRINT "   Redirects and starts program name."
 COLOR Yellow, Black
 PRINT "SIC w/o command line starts interpreter."
 COLOR White, Black
 PRINT "SIC is a public domain program 2006."
 CALL Stop.Program
 END

' standard error trap for all Sic functions.
Error.Routine:
 PrinterLF = False
 Printing = False
 ErrorLine = Program.Line
 ErrorValue = ERR
 IF POS(0) > 1 THEN
    PRINT
 END IF
 Out2=Nul
 CALL Display.Error
 IF Program.Resume <= False THEN
    CALL Key.Prompt
 END IF
 DEF SEG
 InDEFSEG = False
 RESUME Error.Resume

' standard startup error trap.
Error.Routine2:
 Call RestInt
 If Program.Resume = False Then
    Print "SIC is terminating because of an error loading."
    Print "Returning to system with error:";
    Select Case Err
    Case 7
       Print " Out of memory."
    Case 14
       Print " Out of string space."
    Case Else
       Print Err
    End Select
    Print "Free more conventional Ram and restart."
 Endif
 If Program.Resume Then
    Print "Error";Err
 Endif
 Color 7, 0
 End

' check validity of program
SUB Analyze.Program
 COLOR White, Black
 CALL Count.Lines(Last.Line)
 PRINT "Pass 1: counting matching structures."
 RESTORE Analyze.Data1
 FOR Data.Count = 1 TO 8
    READ Start.Structure$, Stop.Structure$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
          Count.Data1 = False
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
             Count.Data1 = True
	  END IF
          IF Start.Structure$ = "FOR" THEN
             IF LEFT$(Temp1$, 5) = "FORIF" THEN
                Count.Data1 = False
             END IF
          END IF
          IF Count.Data1 THEN
	     Nested.Count = Nested.Count + 1
          END IF
	  IF Start.Structure$ = "IF" THEN
	     IF LEFT$(Temp1$, 6) = "END IF" THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
		   PRINT "Analyze error, pass 1: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		   EXIT SUB
		END IF
	     END IF
	  END IF
          IF Stop.Structure$ = "LOOP" THEN
             IF LEFT$(Temp1$, 6) <> "LOOPIF" THEN
                Temp1$ = LEFT$(Temp1$, 4)
             END IF
          END IF
          IF Stop.Structure$ = "NEXT" THEN
             IF LEFT$(Temp1$, 6) <> "NEXTIF" THEN
                Temp1$ = LEFT$(Temp1$, 4)
             END IF
          END IF
          IF Stop.Structure$ = "END SELECT" THEN
             IF LEFT$(Temp1$, 12) <> "END SELECTIF" THEN
                Temp1$ = LEFT$(Temp1$, 10)
             END IF
          END IF
          IF Temp1$ = Stop.Structure$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
		PRINT "Analyze error, pass 1: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 2: counting matching imbedded structures."
 RESTORE Analyze.Data2
 FOR Data.Count = 1 TO 3
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
	     Nested.Count = Nested.Count + 1
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded1$)) = Imbedded1$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
		PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	     Nested.Count = Nested.Count + 1
	  ELSE
             Temp2$ = Temp1$
             IF Imbedded2$ <> "ELSEIF" THEN
                IF LEFT$(Temp1$, LEN(Imbedded2$)) = Imbedded2$ THEN
                   Imbedded3 = INSTR(Temp1$, " ")
                   IF Imbedded3 = False THEN
                      PRINT "Analyze error, pass 2: Bad ";Imbedded2$; ": Line:";Program.Line
                      EXIT SUB
                   END IF
                   Temp2$ = LEFT$(Temp1$, Imbedded3 - 1)
                END IF
             END IF
             IF Temp2$ = Imbedded2$ THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
		   PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		   EXIT SUB
		END IF
		Nested.Count = Nested.Count + 1
	     END IF
	  END IF
	  IF Start.Structure$ = "IF" THEN
	     IF LEFT$(Temp1$, 6) = "END IF" THEN
		Nested.Count = Nested.Count - 1
		IF Nested.Count < False THEN
		   PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		   EXIT SUB
		END IF
	     END IF
	  END IF
          IF Temp1$ = Stop.Structure$ THEN
	     Nested.Count = Nested.Count - 1
	     IF Nested.Count < False THEN
		PRINT "Analyze error, pass 2: Incomplete "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 3: multipass structure match."
 RESTORE Analyze.Data1
 FOR Data.Count = 1 TO 8
    READ Start.Structure$, Stop.Structure$
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
          Count.Data1 = False
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
             Count.Data1 = True
          END IF
          IF Start.Structure$ = "FOR" THEN
             IF LEFT$(Temp1$, 5) = "FORIF" THEN
                Count.Data1 = False
             END IF
          END IF
          IF Count.Data1 THEN
             Nested.Count = 1
	     FOR Nested.Lines = Program.Line + 1 TO Last.Line
		Temp2$ = Program(Nested.Lines)
		Temp2$ = STRIM$(Temp2$)
		IF LEN(Temp2$) THEN
		   Temp2$ = STRIM$(Temp2$)
		   Temp2$ = UCASE$(Temp2$)
                   Count.Data2 = False
		   IF LEFT$(Temp2$, LEN(Start.Structure$)) = Start.Structure$ THEN
                      Count.Data2 = True
                   END IF
                   IF Start.Structure$ = "FOR" THEN
                      IF LEFT$(Temp2$, 5) = "FORIF" THEN
                         Count.Data2 = False
                      END IF
                   END IF
                   IF Count.Data2 THEN
		      Nested.Count = Nested.Count + 1
		   END IF
                   IF Stop.Structure$ = "LOOP" THEN
                      IF LEFT$(Temp2$, 6) <> "LOOPIF" THEN
                         Temp2$ = LEFT$(Temp2$, 4)
                      END IF
                   END IF
                   IF Stop.Structure$ = "NEXT" THEN
                      IF LEFT$(Temp2$, 6) <> "NEXTIF" THEN
                         Temp2$ = LEFT$(Temp2$, 4)
                      END IF
                   END IF
                   IF Stop.Structure$ = "END SELECT" THEN
                      IF LEFT$(Temp1$, 12) <> "END SELECTIF" THEN
                         Temp1$ = LEFT$(Temp1$, 10)
                      END IF
                   END IF
                   IF Temp2$ = Stop.Structure$ THEN
		      Nested.Count = Nested.Count - 1
                      IF Nested.Count = False THEN
                         EXIT FOR
                      END IF
		   END IF
		   IF Start.Structure$ = "IF" THEN
		      IF LEFT$(Temp2$, 6) = "END IF" THEN
			 Nested.Count = Nested.Count - 1
                         IF Nested.Count = False THEN
                            EXIT FOR
                         END IF
		      END IF
		   END IF
		END IF
	     NEXT
	     IF Nested.Count <> False THEN
		PRINT "Analyze error, pass 3: Mismatched "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 4: multipass imbedded struture match."
 RESTORE Analyze.Data2
 FOR Data.Count = 1 TO 3
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
	     Total.Nested1 = 1
	     Total.Nested2 = 0
	     Nested.Count1 = 1
	     Nested.Count2 = 0
	     FOR Nested.Lines = Program.Line + 1 TO Last.Line
		Temp2$ = Program(Nested.Lines)
		Temp2$ = STRIM$(Temp2$)
		IF LEN(Temp2$) THEN
		   Temp2$ = STRIM$(Temp2$)
		   Temp2$ = UCASE$(Temp2$)
		   IF LEFT$(Temp2$, LEN(Start.Structure$)) = Start.Structure$ THEN
		      Total.Nested1 = Total.Nested1 + 1
		      Nested.Count1 = Nested.Count1 + 1
		   END IF
                   IF Temp2$ = Stop.Structure$ THEN
		      Total.Nested2 = Total.Nested2 - 1
		      Nested.Count1 = Nested.Count1 - 1
                      IF Nested.Count1 = False THEN
			 EXIT FOR
		      END IF
		   END IF
		   IF Start.Structure$ = "IF" THEN
		      IF LEFT$(Temp2$, 6) = "END IF" THEN
			 Nested.Count1 = Nested.Count1 - 1
                         IF Nested.Count1 = False THEN
			    EXIT FOR
			 END IF
		      END IF
		   END IF
		   IF LEFT$(Temp2$, LEN(Imbedded1$)) = Imbedded1$ THEN
		      Nested.Count2 = Nested.Count2 + 1
		      IF Nested.Count2 > Nested.Count1 THEN
			 PRINT "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
			 EXIT SUB
		      END IF
		      Nested.Count2 = Nested.Count2 - 1
		   ELSE
                      Temp3$ = Temp2$
                      IF Imbedded2$ <> "ELSEIF" THEN
                         IF LEFT$(Temp2$, LEN(Imbedded2$)) = Imbedded2$ THEN
                            Imbedded3 = INSTR(Temp2$, " ")
                            IF Imbedded3 = False THEN
                               PRINT "Analyze error, pass 4: Bad ";Imbedded2$; ": Line:";Program.Line
                               EXIT SUB
                            END IF
                            Temp3$ = LEFT$(Temp2$, Imbedded3 - 1)
                         END IF
                      END IF
                      IF Temp3$ = Imbedded2$ THEN
			 Nested.Count2 = Nested.Count2 + 1
			 IF Nested.Count2 > Nested.Count1 THEN
			    PRINT "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
			    EXIT SUB
			 END IF
			 Nested.Count2 = Nested.Count2 - 1
		      END IF
		   END IF
		END IF
	     NEXT
	     IF Total.Nested2 > Total.Nested1 THEN
		PRINT "Analyze error, pass 4: Mismatched "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 PRINT "Pass 5: single pass imbedded control structure match."
 RESTORE Analyze.Data3
 FOR Data.Count = 1 TO 5
    READ Start.Structure$, Stop.Structure$, Imbedded1$, Imbedded2$
    Nested.Count = False
    FOR Program.Line = 1 TO Last.Line
       Out2 = Program(Program.Line)
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
	  Temp1$ = STRIM$(Out2)
	  Temp1$ = UCASE$(Temp1$)
          Count.Data1 = False
	  IF LEFT$(Temp1$, LEN(Start.Structure$)) = Start.Structure$ THEN
             Count.Data1 = True
          END IF
          IF Start.Structure$ = "FOR" THEN
             IF LEFT$(Temp1$, 5) = "FORIF" THEN
                Count.Data1 = False
             END IF
          END IF
          IF Count.Data1 THEN
	     Nested.Count = Nested.Count + 1
	  END IF
          Count.Data2 = False
	  IF LEFT$(Temp1$, LEN(Stop.Structure$)) = Stop.Structure$ THEN
             Count.Data2 = True
          END IF
          IF Stop.Structure$ = "LOOP" THEN
             IF LEFT$(Temp1$, 6) = "LOOPIF" THEN
                Count.Data2 = False
             END IF
          END IF
          IF Stop.Structure$ = "NEXT" THEN
             IF LEFT$(Temp1$, 6) = "NEXTIF" THEN
                Count.Data2 = False
             END IF
          END IF
          IF Count.Data2 THEN
             Nested.Count = Nested.Count - 1
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded1$)) = Imbedded1$ THEN
	     IF Nested.Count <= False THEN
		PRINT "Analyze error, pass 5: Badly nested "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
	  IF LEFT$(Temp1$, LEN(Imbedded2$)) = Imbedded2$ THEN
	     IF Nested.Count <= False THEN
		PRINT "Analyze error, pass 5: Badly nested "; Start.Structure$; ": Line:"; Program.Line
		EXIT SUB
	     END IF
	  END IF
       END IF
    NEXT
 NEXT
 COLOR Yellow, Black
 PRINT "Analysis completed. Program syntax correct."
END SUB

' gets last line in program
SUB Count.Lines (Temp1%)
 Temp1% = False
 FOR Temp2% = Max.Lines TO 1 STEP -1
    Temp1$ = Program(Temp2%)
    Temp1$ = STRIM$(Temp1$)
    IF LEN(Temp1$) THEN
       EXIT FOR
    END IF
 NEXT
 Temp1% = Temp2%
END SUB

' reset file handles
SUB Decrease.PSP
 CLOSE
 InregsX.AX = &H6200
 CALL InterruptX(&H21, InregsX, OutregsX)
 PSP.Segment = OutregsX.BX
 DEF SEG = PSP.Segment
 POKE &H32, 20
 POKE &H34, &H18
 DEF SEG
 ' remove dimensioned arrays from memory
 ERASE Arrays, Strngs, Variables, GosubReturn, Definitions
 ERASE Program, Field.Array, File.Fields, Errors, LineBreak
 ERASE VariableBreak, VariableValue
 ERASE VariableBreak2, VariableValue2
 ERASE VariableBreak3, VariableValue3
END SUB

' displays error message
SUB Display.Error
 ' check error value range
 IF ErrorValue > 0 AND ErrorValue <= Max.Errors THEN
    Error.List$ = Errors(ErrorValue) ' store error string
 ELSE
    Error.List$ = "Error" + STR$(ErrorValue) ' store error number
 END IF
 ' parse out ': Line%1:'
 Parse = INSTR(Error.List$, "%1")
 IF Parse THEN
    ' check error line number
    IF ErrorLine = False THEN ' remove %1 string
       Error.List$ = LEFT$(Error.List$, Parse - 7) + MID$(Error.List$, Parse + 2)
    ELSE ' replace %1 string
       Error.List$ = LEFT$(Error.List$, Parse - 1) + STR$(ErrorLine) + MID$(Error.List$, Parse + 2)
    END IF
 END IF
 ' parse out ': %2.'
 Parse = INSTR(Error.List$, "%2")
 IF Parse THEN
    ' check token string
    IF LEN(Strng) = False THEN ' remove %2 string
       Error.List$ = LEFT$(Error.List$, Parse - 1) + "<?>" + MID$(Error.List$, Parse + 2)
    ELSE ' replace %2 string
       Error.List$ = LEFT$(Error.List$, Parse - 1) + Strng + MID$(Error.List$, Parse + 2)
    END IF
 END IF
 ' check program loaded
 IF Program.Resume <= False THEN
    PRINT RTRIM$(Error.List$)
 ELSE
    ' display error for redirected in
    IF ControlBreak = False THEN
       PRINT "Error"; ErrorValue
    END IF
 END IF
END SUB

' parses and stores a program line number
SUB Enter.Program.Line
 Assign = False
 Out2 = STRIM$(Out2)
 FOR Blanks = 1 TO LEN(Out2)
    Imbedded = False
    FOR Parse = 1 TO LEN(White.Space)
       IF MID$(Out2, Blanks, 1) = MID$(White.Space, Parse, 1) THEN
          Imbedded = Blanks
          EXIT FOR
       END IF
    NEXT
    IF Imbedded THEN
       Line.Number = INT(VAL(LEFT$(Out2, Imbedded - 1)))
       IF Line.Number >= 1 AND Line.Number <= Max.Lines THEN
          Out3 = MID$(Out2, Imbedded)
          IF STRIM$(Out3) = Nul THEN
             EXIT FOR
          END IF
          Assign = True
          Program(Line.Number) = Out3
	  IF Program.Name = "<none>" THEN
	     Program.Name = "<untitled>"
	  END IF
       ELSE
          Out3 = STRIM$(Out2)
          IF INSTR("0123456789", LEFT$(Out3, 1)) THEN
             Assign = True
             PRINT "Line number out of range."
          END IF
       END IF
       EXIT SUB
    END IF
 NEXT
 Line.Number = INT(VAL(Out2))
 IF Line.Number > False AND Line.Number <= Max.Lines THEN
    Assign = True
    Program(Line.Number) = Nul
    CALL Count.Lines(Last.Line)
    IF Last.Line = False THEN
       Program.Name = "<none>
    ELSE
       IF Program.Name = "<none>" THEN
          Program.Name = "<untitled>"
       END IF
    END IF
 ELSE
    Out3 = STRIM$(Out2)
    IF INSTR("0123456789", LEFT$(Out3, 1)) THEN
       Assign = True
       PRINT "Line number out of range."
    END IF
 END IF
END SUB

' starts a MS-DOS shell
SUB Execute.Command (Shell.Statement$)
 DEF SEG ' restore basic segment
 CALL RestInt ' reset key trapping
 Var = ClearBreak ' reset break flag

 ' store shell dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(ParseDTA)
 InregsX.DX = VARPTR(ParseDTA)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' store current drive/directory
 Current.Directory$ = CURDIR$

 ' start DOS command shell
 Shell.Command$ = ENVIRON$("COMSPEC") ' v7.3a 11/04/2005
 IF LEN(Shell.Statement$) THEN
    Shell.Command$ = Shell.Command$ + " /E:4096 /C " + Shell.Statement$
 END IF

 ' call shell routine
 SHELL Shell.Command$

 ' restore current drive/directory
 CHDRIVE Current.Directory$
 CHDIR Current.Directory$

 ' restore basic dta
 InregsX.AX = &H1A00
 InregsX.DS = BASIC.DTA.SEG
 InregsX.DX = BASIC.DTA.OFF
 CALL InterruptX(&H21, InregsX, OutregsX)

 CALL SetInt ' restore key trapping
 Var = ClearBreak ' reset break flag
END SUB

' indents current program
SUB Indent.Program(Number.Spaces)
 COLOR White, Black
 CALL More.Prompt("Indent with tabs or spaces(t/s/q)?", "tsq", Output.Char$)
 SELECT CASE Output.Char$
 CASE "t"
    Tabs = True
 CASE "s"
    Tabs = False
 CASE "q"
    EXIT SUB
 END SELECT
 IF Number.Spaces = False THEN
    COLOR White, Black
    IF Tabs THEN
       PRINT "Enter number of tabs to indent";
    ELSE
       PRINT "Enter number of spaces to indent";
    END IF
    INPUT Increment
 ELSE
    Increment = Number.Spaces
 END IF
 Indent = False
 CALL Count.Lines(Last.Line)
 FOR Program.Line = 1 TO Last.Line
    IF Tabs THEN
       Number$ = CHR$(9)
    ELSE
       Number$ = SPACE$(6 - LEN(STR$(Program.Line)))
    END IF
    Out2 = Program(Program.Line)
    Out2 = STRIM$(Out2)
    IF LEN(Out2) THEN
       Temp1$ = STRIM$(Out2)
       Temp1$ = UCASE$(Temp1$)
       Temp1$ = TTRIM$(Temp1$, False)
       Next.Indent = False
       RESTORE Indent.Data
       DO
	  READ Keyword$, KeyIndent
	  IF Keyword$ = "EOF" THEN
	     EXIT DO
	  END IF
	  IF LEFT$(Temp1$, LEN(Keyword$)) = Keyword$ THEN
	     Next.Indent = KeyIndent
	     EXIT DO
	  END IF
       LOOP
       SELECT CASE Next.Indent
       CASE 1
          IF Tabs THEN
             Out2 = STRING$(Indent * Increment, CHR$(9)) + STRIM$(Out2)
          ELSE
             Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
          END IF
	  Indent = Indent + 1
       CASE -1
	  Indent = Indent - 1
	  IF Indent < False THEN
	     PRINT "Indent error: Line:"; Program.Line
             EXIT SUB
	  END IF
          IF Tabs THEN
             Out2 = STRING$(Indent * Increment, CHR$(9)) + STRIM$(Out2)
          ELSE
             Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
          END IF
       CASE -2
	  Indent = Indent - 1
	  IF Indent < False THEN
	     PRINT "Indent error: Line:"; Program.Line
             EXIT SUB
	  END IF
          IF Tabs THEN
             Out2 = STRING$(Indent * Increment, CHR$(9)) + STRIM$(Out2)
          ELSE
             Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
          END IF
	  Indent = Indent + 1
       CASE ELSE
          IF Tabs THEN
             Out2 = STRING$(Indent * Increment, CHR$(9)) + STRIM$(Out2)
          ELSE
             Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
          END IF
       END SELECT
       Out2 = Number$ + Out2
       Program(Program.Line) = Out2
    END IF
 NEXT
 IF Indent <> False THEN
    PRINT "Indent error: Line:"; Program.Line
    EXIT SUB
 END IF
 PRINT "Program indented."
END SUB

' deletes a .sic file
SUB Kill.Program(Temp.Name$)
 DO
    IF Temp.Name$ = Nul THEN
       COLOR White, Black
       PRINT "Program name to kill";
       INPUT Program.File$
    ELSE
       Program.File$ = Temp.Name$
    END IF
    IF LEN(Program.File$) = False THEN
       EXIT DO
    END IF
    Call Concatenate(Program.File$)
    Filename = Program.File$
    IF DIR$(Filename) = Nul THEN
       PRINT "File "; CHR$(34); Filename; CHR$(34); " does not exist."
       IF LEN(Temp.Name$) THEN
          EXIT DO
       END IF
    ELSE
       IF Temp.Name$ = Nul THEN
          COLOR White, Black
          PRINT "Kill "; CHR$(34); Filename; CHR$(34); ". ";
          CALL More.Prompt("Are you sure(y/n)?", "yn", Output.Char$)
       ELSE
          Output.Char$ = "y"
       END IF
       COLOR White, Black
       IF Output.Char$ = "y" THEN
	  KILL Filename
          PRINT "Program "; CHR$(34); Filename; CHR$(34); " killed."
       ELSE
          PRINT "Program "; CHR$(34); Filename; CHR$(34); " not killed."
       END IF
       EXIT DO
    END IF
 LOOP
END SUB

' lists specified .sic files
SUB List.Files (Var$)
 ' declare file date and time work variables
 DIM File.Work.Date AS SINGLE, File.Work.Time AS SINGLE
 DIM HourTemp AS SINGLE, MinuteTemp AS SINGLE, SecondsTemp AS SINGLE
 DIM DayTemp AS SINGLE, MonthTemp AS SINGLE, YearTemp AS SINGLE
 DIM File.Date AS STRING * 10, File.Time AS STRING * 8

 ' declare file size work variables
 DIM File.Size AS DOUBLE, Total.Bytes AS DOUBLE
 DIM Total.Files AS DOUBLE

 ' reset counters
 Line.Count = 1
 Continuous.Display = False

 ' reset some variables
 Total.Files = DFalse
 Total.Bytes = Dfalse

 ' store asciiz search filename
 IF Var$ = Nul THEN
    FileList$ = "*.SIC"
    ASCIIZ = "*.SIC" + CHR$(0)
 ELSE
    IF RIGHT$(Var$, 4) = ".SIC" THEN
       FileList$ = Var$
       ASCIIZ = Var$ + CHR$(0)
    ELSE
       FileList$ = Var$ + ".SIC"
       ASCIIZ = Var$ + ".SIC" + CHR$(0)
    END IF
 END IF
 COLOR White, Black
 PRINT "Searching: ";FileList$
 GOSUB Title.Header

 ' restore directory search dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(ParseDTA)
 InregsX.DX = VARPTR(ParseDTA)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' find first filename
 InregsX.AX = &H4E00
 InregsX.CX = &H27
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.DX = VARPTR(ASCIIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' start file list loop
 DO
    ' check findfirst error
    IF (OutregsX.Flags AND &H1) = &H1 THEN
       EXIT DO
    END IF

    ' store file attribute
    Attribute% = ASC(ParseDTA.FileAttr)
    Attr$ = Space$(5)
    IF (Attribute% AND &H1) = &H1 THEN
       Mid$(Attr$, 1, 1) = "O"
    END IF
    IF (Attribute% AND &H2) = &H2 THEN
       Mid$(Attr$, 2, 1) = "H"
    END IF
    IF (Attribute% AND &H4) = &H4 THEN
       Mid$(Attr$, 3, 1) = "S"
    END IF
    IF (Attribute% AND &H20) = &H20 THEN
       Mid$(Attr$, 4, 1) = "A"
    END IF

    ' store filename
    Filename = ParseDTA.ASCIIZfilename
    Filename = LEFT$(Filename, INSTR(Filename, CHR$(0)) - 1)
    Filename = LEFT$(Filename, INSTR(Filename, ".") - 1)

    ' count files
    Total.Files = Total.Files + 1#

    ' store file size
    File.Size = ASC(MID$(ParseDTA.FileSize, 4, 1))
    File.Size = File.Size * &H100 + ASC(MID$(ParseDTA.FileSize, 3, 1))
    File.Size = File.Size * &H100 + ASC(MID$(ParseDTA.FileSize, 2, 1))
    File.Size = File.Size * &H100 + ASC(MID$(ParseDTA.FileSize, 1, 1))

    ' count bytes
    Total.Bytes = Total.Bytes + File.Size

    ' construct file date and time for display
    File.Work.Date = ASC(MID$(ParseDTA.FileDate, 2, 1))
    File.Work.Date = File.Work.Date * &H100 + ASC(MID$(ParseDTA.FileDate, 1, 1))

    YearTemp = INT(File.Work.Date / 512)
    MonthTemp = INT((File.Work.Date AND &H1E0) / 32)
    DayTemp = INT(File.Work.Date AND &H1F)

    File.Work.Time = ASC(MID$(ParseDTA.FileTime, 2, 1))
    File.Work.Time = File.Work.Time * &H100 + ASC(MID$(ParseDTA.FileTime, 1, 1))

    HourTemp = INT(File.Work.Time / 2048)
    MinuteTemp = INT((File.Work.Time AND &H7E0) / 32)
    SecondsTemp = INT((File.Work.Time AND &H1F) / 2)
    YearTemp = YearTemp + 1980

    File.Date = RIGHT$(STR$(MonthTemp + 100), 2) + "-" + RIGHT$(STR$(DayTemp + 100), 2) + "-" + MID$(STR$(YearTemp), 2)
    File.Time = RIGHT$(STR$(HourTemp + 100), 2) + ":" + RIGHT$(STR$(MinuteTemp + 100), 2) + ":" + RIGHT$(STR$(SecondsTemp + 100), 2)

    ' display filename line
    Filename = LCASE$(Filename)
    MID$(Filename, 1, 1) = UCASE$(MID$(Filename, 1, 1))
    Display.Line$ = Filename + SPACE$(8 - LEN(Filename))
    COLOR Yellow, Black
    PRINT Display.Line$;

    Display.Line$ = " " + File.Date + " " + File.Time
    COLOR Green, Black
    PRINT Display.Line$;

    COLOR Red, Black
    PRINT " "; Attr$;

    FileSize$ = FORMAT$(File.Size, "#,##0")
    Display.Line$ = RTRIM$(FileSize$)
    COLOR Cyan, Black
    PRINT Display.Line$

    ' check page length
    IF Continuous.Display = False THEN
       Line.Count = Line.Count + 1
       IF Line.Count = PageLength - 2 THEN
          Line.Count = False
          CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
	  SELECT CASE Output.Char$
          CASE "y"
             GOSUB Title.Header
	  CASE "n"
	     EXIT DO
	  CASE "c"
	     Continuous.Display = True
	  END SELECT
       END IF
    END IF

    ' find next filename
    InregsX.AX = &H4F00
    CALL InterruptX(&H21, InregsX, OutregsX)
 LOOP

 ' restore basic dta
 InregsX.AX = &H1A00
 InregsX.DS = BASIC.DTA.SEG
 InregsX.DX = BASIC.DTA.OFF
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' check page length
 IF Line.Count >= PageLength - 3 THEN
    IF Continuous.Display = False THEN
       CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
    END IF
 END IF

 ' print totals
 COLOR White, Black
 PRINT "--------                          ----"
 Total.Line$ = FORMAT$(Total.Files, "#,##0") + " Files"
 Total.Line$ = Total.Line$ + SPACE$(34 - LEN(Total.Line$))
 Temp# = Total.Bytes
 TempA = False
 DO
    IF Temp# >= 1024 THEN
       Temp# = Temp# / 1024
       TempA = TempA + 1
       IF TempA = 4 THEN
	  EXIT DO
       END IF
    ELSE
       EXIT DO
    END IF
 LOOP
 Temp$ = FORMAT$(Temp#, "#,##0.0;;")
 SELECT CASE TempA
 CASE 0
    Strng = Temp$ + " B"
 CASE 1
    Strng = Temp$ + " KB"
 CASE 2
    Strng = Temp$ + " MB"
 CASE 3
    Strng = Temp$ + " GB"
 CASE 4
    Strng = Temp$ + " TB"
 CASE ELSE
    Strng = Temp$
 END SELECT
 Total.Line$ = Total.Line$ + Strng
 PRINT Total.Line$
 EXIT SUB

Title.Header:
 COLOR White, Black
 PRINT "Filename Date       Time     Attr Size"
 PRINT "-------- ---------- -------- ---- -----"
 RETURN
END SUB

' display help menu
SUB List.Help
 DO
    COLOR White, Black
    PRINT "Help utility SIC v" + Version + " r" + Release + " list:"
    COLOR Yellow, Black
    PRINT "[1]command list"
    PRINT "[2]general documentation"
    PRINT "[3]formatting information"
    PRINT "[4]screen mode tables"
    PRINT "[5]error code values"
    PRINT "[6]syntax documentation"
    PRINT "[7]boolean syntax/charts"
    PRINT "[8]troolean syntax/charts"
    PRINT "[9]disclaimer notice"
    PRINT "[A]shareware information"
    CALL More.Prompt("Enter(1-A, Q to quit)?", "123456789aq", Output.Char$)
    SELECT CASE Output.Char$
    CASE "1"
       COLOR White, Black
       PRINT "SIC created: " + PublishDate
       COLOR Yellow, Black
       PRINT "ANALYZE  --  checks program structure."
       PRINT "CONTINUE --  continue halted program."
       PRINT "DEBUG    --  immediate debug mode."
       PRINT "FILES    --  display programs."
       PRINT "HELP     --  lists help topics."
       PRINT "INDENT   --  formats current program."
       PRINT "KILL     --  delete program."
       PRINT "LIST     --  display current program."
       PRINT "LOAD     --  read program from disk."
       PRINT "NEW      --  erase current program."
       PRINT "PRINT    --  print current program."
       PRINT "QUIT     --  exit SIC interpreter."
       PRINT "RENUMBER --  renumber program."
       PRINT "RUN      --  start current program."
       PRINT "SAVE     --  store current program."
       PRINT "SEARCH   --  search program for keyword."
       PRINT "SHELL    --  exit to dos shell."
       PRINT "WHATIS   --  enter immediate mode."
       CALL Key.Prompt
    CASE "2"
       Filename = "sic.doc"
       CALL List.Help.File
    CASE "3"
       Filename = "sicform.doc"
       CALL List.Help.File
    CASE "4"
       Filename = "sicscrn.doc"
       CALL List.Help.File
    CASE "5"
       Filename = "error.doc"
       CALL List.Help.File
    CASE "6"
       Filename = "syntax.doc"
       CALL List.Help.File
    CASE "7"
       Filename = "boolean.doc"
       CALL List.Help.File
    CASE "8"
       Filename = "troolean.doc"
       CALL List.Help.File
    CASE "9"
       Filename = "disclaim.doc"
       CALL List.Help.File
    CASE "a"
       Filename = "disclam2.doc"
       CALL List.Help.File
    CASE "q"
       EXIT DO
    END SELECT
 LOOP
END SUB

' displays a help file
SUB List.Help.File
 Call Find.File(Help.Filename$,File.Found)
 IF File.Found = False THEN
    PRINT "Helpfile "; CHR$(34); Filename; CHR$(34); " not found."
    PRINT "Set environment path variable to point at SIC files."
    CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
    EXIT SUB
 END IF
 X = FreeFileNumber
 OPEN Help.Filename$ FOR INPUT AS #FileNumber
 Continuous = False
 Line.Count = False
 DO WHILE NOT EOF(FileNumber)
    COLOR Yellow, Black
    LINE INPUT #FileNumber, Input.Line$
    PRINT Input.Line$
    IF Continuous = False THEN
       Line.Count = Line.Count + 1
       IF Line.Count = PageLength THEN
	  Line.Count = False
	  CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
	  SELECT CASE Output.Char$
	  CASE "n"
	     EXIT DO
	  CASE "c"
	     Continuous = True
	  END SELECT
       END IF
    END IF
 LOOP
 CALL Key.Prompt
 CLOSE #FileNumber
 FileNumber = False
END SUB

' lists current .sic program
SUB List.Program(Start.Line, Stop.Line, Print.Prog)
 COLOR White, Black
 IF Print.Prog THEN
    CALL More.Prompt("Printer number(1-4,q)?", "1234q", Output.Char$)
    IF Output.Char$ = "q" THEN
       EXIT SUB
    END IF
    Print.Number = INT(VAL(Output.Char$))
    X = FreeFileNumber
    OPEN "LPT"+MID$(STR$(Print.Number), 2) + ":" FOR OUTPUT AS #FileNumber
 END IF
 IF Print.Prog THEN
    PRINT #FileNumber, "Program: ";Program.Name
 ELSE
    PRINT "Program: ";Program.Name
 END IF
 Continuous.Display = False
 Line.Count = 1
 FOR Program.Line = Start.Line TO Stop.Line
    Out2 = Program(Program.Line)
    IF LEN(Out2) THEN
       COLOR Yellow, Black
       IF Print.Prog THEN
          IF INSTR(White.Space, LEFT$(Out2, 1)) THEN
             PRINT #FileNumber, MID$(STR$(Program.Line), 2) + Out2
          ELSE
             PRINT #FileNumber, MID$(STR$(Program.Line), 2) + " " + Out2
          END IF
       ELSE
          IF INSTR(White.Space, LEFT$(Out2, 1)) THEN
             PRINT ">";MID$(STR$(Program.Line), 2) + Out2
          ELSE
             PRINT ">";MID$(STR$(Program.Line), 2) + " " + Out2
          END IF
       END IF
       IF Print.Prog = False THEN
          IF Continuous.Display = False THEN
             Line.Count = Line.Count + 1
             IF Line.Count = PageLength THEN
                Line.Count = False
                CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
                SELECT CASE Output.Char$
                CASE "n"
                   EXIT FOR
                CASE "c"
                   Continuous.Display = True
                END SELECT
             END IF
          END IF
       END IF
    END IF
 NEXT
 COLOR White, Black
 PRINT "Program list ended."
 IF Print.Prog THEN
    CLOSE #FileNumber
    FileNumber = False
 END IF
END SUB

' searchs current .sic program
SUB Search.Program
 CALL Count.Lines(Last.Line)
 COLOR White, Black
 IF Last.Search.Line > False THEN
    CALL More.Prompt("Continue search(y/n)?", "yn", Output.Char$)
    IF Output.Char$ = "y" THEN
       Var1 = Last.Search.Case
       Var1$ = Last.Search.Keyword
       Start.Line = Last.Search.Line + 1
       IF Start.Line > Max.Lines THEN
          COLOR White, Black
          PRINT "Program search ended."
          EXIT SUB
       END IF
       PRINT "Continuing search from line:" + STR$(Start.Line)
       GOTO Start.Search
    END IF
 END IF
 DO
    Var = ClearBreak
    Program.Line = False
    Visible = 1
    COLOR Yellow, Black
    LOCATE , 1, 1
    PRINT "Search string?";
    LOCATE , , 1
    Out2 = RTRIM$(KeyboardLine$)
    PRINT
    IF BreakIS THEN
       COLOR Red, Black
       PRINT "*break*"
    ELSE
       IF Out2 <> Nul THEN
          EXIT DO
       END IF
    END IF
 LOOP
 Var1$ = Out2
 CALL More.Prompt("Case-sensitive(y/n)?", "yn", Output.Char$)
 IF Output.Char$ = "y" THEN
    Var1 = True
 ELSE
    Var1 = False
 END IF
 Start.Line = 1
Start.Search:
 PRINT "Searching Program: ";Program.Name
 FOR Program.Line = Start.Line TO Last.Line
    Out2 = Program(Program.Line)
    IF LEN(Out2) THEN
       Flag = False
       IF Var1 THEN
          IF INSTR(Out2, Var1$) THEN
             Flag = True
          END IF
       ELSE
          IF INSTR(UCASE$(Out2), UCASE$(Var1$)) THEN
             Flag = True
          END IF
       END IF
       IF Flag THEN
          COLOR Yellow, Black
          IF INSTR(White.Space, LEFT$(Out2, 1)) THEN
             PRINT ">";MID$(STR$(Program.Line), 2) + Out2
          ELSE
             PRINT ">";MID$(STR$(Program.Line), 2) + " " + Out2
          END IF
          CALL More.Prompt("More(y/n)?", "yn", Output.Char$)
          IF Output.Char$ = "n" THEN
             EXIT FOR
          END IF
       END IF
    END IF
 NEXT
 Last.Search.Case = Var1
 Last.Search.Line = Program.Line
 Last.Search.Keyword = Var1$
 COLOR White, Black
 PRINT "Program search ended."
END SUB

' loads a .sic file
SUB Load.Program(Temp.Name$)
 IF SaveOnExit THEN
    CALL Save.Current
 END IF
 IF Temp.Name$ = Nul THEN
    COLOR White, Black
    PRINT "Program name to load";
    INPUT Program.File$
 ELSE
    Program.File$ = Temp.Name$
 END IF
 IF Program.File$ = Nul THEN
    EXIT SUB
 END IF
 Call Concatenate(Program.File$)
 Filename = Program.File$
 Last.Search.Line = False
 CALL New.Program
 Program.Name = "<none>"
 CALL Read.Program
 Program.Name = Filename
 COLOR White, Black
 PRINT "Program loaded."
END SUB

' prompts for a keystroke
SUB Key.Prompt
 COLOR White, Black
 LOCATE , , 1
 PRINT "Press any key to continue:";
 Var$ = KeyboardChar$
 PRINT
END SUB

' prompts for multiple input characters
SUB More.Prompt (Input.String$, Input.Mask$, Output.String$)
 COLOR White, Black
 PRINT Input.String$; " ";
 Input.Char$ = Nul
 DO
    LOCATE , , 1
    Input.Char$ = LCASE$(KeyboardChar$)
    IF INSTR(Input.Mask$, Input.Char$) THEN
       PRINT Input.Char$
       Output.String$ = Input.Char$
       EXIT DO
    END IF
 LOOP
END SUB

' remove current .sic program from memory
SUB New.Program
 ' erase/redimension program code array
 ERASE Program
 REDIM Program(1 TO Max.Lines) AS STRING
END SUB

' end of .sic program routine
SUB End.Program
 If LastScreen1 <> 0 Then
    SCREEN 0, 1, 0, 0
 Else
    If LastScreen2 <> 1 Then
       SCREEN 0, 1, 0, 0
    Else
       If LastScreen3 <> 0 Or LastScreen4 <> 0 Then
          SCREEN 0, 1, 0, 0
       Endif
    Endif
 Endif
 If LastWidth1 <> 80 Then
    If LastWidth2 <> 25 Then
       WIDTH 80, 25
    Endif
 Endif
 COLOR Plain, Black
 LOCATE , , , 8, 8
 IF LineFeed THEN
    PRINT
 END IF
 IF Program.Resume <= False THEN
    Var = ClearBuffer
 END IF
 DEF SEG
 InDEFSEG = False
END SUB

' quit the Sic program
SUB Quit.Program
 LineFeed = False
 IF SaveOnExit THEN
    CALL Save.Current
 END IF
 CALL Key.Prompt
 CALL End.Program
 PRINT "Exiting to system.."
 CALL Stop.Program
END SUB

' stop Sic program/exit to dos
SUB Stop.Program
 ' Restore BASIC segment
 DEF SEG
 ' restore DOS PSP file handles
 CALL Decrease.PSP
 ' Restore old interrupt service routine
 CALL RestInt
 COLOR Plain, Black
 END
END SUB

' loads a program from disk
SUB Read.Program
 X = FreeFileNumber
 OPEN Filename FOR INPUT AS #FileNumber
 DO WHILE NOT EOF(FileNumber)
    LINE INPUT #FileNumber, Out2
    Out2 = STRIM$(Out2)
    FOR Blanks = 1 TO LEN(White.Space)
       Imbedded = INSTR(Out2, MID$(White.Space, Blanks, 1))
       IF Imbedded THEN
          Line.Number = INT(VAL(LEFT$(Out2, Imbedded - 1)))
          IF Line.Number > False AND Line.Number <= Max.Lines THEN
             Program(Line.Number) = MID$(Out2, Imbedded)
             EXIT FOR
          END IF
       END IF
    NEXT
 LOOP
 CLOSE #FileNumber
 FileNumber = False
END SUB

' gets standard input .sic file
SUB Read.Stdin
 ' check stdin length
 InregsX.AX = &H4202 ' eof
 InregsX.BX = 0 ' stdin
 InregsX.CX = 0
 InregsX.DX = 0
 Call InterruptX(&H21, InregsX, OutregsX)
 IF OutregsX.AX = 0 THEN ' no input found
    CALL RestInt
    Var$ = Inkey$
    CALL SetInt
    EXIT SUB
 END IF

 ' reset run type
 Program.Resume = 1
 CALL New.Program

 ' reset stdin start
 InregsX.AX = &H4200
 InregsX.BX = 0 ' stdin
 InregsX.CX = 0
 InregsX.DX = 0
 Call InterruptX(&H21, InregsX, OutregsX)

 ' loop while reading input
 DO

    ' read character from standard input
    InregsX.AX = &H3F00
    InregsX.BX = 0 ' stdin
    InregsX.CX = 1 ' char
    InregsX.DS = VARSEG(Pipe.Buffer)
    InregsX.DX = VARPTR(Pipe.Buffer)
    Call InterruptX(&H21, InregsX, OutregsX)
    If (OutregsX.Flags AND &H1) = &H1 Then
       Exit Do
    Endif
    If (OutregsX.Flags AND &H1) = &H0 Then
       If OutregsX.AX = 0 Then
          Exit Do
       Endif
       Char$ = Pipe.Buffer

       ' determine character type
       SELECT CASE ASC(Char$)
       CASE 0, 10, 26
       CASE 13
          Out2 = STRIM$(Out2)
          FOR Blanks = 1 TO LEN(White.Space)
             Imbedded = INSTR(Out2, MID$(White.Space, Blanks, 1))
             IF Imbedded THEN
                Line.Number = INT(VAL(LEFT$(Out2, Imbedded - 1)))
                IF Line.Number > False AND Line.Number <= Max.Lines THEN
                   Program(Line.Number) = MID$(Out2, Imbedded)
                   EXIT FOR
                END IF
             END IF
          NEXT
          Out2 = Nul
       CASE ELSE
          Out2 = Out2 + Char$
       END SELECT
    END IF
 LOOP

 ' run stdin program
 Run.Type=False
 CALL Run.Program(False)
 CALL Stop.Program
END SUB

' renumbers current .sic program
SUB Renumber.Program(Start.Value, Increment.Value)
 IF Start.Value = False OR Increment.Value = False THEN
    COLOR White, Black
    PRINT "Starting line number";
    INPUT Start.Line
    PRINT "Increment value";
    INPUT Increment
 ELSE
    Start.Line = Start.Value
    Increment = Increment.Value
 END IF
 Start.Line = INT(Start.Line)
 IF Start.Line <= False THEN
    PRINT "Bad start line value."
    EXIT SUB
 END IF
 IF Start.Line > Max.Lines THEN
    PRINT "Bad start line value."
    EXIT SUB
 END IF
 Increment = INT(Increment)
 IF Increment <= False THEN
    PRINT "Bad increment value."
    EXIT SUB
 END IF
 IF Increment > INT(Max.Lines / 2) THEN
    PRINT "Bad increment value."
    EXIT SUB
 END IF
 DO
    Temp.Filename$ = TempName$
    Filename = Temp.Filename$ + ".sc1"
    IF DIR$(Filename) = Nul THEN
       EXIT DO
    END IF
 LOOP
 CALL Store.Program
 CALL Count.Lines(Last.Line)
 REDIM Renumber.List(1 TO Max.Lines) AS INTEGER
 New.Line.Number = Start.Line
 FOR Line.Number = 1 TO Last.Line
    ProgramLine$ = Program(Line.Number)
    IF STRIM$(ProgramLine$) <> Nul THEN
       IF New.Line.Number > Max.Lines THEN
	  COLOR White, Black
	  PRINT "Renumber list exceeds"; STR$(Max.Lines); " lines."
	  ERASE Renumber.List
	  EXIT SUB
       END IF
       Renumber.List(New.Line.Number) = Line.Number
       New.Line.Number = New.Line.Number + Increment
    END IF
 NEXT
 PRINT "Renumbering program.."
 FOR Line.Number = 1 TO Last.Line
    New.Program.Line$ = Program(Line.Number)
    Old.Program.Line$ = Program(Line.Number)
    Old.Program.Line$ = STRIM$(Old.Program.Line$)
    Old.Program.Line$ = TTRIM$(Old.Program.Line$, True)
    IF Old.Program.Line$ <> Nul THEN
       Line.Renumbered = True
       IF UCASE$(LEFT$(Old.Program.Line$, 7)) = "RESTORE" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "RESTORE") + 7
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 8)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 4)) = "GOTO" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "GOTO") + 4
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 5)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 13)) = "ON ERROR GOTO" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "GOTO") + 4
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 14)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 6)) = "RESUME" THEN
	  IF UCASE$(LEFT$(Old.Program.Line$, 15)) <> "RESUME PREVIOUS" THEN
	     IF UCASE$(LEFT$(Old.Program.Line$, 11)) <> "RESUME SAME" THEN
		IF UCASE$(LEFT$(Old.Program.Line$, 11)) <> "RESUME NEXT" THEN
		   Line.Renumbered = False
                   Imbedded = INSTR(UCASE$(New.Program.Line$), "RESUME") + 6
                   GOSUB Next.Space
		   Number$ = MID$(Old.Program.Line$, 7)
		   Number$ = STRIM$(Number$)
		   Old.Line.Number = INT(VAL(Number$))
                   IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
                      FOR New.Line.Number = 1 TO Max.Lines
                         IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                            Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                            Line.Renumbered = True
                            EXIT FOR
                         END IF
                      NEXT
                   END IF
		END IF
	     END IF
	  END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 5)) = "GOSUB" THEN
	  Line.Renumbered = False
          Imbedded = INSTR(UCASE$(New.Program.Line$), "GOSUB") + 5
          GOSUB Next.Space
	  Number$ = MID$(Old.Program.Line$, 6)
	  Number$ = STRIM$(Number$)
	  Old.Line.Number = INT(VAL(Number$))
          IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
             FOR New.Line.Number = 1 TO Max.Lines
                IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                   Program(Line.Number) = Next.Program.Line$ + LTRIM$(STR$(New.Line.Number))
                   Line.Renumbered = True
                   EXIT FOR
                END IF
             NEXT
          END IF
       END IF
       IF UCASE$(LEFT$(Old.Program.Line$, 2)) = "ON" THEN
	  IF UCASE$(LEFT$(Old.Program.Line$, 8)) <> "ON ERROR" THEN
	     Line.Renumbered = False
             IF INSTR(UCASE$(Old.Program.Line$), "GOTO") THEN
                Imbedded = INSTR(UCASE$(New.Program.Line$), "GOTO") + 4
                Old.Number1$ = LTRIM$(MID$(New.Program.Line$, Imbedded))
                GOSUB Next.Space
                New.Program.Line1$ = Next.Program.Line$
                Imbedded2 = INSTR(UCASE$(Old.Program.Line$), "GOTO")
                Old.Number2$ = MID$(Old.Program.Line$, Imbedded2 + 4)
		DO
                   Imbedded1 = INSTR(Old.Number1$, ",")
                   IF Imbedded1 THEN
                      New.Number1$ = LEFT$(Old.Number1$, Imbedded1 - 1)
                      Old.Number1$ = MID$(Old.Number1$, Imbedded1 + 1)
		   ELSE
                      New.Number1$ = Old.Number1$
                      Old.Number1$ = Nul
		   END IF
                   IF INSTR(White.Space, MID$(New.Number1$, 1, 1)) THEN
                      Imbedded = 1
                      New.Program.Line$ = New.Number1$
                      GOSUB Next.Space
                      New.Number1$ = Next.Program.Line$
                   ELSE
                      New.Number1$ = Nul
                   END IF
                   Imbedded2 = INSTR(Old.Number2$, ",")
                   IF Imbedded2 THEN
                      New.Number2$ = LEFT$(Old.Number2$, Imbedded2 - 1)
                      Old.Number2$ = MID$(Old.Number2$, Imbedded2 + 1)
		   ELSE
                      New.Number2$ = Old.Number2$
                      Old.Number2$ = Nul
		   END IF
		   Line.Renumbered = False
                   Old.Line.Number = INT(VAL(New.Number2$))
                   IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
                      FOR New.Line.Number = 1 TO Max.Lines
                         IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                            New.Program.Line1$ = New.Program.Line1$ + New.Number1$ + LTRIM$(STR$(New.Line.Number)) + ","
                            Line.Renumbered = True
                            EXIT FOR
                         END IF
                      NEXT
                   END IF
                   IF Old.Number2$ = Nul THEN
		      EXIT DO
		   END IF
		   IF Line.Renumbered = False THEN
		      EXIT DO
		   END IF
		LOOP
                IF RIGHT$(New.Program.Line1$, 1) = "," THEN
                   New.Program.Line1$ = LEFT$(New.Program.Line1$, LEN(New.Program.Line1$) - 1)
                END IF
                Program(Line.Number) = New.Program.Line1$
	     ELSE
                IF INSTR(UCASE$(Old.Program.Line$), "GOSUB") THEN
                   Imbedded = INSTR(UCASE$(New.Program.Line$), "GOSUB") + 5
                   Old.Number1$ = LTRIM$(MID$(New.Program.Line$, Imbedded))
                   GOSUB Next.Space
                   New.Program.Line1$ = Next.Program.Line$
                   Imbedded2 = INSTR(UCASE$(Old.Program.Line$), "GOSUB")
                   Old.Number2$ = MID$(Old.Program.Line$, Imbedded2 + 5)
                   DO
                      Imbedded1 = INSTR(Old.Number1$, ",")
                      IF Imbedded1 THEN
                         New.Number1$ = LEFT$(Old.Number1$, Imbedded1 - 1)
                         Old.Number1$ = MID$(Old.Number1$, Imbedded1 + 1)
                      ELSE
                         New.Number1$ = Old.Number1$
                         Old.Number1$ = Nul
                      END IF
                      IF INSTR(White.Space, MID$(New.Number1$, 1, 1)) THEN
                         Imbedded = 1
                         New.Program.Line$ = New.Number1$
                         GOSUB Next.Space
                         New.Number1$ = Next.Program.Line$
                      ELSE
                         New.Number1$ = Nul
                      END IF
                      Imbedded2 = INSTR(Old.Number2$, ",")
                      IF Imbedded2 THEN
                         New.Number2$ = LEFT$(Old.Number2$, Imbedded2 - 1)
                         Old.Number2$ = MID$(Old.Number2$, Imbedded2 + 1)
                      ELSE
                         New.Number2$ = Old.Number2$
                         Old.Number2$ = Nul
                      END IF
                      Line.Renumbered = False
                      Old.Line.Number = INT(VAL(New.Number2$))
                      IF Old.Line.Number > False AND Old.Line.Number <= Max.Lines THEN
                         FOR New.Line.Number = 1 TO Max.Lines
                            IF Renumber.List(New.Line.Number) = Old.Line.Number THEN
                               New.Program.Line1$ = New.Program.Line1$ + New.Number1$ + LTRIM$(STR$(New.Line.Number)) + ","
                               Line.Renumbered = True
                               EXIT FOR
                            END IF
                         NEXT
                      END IF
                      IF Old.Number2$ = Nul THEN
                         EXIT DO
                      END IF
                      IF Line.Renumbered = False THEN
                         EXIT DO
                      END IF
                   LOOP
                   IF RIGHT$(New.Program.Line1$, 1) = "," THEN
                      New.Program.Line1$ = LEFT$(New.Program.Line1$, LEN(New.Program.Line1$) - 1)
                   END IF
                   Program(Line.Number) = New.Program.Line1$
                END IF
	     END IF
	  END IF
       END IF
       IF Line.Renumbered = False THEN
	  COLOR White, Black
          PRINT "Error renumbering program: line";Line.Number
          Filename = Temp.Filename$ + ".sc1"
	  CALL Read.Program
	  COLOR White, Black
	  PRINT "Program reloaded."
          KILL Filename
	  ERASE Renumber.List
	  EXIT SUB
       END IF
    END IF
 NEXT
 PRINT "Resequencing line numbers.."
 Filename = Temp.Filename$ + ".sc1"
 CALL Store.Program
 X = FreeFileNumber
 OPEN Filename FOR INPUT AS #FileNumber
 CALL New.Program
 WHILE NOT EOF(FileNumber)
    LINE INPUT #FileNumber, New.Program.Line$
    FOR Blanks = 1 TO LEN(White.Space)
       Imbedded = INSTR(New.Program.Line$, MID$(White.Space, Blanks, 1))
       IF Imbedded THEN
          EXIT FOR
       END IF
    NEXT
    Old.Line.Number = INT(VAL(LEFT$(New.Program.Line$, Imbedded - 1)))
    FOR New.Program.Line = 1 TO Max.Lines
       IF Renumber.List(New.Program.Line) = Old.Line.Number THEN
          Program(New.Program.Line) = MID$(New.Program.Line$, Imbedded)
	  EXIT FOR
       END IF
    NEXT
 WEND
 CLOSE #FileNumber
 FileNumber = False
 COLOR White, Black
 PRINT "Program renumbered."
 KILL Filename
 ERASE Renumber.List
 EXIT SUB
' locates string with following white spaces
Next.Space:
 Next.Program.Line$ = New.Program.Line$
 DO
    IF Imbedded >= LEN(Next.Program.Line$) THEN
       EXIT DO
    END IF
    IF INSTR(White.Space, MID$(Next.Program.Line$, Imbedded + 1, 1)) THEN
       Imbedded = Imbedded + 1
    ELSE
       EXIT DO
    END IF
 LOOP
 Next.Program.Line$ = LEFT$(Next.Program.Line$, Imbedded)
 RETURN
END SUB

' starts current .sic program
SUB Run.Program(Start.Line)
 ' check to continue halted program.
 IF Run.Type THEN
    COLOR Plain, Black
    GOTO RunProg
 END IF

 ' close any files
 CLOSE

 ' try to release any memory
 Var! = FRE(-1)
 Var! = FRE("A")

 ' store current drive/directory
 CurrentDirectory = CURDIR$

 ' restore run variables
 DataLine = 1
 DataNumber = False
 ErrorLine = False
 ErrorType = False
 ErrorValue = False
 Nested.Gosub = False
 Max.Gosubs = 10
 ScreenMode = 0
 ScreenHeight = 25
 ScreenWidth = 80
 Visible = 1
 COLOR Plain, Black

 ' clear runtime arrays
 REDIM GosubReturn(1 TO 10) AS INTEGER
 FOR Count1 = 1 TO 26
    Variables(Count1) = Dfalse
    Strngs(Count1) = Nul
    FOR Count2 = 1 TO Max.Arrays
       Arrays(Count1, Count2) = Dfalse
    NEXT
 NEXT
 FOR Count1 = 1 TO Max.Functions
    Definitions(Count1) = Nul
 NEXT

 ' start program processing loop.
RunProg:

 ' start program execution
 CALL Prepare.Program

 ' check starting line number
 CALL Count.Lines(Last.Line)

 ' check to continue halted program.
 IF Run.Type THEN
    ' restore last program line processed.
    Program.Line = Run.Line
 END IF

 ' check to continue halted program.
 IF Run.Type = False THEN
    Program.Line = False
    IF Start.Line THEN
       IF Start.Line > False AND Start.Line <= Last.Line THEN
          IF LEN(STRIM$(Program(Start.Line))) THEN
             Program.Line = Start.Line - 1
          ELSE
             GOTO Run.Error
          END IF
       ELSE
          GOTO Run.Error
       END IF
    END IF
 END IF

 ' clear Control-Break flag
 Var = ClearBreak

 ' reset segment flag
 IF Run.Type THEN
    InDEFSEG = InDEFSEG2
 ELSE
    InDEFSEG = False
    InDEFSEG2 = False
 END IF

 ' reset colors
 IF Run.Type THEN
    COLOR LastColor1, LastColor2
 ELSE
    LastColor1 = Plain
    LastColor2 = Black
 END IF

 ' reset screen width
 IF Run.Type THEN
    WIDTH LastWidth1, LastWidth2
 ELSE
    LastWidth1 = 80
    LastWidth2 = 25
 END IF

 ' reset screen mode
 IF Run.Type THEN
    SCREEN LastScreen1, LastScreen2, LastScreen3, LastScreen4
 ELSE
    LastScreen1 = 0
    LastScreen2 = 1
    LastScreen3 = 0
    LastScreen4 = 0
 END IF

 ' reset cursor size
 IF Run.Type THEN
    LOCATE , , LastCursor1, LastCursor2, LastCursor3
 ELSE
    LastCursor1 = 1
    LastCursor2 = 8
    LastCursor3 = 8
 END IF

 ' start program flow
 Break.Flag1 = False
 Break.Flag2 = False
 Break.Flag3 = False
 Break.Flag4 = False
 Break.Flag5 = False
 Break.Flag6 = False
 Break.Flag7 = False

 ' check for break variables
 FOR VarBreak = 1 TO 26
    IF VariableBreak(VarBreak) THEN
       ' store first break variable
       Break.Flag3 = VarBreak
       EXIT FOR
    END IF
 NEXT

 ' check for break variables
 FOR VarBreak = 1 TO 26
    IF LEN(VariableBreak2(VarBreak))<>False THEN
       ' store first break variable
       Break.Flag5 = VarBreak
       EXIT FOR
    END IF
 NEXT

 ' check for break variables
 FOR VarBreak = 1 TO 26
    FOR VarBreak2 = 1 TO Max.Arrays
       IF VariableBreak3(VarBreak, VarBreak2) THEN
          ' store first break variable
          Break.Flag7 = VarBreak
          EXIT FOR
       END IF
    NEXT
    IF Break.Flag7 THEN
       EXIT FOR
    END IF
 NEXT

 ' start program loop
 DO
    ' check Control-Break flag
    IF BreakIS THEN
       EXIT DO
    END IF

    ' increment program flow
    Program.Line = Program.Line + 1
    IF Program.Line > Last.Line THEN
       Program.Line = Max.Lines + 1
    END IF
    IF Program.Line > Max.Lines THEN
       EXIT DO
    END IF

    ' test break lines
    IF LEN(Program(Program.Line))<>False THEN
       IF LineBreak(Program.Line) THEN
          Break.Flag1 = True
          EXIT DO
       END IF
    END IF

    ' process the program line
    Out2 = STRIM$(Program(Program.Line))
    IF LEN(Out2) THEN

       ' clear recurse flag
       Recurse = 0

       ' enter the parser
       CALL Enter.Equate

       ' test break variables
       IF Break.Flag3 THEN
          GOSUB Test.Break1
          IF Break.Flag2 THEN
             EXIT DO
          END IF
       END IF

       ' test break variables
       IF Break.Flag5 THEN
          GOSUB Test.Break2
          IF Break.Flag4 THEN
             EXIT DO
          END IF
       END IF

       ' test break variables
       IF Break.Flag7 THEN
          GOSUB Test.Break3
          IF Break.Flag6 THEN
             EXIT DO
          END IF
       END IF
    END IF
 LOOP

 ' store last program line processed.
 Run.Line = Program.Line

 ' store segment flag.
 InDEFSEG2 = InDEFSEG

 ' end program parsing
 CALL End.Program

 ' stop processing program
 Program.Line = Max.Lines

 ' display any break messages
 IF Break.Flag1 THEN
    PRINT "*line break*"
    PRINT "Line:" + STR$(Run.Line) + "."
 END IF
 IF Break.Flag2 THEN
    PRINT "*variable break*"
    PRINT "Line:" + STR$(Run.Line) + "."
    PRINT "Variable: " + CHR$(VarBreak + 64)
    PRINT "Test: " + Symbol$ + " " + LTRIM$(STR$(VariableValue(VarBreak)))
    PRINT "Value: " + LTRIM$(STR$(Variables(VarBreak)))
 END IF
 IF Break.Flag4 THEN
    PRINT "*variable break*"
    PRINT "Line:" + STR$(Run.Line) + "."
    PRINT "Variable: " + CHR$(VarBreak + 64) + "$"
    IF LEN(VariableValue2(VarBreak)) > 40 THEN
       PRINT "Test: " + Symbol$ + " " + CHR$(34) + LEFT$(VariableValue2(VarBreak), 40) + "..."
    ELSE
       PRINT "Test: " + Symbol$ + " " + CHR$(34) + VariableValue2(VarBreak) + CHR$(34)
    END IF
    IF LEN(Strngs(VarBreak)) > 40 THEN
       PRINT "Value: " + CHR$(34) + LEFT$(Strngs(VarBreak), 40) + "..."
    ELSE
       PRINT "Value: " + CHR$(34) + Strngs(VarBreak) + CHR$(34)
    END IF
 END IF
 IF Break.Flag6 THEN
    PRINT "*variable break*"
    PRINT "Line:" + STR$(Run.Line) + "."
    PRINT "Variable: " + CHR$(VarBreak + 64) + "(" + MID$(STR$(VarBreak2), 2) + ")"
    PRINT "Test: " + Symbol$ + " " + LTRIM$(STR$(VariableValue3(VarBreak, VarBreak2)))
    PRINT "Value: " + " " + LTRIM$(STR$(Arrays(VarBreak, VarBreak2)))
 END IF
 IF ControlBreak THEN
    IF Program.Resume <= False THEN
       COLOR Red, Black
       PRINT "*break*"
    END IF
 END IF

 ' restore current drive/directory/program
 CHDRIVE CurrentDirectory
 CHDIR CurrentDirectory
 GOSUB Read.Prog
 EXIT SUB

' exit with error
Run.Error:
 GOSUB Read.Prog
 ERROR 145
 EXIT SUB

' read original program
Read.Prog:
 CALL New.Program
 Filename = Prepare.Filename
 CALL Read.Program
 KILL Prepare.Filename
 RETURN

Test.Break1:
 ' start with first break variable
 FOR VarBreak = Break.Flag3 TO 26
    IF VariableBreak(VarBreak) THEN
       SELECT CASE VariableBreak(VarBreak)
       CASE -1
          IF Variables(VarBreak) = VariableValue(VarBreak) THEN
             Break.Flag2 = True
             Symbol$ = "="
             RETURN
          END IF
       CASE 1
          IF Variables(VarBreak) <> VariableValue(VarBreak) THEN
             Break.Flag2 = True
             Symbol$ = "<>"
             RETURN
          END IF
       CASE 2
          IF Variables(VarBreak) > VariableValue(VarBreak) THEN
             Break.Flag2 = True
             Symbol$ = ">"
             RETURN
          END IF
       CASE 3
          IF Variables(VarBreak) >= VariableValue(VarBreak) THEN
             Break.Flag2 = True
             Symbol$ = ">="
             RETURN
          END IF
       CASE 4
          IF Variables(VarBreak) < VariableValue(VarBreak) THEN
             Break.Flag2 = True
             Symbol$ = "<"
             RETURN
          END IF
       CASE 5
          IF Variables(VarBreak) <= VariableValue(VarBreak) THEN
             Break.Flag2 = True
             Symbol$ = "<="
             RETURN
          END IF
       END SELECT
    END IF
 NEXT
 RETURN

Test.Break2:
 ' start with first break variable
 FOR VarBreak = Break.Flag5 TO 26
    IF VariableBreak2(VarBreak) THEN
       SELECT CASE VariableBreak2(VarBreak)
       CASE -1
          IF Strngs(VarBreak) = VariableValue2(VarBreak) THEN
             Break.Flag4 = True
             Symbol$ = "="
             RETURN
          END IF
       CASE 1
          IF Strngs(VarBreak) <> VariableValue2(VarBreak) THEN
             Break.Flag4 = True
             Symbol$ = "<>"
             RETURN
          END IF
       CASE 2
          IF Strngs(VarBreak) > VariableValue2(VarBreak) THEN
             Break.Flag4 = True
             Symbol$ = ">"
             RETURN
          END IF
       CASE 3
          IF Strngs(VarBreak) >= VariableValue2(VarBreak) THEN
             Break.Flag4 = True
             Symbol$ = ">="
             RETURN
          END IF
       CASE 4
          IF Strngs(VarBreak) < VariableValue2(VarBreak) THEN
             Break.Flag4 = True
             Symbol$ = "<"
             RETURN
          END IF
       CASE 5
          IF Strngs(VarBreak) <= VariableValue2(VarBreak) THEN
             Break.Flag4 = True
             Symbol$ = "<="
             RETURN
          END IF
       END SELECT
    END IF
 NEXT
 RETURN

Test.Break3:
 ' start with first break variable
 FOR VarBreak = Break.Flag7 TO 26
    FOR VarBreak2 = 1 TO Max.Arrays
       IF VariableBreak3(VarBreak, VarBreak2) THEN
          SELECT CASE VariableBreak3(VarBreak, VarBreak2)
          CASE -1
             IF Arrays(VarBreak, VarBreak2) = VariableValue3(VarBreak, VarBreak2) THEN
                Break.Flag6 = True
                Symbol$ = "="
                RETURN
             END IF
          CASE 1
             IF Arrays(VarBreak, VarBreak2) <> VariableValue3(VarBreak, VarBreak2) THEN
                Break.Flag6 = True
                Symbol$ = "<>"
                RETURN
             END IF
          CASE 2
             IF Arrays(VarBreak, VarBreak2) > VariableValue3(VarBreak, VarBreak2) THEN
                Break.Flag6 = True
                Symbol$ = ">"
                RETURN
             END IF
          CASE 3
             IF Arrays(VarBreak, VarBreak2) >= VariableValue3(VarBreak, VarBreak2) THEN
                Break.Flag6 = True
                Symbol$ = ">="
                RETURN
             END IF
          CASE 4
             IF Arrays(VarBreak, VarBreak2) < VariableValue3(VarBreak, VarBreak2) THEN
                Break.Flag6 = True
                Symbol$ = "<"
                RETURN
             END IF
          CASE 5
             IF Arrays(VarBreak, VarBreak2) <= VariableValue3(VarBreak, VarBreak2) THEN
                Break.Flag6 = True
                Symbol$ = "<="
                RETURN
             END IF
          END SELECT
       END IF
    NEXT
 NEXT
 RETURN
END SUB

' prompts to store current .sic program
SUB Save.Current
 IF Program.Name <> "<none>" THEN
    CALL More.Prompt("Save current program(y/n)?", "yn", Output.Char$)
    IF Output.Char$ = "y" THEN
       CALL Save.Program(Nul)
    END IF
 END IF
END SUB

' stores current .sic program
SUB Save.Program(Temp.Name$)
 DO
    IF Temp.Name$ <> Nul THEN
       Program.File$ = Temp.Name$
    END IF
    IF Temp.Name$ = Nul Then
       DO
          COLOR White, Black
          PRINT "Program name to save";
          IF Program.Name <> "<untitled>" THEN
             COLOR White, Black
             PRINT "("; Program.Name; ")";
          END IF
          INPUT Program.File$
          IF Program.File$ <> Nul THEN
             EXIT DO
          END IF
          IF Program.File$ = Nul THEN
             IF Program.Name <> "<untitled>" THEN
                Program.File$ = Program.Name
                EXIT DO
             END IF
          END IF
       LOOP
    END IF
    Call Concatenate(Program.File$)
    Filename = Program.File$
    IF Temp.Name$ = Nul THEN
       COLOR White, Black
       PRINT "Save program as "; CHR$(34); Filename; CHR$(34);
       CALL More.Prompt("(y/n/q)?", "ynq", Output.Char$)
    ELSE
       Output.Char$ = "y"
    END IF
    SELECT CASE Output.Char$
    CASE "y"
       IF Temp.Name$ = Nul THEN
          Output.Char$ = "y"
          IF DIR$(Filename) <> Nul THEN
             PRINT "Program already exists. ";
             CALL More.Prompt("Overwrite(y/n)?", "yn", Output.Char$)
          END IF
       ELSE
          Output.Char$ = "y"
       END IF
       IF Output.Char$ = "y" THEN
          ErrorValue = False
	  CALL Store.Program
          If ErrorValue = False Then
             Program.Name = Program.File$
             COLOR White, Black
             PRINT "Program "; CHR$(34); Filename; CHR$(34); " saved to disk."
          Endif
	  EXIT DO
       END IF
    CASE "q"
       COLOR White, Black
       PRINT "Program not saved to disk."
       EXIT DO
    END SELECT
 LOOP
END SUB

' writes out the current .sic program to file
SUB Store.Program
 X = FreeFileNumber
 OPEN Filename FOR OUTPUT AS #FileNumber
 CALL Count.Lines(Last.Line)
 FOR Line.Number = 1 TO Last.Line
    ProgramLine$ = Program(Line.Number)
    IF STRIM$(ProgramLine$) <> Nul THEN
       IF INSTR(White.Space, LEFT$(ProgramLine$, 1)) THEN
          PRINT #FileNumber, MID$(STR$(Line.Number), 2) + ProgramLine$
       ELSE
          PRINT #FileNumber, MID$(STR$(Line.Number), 2) + " " + ProgramLine$
       END IF
    END IF
 NEXT
 CLOSE #FileNumber
 FileNumber = False
END SUB

' immediate debugging prompt.
SUB Debug.Command
 ControlBreak = False
 COLOR White, Black
 PRINT "Type 'Quit' to exit Debug mode."
 PRINT "Or type ? for brief command list."
 DO
StartDebug:
    Var = ClearBreak
    Visible = 1
    COLOR Yellow, Black
    LOCATE , 1, 1
    PRINT "?";
    LOCATE , , 1
    Out2 = KeyboardLine$
    PRINT
    IF BreakIS THEN
       COLOR Red, Black
       PRINT "*break*"
       GOTO StartDebug
    END IF
    ' test 2-byte shortcuts
    IF LEN(Out2) >= 2 THEN
       SELECT CASE UCASE$(LEFT$(Out2, 2))
       CASE "SB"
          Out2 = "SETBREAK" + MID$(Out2, 3)
       CASE "CB"
          Out2 = "CLEARBREAK" + MID$(Out2, 3)
       CASE "LB"
          Out2 = "LISTBREAKS" + MID$(Out2, 3)
       CASE "CA"
          Out2 = "CLEARALLBREAKS" + MID$(Out2, 3)
       CASE "SV"
          Out2 = "SETVARIABLE" + MID$(Out2, 3)
       CASE "CV"
          Out2 = "CLEARVARIABLE" + MID$(Out2, 3)
       CASE "TV"
          Out2 = "TOGGLEVARIABLE" + MID$(Out2, 3)
       CASE "LV"
          Out2 = "LISTVARIABLES" + MID$(Out2, 3)
       CASE "AV"
          Out2 = "CLEARALLVARIABLES" + MID$(Out2, 3)
       END SELECT
    END IF
    ' parse debug commands
    IF LEFT$(UCASE$(Out2),8) = "SETBREAK" THEN
       GOSUB Set.Break
       GOTO StartDebug
    END IF
    IF LEFT$(UCASE$(Out2),10) = "CLEARBREAK" THEN
       GOSUB Clear.Break
       GOTO StartDebug
    END IF
    IF LEFT$(UCASE$(Out2),11) = "SETVARIABLE" THEN
       GOSUB Set.Variable
       GOTO StartDebug
    END IF
    IF LEFT$(UCASE$(Out2),13) = "CLEARVARIABLE" THEN
       GOSUB Clear.Variable
       GOTO StartDebug
    END IF
    IF LEFT$(UCASE$(Out2),14) = "TOGGLEVARIABLE" THEN
       GOSUB Toggle.Variable
       GOTO StartDebug
    END IF
    IF UCASE$(Out2) = "CLEARALLBREAKS" THEN
       GOSUB Clear.All.Breaks
       GOTO StartDebug
    END IF
    IF UCASE$(Out2) = "CLEARALLVARIABLES" THEN
       GOSUB Clear.All.Variables
       GOTO StartDebug
    END IF
    IF UCASE$(Out2) = "LISTVARIABLES" THEN
       GOSUB Display.Variables
       GOTO StartDebug
    END IF
    IF UCASE$(Out2) = "LISTBREAKS" THEN
       GOSUB Display.Breaks
       GOTO StartDebug
    END IF
    IF UCASE$(Out2) = "QUIT" THEN
       EXIT DO
    END IF
    ' list commands
    IF Out2 = "?" THEN
       COLOR Yellow, Black
       PRINT "Brief list of Debug commands:"
       PRINT "<command>         <shortcut>"
       COLOR White, Black
       PRINT "SETBREAK <l>        --  SB"
       PRINT "CLEARBREAK <l>      --  CB"
       PRINT "LISTBREAKS          --  LB"
       PRINT "CLEARALLBREAKS      --  CA"
       PRINT "SETVARIABLE <x>, n  --  SV
       PRINT "CLEARVARIABLE <x>   --  CV"
       PRINT "TOGGLEVARIABLE <x>  --  TV"
       PRINT "LISTVARIABLES       --  LV"
       PRINT "CLEARALLVARIABLES   --  AV"
       GOTO StartDebug
    END IF
    ' parse whatis
    IF Out2 <> Nul THEN
       COLOR Plain, Black
       Out2 = TTRIM$(Out2, True)
       ' clear recurse flag
       Recurse = 0
       ' start the parser
       CALL Enter.Equate
       IF LineFeed THEN
          PRINT
       END IF
    END IF
 LOOP
 CALL End.Program
 COLOR White, Black
 PRINT "Debug mode ended."
 EXIT SUB

Display.Variables:
 Line.Count = False
 Line.Flag = False
 FOR Var = 1 TO 26
    ' display break variables 
    IF VariableBreak(Var) THEN
       ' check page length
       GOSUB Check.Title
       COLOR Yellow, Black
       PRINT " "; CHR$(Var + 64); "        ";
       BreakSign = VariableBreak(Var)
       GOSUB Get.Sign
       PRINT Symbol$; "   ";
       PRINT STR$(VariableValue(Var))
       Line.Flag = True
    END IF

    ' check page length
    IF Line.Count = PageLength - 2 THEN
       GOSUB Check.Page
       CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
       SELECT CASE Output.Char$
       CASE "n"
          RETURN
       CASE "c"
          Continuous.Display = True
       END SELECT
    END IF
 NEXT
 FOR Var = 1 TO 26
    ' display break variables 
    IF VariableBreak2(Var) THEN
       ' check page length
       GOSUB Check.Title
       COLOR Yellow, Black
       PRINT " "; CHR$(Var + 64); "$       ";
       BreakSign = VariableBreak2(Var)
       GOSUB Get.Sign
       PRINT Symbol$; "   ";
       IF LEN(VariableValue2(Var)) > 40 THEN
          PRINT CHR$(34) + LEFT$(VariableValue2(Var), 40) + "..."
       ELSE
          PRINT CHR$(34) + VariableValue2(Var) + CHR$(34)
       END IF
       Line.FLag = True
    END IF

    ' check page length
    IF Line.Count = PageLength - 2 THEN
       GOSUB Check.Page
       SELECT CASE Output.Char$
       CASE "n"
          RETURN
       CASE "c"
          Continuous.Display = True
       END SELECT
    END IF
 NEXT
 FOR Var = 1 TO 26
    FOR Var2 = 1 TO Max.Arrays
       ' display break variables 
       IF VariableBreak3(Var, Var2) THEN
          ' check page length
          GOSUB Check.Title
          COLOR Yellow, Black
          PRINT " "; CHR$(Var + 64); "("; MID$(STR$(Var2), 2); ")   ";
          BreakSign = VariableBreak3(Var, Var2)
          GOSUB Get.Sign
          PRINT Symbol$; "   ";
          PRINT STR$(VariableValue3(Var, Var2))
          Line.Flag = True
       END IF

       ' check page length
       IF Line.Count = PageLength - 2 THEN
          GOSUB Check.Page
          CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
          SELECT CASE Output.Char$
          CASE "n"
             RETURN
          CASE "c"
             Continuous.Display = True
          END SELECT
       END IF
    NEXT
 NEXT
 IF Line.Flag = False THEN
    COLOR White, Black
    PRINT "No variable breaks set."
 END IF
 RETURN

Display.Breaks:
 Line.Count = False
 Line.Flag = False
 FOR Var = 1 TO Max.Lines
    ' display break variables 
    IF LineBreak(Var) THEN
       ' check page length
       Line.Count = Line.Count + 1
       IF Continuous.Display = False THEN
          IF Line.Count = 1 THEN
             COLOR White, Black
             PRINT "Line Number"
             PRINT "-----------"
          END IF
       END IF
       COLOR Yellow, Black
       PRINT STR$(Var)
       Line.Flag = True
    END IF

    ' check page length
    IF Line.Count = PageLength - 2 THEN
       GOSUB Check.Page
       SELECT CASE Output.Char$
       CASE "n"
          RETURN
       CASE "c"
          Continuous.Display = True
       END SELECT
    END IF
 NEXT
 IF Line.Flag = False THEN
    COLOR White, Black
    PRINT "No line breaks set."
 END IF
 RETURN

Check.Page:
 Line.Count = False
 IF Continuous.Display = False THEN
    CALL More.Prompt("More(y/n/c)?", "ync", Output.Char$)
 END IF
 RETURN

Check.Title:
 Line.Count = Line.Count + 1
 IF Continuous.Display = False THEN
    IF Line.Count = 1 THEN
       COLOR White, Black
       PRINT "Variable  Sign Value"
       PRINT "--------------------"
    END IF
 END IF
 RETURN

Get.Sign:
 SELECT CASE BreakSign
 CASE -1
    Symbol$ = "= "
 CASE 1
    Symbol$ = "<>"
 CASE 2
    Symbol$ = "> "
 CASE 3
    Symbol$ = ">="
 CASE 4
    Symbol$ = "< "
 CASE 5
    Symbol$ = "<="
 END SELECT
 RETURN

Set.Break:
 BreakLine = INT(VAL(MID$(Out2,9)))
 IF BreakLine >= False AND BreakLine <= Max.Lines THEN
    LineBreak(BreakLine) = True
    COLOR White, Black
    PRINT "Break line"+STR$(BreakLine)+" set."
    RETURN
 END IF
 COLOR White, Black
 PRINT "Unknown line."
 RETURN

Clear.Break:
 BreakLine = INT(VAL(MID$(Out2,11)))
 IF BreakLine >= False AND BreakLine <= Max.Lines THEN
    LineBreak(BreakLine) = False
    COLOR White, Black
    PRINT "Break line"+STR$(BreakLine)+" cleared."
    RETURN
 END IF
 COLOR White, Black
 PRINT "Unknown line."
 RETURN

Set.Variable:
 Var$ = MID$(Out2,12)
 Var$ = LTRIM$(Var$)
 Var2$ = LEFT$(Var$, 1)
 Var2$ = UCASE$(Var2$)
 IF Var2$>="A" AND Var2$<="Z" THEN
    BreakVar = ASC(Var2$)-64
    Var$ = MID$(Var$, 2)
    Var$ = LTRIM$(Var$)
    IF LEFT$(Var$, 1) = "(" THEN
       Imbedded = INSTR(Var$, ")")
       IF Imbedded THEN
          Var2$ = LEFT$(Var$, Imbedded - 1)
          Var2$ = MID$(Var2$, 2)
          BreakVar2 = INT(VAL(Var2$))
          IF BreakVar2 >= 1 AND BreakVar2 <= Max.Arrays THEN
             Var$ = MID$(Var$, Imbedded + 1)
             Var$ = LTRIM$(Var$)
             IF LEFT$(Var$, 1) = "," THEN
                BreakVar3# = VAL(MID$(Var$, 2))
                VariableBreak3(BreakVar, BreakVar2) = True
                VariableValue3(BreakVar, BreakVar2) = BreakVar3#
                COLOR White, Black
                PRINT "Break variable "+CHR$(BreakVar+64)+"("+MID$(STR$(BreakVar2),2)+")"+" set to "+LTRIM$(STR$(BreakVar3#))+"."
                RETURN
             END IF
          END IF
       END IF
    ELSE
       IF LEFT$(Var$, 1) = "$" THEN
          Var$ = MID$(Var$, 2)
          Var$ = LTRIM$(Var$)
          IF LEFT$(Var$, 1) = "," THEN
             BreakVar2$ = MID$(Var$, 2)
             VariableBreak2(BreakVar) = True
             VariableValue2(BreakVar) = BreakVar2$
             COLOR White, Black
             PRINT "Break variable "+CHR$(BreakVar+64)+"$ set to "+CHR$(34)+BreakVar2$+CHR$(34)+"."
             RETURN
          END IF
       ELSE
          IF LEFT$(Var$, 1) = "," THEN
             BreakVar2# = VAL(MID$(Var$, 2))
             VariableBreak(BreakVar) = True
             VariableValue(BreakVar) = BreakVar2#
             COLOR White, Black
             PRINT "Break variable "+CHR$(BreakVar+64)+" set to "+LTRIM$(STR$(BreakVar2#))+"."
             RETURN
          END IF
       END IF
    END IF
 END IF
 COLOR White, Black
 PRINT "Unknown variable."
 RETURN

Clear.Variable:
 Var$ = MID$(Out2,14)
 Var$ = UCASE$(Var$)
 Var$ = RTRIM$(Var$)
 Var$ = LTRIM$(Var$)
 Var2$ = LEFT$(Var$, 1)
 IF Var2$>="A" AND Var2$<="Z" THEN
    BreakVar=ASC(Var2$)-64
    IF LEN(Var$) = 1 THEN
       VariableBreak(BreakVar) = False
       VariableValue(BreakVar) = DFalse
       COLOR White, Black
       PRINT "Break variable "+CHR$(BreakVar+64)+" cleared."
       RETURN
    ELSE
       IF LEN(Var$) = 2 THEN
          Var2$ = MID$(Var$, 2)
          IF Var2$ = "$" THEN
             VariableBreak2(BreakVar) = False
             VariableValue2(BreakVar) = Nul
             COLOR White, Black
             PRINT "Break variable "+CHR$(BreakVar+64)+"$ cleared."
             RETURN
          END IF
       ELSE
          Var$ = MID$(Var$, 2)
          IF LEFT$(Var$, 1) = "(" THEN
             Imbedded = INSTR(Var$, ")")
             IF Imbedded THEN
                Var$ = LEFT$(Var$, Imbedded - 1)
                Var$ = MID$(Var$, 2)
                BreakVar2 = VAL(Var$)
                IF BreakVar2>=1 AND BreakVar2<=Max.Arrays THEN
                   VariableBreak3(BreakVar, BreakVar2) = False
                   VariableValue3(BreakVar, BreakVar2) = DFalse
                   COLOR White, Black
                   PRINT "Break variable "+CHR$(BreakVar+64)+"("+MID$(STR$(BreakVar2),2)+") cleared."
                   RETURN
                END IF
             END IF
          END IF
       END IF
    END IF
 END IF
 COLOR White, Black
 PRINT "Unknown variable."
 RETURN

Toggle.Variable:
 Var$ = MID$(Out2,15)
 Var$ = UCASE$(Var$)
 Var$ = RTRIM$(Var$)
 Var$ = LTRIM$(Var$)
 Var2$ = LEFT$(Var$, 1)
 IF Var2$>="A" AND Var2$<="Z" THEN
    BreakVar=ASC(Var2$)-64
    IF LEN(Var$) = 1 THEN
       IF VariableBreak(BreakVar) THEN
          NewBreak = VariableBreak(BreakVar)
          GOSUB Next.Break
          VariableBreak(BreakVar) = NewBreak
          COLOR White, Black
          PRINT "Break variable "+CHR$(BreakVar+64)+" toggled to "; Symbol$; "."
          RETURN
       END IF
    ELSE
       IF LEN(Var$) = 2 THEN
          Var2$ = MID$(Var$, 2)
          IF Var2$ = "$" THEN
             IF VariableBreak2(BreakVar) THEN
                NewBreak = VariableBreak2(BreakVar)
                GOSUB Next.Break
                VariableBreak2(BreakVar) = NewBreak
                COLOR White, Black
                PRINT "Break variable "+CHR$(BreakVar+64)+"$ toggled to "; Symbol$; "."
                RETURN
             END IF
          END IF
       ELSE
          Var$ = MID$(Var$, 2)
          IF LEFT$(Var$, 1) = "(" THEN
             Imbedded = INSTR(Var$, ")")
             IF Imbedded THEN
                Var$ = LEFT$(Var$, Imbedded - 1)
                Var$ = MID$(Var$, 2)
                BreakVar2 = VAL(Var$)
                IF BreakVar2>=1 AND BreakVar2<=Max.Arrays THEN
                   IF VariableBreak3(BreakVar, BreakVar2) THEN
                      NewBreak = VariableBreak3(BreakVar, BreakVar2)
                      GOSUB Next.Break
                      VariableBreak3(BreakVar, BreakVar2) = NewBreak
                      COLOR White, Black
                      PRINT "Break variable "+CHR$(BreakVar+64)+"("+MID$(STR$(BreakVar2),2)+") toggled to "; Symbol$; "."
                      RETURN
                   END IF
                END IF
             END IF
          END IF
       END IF
    END IF
 END IF
 COLOR White, Black
 PRINT "Unknown variable."
 RETURN

Next.Break:
 SELECT CASE NewBreak
 CASE -1 ' =
    NewBreak = 1
    Symbol$ = "<>"
 CASE 1  ' <>
    NewBreak = 2
    Symbol$ = ">"
 CASE 2  ' >
    NewBreak = 3
    Symbol$ = ">="
 CASE 3  ' >=
    NewBreak = 4
    Symbol$ = "<"
 CASE 4  ' <
    NewBreak = 5
    Symbol$ = "<="
 CASE 5  ' <=
    NewBreak = True
    Symbol$ = "="
 END SELECT
 RETURN

Clear.All.Breaks:
 FOR BreakLine = 1 TO Max.Lines
    LineBreak(BreakLine) = False
 NEXT
 COLOR White, Black
 PRINT "All line breaks cleared."
 RETURN

Clear.All.Variables:
 FOR BreakVar = 1 TO 26
    VariableBreak(BreakVar) = False
    VariableValue(BreakVar) = DFalse
    VariableBreak2(BreakVar) = False
    VariableValue2(BreakVar) = Nul
    FOR BreakVar2 = 1 TO Max.Arrays
       VariableBreak3(BreakVar, BreakVar2) = False
       VariableValue3(BreakVar, BreakVar2) = DFalse
    NEXT
 NEXT
 COLOR White, Black
 PRINT "All variable breaks cleared."
 RETURN
END SUB

' immediate parsing prompt.
SUB Whatis.Command(What.Value$)
 ErrorLine = False
 ErrorType = False
 ErrorValue = False
 Nested.Gosub = False
 Max.Gosubs = 10
 ScreenMode = 0
 ScreenHeight = 25
 ScreenWidth = 80
 Visible = 1
 REDIM GosubReturn(1 TO 10) AS INTEGER
 FOR Count1 = 1 TO 26
    Variables(Count1) = Dfalse
    Strngs(Count1) = Nul
    FOR Count2 = 1 TO Max.Arrays
       Arrays(Count1, Count2) = Dfalse
    NEXT
 NEXT
 FOR Count1 = 1 TO Max.Functions
    Definitions(Count1) = Nul
 NEXT
 InDEFSEG = False
 ControlBreak = False
 IF LEN(What.Value$) THEN
    Program.Line = False
    Out2 = TTRIM$(What.Value$, True)
    ' clear recurse flag
    Recurse = 0
    ' start the parser
    CALL Enter.Equate
    IF LineFeed THEN
       PRINT
    END IF
    GOTO End.Whatis
 END IF
 COLOR White, Black
 PRINT "Type 'Quit' to exit Whatis mode."
 DO
StartWhatis:
    Var = ClearBreak
    Program.Line = False
    Visible = 1
    COLOR Yellow, Black
    LOCATE , 1, 1
    PRINT ":";
    LOCATE , , 1
    Out2 = RTRIM$(KeyboardLine$)
    PRINT
    IF BreakIS THEN
       COLOR Red, Black
       PRINT "*break*"
       GOTO StartWhatis
    END IF
    IF UCASE$(Out2) = "QUIT" THEN
       EXIT DO
    END IF
    IF Out2 <> Nul THEN
       COLOR Plain, Black
       Out2 = TTRIM$(Out2, True)
       ' clear recurse flag
       Recurse = 0
       ' start the parser
       CALL Enter.Equate
       IF LineFeed THEN
          PRINT
       END IF
    END IF
 LOOP
End.Whatis:
 CALL End.Program
 COLOR White, Black
 PRINT "Whatis mode ended."
END SUB

' prepares program for analyze/run command
SUB Prepare.Program
 ' write out current program
 DO
    Temp.Filename$ = TempName$
    Filename = Temp.Filename$ + ".sc2"
    IF DIR$(Filename) = Nul THEN
       EXIT DO
    END IF
 LOOP
 Prepare.Filename = Filename
 CALL Store.Program

 ' concatenate line continuation statements, remove continued lines.
 Program.Line = False
 CALL Count.Lines(Last.Line)
Count.Start1:
 Program.Line = Program.Line + 1
 IF Program.Line > Last.Line THEN
    GOTO Count.End1
 END IF
 IF Program.Line > Max.Lines THEN
    GOTO Count.End1
 END IF
 First.Line = Program.Line
 Out2 = STRIM$(Program(Program.Line))
 IF LEN(Out2) THEN
    DO
       IF RIGHT$(Out2, 1) = "_" THEN
          WHILE RIGHT$(Out2, 1) = "_"
             Out2 = LEFT$(Out2, LEN(Out2) - 1)
          WEND
          FOR Next.Line = Program.Line + 1 TO Last.Line
             Out3 = STRIM$(Program(Next.Line))
             IF LEN(Out3) THEN
                Out2 = Out2 + Out3
                Program.Line = Next.Line
                Program(Next.Line) = Nul
                EXIT FOR
             END IF
          NEXT
       ELSE
          EXIT DO
       END IF
       Out2 = STRIM$(Out2)
    LOOP
    Program(First.Line) = Out2
 END IF
 GOTO Count.Start1
Count.End1:

 ' compress program array,
 ' replaces all white spaces with single space,
 ' replaces all double spaces with single space.
 Program.Line = False
 CALL Count.Lines(Last.Line)
 FOR Program.Line = 1 TO Last.Line
    Out2 = STRIM$(Program(Program.Line))
    IF LEN(Out2) THEN
       Program(Program.Line) = TTRIM$(Out2, True)
    ELSE
       Program(Program.Line) = Nul
    END IF
 NEXT

 ' remove remark at end of line,
 ' search for end of matching double quotes
 ' which might contain an apostrophe.
 FOR Program.Line = 1 TO Last.Line
    Out2 = STRIM$(Program(Program.Line))
    IF LEN(Out2) THEN
       Start.Char = 1
Next.Quotes:
       Quote.Start = False
       FOR Temp = Start.Char TO LEN(Out2)
          IF MID$(Out2, Temp, 1) = CHR$(34) THEN
             Quote.Start = Temp
             EXIT FOR
          END IF
       NEXT
       IF Quote.Start THEN
          Quote.Stop = False
          FOR Temp2 = Quote.Start + 1 TO LEN(Out2)
             IF MID$(Out2, Temp2, 1) = CHR$(34) THEN
                Quote.Stop = Temp2
                EXIT FOR
             END IF
          NEXT
          IF Quote.Stop THEN
             Start.Char = Quote.Stop + 1
             GOTO Next.Quotes
          END IF
       END IF
       FOR Temp = Start.Char TO LEN(Out2)
          IF MID$(Out2, Temp, 1) = "'" THEN
             Out2 = LEFT$(Out2, Temp - 1)
             EXIT FOR
          END IF
       NEXT
       Out2 = STRIM$(Out2)
       IF LEN(Out2) THEN
          Program(Program.Line) = Out2
       ELSE
          Program(Program.Line) = "REM"
       END IF
    END IF
 NEXT
END SUB

' replaces white spaces with blanks,
' var = true; skip blanks in quotes
FUNCTION TTRIM$(Var$, Var)
 VarX$ = Var$
 Temp = False
 DO
    Temp = Temp + 1
    IF Temp > LEN(VarX$) THEN
       EXIT DO
    END IF
    IF Var THEN
       IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
          DO
             Temp = Temp + 1
             IF Temp > LEN(VarX$) THEN
                EXIT DO
             END IF
             IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
    FOR Blanks = 1 TO LEN(White.Space)
       IF MID$(VarX$, Temp, 1) = MID$(White.Space, Blanks, 1) THEN
          MID$(VarX$, Temp, 1) = " "
       END IF
    NEXT
 LOOP
 Temp = False
 DO
    Temp = Temp + 1
    IF Temp > LEN(VarX$) THEN
       EXIT DO
    END IF
    IF Var THEN
       IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
          DO
             Temp = Temp + 1
             IF Temp > LEN(VarX$) THEN
                EXIT DO
             END IF
             IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
    IF MID$(VarX$, Temp, 2) = "  " THEN
       VarX$ = LEFT$(VarX$, Temp) + MID$(VarX$, Temp + 2)
       Temp = Temp - 1
    END IF
 LOOP
 TTRIM$ = VarX$
END FUNCTION

' strips leading/trailing white spaces from string
FUNCTION STRIM$(Var$)
 XVar$ = Var$
 DO
    Blanks = False
    FOR Count = 1 TO LEN(White.Space)
       IF LEFT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
          XVar$ = MID$(XVar$, 2)
          Blanks = True
       END IF
    NEXT
    IF Blanks = False THEN
       EXIT DO
    END IF
 LOOP
 DO
    Blanks = False
    FOR Count = 1 TO LEN(White.Space)
       IF RIGHT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
	  XVar$ = LEFT$(XVar$, LEN(XVar$) - 1)
          Blanks = True
       END IF
    NEXT
    IF Blanks = False THEN
       EXIT DO
    END IF
 LOOP
 STRIM$ = XVar$
END FUNCTION

' returns a randomized temporary filename.
FUNCTION TempName$
 Var$ = Nul
 FOR Temp = 1 TO 8
    Var$ = Var$ + LTRIM$(STR$(INT(RND*9+1)))
 NEXT
 TempName$ = Var$
END FUNCTION

' uses direct keyboard input to get an input line during redirected input.
FUNCTION KeyboardLine$
 Var$ = Nul
 DO
    IF KeyIS THEN ' check keyboard
       Var2$ = KeyboardChar$ ' get character
       SELECT CASE Var2$
       CASE CHR$(0) + CHR$(0) ' control-break
          ' nul
       CASE CHR$(13) ' return
          EXIT DO
       CASE CHR$(27) ' escape
          PRINT "\";
          Var$ = Nul
          EXIT DO
       CASE CHR$(8) ' backspace
          IF LEN(Var$) > 0 THEN
             Var$ = LEFT$(Var$, LEN(Var$) - 1)
             IF POS(0) > 1 THEN ' check cursor location
                LOCATE CSRLIN, POS(0) - 1, 0
                PRINT " ";
                LOCATE CSRLIN, POS(0) - 1, Visible
             ELSE ' line-wrap
                LOCATE CSRLIN - 1, ScreenWidth, 0
                PRINT " ";
                LOCATE CSRLIN - 1, ScreenWidth, Visible
             END IF
          END IF
       CASE ELSE ' store input
          PRINT Var2$;
          LOCATE , , Visible
          Var$ = Var$ + Var2$
       END SELECT
    END IF

    ' release time slice for tight loop
    CALL Release.Time(1)

    ' check control-break key
    IF BreakIS THEN
       EXIT DO
    END IF
 LOOP

 ' return input line
 KeyboardLine$ = Var$
END FUNCTION

' reads character directly from keyboard including extended keys.
FUNCTION KeyboardChar$
 InregsX.AX = &H0000
 CALL InterruptX(&H16, InregsX, OutregsX)
 Key1 = (OutregsX.AX AND &HFF)
 IF Key1 = False THEN ' extended key
    Key2 = (OutregsX.AX AND &HFF00) / 256
    KeyboardChar$ = CHR$(0) + CHR$(Key2)
 ELSE
    KeyboardChar$ = CHR$(Key1)
 END IF
 Flag = BreakIS ' check control-break
END FUNCTION

' checks keyboard buffer
FUNCTION KeyIS
 InregsX.AX = &H0100
 CALL InterruptX(&H16, InregsX, OutregsX)
 IF (OutregsX.Flags AND &H40) = &H40 THEN
    KeyIS = False
 ELSE
    KeyIS = True
 END IF
END FUNCTION

' clears keyboard buffer
FUNCTION ClearBuffer
 DO
    IF KeyIS THEN
       Char$ = KeyboardChar$
    ELSE
       EXIT DO
    END IF
 LOOP
 ClearBuffer = True
END FUNCTION

' releases time slice in windows during tight keyboard input loops.
SUB Release.Time(Var)
 IF Supported.Call = False THEN
    FOR Var1 = 1 TO Var
       InregsX.AX = &H1680
       InregsX.BX = &H0000
       CALL InterruptX(&H2F, InregsX, OutregsX)
       IF (OutregsX.AX AND &HFF) = &H80 THEN
          Supported.Call = True
          EXIT FOR
       END IF
    NEXT
 END IF
END SUB

' checks Control-Break flag
FUNCTION BreakIS
 DEF SEG = &H40 ' set segment
 IF PEEK(&H71) THEN ' check bit flag
    ControlBreak = True ' store control-break variable
    POKE &H71, &H0 ' reset bit flag
 END IF
 IF InDEFSEG THEN ' check segment flag
    DEF SEG = DEFSEGvalue ' restore currently set segment
 ELSE
    DEF SEG ' restore BASIC segment
 END IF
 IF ControlBreak THEN ' check control-break flag
    BreakIS = True
 ELSE
    BreakIS = False
 END IF
END FUNCTION

' clears Control-Break flag
FUNCTION ClearBreak
 DEF SEG = &H40
 POKE &H71, &H0
 DEF SEG
 ControlBreak = False
 ClearBreak = True
END FUNCTION

' closes last file open,
' resets next free file number
FUNCTION FreeFileNumber
 IF FileNumber THEN
    CLOSE #FileNumber
    FileNumber = False
 END IF
 FileNumber = FreeFile
 FreeFileNumber = True
END FUNCTION

' declares all 18 Sic commands
Command.Data:
 DATA "ANALYZE","FILES","HELP","INDENT","KILL", "LIST","LOAD","NEW","PRINT","QUIT"
 DATA "RENUMBER","RUN","SAVE","WHATIS","CONTINUE","DEBUG","SHELL","SEARCH"

' declares indent structure types
Indent.Data:
 ' 1=indent right
 DATA "SELECTIF CASE", 1
 DATA "DO WHILE", 1
 DATA "DO", 1
 DATA "IF", 1
 DATA "SELECT CASE", 1
 DATA "DO UNTIL", 1
 DATA "FORIF", 1
 DATA "FOR", 1
 DATA "WHILE", 1
 DATA "LOOPIF", 1
 ' -1=indent left
 DATA "ENDIF", -1
 DATA "END IF", -1
 DATA "NEXTIF", -1
 DATA "NEXT", -1
 DATA "LOOP UNTIL", -1
 DATA "LOOP WHILE", -1
 DATA "END SELECT", -1
 DATA "WEND", -1
 DATA "END LOOPIF", -1
 DATA "LOOP", -1
 DATA "END SELECTIF", -1
 ' -2=indent left, then right
 DATA "ELSE", -2
 DATA "CASE", -2
 DATA "EOF", 0

' declares analyze functions types and pairs
Analyze.Data1:
 DATA "IF", "ENDIF"
 DATA "DO", "LOOP"
 DATA "FOR", "NEXT"
 DATA "WHILE", "WEND"
 DATA "FORIF", "NEXTIF"
 DATA "LOOPIF", "END LOOPIF"
 DATA "SELECT CASE", "END SELECT"
 DATA "SELECTIF CASE", "END SELECTIF"

Analyze.Data2:
 DATA "IF", "ENDIF", "ELSE", "ELSEIF"
 DATA "SELECT CASE", "END SELECT", "CASE ELSE", "CASE"
 DATA "SELECTIF CASE", "END SELECTIF", "CASEIF ELSE", "CASEIF"

Analyze.Data3:
 DATA "DO", "LOOP", "EXIT DO", "CONTINUE DO"
 DATA "FOR", "NEXT", "EXIT FOR", "CONTINUE FOR"
 DATA "WHILE", "WEND", "EXIT WHILE", "CONTINUE WHILE"
 DATA "FORIF","NEXTIF", "EXIT FORIF", "CONTINUE FORIF"
 DATA "LOOPIF", "END LOOPIF", "EXIT LOOPIF", "CONTINUE LOOPIF"

 ' declares all Sic statements on left side of equation,
 ' each statement listed contains its own subroutine.
 ' listed in rows of ten.
Program.Data:
 DATA "'","ENDIF","END IF","STOP","REM","MID$","LEFT$","RIGHT$","PRINT #","DPRINT"
 DATA "LPRINT","SPRINT","UPRINT","INPUT;","FORIF","FOR","NEXTIF","NEXT","CONTINUE FORIF","CONTINUE FOR"
 DATA "EXIT FORIF","EXIT FOR","DO UNTIL","LOOP WHILE","EXIT DO","CONTINUE DO","GOTO","GOSUB","RETURN","DO WHILE"
 DATA "DO","OFF","IF","ELSEIF","CASEIF ELSE","CASEIF","SELECT CASE","END SELECTIF","BEEP","SOUND"
 DATA "COLOR","LOCATE","CLS","SCREEN","WIDTH","WRITE #","LINE INPUT;","LINE INPUT #","INPUT #","WEND"
 DATA "WHILE","CONTINUE WHILE","EXIT WHILE","ELSE","LOOP UNTIL","LOOPIF","END LOOPIF","EXIT LOOPIF","LOOP","RANDOMIZE"
 DATA "POKE","INT86","DEFSEG","ABSOLUTE","OUT","WAIT","SLEEP","PAUSE","SELECTIF CASE","END SELECT"
 DATA "CASE ELSE","CASE","CONTINUE LOOPIF","END","CLEAR","SYSTEM","SWAP","ERROR","ON ERROR GOTO","ON ERROR RESUME PREVIOUS"
 DATA "ON ERROR RESUME SAME","ON ERROR RESUME NEXT","ON ERROR STOP","RESUME PREVIOUS","RESUME SAME","RESUME NEXT","RESUME","ON","DATE$","TIME$"
 DATA "CHDRIVE","CD","CHDIR","MD","MKDIR","RD","RMDIR","KILL","DELETE","RENAME"
 DATA "NAME","SHELL","CHAIN","LET","CLOSE #","OPEN #","FIELD #","WRITE","PRINT","INPUT"
 DATA "LINE INPUT","LSET #","RSET #","PUT #","GET #","READ #","DATA","READ","RESTORE","CIRCLE STEP"
 DATA "LINE STEP","PSET","PRESET","PAINT","DRAW","PLAY","GET","PUT","BSAVE","BLOAD"
 DATA "VIEW SCREEN","VIEW","WINDOW SCREEN","WINDOW","CIRCLE","LINE","CLOSE","DEF FN"

 REM  "This program is public domain software written by:"
 DATA "Author: Erik Jon Oredson AS. CSci"
 DATA "Email: eoredson@gmail.com"
 DATA "Url: www.simtel.net www.filegate.net"
 REM  "Note: Cookies are delicious. So are cats."

 ' -end of program-
