'----------------------------------------------------------------------------
'                              4DirSize Ver 2.01
'                             By Randall L Glass
'                                CopyRight 2000
'
'----------------------------------------------------------------------------
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; version 2 of the License.(Check file:"copying")
'
' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
'
'----------------------------------------------------------------------------
' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.
'
' ---------------------------------------------------------------------------
'
' I was using the program to get rid of junk files on my hard drive.
' So I made a few improvements. Now the program shows the largest directories
' first.
'
'----------------------------------------------------------------------------
' This Program looks at a directory and subdirectories and adds up the file
' sizes to give you the total amount of space that the directories in that
' directory that use up.
'
' This is useful for finding junkfiles and wasted space on your hard drive.
' So you can delete the junk files and compress the files that waste a lot
' of disk space.
'
'--------------------------------------------------------------------------

$CPU 8086                 ' program works on any CPU
$COMPILE EXE              ' compile to an EXE

$ERROR ALL OFF            ' turn off error handling

$STACK  16384             ' use a 16k stack

$OPTION CNTLBREAK OFF     ' don't allow Ctrl-Break to exit program

DEFINT A-Z                ' default all variables to integers for maximum
                          ' speed and minimum size

DECLARE FUNCTION GetStrLoc(BYVAL AllocHandle%) AS LONG
DECLARE FUNCTION ExtractFileName$(LongName$)

DIM Directories$(1000)

SHARED TotalTreeSize&&, TotalFiles%, TotalDirectories%,Directories%,FileNumber%
SHARED SubDirTreeSize&&, SubFileNumber%, DirFileNumber%, SubDirectories%
SHARED AllocSubDirTreeSize&&,ClusterSize&&,Numberlines%,AllocatedTreeSize&&
SHARED Directories$(),InWindows%,ErrorCode%

Quote$ = CHR$(34)
InWindows% = WinLongNames

Cmd$ = COMMAND$
Arguments$ = TRIM$(UCASE$(Cmd$))

IF Arguments$ = "" THEN
  PRINT
  PRINT "Usage: 4DirSize ";Quote$;"Directory";Quote$
  PRINT "Finds disk space used up by sub directories"
  PRINT
  PRINT Quote$;"Directory";Quote$;" is the directory containing the sub directories"
  END 1
END IF

Directory$ = Arguments$

IF InWindows% THEN
	Directory$ = Lfn2Sfn$(Directory$)
ELSE
	Directory$ = TrueName$(Directory$)
END IF

IsValidDir Directory$

Drive$ = LEFT$(Directory$,1)
CurDrive$ = LEFT$(CURDIR$,1)
FileSpec$  = "*.*"

Viewer$  = ENVIRON$("VIEWER") + " "
TempDir$ = ENVIRON$("TEMP")+"\"

IF InWindows% THEN
	WinDir$ = Environ$("windir")
	TempDir$ = WinDir$+"\TEMP\"
ELSE
	IF TempDir$ = "" THEN TempDir$ = CurDrive$ + ":\"
END IF

IF Viewer$ = " " THEN Viewer$ = "EDIT "

REPLACE "/" WITH "\" IN TempDir$
REPLACE "\\" WITH "\" IN TempDir$

DiskInfo Drive$,DiskSize&&,Diskfree&&

PRINT
PRINT "Disk Waste Finder"
PRINT "By Randall Glass"
PRINT "CopyRight 2000"
PRINT "Getting Total Size of Directories"
PRINT "Checking Directories for files \";

DirectorySize&& = DirSize&&(Directory$, FileSpec$)

OPEN TempDir$ + "Dskspace.use" FOR OUTPUT AS #1

ARRAY SORT Directories$(1) FOR Directories%+1,FROM 65 TO 76,DESCEND

FOR ZZZ% = 1 TO Directories%
	IF (ZZZ% -1) MOD 19 = 0 THEN
		PRINT #1, STRING$(115,"-")
                PRINT #1, "Directory                                % Wasted     Bytes    Allocated Bytes  Number of Files  Average File Size"
	        PRINT #1, STRING$(115,"-")
	END IF
	a$ = MID$(Directories$(zzz%),65)
	Alen% = LEN(Directories$(zzz%))
	PRINT #1,Directories$(zzz%)
NEXT ZZZ%

'OPEN TempDir$ + "Dskspace.use" FOR APPEND AS #1
Numberlines% = 22 - (Numberlilnes% MOD 22)
Wasted&& = INT(.5 + 100 * (AllocatedTreeSize&& -TotalTreeSize&&)/TotalTreeSize&&)

PRINT #1, STRING$(115,"-")
IF Directories% > 1 THEN
	PRINT #1, LTRIM$(USING$("###,###,###",Directories%)); " Directories"
	PRINT #1, STRING$(115,"-")
END IF
PRINT #1,
PRINT #1, "Total Directories% = "; LTRIM$(USING$("###,###,###",TotalDirectories%)); ": ";
PRINT #1, "Total Files = "; LTRIM$(USING$("###,###,###",TotalFiles%))
PRINT #1, "Total Size of Directory And SubDirectories = "; FormatSize$(TotalTreeSize&&)
PRINT #1, "Total Allocated Size of Directory And SubDirectories = "; FormatSize$(AllocatedTreeSize&&)
PRINT #1, "Wasted Directory Space = "; LTRIM$(USING$("###%",Wasted&&))

PRINT #1, STRING$(115,"-")
PRINT #1,
PRINT #1, "Disk Format = ";FatType$(Drive$)
PRINT #1, "Disk Cluster Size = "; LTRIM$(USING$("###,###,###",ClusterSize&&));" Bytes"
PRINT #1,
PRINT #1, "Disk Size = "; FormatSize$(DiskSize&&)
PRINT #1, "Used Disk Space = ";FormatSize$(DiskSize&& -Diskfree&&)
PRINT #1, "Free Disk Space = "; FormatSize$(Diskfree&&)

FOR I% = 1 TO NumberLines% -10
	PRINT #1,
NEXT I%
CLOSE
PRINT
CommandLine$ = Viewer$ + TempDir$ + "Dskspace.use"
IF InWindows% THEN
        EXECUTE CommandLine$
ELSE
        SHELL CommandLine$
        KILL TempDir$ + "Dskspace.use"
END IF
END

FUNCTION DirSize&&(StartPath$, FileSpec$) PUBLIC
  DIM SPIN$(3)
  SPIN$(0) = "-"
  SPIN$(1) = "\"
  SPIN$(2) = "|"
  SPIN$(3) = "/"

  DriveNo% = ASCII(UCASE$(StartPath$))
  IF DriveNo% > 63 AND DriveNo% < 91 AND RIGHT$(StartPath$,1) = ":" THEN StartPath$ = StartPath$ + "."

  StartPath$ = TrueName$(StartPath$)

  StartPath$ = StartPath$ + "\"

  REPLACE "\\" WITH "\" IN StartPath$

  FileName$ = DIR$(StartPath$ + FileSpec$, 55)

  WHILE LEN(FileName$) > 0
      AllocatedFileSize??? = 0
      DirInfo DirAttrib?,FileSize???
      IF Bit(DirAttrib?,4) AND FileName$ <> "." AND FileName$ <> ".." THEN
		SubFileNumber% = 0
		SubDirectories% = 0
		SubDirTreeSize&& = 0
		AllocatedSubDirSize&& = 0
		AllocSubDirTreeSize&& = 0
		SubDirectorySize&& = SubDirSize&&(StartPath$ + FileName$ + "\", FileSpec$)
		TotalTreeSize&& = TotalTreeSize&& + SubDirectorySize&&
		AllocatedTreeSize&& = AllocatedTreeSize&& + AllocSubDirTreeSize&&
		TotalFiles% = TotalFiles% + SubFileNumber%
                TotalDirectories% = TotalDirectories% + SubDirectories% + 1
                INCR Directories%
                INCR Numberlines%
                INCR Spin3%
                Spin2% = Spin3% MOD 4
                'PRINT Spin3%
                QPRINT SPIN$(Spin2%)
                IF InWindows% THEN
                        Directories$(Directories%) = USING$("\                                 \",Sfn2Lfn$(StartPath$ + FileName$)) _
                        + "  " '+ USING$("###,###",SubFileNumber%) + "  "
                ELSE
                        Directories$(Directories%) = USING$("\                                 \",FileName$) _
                        + "  " '+ USING$("###,###",SubFileNumber%) + "  "
                END IF
		Directories$(Directories%) = Directories$(Directories%) + _
                USING$("      ###%",INT(.5 + 100 *(AllocSubDirTreeSize&& -SubDirectorySize&&)/AllocSubDirTreeSize&&)) + _
                USING$("###,###,###,###",SubDirectorySize&&) + _
                USING$("###,###,###,###",AllocSubDirTreeSize&&)

		IF SubFileNumber% > 0 THEN
			AverageFileSize&& = SubDirectorySize&&\SubFileNumber%
        		Directories$(Directories%) = Directories$(Directories%) + " " + USING$("###,###,###,###",SubFileNumber%) + "     " + USING$("###,###,###,###",AverageFileSize&&) + " "
		ELSE
        		Directories$(Directories%) = Directories$(Directories%) + " " + USING$("###,###,###,###",0) + "     " + USING$("###,###,###,###",0) + " "
		END IF

      ELSEIF ISFALSE Bit(DirAttrib?,3) THEN
                ClusterNumber??? = FileSize???\ClusterSize&&
      		ModSize??? = FileSize??? MOD ClusterSize&&
		IF ModSize??? <> 0 THEN
      			AllocatedFileSize??? = (ClusterNumber??? + 1) * ClusterSize&&
                ELSE
			AllocatedFileSize??? = FileSize???
      		END IF
                'IF FileSize??? = 0 THEN AllocatedFileSize??? = ClusterNumber???
		INCR FileNumber%
                INCR DirFileNumber%
		DirectorySize&& = DirectorySize&& + FileSize???
		AllocatedDirSize&& = AllocatedDirSize&& + AllocatedFileSize???
      END IF

      IF INKEY$ = CHR$(27) THEN END  'is escape is pressed
      FileName$ = DIR$
  WEND

DirSize&& = DirectorySize&&
TotalTreeSize&& = TotalTreeSize&& + DirectorySize&&
AllocatedTreeSize&& = AllocatedTreeSize&& + AllocatedDirSize&&
TotalFiles% = TotalFiles% + FileNumber%

INCR Directories%
DirName$ = "."
Directories$(Directories%) =  USING$("\                                 \",DirName$) + _
  "  " '+ USING$("###,###",DirFileNumber%) + "  "
Directories$(Directories%) = Directories$(Directories%) + _
  USING$("      ###%",INT(.5 + 100 *(AllocatedDirSize&& -DirectorySize&&)/AllocatedDirSize&&)) + _
  USING$("###,###,###,###",DirectorySize&&) + _
  USING$("###,###,###,###",AllocatedDirSize&&)

IF SubFileNumber% > 0 THEN
	AverageFileSize&& = SubDirectorySize&&\SubFileNumber%
        Directories$(Directories%) = Directories$(Directories%) + " " + USING$("###,###,###,###",SubFileNumber%) + "     " + USING$("###,###,###,###",AverageFileSize&&) + " "
ELSE
        Directories$(Directories%) = Directories$(Directories%) + " " + USING$("###,###,###,###",0) + "     " + USING$("###,###,###,###",0) + " "
END IF

END FUNCTION

FUNCTION SubDirSize&&(Path$, FileSpec$) PUBLIC

  GetDta DtaSeg??,DtaOfs??
  DEF SEG = DtaSeg??
    SubOldDtaBuffer$ = PEEK$(DtaOfs??, 44)    'save current DTA information
  DEF SEG

  FileName$ = DIR$(Path$ + FileSpec$, 55)

  WHILE LEN(FileName$) > 0
      DirInfo DirAttrib?,FileSize???
      IF Bit(DirAttrib?,4) AND FileName$ <> "." AND FileName$ <> ".." THEN
		AllocDirSize&& = 0
		SubDirSize&& Path$ + FileName$ + "\", FileSpec$
		INCR SubDirectories%
      ELSEIF ISFALSE Bit(DirAttrib?,3) THEN
                ClusterNumber??? = FileSize???\ClusterSize&&
      		ModSize??? = FileSize??? MOD ClusterSize&&
		IF ModSize??? <> 0 THEN
      			AllocatedFileSize??? = (ClusterNumber??? + 1) * ClusterSize&&
                ELSE
			AllocatedFileSize??? = FileSize???
      		END IF

                'IF FileSize??? = 0 THEN AllocatedFileSize??? = ClusterNumber???
		INCR SubFileNumber%
		DirectorySize&& = DirectorySize&& + FileSize???
		AllocatedDirSize&& = AllocatedDirSize&& + AllocatedFileSize???
      END IF

      IF INKEY$ = CHR$(27) THEN END  'escape is pressed
      FileName$ = DIR$
  WEND

  DEF SEG = DtaSeg??
    POKE$ DtaOfs??, SubOldDtaBuffer$   'restore saved DTA information
  DEF SEG

  SubDirTreeSize&& =  SubDirTreeSize&& + DirectorySize&&
  AllocSubDirTreeSize&& = AllocSubDirTreeSize&& + AllocatedDirSize&&
  SubDirSize&& = SubDirTreeSize&&

END FUNCTION

SUB DirInfo(DirAttrib?,DirectorySize???) PUBLIC
  LOCAL DirDate??,DirTime??,DirAttr?,Dsize???
  ! mov  AX, &H2F00              ; function 2Fh, get DTA location
  ! int  &H21                    ; call DOS
  ! MOV  AX,ES:[BX +26]
  ! MOV  DSize???[0],AX
  ! MOV  AX,ES:[BX +28]
  ! MOV  DSize???[2],AX
  ! MOV  AL,ES:[BX +21]
  ! MOV  DirAttr?,AL
  DirectorySize??? = DSize???
  DirAttrib? = DirAttr?
END SUB

SUB GetDTA(DtaSeg??, DtaOfs??) PUBLIC
  ! push DS
  ! mov  AX, &H2F00              ; function 2Fh, get DTA location
  ! int  &H21                    ; call DOS
  ! lds  SI, DtaSeg??            ; point DS:SI at DtaSeg
  ! mov  DS:[SI], ES             ; put segment of DTA in variable
  ! lds  SI, DtaOfs??            ; point DS:SI at DtaOfs
  ! mov  DS:[SI], BX             ; put offset of DTA in variable
  ! pop  DS
END SUB

FUNCTION FormatSize$(Bytes&&)
IF Bytes&& > 3999999 THEN
        FormatSize$ = LTRIM$(USING$("###,###,###.##",Bytes&&/1000000))+" Megabytes"
ELSEIF Bytes&& > 999999 THEN
        FormatSize$ = LTRIM$(USING$("###,###,###,###,###.##",Bytes&&/1000))+" Kilobytes"
ELSE
        FormatSize$ = LTRIM$(USING$("###,###,###,###,###",Bytes&&))+" Bytes"
END IF
END FUNCTION

FUNCTION TrueName$(Directory$)
REPLACE "......" WITH "..\..\..\..\..\" IN Directory$
REPLACE "....." WITH "..\..\..\..\" IN Directory$
REPLACE "...." WITH "..\..\..\" IN Directory$
REPLACE "..." WITH "..\..\" IN Directory$
REPLACE "/" WITH "\" IN Directory$
REPLACE "\\" WITH "\" IN Directory$

DIM Canonicalized AS STRING * 128

DirName$ = TRIM$(Directory$) + CHR$(0)
DirNamePtr??? = STRPTR32(DirName$)
CanonicalizedPtr??? = VARPTR32(Canonicalized$)
DosError?? = 0

!PUSH DS
!LDS SI,DirNamePtr???
!LES DI,CanonicalizedPtr???
!MOV AH,&H60
!INT &H21
!POP DS

!JNC NoError
!MOV DosError??,AX
PRINT
PRINT "Invalid Path or File"
END 2
NoError:
IF LEFT$(Canonicalized$,2) = "\\" THEN
        Drive$ = MID$(Canonicalized$,3,1)+":"
        Path$ = EXTRACT$(MID$(Canonicalized$,8),CHR$(0))
        IF Path$ = "" THEN Path$ = "\"
	FUNCTION = EXTRACT$(Drive$ +Path$,CHR$(0))
ELSE
FUNCTION = EXTRACT$(Canonicalized$,CHR$(0))
END IF
END FUNCTION

SUB QPRINT(Txt$) PUBLIC
 ! LES     BX,Txt$
 ! MOV     AX,ES:[BX]
 ! PUSH    AX
 ! CALL    GetStrLoc
 ! JCXZ    Quit
 ! MOV     ES, DX
 ! MOV     SI, AX
 ! MOV     AH,&H0E
 ! MOV     BH,PbvScrnVpage
 ! MOV     BL,7
 Printit:
 ! MOV     AL,ES:[SI]
 ! INT     &H10
 ! INC     SI
 ! LOOP    Printit
Quit:
END SUB

FUNCTION Sfn2Lfn$(BYVAL ShortName$)
 LOCAL ErrorCode??
 DIM LongName AS STRING * 261

 ShortName$ = ShortName$ + CHR$(0)
 LongName$ =  STRING$(261,0)
 LongNamePtr???  = VARPTR32(LongName$)
 ShortNamePtr??? = STRPTR32(ShortName$)

 ! PUSH DS
 ! PUSH ES
 ! PUSH SI
 ! PUSH DI
 ! MOV AX,&H7160
 ! MOV CX,2
 ! LES DI,LongNamePtr???
 ! LDS SI,ShortNamePtr???
 ! INT &H21
 ! POP DI
 ! POP SI
 ! POP ES
 ! POP DS
 ! MOV ErrorCode??,AX
 ! JC LongError
LongName2$ = EXTRACT$(LongName$,CHR$(0))
Slash% = RINST%(LongName2$,"\")
IF Slash% = 0 THEN Slash% = 1
FUNCTION = MID$(LongName$,Slash% + 1)
 EXIT FUNCTION
LongError:
FUNCTION = ShortName$
END FUNCTION

FUNCTION RINST%(S$,Char$)
LOCAL FoundPos%
! STD
! LES DI,Char$
! MOV AX,ES:[DI]
! PUSH AX
! CALL GetStrLoc           ; find where the data is located
! JCXZ DoneAndExit
! MOV  ES, DX              ; put segment in ES
! MOV  DI, AX              ; put offset in DI
! MOV  BL, ES:[DI]         ; value for "A" in AL
! LES DI,S$
! MOV AX,ES:[DI]
! PUSH AX
! CALL GetStrLoc           ; find where the data is located
! JCXZ DoneAndExit
! MOV  ES, DX              ; put segment in ES
! MOV  DI, AX              ; put offset in DI
! ADD  DI, CX
! DEC  DI
! MOV  Al,BL
! REPNE SCASB             ; fill the string (CX holds the length)
! JNE DoneAndExit
! INC CX
! MOV FUNCTION,CX
EXIT FUNCTION
DoneAndExit:
! MOV FUNCTION,0
END FUNCTION

FUNCTION Lfn2Sfn$(BYVAL LongName$)
 LOCAL ErrorCode??
 DIM ShortName AS STRING * 128
 LongName$ =  LongName$ +  CHR$(0)
 LongNamePtr???  = STRPTR32(LongName$)
 ShortNamePtr??? = VARPTR32(ShortName$)

 ! PUSH DS
 ! PUSH ES
 ! PUSH SI
 ! PUSH DI
 ! MOV AX,&H7160
 ! MOV CX,&h8001
 ! LES DI,ShortNamePtr???
 ! LDS SI,LongNamePtr???
 ! STC
 ! INT &H21
 ! POP DI
 ! POP SI
 ! POP ES
 ! POP DS
 ! MOV ErrorCode??,AX
 ! JC ShortError
ShortName2$ = EXTRACT$(ShortName$,CHR$(0))
FUNCTION = ShortName2$
EXIT FUNCTION
ShortError:
PRINT "Invalid Directory"
END 2
END FUNCTION

FUNCTION WinLongNames () PRIVATE AS INTEGER
'----------------------------------------------------------------------
' LfnSupported3 returns %TRUE (-1) if Windows 95 long file names are
' supported, and %FALSE (0) otherwise
'----------------------------------------------------------------------

DIM SystemName  AS STRING
DIM RootName    AS STRING
DIM LenSysName  AS INTEGER
DIM PtrSysName  AS STRING PTR
DIM PtrRootName AS STRING PTR

  'Does system support long names?

  SystemName$ = STRING$(8,0)
  PtrSysName  = STRPTR32(SystemName$)
  LenSysName  = LEN(SystemName$)
  RootName$   = "C:\" + CHR$(0)
  PtrRootName = STRPTR32(RootName$)

  !   PUSH    DS
  !   PUSH    DI
  !   STC
  !   LES     DI, PtrSysName          ;get address of SystemName in ES:DI
  !   MOV     CX, LenSysName          ;   and length in CX
  !   LDS     DX, PtrRootName         ;get address of RootName in DS:DX
  !   MOV     AX, &h71A0              ;get volume information
  !   INT     &h21
  !   POP     DI
  !   POP     DS
  !   JC      L3                      ;if OK,
  !   CMP     AX,&H7100
  !   JE      L3
      FUNCTION = 1                      'then long names are supported
  L3:

END FUNCTION

'-----------------------------------------------------------------------------
'A subroutine of PB DISKINFO V2.5 by Marc van den Dikkenberg
'Debuged & fixed part of his program.
'Also made it more readable
'-----------------------------------------------------------------------------
SUB DiskInfo(Drive$,DiskSize&&,DiskFree&&) PUBLIC
   LOCAL SectorsPerCluster??, FreeClusters??, BytesPerSector??, TotalClusters??
   Dim DriveName AS String * 4

   Drive$ = UCASE$(LEFT$(Drive$,1))
   DriveName$ = LEFT$(Drive$,1) +":\"+CHR$(0)

   IF FatType$(Drive$) = "FAT32" THEN
                Dim Buffer as String * 44
                BufferPtr32??? = VARPTR32(Buffer$)
                DriveNamePtr32??? = VARPTR32(DriveName$)

		! PUSH DS
		! MOV AX,&H7303
                ! LES DI,BufferPtr32???
                ! LDS DX,DriveNamePtr32???
                ! MOV CX,44    ;length of buffer
		! INT &H21
		! POP DS

                IF CVWRD(LEFT$(Buffer$,2))<>0 THEN
                        ' FAT32
                        SectorsPerCluster??? = CVDWD(MID$(Buffer$,9,4))
                        BytesPerSector??? = CVDWD(MID$(Buffer$,5,4))
                        ClusterSize&& = SectorsPerCluster??? * BytesPerSector???
                        TotalClusters??? = CVDWD(MID$(Buffer$,17,4))
                        FreeClusters??? = CVDWD(MID$(Buffer$,13,4))
                        DiskSize&& = TotalClusters??? * ClusterSize&&
                        DiskFree&& = FreeClusters???  * ClusterSize&&
                ELSE
                        ' Disk not found
                        Drive$ = chr$(255)
                        DiskFree&& = -1
                END IF
        ELSE
		' FAT32 not supported -- Using FAT16 & FAT12 Method instead.
                Drive% = ASC(LEFT$(Drive$,1))-64
	   	! PUSH DS
	   	! MOV AX,&H3600
	   	! MOV DX,drive%    ; Disk-#  01=A:, 02=B:, etc.
                ! MOV CX,0
                ! MOV BX,0
	   	! INT &H21
           	! MOV SectorsPerCluster??,ax
           	! MOV FreeClusters??,bx
           	! MOV BytesPerSector??,cx
           	! MOV TotalClusters??,dx
	   	! POP DS
           	IF SectorsPerCluster?? <> &H0FFFF THEN
                        ClusterSize&& = SectorsPerCluster?? * BytesPerSector??
                        DiskSize&& = ClusterSize&& * TotalClusters??
                        DiskFree&& = ClusterSize&& * FreeClusters??

           	ELSE
               		'Disk not found
                        DiskFree&& = -1
               		Drive$ = chr$(255)
               END IF
   END IF
END SUB

FUNCTION FatType$(Drive$)
DIM FatInfo AS STRING * 64
FatInfo32??? = VARPTR32(fatinfo$)
Drive? =ASC(Drive$) -64
! PUSH DS
! LDS DX,FatInfo32???
! MOV AH,&H69
! MOV AL,0
! MOV BL,Drive?      ;drive number
! INT &H21
! POP DS
FatType$ = TRIM$(MID$(FatInfo$,18,8))
END FUNCTION

FUNCTION GetFileName$(D$)
Ln% = LEN(D$)
Slash% =RINST%(S$,"\")
IF Slash% < Ln% THEN GetFileName$ = MID$(D$,Slash% + 1)
END FUNCTION

SUB IsValidDir(BYVAL Directory$)
ON LOCAL ERROR RESUME NEXT

IF Right$(Directory$,1) = "\" THEN
	Ln% = LEN(Directory$)
	Directory$ = LEFT$(Directory$,Ln% -1)
END IF
IF RIGHT$(Directory$,1) = ":" THEN EXIT SUB
IsDirectory% = Attrib(Directory$)
IF ERR OR (ISFALSE Bit(IsDirectory%,4)) THEN
	PRINT "Invalid Directory"
        END 2
END IF
END SUB
