// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'RVStyle.pas' rev: 4.00

#ifndef RVStyleHPP
#define RVStyleHPP

#pragma delphiheader begin
#pragma option push -w-
#include <RVMapWht.hpp>	// Pascal unit
#include <RVClasses.hpp>	// Pascal unit
#include <RVFuncs.hpp>	// Pascal unit
#include <Registry.hpp>	// Pascal unit
#include <IniFiles.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Rvstyle
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TRVRTFSaveArea { rv_rtfs_TextStyle, rv_rtfs_ParaStyle, rv_rtfs_CellProps, rv_rtfs_RowProps };
#pragma option pop

#pragma option push -b-
enum TRVReaderUnicode { rvruMixed, rvruNoUnicode, rvruOnlyUnicode };
#pragma option pop

#pragma option push -b-
enum TRVReaderStyleMode { rvrsUseSpecified, rvrsUseClosest, rvrsAddIfNeeded };
#pragma option pop

#pragma option push -b-
enum TRVFReaderStyleMode { rvf_sIgnore, rvf_sInsertMap, rvf_sInsertMerge };
#pragma option pop

typedef unsigned TRVCodePage;

typedef void *TCheckpointData;

#pragma option push -b-
enum TRVTextDrawState { rvtsSelected, rvtsHover, rvtsItemStart, rvtsItemEnd, rvtsDrawItemStart, rvtsDrawItemEnd, 
	rvtsControlFocused };
#pragma option pop

typedef Set<TRVTextDrawState, rvtsSelected, rvtsControlFocused>  TRVTextDrawStates;

class DELPHICLASS TRVStyle;
typedef void __fastcall (__closure *TRVDrawTextBackEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int StyleNo, int Left, int Top, int Width, int Height, TRVTextDrawStates DrawState, bool &DoDefault
	);

typedef void __fastcall (__closure *TRVApplyStyleEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas, 
	int StyleNo, bool &DoDefault);

typedef void __fastcall (__closure *TRVApplyStyleColorEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int StyleNo, TRVTextDrawStates DrawState, bool &DoDefault);

typedef void __fastcall (__closure *TRVDrawStyleTextEvent)(TRVStyle* Sender, const AnsiString s, Graphics::TCanvas* 
	Canvas, int StyleNo, int SpaceBefore, int Left, int Top, int Width, int Height, TRVTextDrawStates DrawState
	, bool &DoDefault);

typedef void __fastcall (__closure *TRVStyleHoverSensitiveEvent)(TRVStyle* Sender, int StyleNo, bool 
	&Sensitive);

typedef void __fastcall (__closure *TRVDrawCheckpointEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int X, int Y, int ItemNo, int XShift, bool RaiseEvent, Controls::TControl* Control, bool &DoDefault
	);

typedef void __fastcall (__closure *TRVDrawPageBreakEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int Y, int XShift, Controls::TControl* Control, bool &DoDefault);

typedef void __fastcall (__closure *TRVDrawParaRectEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int ParaNo, const Windows::TRect &ARect, bool &DoDefault);

#pragma option push -b-
enum TRVBreakStyle { rvbsLine, rvbsRectangle, rvbs3d };
#pragma option pop

#pragma option push -b-
enum TRVVAlign { rvvaBaseline, rvvaMiddle };
#pragma option pop

#pragma option push -b-
enum TRVFOption { rvfoSavePicturesBody, rvfoSaveControlsBody, rvfoIgnoreUnknownPicFmt, rvfoIgnoreUnknownCtrls, 
	rvfoConvUnknownStylesToZero, rvfoConvLargeImageIdxToZero, rvfoSaveBinary, rvfoUseStyleNames, rvfoSaveBack, 
	rvfoLoadBack, rvfoSaveTextStyles, rvfoSaveParaStyles };
#pragma option pop

typedef Set<TRVFOption, rvfoSavePicturesBody, rvfoSaveParaStyles>  TRVFOptions;

#pragma option push -b-
enum TRVFWarning { rvfwUnknownPicFmt, rvfwUnknownCtrls, rvfwConvUnknownStyles, rvfwConvLargeImageIdx, 
	rvfwConvToUnicode, rvfwConvFromUnicode };
#pragma option pop

typedef Set<TRVFWarning, rvfwUnknownPicFmt, rvfwConvFromUnicode>  TRVFWarnings;

#pragma option push -b-
enum TRVControlAction { rvcaAfterRVFLoad, rvcaDestroy, rvcaMoveToUndoList, rvcaMoveFromUndoList, rvcaDestroyInUndoList, 
	rvcaBeforeRVFSave, rvcaAfterRVFSave };
#pragma option pop

#pragma option push -b-
enum TRVProtectOption { rvprStyleProtect, rvprModifyProtect, rvprDeleteProtect, rvprConcateProtect, 
	rvprRVFInsertProtect, rvprDoNotAutoSwitch, rvprParaStartProtect, rvprSticking };
#pragma option pop

typedef Set<TRVProtectOption, rvprStyleProtect, rvprSticking>  TRVProtectOptions;

#pragma option push -b-
enum TRVParaOption { rvpaoNoWrap, rvpaoReadOnly, rvpaoStyleProtect };
#pragma option pop

typedef Set<TRVParaOption, rvpaoNoWrap, rvpaoStyleProtect>  TRVParaOptions;

#pragma option push -b-
enum TRVSaveOption { rvsoOverrideImages, rvsoFirstOnly, rvsoMiddleOnly, rvsoLastOnly, rvsoDefault0Style, 
	rvsoNoHypertextImageBorders, rvsoImageSizes, rvsoForceNonTextCSS };
#pragma option pop

typedef Set<TRVSaveOption, rvsoOverrideImages, rvsoForceNonTextCSS>  TRVSaveOptions;

#pragma option push -b-
enum TRVRTFOption { rvrtfSaveStyleSheet, rvrtfDuplicateUnicode, rvrtfSaveEMFAsWMF, rvrtfSaveJpegAsJpeg, 
	rvrtfSaveBitmapDefault, rvrtfSaveEMFDefault };
#pragma option pop

typedef Set<TRVRTFOption, rvrtfSaveStyleSheet, rvrtfSaveEMFDefault>  TRVRTFOptions;

#pragma option push -b-
enum TRVFontStyle { rvfsOverline, rvfsAllCaps };
#pragma option pop

typedef Set<TRVFontStyle, rvfsOverline, rvfsAllCaps>  TRVFontStyles;

#pragma option push -b-
enum TRVAlignment { rvaLeft, rvaRight, rvaCenter, rvaJustify };
#pragma option pop

typedef TCustomIniFile TRVIniFile;
;

#pragma option push -b-
enum TRVSaveCSSOption { rvcssOnlyDifference, rvcssIgnoreLeftAlignment };
#pragma option pop

typedef Set<TRVSaveCSSOption, rvcssOnlyDifference, rvcssIgnoreLeftAlignment>  TRVSaveCSSOptions;

#pragma option push -b-
enum TRVBiDiMode { rvbdUnspecified, rvbdLeftToRight, rvbdRightToLeft };
#pragma option pop

#pragma option push -b-
enum TRVFontInfoProperty { rvfiFontName, rvfiSize, rvfiCharset, rvfiUnicode, rvfiBold, rvfiItalic, rvfiUnderline, 
	rvfiStrikeout, rvfiOverline, rvfiAllCaps, rvfiVShift, rvfiColor, rvfiBackColor, rvfiJump, rvfiHoverBackColor, 
	rvfiHoverColor, rvfiJumpCursor, rvfiNextStyleNo, rvfiProtection, rvfiCharScale, rvfiBaseStyleNo, rvfiBiDiMode, 
	rvfiCharSpacing };
#pragma option pop

#pragma option push -b-
enum TRVParaInfoProperty { rvpiFirstIndent, rvpiLeftIndent, rvpiRightIndent, rvpiSpaceBefore, rvpiSpaceAfter, 
	rvpiAlignment, rvpiNextParaNo, rvpiLineSpacing, rvpiLineSpacingType, rvpiBackground_Color, rvpiBackground_BO_Left, 
	rvpiBackground_BO_Top, rvpiBackground_BO_Right, rvpiBackground_BO_Bottom, rvpiBorder_Color, rvpiBorder_Style, 
	rvpiBorder_Width, rvpiBorder_InternalWidth, rvpiBorder_BO_Left, rvpiBorder_BO_Top, rvpiBorder_BO_Right, 
	rvpiBorder_BO_Bottom, rvpiBorder_Vis_Left, rvpiBorder_Vis_Top, rvpiBorder_Vis_Right, rvpiBorder_Vis_Bottom, 
	rvpiNoWrap, rvpiReadOnly, rvpiStyleProtect, rvpiBiDiMode };
#pragma option pop

typedef Set<TRVFontInfoProperty, rvfiFontName, rvfiCharSpacing>  TRVFontInfoProperties;

typedef Set<TRVParaInfoProperty, rvpiFirstIndent, rvpiBiDiMode>  TRVParaInfoProperties;

#pragma option push -b-
enum TRVLineSpacingType { rvlsPercent, rvlsSpaceBetween };
#pragma option pop

#pragma option push -b-
enum TRVStyleMergeMode { rvs_merge_SmartMerge, rvs_merge_Map, rvs_merge_Append };
#pragma option pop

class DELPHICLASS TCustomRVInfo;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TCustomRVInfo : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	int FBaseStyleNo;
	AnsiString FName;
	bool FStandard;
	
protected:
	DYNAMIC bool __fastcall IsSimpleEqual(TCustomRVInfo* Value) = 0 ;
	DYNAMIC int __fastcall SimilarityValue(TCustomRVInfo* Value) = 0 ;
	
public:
	__fastcall virtual TCustomRVInfo(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual AnsiString __fastcall GetDisplayName(void);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs, const AnsiString DefName);
	
__published:
	__property int BaseStyleNo = {read=FBaseStyleNo, write=FBaseStyleNo, default=-1};
	__property AnsiString StyleName = {read=FName, write=FName};
	__property bool Standard = {read=FStandard, write=FStandard, default=1};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TCustomRVInfo(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TFontInfo;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TFontInfo : public TCustomRVInfo 
{
	typedef TCustomRVInfo inherited;
	
private:
	TRVBiDiMode FBiDiMode;
	bool FJump;
	Controls::TCursor FJumpCursor;
	AnsiString FFontName;
	int FSize;
	Graphics::TColor FColor;
	Graphics::TColor FBackColor;
	Graphics::TColor FHoverColor;
	Graphics::TColor FHoverBackColor;
	Graphics::TFontStyles FStyle;
	TRVFontStyles FStyleEx;
	int FVShift;
	int FNextStyleNo;
	Graphics::TFontCharset FCharset;
	bool FUnicode;
	TRVProtectOptions FProtection;
	int FCharScale;
	int FCharSpacing;
	void __fastcall SingleSymbolsReader(Classes::TReader* reader);
	
protected:
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	DYNAMIC bool __fastcall IsSimpleEqual(TCustomRVInfo* Value);
	DYNAMIC int __fastcall SimilarityValue(TCustomRVInfo* Value);
	
public:
	__fastcall virtual TFontInfo(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall AssignToLogFont(tagLOGFONTA &LogFont, Graphics::TCanvas* Canvas);
	void __fastcall Apply(Graphics::TCanvas* Canvas, TRVBiDiMode DefBiDiMode);
	void __fastcall ApplyColor(Graphics::TCanvas* Canvas, TRVStyle* RVStyle, TRVTextDrawStates DrawState
		);
	void __fastcall Draw(const AnsiString s, Graphics::TCanvas* Canvas, int ThisStyleNo, int SpaceBefore
		, int Left, int Top, int Width, int Height, TRVStyle* RVStyle, TRVTextDrawStates DrawState, bool Printing
		);
	void __fastcall DrawVertical(const AnsiString s, Graphics::TCanvas* Canvas, int ThisStyleNo, int SpaceBefore
		, int Left, int Top, int Width, int Height, TRVStyle* RVStyle, TRVTextDrawStates DrawState);
	bool __fastcall IsEqual(TFontInfo* Value, TRVFontInfoProperties IgnoreList);
	HIDESBASE void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const 
		AnsiString fs);
	HIDESBASE void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const 
		AnsiString fs, bool JumpByDefault, Controls::TCursor DefJumpCursor);
	
__published:
	__property Graphics::TFontCharset Charset = {read=FCharset, write=FCharset, default=1};
	__property AnsiString FontName = {read=FFontName, write=FFontName};
	__property int Size = {read=FSize, write=FSize, default=10};
	__property Graphics::TFontStyles Style = {read=FStyle, write=FStyle, default=0};
	__property int VShift = {read=FVShift, write=FVShift, default=0};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-2147483640};
	__property Graphics::TColor BackColor = {read=FBackColor, write=FBackColor, default=536870911};
	__property Graphics::TColor HoverBackColor = {read=FHoverBackColor, write=FHoverBackColor, default=536870911
		};
	__property Graphics::TColor HoverColor = {read=FHoverColor, write=FHoverColor, default=536870911};
	__property TRVFontStyles StyleEx = {read=FStyleEx, write=FStyleEx, default=0};
	__property bool Jump = {read=FJump, write=FJump, default=0};
	__property Controls::TCursor JumpCursor = {read=FJumpCursor, write=FJumpCursor, default=101};
	__property int CharScale = {read=FCharScale, write=FCharScale, default=100};
	__property int CharSpacing = {read=FCharSpacing, write=FCharSpacing, default=0};
	__property int NextStyleNo = {read=FNextStyleNo, write=FNextStyleNo, default=-1};
	__property TRVBiDiMode BiDiMode = {read=FBiDiMode, write=FBiDiMode, default=0};
	__property bool Unicode = {read=FUnicode, write=FUnicode, default=0};
	__property TRVProtectOptions Protection = {read=FProtection, write=FProtection, default=0};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TFontInfo(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TCustomRVInfos;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TCustomRVInfos : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	Classes::TPersistent* FOwner;
	
public:
	__fastcall TCustomRVInfos(TMetaClass* ItemClass, Classes::TPersistent* Owner);
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall MergeWith(TCustomRVInfos* Styles, TRVStyleMergeMode Mode, Rvclasses::TRVIntegerList* 
		Mapping);
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TCustomRVInfos(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TFontInfos;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TFontInfos : public TCustomRVInfos 
{
	typedef TCustomRVInfos inherited;
	
private:
	HIDESBASE TFontInfo* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TFontInfo* Value);
	
public:
	__fastcall TFontInfos(Classes::TPersistent* Owner);
	int __fastcall FindStyleWithCharset(int BaseStyle, Graphics::TFontCharset Charset);
	int __fastcall FindStyleWithFontStyle(int BaseStyle, Graphics::TFontStyles Value, Graphics::TFontStyles 
		Mask);
	int __fastcall FindStyleWithFontSize(int BaseStyle, int Size);
	int __fastcall FindStyleWithColor(int BaseStyle, Graphics::TColor Color, Graphics::TColor BackColor
		);
	int __fastcall FindStyleWithFontName(int BaseStyle, const AnsiString FontName);
	int __fastcall FindSuchStyle(int BaseStyle, TFontInfo* Style, TRVFontInfoProperties Mask);
	int __fastcall FindStyleWithFont(int BaseStyle, Graphics::TFont* Font);
	HIDESBASE TFontInfo* __fastcall Add(void);
	void __fastcall Delete(int Index);
	TFontInfo* __fastcall AddFont(AnsiString Name, int Size, Graphics::TColor Color, Graphics::TColor BackColor
		, Graphics::TFontStyles Style);
	TFontInfo* __fastcall AddFontEx(AnsiString Name, int Size, Graphics::TColor Color, Graphics::TColor 
		BackColor, Graphics::TFontStyles Style, Graphics::TFontCharset Charset);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, Controls::TCursor 
		DefJumpCursor);
	__property TFontInfo* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TFontInfos(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TRVRect;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVRect : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	int FTop;
	int FLeft;
	int FRight;
	int FBottom;
	bool __fastcall IsEqualEx(TRVRect* Value, bool IgnL, bool IgnT, bool IgnR, bool IgnB);
	int __fastcall SimilarityValue(TRVRect* Value, int Weight);
	
public:
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall InflateRect(Windows::TRect &Rect);
	void __fastcall InflateRectSaD(Windows::TRect &Rect, const Rvfuncs::TRVScreenAndDevice &sad);
	void __fastcall AssignToRect(Windows::TRect &Rect);
	void __fastcall AssignToRectIfGreater(Windows::TRect &Rect);
	bool __fastcall IsEqual(TRVRect* Value);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	
__published:
	__property int Left = {read=FLeft, write=FLeft, default=0};
	__property int Right = {read=FRight, write=FRight, default=0};
	__property int Top = {read=FTop, write=FTop, default=0};
	__property int Bottom = {read=FBottom, write=FBottom, default=0};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TRVRect(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRVRect(void) : Classes::TPersistent() { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TRVBooleanRect;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVBooleanRect : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FTop;
	bool FLeft;
	bool FRight;
	bool FBottom;
	bool __fastcall IsEqualEx(TRVBooleanRect* Value, bool IgnL, bool IgnT, bool IgnR, bool IgnB);
	
public:
	__fastcall TRVBooleanRect(bool DefValue);
	void __fastcall SetAll(bool Value);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	bool __fastcall IsEqual(TRVBooleanRect* Value);
	bool __fastcall IsAllEqual(bool Value);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	
__published:
	__property bool Left = {read=FLeft, write=FLeft, default=1};
	__property bool Right = {read=FRight, write=FRight, default=1};
	__property bool Top = {read=FTop, write=FTop, default=1};
	__property bool Bottom = {read=FBottom, write=FBottom, default=1};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TRVBooleanRect(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma option push -b-
enum TRVBorderStyle { rvbNone, rvbSingle, rvbDouble, rvbTriple, rvbThickInside, rvbThickOutside };
#pragma option pop

class DELPHICLASS TRVBorder;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVBorder : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Graphics::TColor FColor;
	TRVBorderStyle FStyle;
	int FWidth;
	int FInternalWidth;
	TRVBooleanRect* FVisibleBorders;
	TRVRect* FBorderOffsets;
	void __fastcall SetBorderOffsets(const TRVRect* Value);
	void __fastcall SetVisibleBorders(const TRVBooleanRect* Value);
	int __fastcall SimilarityValue(TRVBorder* Value);
	
protected:
	void __fastcall DoDraw(const Windows::TRect &Rect, Graphics::TCanvas* Canvas, int Width, int InternalWidth
		, int OnePixelWidth);
	
public:
	__fastcall TRVBorder(void);
	__fastcall virtual ~TRVBorder(void);
	void __fastcall Draw(const Windows::TRect &Rect, Graphics::TCanvas* Canvas);
	void __fastcall DrawSaD(const Windows::TRect &Rect, Graphics::TCanvas* Canvas, const Rvfuncs::TRVScreenAndDevice 
		&sad);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	bool __fastcall IsEqual(TRVBorder* Value);
	bool __fastcall IsEqual_Para(TRVBorder* Value, TRVParaInfoProperties IgnoreList);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	int __fastcall GetTotalWidth(void);
	
__published:
	__property int Width = {read=FWidth, write=FWidth, default=1};
	__property int InternalWidth = {read=FInternalWidth, write=FInternalWidth, default=1};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-2147483640};
	__property TRVBorderStyle Style = {read=FStyle, write=FStyle, default=0};
	__property TRVBooleanRect* VisibleBorders = {read=FVisibleBorders, write=SetVisibleBorders};
	__property TRVRect* BorderOffsets = {read=FBorderOffsets, write=SetBorderOffsets};
};

#pragma pack(pop)

class DELPHICLASS TRVBackgroundRect;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVBackgroundRect : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TRVRect* FBorderOffsets;
	Graphics::TColor FColor;
	void __fastcall SetBorderOffsets(const TRVRect* Value);
	int __fastcall SimilarityValue(TRVBackgroundRect* Value);
	
public:
	__fastcall TRVBackgroundRect(void);
	__fastcall virtual ~TRVBackgroundRect(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall PrepareDraw(Windows::TRect &Rect);
	void __fastcall PrepareDrawSaD(Windows::TRect &Rect, const Rvfuncs::TRVScreenAndDevice &sad);
	void __fastcall Draw(const Windows::TRect &Rect, Graphics::TCanvas* Canvas);
	bool __fastcall IsEqual(TRVBackgroundRect* Value);
	bool __fastcall IsEqual_Para(TRVBackgroundRect* Value, TRVParaInfoProperties IgnoreList);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	
__published:
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=536870911};
	__property TRVRect* BorderOffsets = {read=FBorderOffsets, write=SetBorderOffsets};
};

#pragma pack(pop)

class DELPHICLASS TParaInfo;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TParaInfo : public TCustomRVInfo 
{
	typedef TCustomRVInfo inherited;
	
private:
	int FFirstIndent;
	int FLeftIndent;
	int FRightIndent;
	int FSpaceBefore;
	int FSpaceAfter;
	int FLineSpacing;
	TRVLineSpacingType FLineSpacingType;
	TRVAlignment FAlignment;
	TRVBorder* FBorder;
	int FNextParaNo;
	TRVBackgroundRect* FBackground;
	TRVParaOptions FOptions;
	TRVBiDiMode FBiDiMode;
	void __fastcall SetBorder(const TRVBorder* Value);
	void __fastcall SetBackground(const TRVBackgroundRect* Value);
	bool __fastcall ExtraLineSpacing(void);
	
protected:
	DYNAMIC bool __fastcall IsSimpleEqual(TCustomRVInfo* Value);
	DYNAMIC int __fastcall SimilarityValue(TCustomRVInfo* Value);
	
public:
	__fastcall virtual TParaInfo(Classes::TCollection* Collection);
	__fastcall virtual ~TParaInfo(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	HIDESBASE void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const 
		AnsiString fs);
	HIDESBASE void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const 
		AnsiString fs);
	bool __fastcall IsEqual(TParaInfo* Value, TRVParaInfoProperties IgnoreList);
	
__published:
	__property int FirstIndent = {read=FFirstIndent, write=FFirstIndent, default=0};
	__property int LeftIndent = {read=FLeftIndent, write=FLeftIndent, default=0};
	__property int RightIndent = {read=FRightIndent, write=FRightIndent, default=0};
	__property int SpaceBefore = {read=FSpaceBefore, write=FSpaceBefore, default=0};
	__property int SpaceAfter = {read=FSpaceAfter, write=FSpaceAfter, default=0};
	__property TRVAlignment Alignment = {read=FAlignment, write=FAlignment, default=0};
	__property TRVBorder* Border = {read=FBorder, write=SetBorder};
	__property TRVBackgroundRect* Background = {read=FBackground, write=SetBackground};
	__property int NextParaNo = {read=FNextParaNo, write=FNextParaNo, default=-1};
	__property int LineSpacing = {read=FLineSpacing, write=FLineSpacing, default=100};
	__property TRVLineSpacingType LineSpacingType = {read=FLineSpacingType, write=FLineSpacingType, default=0
		};
	__property TRVParaOptions Options = {read=FOptions, write=FOptions, nodefault};
	__property TRVBiDiMode BiDiMode = {read=FBiDiMode, write=FBiDiMode, default=0};
};

#pragma pack(pop)

class DELPHICLASS TParaInfos;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TParaInfos : public TCustomRVInfos 
{
	typedef TCustomRVInfos inherited;
	
private:
	HIDESBASE TParaInfo* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TParaInfo* Value);
	
public:
	__fastcall TParaInfos(Classes::TPersistent* Owner);
	HIDESBASE TParaInfo* __fastcall Add(void);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section);
	int __fastcall FindSuchStyle(int BaseStyle, TParaInfo* Style, TRVParaInfoProperties Mask);
	int __fastcall FindStyleWithAlignment(int BaseStyle, TRVAlignment Alignment);
	__property TParaInfo* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TParaInfos(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVStyle : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Graphics::TColor FColor;
	Graphics::TColor FHoverColor;
	Graphics::TColor FSelColor;
	Graphics::TColor FSelTextColor;
	Graphics::TColor FInactiveSelColor;
	Graphics::TColor FInactiveSelTextColor;
	Graphics::TColor FCheckpointColor;
	Graphics::TColor FCheckpointEvColor;
	Controls::TCursor FCursor;
	TFontInfos* FTextStyles;
	TParaInfos* FParaStyles;
	bool FFullRedraw;
	short FSpacesInTab;
	Graphics::TColor FPageBreakColor;
	TRVApplyStyleColorEvent FOnApplyStyleColor;
	TRVApplyStyleEvent FOnApplyStyle;
	TRVDrawStyleTextEvent FOnDrawStyleText;
	TRVStyleHoverSensitiveEvent FOnStyleHoverSensitive;
	TRVDrawTextBackEvent FOnDrawTextBack;
	TRVDrawCheckpointEvent FOnDrawCheckpoint;
	TRVDrawPageBreakEvent FOnDrawPageBreak;
	TRVDrawParaRectEvent FOnDrawParaBack;
	int FDefUnicodeStyle;
	TRVCodePage FDefCodePage;
	bool FUseSound;
	void __fastcall SetTextStyles(TFontInfos* ATextStyles);
	void __fastcall SetParaStyles(TParaInfos* Value);
	Graphics::TColor __fastcall GetHoverColorByColor(Graphics::TColor Color);
	
protected:
	virtual void __fastcall ReadState(Classes::TReader* Reader);
	
public:
	int ItemNo;
	int OffsetInItem;
	Classes::TPersistent* RVData;
	void __fastcall ResetTextStyles(void);
	void __fastcall ResetParaStyles(void);
	__fastcall virtual TRVStyle(Classes::TComponent* AOwner);
	__fastcall virtual ~TRVStyle(void);
	int __fastcall AddTextStyle(void);
	void __fastcall DeleteTextStyle(int Index);
	void __fastcall SaveINI(const AnsiString FileName, const AnsiString Section);
	void __fastcall LoadINI(const AnsiString FileName, const AnsiString Section);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, AnsiString Section);
	void __fastcall SaveReg(const AnsiString BaseKey);
	void __fastcall LoadReg(const AnsiString BaseKey);
	void __fastcall SaveCSSToStream(Classes::TStream* Stream, TRVSaveCSSOptions AOptions);
	bool __fastcall SaveCSS(const AnsiString FileName, TRVSaveCSSOptions AOptions);
	Graphics::TColor __fastcall GetHoverColor(int StyleNo);
	void __fastcall DrawTextBack(Graphics::TCanvas* Canvas, int ItemNo, int StyleNo, Classes::TPersistent* 
		RVData, int Left, int Top, int Width, int Height, TRVTextDrawStates DrawState);
	void __fastcall ApplyStyle(Graphics::TCanvas* Canvas, int StyleNo, TRVBiDiMode DefBiDiMode);
	void __fastcall ApplyStyleColor(Graphics::TCanvas* Canvas, int StyleNo, TRVTextDrawStates DrawState
		);
	void __fastcall DrawStyleText(const AnsiString s, Graphics::TCanvas* Canvas, int ItemNo, int OffsetInItem
		, int StyleNo, Classes::TPersistent* RVData, int SpaceBefore, int Left, int Top, int Width, int Height
		, TRVTextDrawStates DrawState, bool Printing);
	void __fastcall DrawCheckpoint(Graphics::TCanvas* Canvas, int X, int Y, int ItemNo, int XShift, bool 
		RaiseEvent, Controls::TControl* Control);
	void __fastcall DrawPageBreak(Graphics::TCanvas* Canvas, int Y, int XShift, Controls::TControl* Control
		);
	void __fastcall DrawParaBack(Graphics::TCanvas* Canvas, int ParaNo, const Windows::TRect &Rect);
	bool __fastcall StyleHoverSensitive(int StyleNo);
	
__published:
	__property TFontInfos* TextStyles = {read=FTextStyles, write=SetTextStyles};
	__property TParaInfos* ParaStyles = {read=FParaStyles, write=SetParaStyles};
	__property short SpacesInTab = {read=FSpacesInTab, write=FSpacesInTab, default=8};
	__property Controls::TCursor JumpCursor = {read=FCursor, write=FCursor, default=101};
	__property bool FullRedraw = {read=FFullRedraw, write=FFullRedraw, default=0};
	__property bool UseSound = {read=FUseSound, write=FUseSound, default=1};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-2147483643};
	__property Graphics::TColor HoverColor = {read=FHoverColor, write=FHoverColor, default=536870911};
	__property Graphics::TColor SelColor = {read=FSelColor, write=FSelColor, default=-2147483635};
	__property Graphics::TColor SelTextColor = {read=FSelTextColor, write=FSelTextColor, default=-2147483634
		};
	__property Graphics::TColor InactiveSelColor = {read=FInactiveSelColor, write=FInactiveSelColor, default=-2147483635
		};
	__property Graphics::TColor InactiveSelTextColor = {read=FInactiveSelTextColor, write=FInactiveSelTextColor
		, default=-2147483634};
	__property Graphics::TColor CheckpointColor = {read=FCheckpointColor, write=FCheckpointColor, default=32768
		};
	__property Graphics::TColor CheckpointEvColor = {read=FCheckpointEvColor, write=FCheckpointEvColor, 
		default=65280};
	__property Graphics::TColor PageBreakColor = {read=FPageBreakColor, write=FPageBreakColor, default=-2147483632
		};
	__property int DefUnicodeStyle = {read=FDefUnicodeStyle, write=FDefUnicodeStyle, default=-1};
	__property TRVCodePage DefCodePage = {read=FDefCodePage, write=FDefCodePage, default=0};
	__property TRVApplyStyleEvent OnApplyStyle = {read=FOnApplyStyle, write=FOnApplyStyle};
	__property TRVApplyStyleColorEvent OnApplyStyleColor = {read=FOnApplyStyleColor, write=FOnApplyStyleColor
		};
	__property TRVDrawStyleTextEvent OnDrawStyleText = {read=FOnDrawStyleText, write=FOnDrawStyleText};
		
	__property TRVStyleHoverSensitiveEvent OnStyleHoverSensitive = {read=FOnStyleHoverSensitive, write=
		FOnStyleHoverSensitive};
	__property TRVDrawTextBackEvent OnDrawTextBack = {read=FOnDrawTextBack, write=FOnDrawTextBack};
	__property TRVDrawCheckpointEvent OnDrawCheckpoint = {read=FOnDrawCheckpoint, write=FOnDrawCheckpoint
		};
	__property TRVDrawPageBreakEvent OnDrawPageBreak = {read=FOnDrawPageBreak, write=FOnDrawPageBreak};
		
	__property TRVDrawParaRectEvent OnDrawParaBack = {read=FOnDrawParaBack, write=FOnDrawParaBack};
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
static const Shortint crJump = 0x65;
static const Shortint rvsNormal = 0x0;
static const Shortint rvsHeading = 0x1;
static const Shortint rvsSubheading = 0x2;
static const Shortint rvsKeyword = 0x3;
static const Shortint rvsJump1 = 0x4;
static const Shortint rvsJump2 = 0x5;
static const Shortint rvsBreak = 0xffffffff;
static const Shortint rvsCheckpoint = 0xfffffffe;
static const Shortint rvsPicture = 0xfffffffd;
static const Shortint rvsHotspot = 0xfffffffc;
static const Shortint rvsComponent = 0xfffffffb;
static const Shortint rvsBullet = 0xfffffffa;
static const Shortint rvsBack = 0xfffffff9;
static const Shortint rvsVersionInfo = 0xfffffff8;
static const Shortint rvsDocProperty = 0xfffffff7;
static const Shortint rvsHotPicture = 0xfffffff6;
static const Shortint LAST_DEFAULT_STYLE_NO = 0x5;
extern PACKAGE TRVRTFOptions rvrtfDefault;
extern PACKAGE TRVFontInfoProperties RVAllFontInfoProperties;
extern PACKAGE TRVParaInfoProperties RVAllParaInfoProperties;
extern PACKAGE TRVParaInfoProperties RVAllParaBackgroundProperties;
extern PACKAGE TRVParaInfoProperties RVAllParaBorderProperties;
extern PACKAGE void __fastcall RVWrite(Classes::TStream* Stream, const AnsiString s);
extern PACKAGE void __fastcall RVWriteLn(Classes::TStream* Stream, const AnsiString s);

}	/* namespace Rvstyle */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Rvstyle;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// RVStyle
