//----------------------------------------------------------------------------
// RVStyle.hpp - bcbdcc32 generated hdr (DO NOT EDIT) rev: 0
// From: RVStyle.pas
//----------------------------------------------------------------------------
#ifndef RVStyleHPP
#define RVStyleHPP
//----------------------------------------------------------------------------
#include <RVMapWht.hpp>
#include <RVClasses.hpp>
#include <RVFuncs.hpp>
#include <Registry.hpp>
#include <IniFiles.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <System.hpp>
namespace Rvstyle
{
//-- type declarations -------------------------------------------------------
enum TRVRTFSaveArea { rv_rtfs_TextStyle, rv_rtfs_ParaStyle, rv_rtfs_CellProps, rv_rtfs_RowProps };

enum TRVReaderUnicode { rvruMixed, rvruNoUnicode, rvruOnlyUnicode };

enum TRVReaderStyleMode { rvrsUseSpecified, rvrsUseClosest, rvrsAddIfNeeded };

enum TRVFReaderStyleMode { rvf_sIgnore, rvf_sInsertMap, rvf_sInsertMerge };

typedef int TRVCodePage;

typedef void *TCheckpointData;

enum TRVTextDrawState { rvtsSelected, rvtsHover, rvtsItemStart, rvtsItemEnd, rvtsDrawItemStart, rvtsDrawItemEnd, 
	rvtsControlFocused };

typedef Set<TRVTextDrawState, rvtsSelected, rvtsControlFocused>  TRVTextDrawStates;

class __declspec(delphiclass) TRVStyle;
typedef void __fastcall (__closure *TRVDrawTextBackEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int StyleNo, int Left, int Top, int Width, int Height, TRVTextDrawStates DrawState, bool &DoDefault
	);

typedef void __fastcall (__closure *TRVApplyStyleEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas, 
	int StyleNo, bool &DoDefault);

typedef void __fastcall (__closure *TRVApplyStyleColorEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int StyleNo, TRVTextDrawStates DrawState, bool &DoDefault);

typedef void __fastcall (__closure *TRVDrawStyleTextEvent)(TRVStyle* Sender, const System::AnsiString 
	s, Graphics::TCanvas* Canvas, int StyleNo, int SpaceBefore, int Left, int Top, int Width, int Height
	, TRVTextDrawStates DrawState, bool &DoDefault);

typedef void __fastcall (__closure *TRVStyleHoverSensitiveEvent)(TRVStyle* Sender, int StyleNo, bool 
	&Sensitive);

typedef void __fastcall (__closure *TRVDrawCheckpointEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int X, int Y, int ItemNo, int XShift, bool RaiseEvent, Controls::TControl* Control, bool &DoDefault
	);

typedef void __fastcall (__closure *TRVDrawPageBreakEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int Y, int XShift, Controls::TControl* Control, bool &DoDefault);

typedef void __fastcall (__closure *TRVDrawParaRectEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int ParaNo, const Windows::TRect &ARect, bool &DoDefault);

enum TRVBreakStyle { rvbsLine, rvbsRectangle, rvbs3d };

enum TRVVAlign { rvvaBaseline, rvvaMiddle };

enum TRVFOption { rvfoSavePicturesBody, rvfoSaveControlsBody, rvfoIgnoreUnknownPicFmt, rvfoIgnoreUnknownCtrls, 
	rvfoConvUnknownStylesToZero, rvfoConvLargeImageIdxToZero, rvfoSaveBinary, rvfoUseStyleNames, rvfoSaveBack, 
	rvfoLoadBack, rvfoSaveTextStyles, rvfoSaveParaStyles };

typedef Set<TRVFOption, rvfoSavePicturesBody, rvfoSaveParaStyles>  TRVFOptions;

enum TRVFWarning { rvfwUnknownPicFmt, rvfwUnknownCtrls, rvfwConvUnknownStyles, rvfwConvLargeImageIdx, 
	rvfwConvToUnicode, rvfwConvFromUnicode };

typedef Set<TRVFWarning, rvfwUnknownPicFmt, rvfwConvFromUnicode>  TRVFWarnings;

enum TRVControlAction { rvcaAfterRVFLoad, rvcaDestroy, rvcaMoveToUndoList, rvcaMoveFromUndoList, rvcaDestroyInUndoList, 
	rvcaBeforeRVFSave, rvcaAfterRVFSave };

enum TRVProtectOption { rvprStyleProtect, rvprModifyProtect, rvprDeleteProtect, rvprConcateProtect, 
	rvprRVFInsertProtect, rvprDoNotAutoSwitch, rvprParaStartProtect, rvprSticking };

typedef Set<TRVProtectOption, rvprStyleProtect, rvprSticking>  TRVProtectOptions;

enum TRVParaOption { rvpaoNoWrap, rvpaoReadOnly, rvpaoStyleProtect };

typedef Set<TRVParaOption, rvpaoNoWrap, rvpaoStyleProtect>  TRVParaOptions;

enum TRVSaveOption { rvsoOverrideImages, rvsoFirstOnly, rvsoMiddleOnly, rvsoLastOnly, rvsoDefault0Style, 
	rvsoNoHypertextImageBorders, rvsoImageSizes, rvsoForceNonTextCSS };

typedef Set<TRVSaveOption, rvsoOverrideImages, rvsoForceNonTextCSS>  TRVSaveOptions;

enum TRVRTFOption { rvrtfSaveStyleSheet, rvrtfDuplicateUnicode, rvrtfSaveEMFAsWMF, rvrtfSaveJpegAsJpeg, 
	rvrtfSaveBitmapDefault, rvrtfSaveEMFDefault };

typedef Set<TRVRTFOption, rvrtfSaveStyleSheet, rvrtfSaveEMFDefault>  TRVRTFOptions;

enum TRVFontStyle { rvfsOverline, rvfsAllCaps };

typedef Set<TRVFontStyle, rvfsOverline, rvfsAllCaps>  TRVFontStyles;

enum TRVAlignment { rvaLeft, rvaRight, rvaCenter, rvaJustify };


enum TRVSaveCSSOption { rvcssOnlyDifference, rvcssIgnoreLeftAlignment };

typedef Set<TRVSaveCSSOption, rvcssOnlyDifference, rvcssIgnoreLeftAlignment>  TRVSaveCSSOptions;

enum TRVBiDiMode { rvbdUnspecified, rvbdLeftToRight, rvbdRightToLeft };

enum TRVFontInfoProperty { rvfiFontName, rvfiSize, rvfiCharset, rvfiUnicode, rvfiBold, rvfiItalic, rvfiUnderline, 
	rvfiStrikeout, rvfiOverline, rvfiAllCaps, rvfiVShift, rvfiColor, rvfiBackColor, rvfiJump, rvfiHoverBackColor, 
	rvfiHoverColor, rvfiJumpCursor, rvfiNextStyleNo, rvfiProtection, rvfiCharScale, rvfiBaseStyleNo, rvfiBiDiMode, 
	rvfiCharSpacing };

enum TRVParaInfoProperty { rvpiFirstIndent, rvpiLeftIndent, rvpiRightIndent, rvpiSpaceBefore, rvpiSpaceAfter, 
	rvpiAlignment, rvpiNextParaNo, rvpiLineSpacing, rvpiLineSpacingType, rvpiBackground_Color, rvpiBackground_BO_Left, 
	rvpiBackground_BO_Top, rvpiBackground_BO_Right, rvpiBackground_BO_Bottom, rvpiBorder_Color, rvpiBorder_Style, 
	rvpiBorder_Width, rvpiBorder_InternalWidth, rvpiBorder_BO_Left, rvpiBorder_BO_Top, rvpiBorder_BO_Right, 
	rvpiBorder_BO_Bottom, rvpiBorder_Vis_Left, rvpiBorder_Vis_Top, rvpiBorder_Vis_Right, rvpiBorder_Vis_Bottom, 
	rvpiNoWrap, rvpiReadOnly, rvpiStyleProtect, rvpiBiDiMode };

typedef Set<TRVFontInfoProperty, rvfiFontName, rvfiCharSpacing>  TRVFontInfoProperties;

typedef Set<TRVParaInfoProperty, rvpiFirstIndent, rvpiBiDiMode>  TRVParaInfoProperties;

enum TRVLineSpacingType { rvlsPercent, rvlsSpaceBetween };

enum TRVStyleMergeMode { rvs_merge_SmartMerge, rvs_merge_Map, rvs_merge_Append };

class __declspec(delphiclass) TCustomRVInfo;
class __declspec(pascalimplementation) TCustomRVInfo : public Classes::TCollectionItem
{
	typedef Classes::TCollectionItem inherited;
	
private:
	int FBaseStyleNo;
	System::AnsiString FName;
	bool FStandard;
	
protected:
	virtual bool __fastcall IsSimpleEqual(TCustomRVInfo* Value) = 0;
	virtual int __fastcall SimilarityValue(TCustomRVInfo* Value) = 0;
	
public:
	__fastcall virtual TCustomRVInfo(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs, const System::AnsiString DefName);
	
__published:
	__property int BaseStyleNo = {read=FBaseStyleNo, write=FBaseStyleNo, default=-1};
	__property System::AnsiString StyleName = {read=FName, write=FName, nodefault};
	__property bool Standard = {read=FStandard, write=FStandard, default=1};
public:
	/* TCollectionItem.Destroy */ __fastcall virtual ~TCustomRVInfo(void) { }
	
};

class __declspec(delphiclass) TFontInfo;
class __declspec(pascalimplementation) TFontInfo : public TCustomRVInfo
{
	typedef TCustomRVInfo inherited;
	
private:
	TRVBiDiMode FBiDiMode;
	bool FJump;
	Controls::TCursor FJumpCursor;
	Graphics::TFontName FFontName;
	int FSize;
	Graphics::TColor FColor;
	Graphics::TColor FBackColor;
	Graphics::TColor FHoverColor;
	Graphics::TColor FHoverBackColor;
	Graphics::TFontStyles FStyle;
	TRVFontStyles FStyleEx;
	int FVShift;
	int FNextStyleNo;
	bool FUnicode;
	TRVProtectOptions FProtection;
	int FCharScale;
	int FCharSpacing;
	void __fastcall SingleSymbolsReader(Classes::TReader* reader);
	
protected:
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	virtual bool __fastcall IsSimpleEqual(TCustomRVInfo* Value);
	virtual int __fastcall SimilarityValue(TCustomRVInfo* Value);
	
public:
	__fastcall virtual TFontInfo(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall AssignToLogFont(tagLOGFONTA &LogFont, Graphics::TCanvas* Canvas);
	void __fastcall Apply(Graphics::TCanvas* Canvas, TRVBiDiMode DefBiDiMode);
	void __fastcall ApplyColor(Graphics::TCanvas* Canvas, TRVStyle* RVStyle, TRVTextDrawStates DrawState
		);
	void __fastcall Draw(const System::AnsiString s, Graphics::TCanvas* Canvas, int ThisStyleNo, int SpaceBefore
		, int Left, int Top, int Width, int Height, TRVStyle* RVStyle, TRVTextDrawStates DrawState, bool Printing
		);
	void __fastcall DrawVertical(const System::AnsiString s, Graphics::TCanvas* Canvas, int ThisStyleNo
		, int SpaceBefore, int Left, int Top, int Width, int Height, TRVStyle* RVStyle, TRVTextDrawStates 
		DrawState);
	bool __fastcall IsEqual(TFontInfo* Value, TRVFontInfoProperties IgnoreList);
	HIDESBASE void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	HIDESBASE void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs, bool JumpByDefault, Controls::TCursor DefJumpCursor);
	
__published:
	__property Graphics::TFontName FontName = {read=FFontName, write=FFontName};
	__property int Size = {read=FSize, write=FSize, default=10};
	__property Graphics::TFontStyles Style = {read=FStyle, write=FStyle, default=0};
	__property int VShift = {read=FVShift, write=FVShift, default=0};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-2147483640};
	__property Graphics::TColor BackColor = {read=FBackColor, write=FBackColor, default=536870911};
	__property Graphics::TColor HoverBackColor = {read=FHoverBackColor, write=FHoverBackColor, default=536870911
		};
	__property Graphics::TColor HoverColor = {read=FHoverColor, write=FHoverColor, default=536870911};
	__property TRVFontStyles StyleEx = {read=FStyleEx, write=FStyleEx, default=0};
	__property bool Jump = {read=FJump, write=FJump, default=0};
	__property Controls::TCursor JumpCursor = {read=FJumpCursor, write=FJumpCursor, default=101};
	__property int CharScale = {read=FCharScale, write=FCharScale, default=100};
	__property int CharSpacing = {read=FCharSpacing, write=FCharSpacing, default=0};
	__property int NextStyleNo = {read=FNextStyleNo, write=FNextStyleNo, default=-1};
	__property TRVBiDiMode BiDiMode = {read=FBiDiMode, write=FBiDiMode, default=0};
	__property bool Unicode = {read=FUnicode, write=FUnicode, default=0};
	__property TRVProtectOptions Protection = {read=FProtection, write=FProtection, default=0};
public:
	/* TCollectionItem.Destroy */ __fastcall virtual ~TFontInfo(void) { }
	
};

class __declspec(delphiclass) TCustomRVInfos;
class __declspec(pascalimplementation) TCustomRVInfos : public Classes::TCollection
{
	typedef Classes::TCollection inherited;
	
private:
	Classes::TPersistent* FOwner;
	
public:
	__fastcall TCustomRVInfos(System::TMetaClass* ItemClass, Classes::TPersistent* Owner);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall MergeWith(TCustomRVInfos* Styles, TRVStyleMergeMode Mode, Rvclasses::TRVIntegerList* 
		Mapping);
public:
	/* TCollection.Destroy */ __fastcall virtual ~TCustomRVInfos(void) { }
	
};

class __declspec(delphiclass) TFontInfos;
class __declspec(pascalimplementation) TFontInfos : public TCustomRVInfos
{
	typedef TCustomRVInfos inherited;
	
private:
	HIDESBASE TFontInfo* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TFontInfo* Value);
	
public:
	__fastcall TFontInfos(Classes::TPersistent* Owner);
	int __fastcall FindStyleWithFontStyle(int BaseStyle, Graphics::TFontStyles Value, Graphics::TFontStyles 
		Mask);
	int __fastcall FindStyleWithFontSize(int BaseStyle, int Size);
	int __fastcall FindStyleWithColor(int BaseStyle, Graphics::TColor Color, Graphics::TColor BackColor
		);
	int __fastcall FindStyleWithFontName(int BaseStyle, const Graphics::TFontName &FontName);
	int __fastcall FindSuchStyle(int BaseStyle, TFontInfo* Style, TRVFontInfoProperties Mask);
	int __fastcall FindStyleWithFont(int BaseStyle, Graphics::TFont* Font);
	HIDESBASE TFontInfo* __fastcall Add(void);
	void __fastcall Delete(int Index);
	TFontInfo* __fastcall AddFont( Graphics::TFontName &Name, int Size, Graphics::TColor Color, Graphics::TColor 
		BackColor, Graphics::TFontStyles Style);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, Controls::TCursor 
		DefJumpCursor);
	__property TFontInfo* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
public:
	/* TCollection.Destroy */ __fastcall virtual ~TFontInfos(void) { }
	
};

class __declspec(delphiclass) TRVRect;
class __declspec(pascalimplementation) TRVRect : public Classes::TPersistent
{
	typedef Classes::TPersistent inherited;
	
private:
	int FTop;
	int FLeft;
	int FRight;
	int FBottom;
	bool __fastcall IsEqualEx(TRVRect* Value, bool IgnL, bool IgnT, bool IgnR, bool IgnB);
	int __fastcall SimilarityValue(TRVRect* Value, int Weight);
	
public:
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall InflateRect(Windows::TRect &Rect);
	void __fastcall InflateRectSaD(Windows::TRect &Rect, const Rvfuncs::TRVScreenAndDevice &sad);
	void __fastcall AssignToRect(Windows::TRect &Rect);
	void __fastcall AssignToRectIfGreater(Windows::TRect &Rect);
	bool __fastcall IsEqual(TRVRect* Value);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	
__published:
	__property int Left = {read=FLeft, write=FLeft, default=0};
	__property int Right = {read=FRight, write=FRight, default=0};
	__property int Top = {read=FTop, write=FTop, default=0};
	__property int Bottom = {read=FBottom, write=FBottom, default=0};
public:
	/* TObject.Create */ __fastcall TRVRect(void) : Classes::TPersistent() { }
	/* TObject.Destroy */ __fastcall virtual ~TRVRect(void) { }
	
};

class __declspec(delphiclass) TRVBooleanRect;
class __declspec(pascalimplementation) TRVBooleanRect : public Classes::TPersistent
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FTop;
	bool FLeft;
	bool FRight;
	bool FBottom;
	bool __fastcall IsEqualEx(TRVBooleanRect* Value, bool IgnL, bool IgnT, bool IgnR, bool IgnB);
	
public:
	__fastcall TRVBooleanRect(bool DefValue);
	void __fastcall SetAll(bool Value);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	bool __fastcall IsEqual(TRVBooleanRect* Value);
	bool __fastcall IsAllEqual(bool Value);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	
__published:
	__property bool Left = {read=FLeft, write=FLeft, default=1};
	__property bool Right = {read=FRight, write=FRight, default=1};
	__property bool Top = {read=FTop, write=FTop, default=1};
	__property bool Bottom = {read=FBottom, write=FBottom, default=1};
public:
	/* TObject.Destroy */ __fastcall virtual ~TRVBooleanRect(void) { }
	
};

enum TRVBorderStyle { rvbNone, rvbSingle, rvbDouble, rvbTriple, rvbThickInside, rvbThickOutside };

class __declspec(delphiclass) TRVBorder;
class __declspec(pascalimplementation) TRVBorder : public Classes::TPersistent
{
	typedef Classes::TPersistent inherited;
	
private:
	Graphics::TColor FColor;
	TRVBorderStyle FStyle;
	int FWidth;
	int FInternalWidth;
	TRVBooleanRect* FVisibleBorders;
	TRVRect* FBorderOffsets;
	void __fastcall SetBorderOffsets(TRVRect* const Value);
	void __fastcall SetVisibleBorders(TRVBooleanRect* const Value);
	int __fastcall SimilarityValue(TRVBorder* Value);
	
protected:
	void __fastcall DoDraw(const Windows::TRect &Rect, Graphics::TCanvas* Canvas, int Width, int InternalWidth
		, int OnePixelWidth);
	
public:
	__fastcall TRVBorder(void);
	__fastcall virtual ~TRVBorder(void);
	void __fastcall Draw(const Windows::TRect &Rect, Graphics::TCanvas* Canvas);
	void __fastcall DrawSaD(const Windows::TRect &Rect, Graphics::TCanvas* Canvas, const Rvfuncs::TRVScreenAndDevice 
		&sad);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	bool __fastcall IsEqual(TRVBorder* Value);
	bool __fastcall IsEqual_Para(TRVBorder* Value, TRVParaInfoProperties IgnoreList);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	int __fastcall GetTotalWidth(void);
	
__published:
	__property int Width = {read=FWidth, write=FWidth, default=1};
	__property int InternalWidth = {read=FInternalWidth, write=FInternalWidth, default=1};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-2147483640};
	__property TRVBorderStyle Style = {read=FStyle, write=FStyle, default=0};
	__property TRVBooleanRect* VisibleBorders = {read=FVisibleBorders, write=SetVisibleBorders, nodefault
		};
	__property TRVRect* BorderOffsets = {read=FBorderOffsets, write=SetBorderOffsets, nodefault};
};

class __declspec(delphiclass) TRVBackgroundRect;
class __declspec(pascalimplementation) TRVBackgroundRect : public Classes::TPersistent
{
	typedef Classes::TPersistent inherited;
	
private:
	TRVRect* FBorderOffsets;
	Graphics::TColor FColor;
	void __fastcall SetBorderOffsets(TRVRect* const Value);
	int __fastcall SimilarityValue(TRVBackgroundRect* Value);
	
public:
	__fastcall TRVBackgroundRect(void);
	__fastcall virtual ~TRVBackgroundRect(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall PrepareDraw(Windows::TRect &Rect);
	void __fastcall PrepareDrawSaD(Windows::TRect &Rect, const Rvfuncs::TRVScreenAndDevice &sad);
	void __fastcall Draw(const Windows::TRect &Rect, Graphics::TCanvas* Canvas);
	bool __fastcall IsEqual(TRVBackgroundRect* Value);
	bool __fastcall IsEqual_Para(TRVBackgroundRect* Value, TRVParaInfoProperties IgnoreList);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	
__published:
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=536870911};
	__property TRVRect* BorderOffsets = {read=FBorderOffsets, write=SetBorderOffsets, nodefault};
};

class __declspec(delphiclass) TParaInfo;
class __declspec(pascalimplementation) TParaInfo : public TCustomRVInfo
{
	typedef TCustomRVInfo inherited;
	
private:
	int FFirstIndent;
	int FLeftIndent;
	int FRightIndent;
	int FSpaceBefore;
	int FSpaceAfter;
	int FLineSpacing;
	TRVLineSpacingType FLineSpacingType;
	TRVAlignment FAlignment;
	TRVBorder* FBorder;
	int FNextParaNo;
	TRVBackgroundRect* FBackground;
	TRVParaOptions FOptions;
	TRVBiDiMode FBiDiMode;
	void __fastcall SetBorder(TRVBorder* const Value);
	void __fastcall SetBackground(TRVBackgroundRect* const Value);
	bool __fastcall ExtraLineSpacing(void);
	
protected:
	virtual bool __fastcall IsSimpleEqual(TCustomRVInfo* Value);
	virtual int __fastcall SimilarityValue(TCustomRVInfo* Value);
	
public:
	__fastcall virtual TParaInfo(Classes::TCollection* Collection);
	__fastcall virtual ~TParaInfo(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	HIDESBASE void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	HIDESBASE void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	bool __fastcall IsEqual(TParaInfo* Value, TRVParaInfoProperties IgnoreList);
	
__published:
	__property int FirstIndent = {read=FFirstIndent, write=FFirstIndent, default=0};
	__property int LeftIndent = {read=FLeftIndent, write=FLeftIndent, default=0};
	__property int RightIndent = {read=FRightIndent, write=FRightIndent, default=0};
	__property int SpaceBefore = {read=FSpaceBefore, write=FSpaceBefore, default=0};
	__property int SpaceAfter = {read=FSpaceAfter, write=FSpaceAfter, default=0};
	__property TRVAlignment Alignment = {read=FAlignment, write=FAlignment, default=0};
	__property TRVBorder* Border = {read=FBorder, write=SetBorder, nodefault};
	__property TRVBackgroundRect* Background = {read=FBackground, write=SetBackground, nodefault};
	__property int NextParaNo = {read=FNextParaNo, write=FNextParaNo, default=-1};
	__property int LineSpacing = {read=FLineSpacing, write=FLineSpacing, default=100};
	__property TRVLineSpacingType LineSpacingType = {read=FLineSpacingType, write=FLineSpacingType, default=0
		};
	__property TRVParaOptions Options = {read=FOptions, write=FOptions, nodefault};
	__property TRVBiDiMode BiDiMode = {read=FBiDiMode, write=FBiDiMode, default=0};
};

class __declspec(delphiclass) TParaInfos;
class __declspec(pascalimplementation) TParaInfos : public TCustomRVInfos
{
	typedef TCustomRVInfos inherited;
	
private:
	HIDESBASE TParaInfo* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TParaInfo* Value);
	
public:
	__fastcall TParaInfos(Classes::TPersistent* Owner);
	HIDESBASE TParaInfo* __fastcall Add(void);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section);
	int __fastcall FindSuchStyle(int BaseStyle, TParaInfo* Style, TRVParaInfoProperties Mask);
	int __fastcall FindStyleWithAlignment(int BaseStyle, TRVAlignment Alignment);
	__property TParaInfo* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
public:
	/* TCollection.Destroy */ __fastcall virtual ~TParaInfos(void) { }
	
};

class __declspec(pascalimplementation) TRVStyle : public Classes::TComponent
{
	typedef Classes::TComponent inherited;
	
private:
	Graphics::TColor FColor;
	Graphics::TColor FHoverColor;
	Graphics::TColor FSelColor;
	Graphics::TColor FSelTextColor;
	Graphics::TColor FInactiveSelColor;
	Graphics::TColor FInactiveSelTextColor;
	Graphics::TColor FCheckpointColor;
	Graphics::TColor FCheckpointEvColor;
	Controls::TCursor FCursor;
	TFontInfos* FTextStyles;
	TParaInfos* FParaStyles;
	bool FFullRedraw;
	short FSpacesInTab;
	Graphics::TColor FPageBreakColor;
	TRVApplyStyleColorEvent FOnApplyStyleColor;
	TRVApplyStyleEvent FOnApplyStyle;
	TRVDrawStyleTextEvent FOnDrawStyleText;
	TRVStyleHoverSensitiveEvent FOnStyleHoverSensitive;
	TRVDrawTextBackEvent FOnDrawTextBack;
	TRVDrawCheckpointEvent FOnDrawCheckpoint;
	TRVDrawPageBreakEvent FOnDrawPageBreak;
	TRVDrawParaRectEvent FOnDrawParaBack;
	int FDefUnicodeStyle;
	TRVCodePage FDefCodePage;
	bool FUseSound;
	void __fastcall SetTextStyles(TFontInfos* ATextStyles);
	void __fastcall SetParaStyles(TParaInfos* Value);
	Graphics::TColor __fastcall GetHoverColorByColor(Graphics::TColor Color);
	
protected:
	virtual void __fastcall ReadState(Classes::TReader* Reader);
	
public:
	int ItemNo;
	int OffsetInItem;
	Classes::TPersistent* RVData;
	void __fastcall ResetTextStyles(void);
	void __fastcall ResetParaStyles(void);
	__fastcall virtual TRVStyle(Classes::TComponent* AOwner);
	__fastcall virtual ~TRVStyle(void);
	int __fastcall AddTextStyle(void);
	void __fastcall DeleteTextStyle(int Index);
	void __fastcall SaveINI(const System::AnsiString FileName, const System::AnsiString Section);
	void __fastcall LoadINI(const System::AnsiString FileName, const System::AnsiString Section);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini,  System::AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini,  System::AnsiString Section);
	void __fastcall SaveCSSToStream(Classes::TStream* Stream, TRVSaveCSSOptions AOptions);
	bool __fastcall SaveCSS(const System::AnsiString FileName, TRVSaveCSSOptions AOptions);
	Graphics::TColor __fastcall GetHoverColor(int StyleNo);
	void __fastcall DrawTextBack(Graphics::TCanvas* Canvas, int ItemNo, int StyleNo, Classes::TPersistent* 
		RVData, int Left, int Top, int Width, int Height, TRVTextDrawStates DrawState);
	void __fastcall ApplyStyle(Graphics::TCanvas* Canvas, int StyleNo, TRVBiDiMode DefBiDiMode);
	void __fastcall ApplyStyleColor(Graphics::TCanvas* Canvas, int StyleNo, TRVTextDrawStates DrawState
		);
	void __fastcall DrawStyleText(const System::AnsiString s, Graphics::TCanvas* Canvas, int ItemNo, int 
		OffsetInItem, int StyleNo, Classes::TPersistent* RVData, int SpaceBefore, int Left, int Top, int Width
		, int Height, TRVTextDrawStates DrawState, bool Printing);
	void __fastcall DrawCheckpoint(Graphics::TCanvas* Canvas, int X, int Y, int ItemNo, int XShift, bool 
		RaiseEvent, Controls::TControl* Control);
	void __fastcall DrawPageBreak(Graphics::TCanvas* Canvas, int Y, int XShift, Controls::TControl* Control
		);
	void __fastcall DrawParaBack(Graphics::TCanvas* Canvas, int ParaNo, const Windows::TRect &Rect);
	bool __fastcall StyleHoverSensitive(int StyleNo);
	
__published:
	__property TFontInfos* TextStyles = {read=FTextStyles, write=SetTextStyles, nodefault};
	__property TParaInfos* ParaStyles = {read=FParaStyles, write=SetParaStyles, nodefault};
	__property short SpacesInTab = {read=FSpacesInTab, write=FSpacesInTab, default=8};
	__property Controls::TCursor JumpCursor = {read=FCursor, write=FCursor, default=101};
	__property bool FullRedraw = {read=FFullRedraw, write=FFullRedraw, default=0};
	__property bool UseSound = {read=FUseSound, write=FUseSound, default=1};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-2147483643};
	__property Graphics::TColor HoverColor = {read=FHoverColor, write=FHoverColor, default=536870911};
	__property Graphics::TColor SelColor = {read=FSelColor, write=FSelColor, default=-2147483635};
	__property Graphics::TColor SelTextColor = {read=FSelTextColor, write=FSelTextColor, default=-2147483634
		};
	__property Graphics::TColor InactiveSelColor = {read=FInactiveSelColor, write=FInactiveSelColor, default=-2147483635
		};
	__property Graphics::TColor InactiveSelTextColor = {read=FInactiveSelTextColor, write=FInactiveSelTextColor
		, default=-2147483634};
	__property Graphics::TColor CheckpointColor = {read=FCheckpointColor, write=FCheckpointColor, default=32768
		};
	__property Graphics::TColor CheckpointEvColor = {read=FCheckpointEvColor, write=FCheckpointEvColor, 
		default=65280};
	__property Graphics::TColor PageBreakColor = {read=FPageBreakColor, write=FPageBreakColor, default=-2147483632
		};
	__property int DefUnicodeStyle = {read=FDefUnicodeStyle, write=FDefUnicodeStyle, default=-1};
	__property TRVCodePage DefCodePage = {read=FDefCodePage, write=FDefCodePage, default=0};
	__property TRVApplyStyleEvent OnApplyStyle = {read=FOnApplyStyle, write=FOnApplyStyle};
	__property TRVApplyStyleColorEvent OnApplyStyleColor = {read=FOnApplyStyleColor, write=FOnApplyStyleColor
		};
	__property TRVDrawStyleTextEvent OnDrawStyleText = {read=FOnDrawStyleText, write=FOnDrawStyleText};
		
	__property TRVStyleHoverSensitiveEvent OnStyleHoverSensitive = {read=FOnStyleHoverSensitive, write=
		FOnStyleHoverSensitive};
	__property TRVDrawTextBackEvent OnDrawTextBack = {read=FOnDrawTextBack, write=FOnDrawTextBack};
	__property TRVDrawCheckpointEvent OnDrawCheckpoint = {read=FOnDrawCheckpoint, write=FOnDrawCheckpoint
		};
	__property TRVDrawPageBreakEvent OnDrawPageBreak = {read=FOnDrawPageBreak, write=FOnDrawPageBreak};
		
	__property TRVDrawParaRectEvent OnDrawParaBack = {read=FOnDrawParaBack, write=FOnDrawParaBack};
};

//-- var, const, procedure ---------------------------------------------------
#define crJump (Byte)(101)
#define rvsNormal (Byte)(0)
#define rvsHeading (Byte)(1)
#define rvsSubheading (Byte)(2)
#define rvsKeyword (Byte)(3)
#define rvsJump1 (Byte)(4)
#define rvsJump2 (Byte)(5)
#define rvsBreak (Shortint)(-1)
#define rvsCheckpoint (Shortint)(-2)
#define rvsPicture (Shortint)(-3)
#define rvsHotspot (Shortint)(-4)
#define rvsComponent (Shortint)(-5)
#define rvsBullet (Shortint)(-6)
#define rvsBack (Shortint)(-7)
#define rvsVersionInfo (Shortint)(-8)
#define rvsDocProperty (Shortint)(-9)
#define rvsHotPicture (Shortint)(-10)
#define LAST_DEFAULT_STYLE_NO (Byte)(5)
extern TRVRTFOptions rvrtfDefault;
extern TRVFontInfoProperties RVAllFontInfoProperties;
extern TRVParaInfoProperties RVAllParaInfoProperties;
extern TRVParaInfoProperties RVAllParaBackgroundProperties;
extern TRVParaInfoProperties RVAllParaBorderProperties;
extern void __fastcall RVWrite(Classes::TStream* Stream, const System::AnsiString s);
extern void __fastcall RVWriteLn(Classes::TStream* Stream, const System::AnsiString s);
//-- template instantiations -------------------------------------------------
template class Graphics::TFontStyles ;
template class TRVParaInfoProperties ;
template class TRVFontInfoProperties ;
template class TRVSaveCSSOptions ;
template class TRVFontStyles ;
template class TRVRTFOptions ;
template class TRVSaveOptions ;
template class TRVParaOptions ;
template class TRVProtectOptions ;
template class TRVFWarnings ;
template class TRVFOptions ;
template class TRVTextDrawStates ;

}	/* namespace Rvstyle */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Rvstyle;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// RVStyle
