unit BlockInsert;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DXFConv;

type
  TfmBlockInsert = class(TForm)
    lsbBlockName: TListBox;
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    lbeY: TEdit;
    lbY: TLabel;
    lbeX: TEdit;
    lbX: TLabel;
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmBlockInsert: TfmBlockInsert;

implementation
{$INCLUDE SGDXF.INC}

uses fMain;

{$R *.dfm}

procedure TfmBlockInsert.FormShow(Sender: TObject);
var
  I: Integer;
begin
  lsbBlockName.Items.Clear;
  for I := 0 to fmMain.FBlockLibrary.BlockList.Count - 1 do
    lsbBlockName.Items.Add(TsgDXFBlock(fmMain.FBlockLibrary.BlockList.Items[I]).Name);
end;

procedure TfmBlockInsert.Button1Click(Sender: TObject);
var
  X, Y: Single;
  Index: Integer;
begin
  if (lbeX.Text <> '')and(lbeY.Text <> '') then
    try
      X := StrToFloat(lbeX.Text);
      Y := StrToFloat(lbeY.Text);
    except
      ShowMessage('Point is incorrect');
      Exit;
    end
  else
  begin
    ShowMessage('Indicate a point');
    Exit;
  end;
  Index := lsbBlockName.ItemIndex;
  if Index = -1 then
  begin
    ShowMessage('Select block');
    Exit;
  end;
  fmMain.InsertBlock(Index, X, Y);
  Close;
end;

procedure TfmBlockInsert.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TfmBlockInsert.FormCreate(Sender: TObject);
begin
  {$IFDEF SGDEL_4}
  OldCreateOrder := False;
  {$ENDIF}
end;

end.
