//---------------------------------------------------------------------------
#ifndef fAddScaledFileH
#define fAddScaledFileH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include <DXFConv.hpp>
#include <sgConsts.hpp>
#include "CSPIN.h"
#include <Dialogs.hpp>
#include <ExtDlgs.hpp>
#include <DXFImage.hpp>
#include <Dialogs.hpp>
#include <ExtDlgs.hpp>
#include "cspin.h"
//-- type declarations -------------------------------------------------------
struct TInsertProp;
typedef TInsertProp *PInsertProp;

struct TInsertProp
{
	Sgconsts::TFPoint Position;
	Sgconsts::TFPoint Scale;
	double Rotation;
	AnsiString FileName;
} ;

class TfmAddScaledFile : public TForm
{
__published:	// IDE-managed Components
  TPanel *pnlUp;
  TCheckBox *cbWithoutBorder;
  TPanel *pnlDown;
  TPanel *pnlAll;
  TLabel *lblWasAdded;
  TLabel *lblCountWasAdded;
  TLabel *lblRotation;
  TBitBtn *btnOpenFile;
  TBitBtn *btnApplyDefault;
  TComboBox *cbAddedFiles;
  TGroupBox *gbPosition;
  TLabel *lblPosX;
  TLabel *lblPosY;
  TLabel *lblPosZ;
  TGroupBox *gbScale;
  TLabel *lblScaleZ;
  TLabel *Label3;
  TLabel *lblScaleX;
  TLabel *Label6;
  TLabel *lblScaleY;
  TLabel *Label7;
  TBitBtn *btnOk;
  TCSpinEdit *sePosX;
  TCSpinEdit *sePosY;
  TCSpinEdit *sePosZ;
  TCSpinEdit *seScaleX;
  TCSpinEdit *seScaleY;
  TCSpinEdit *seScaleZ;
  TCSpinEdit *seRotation;
  TOpenPictureDialog *OpenDialog;
  void __fastcall btnOpenFileClick(TObject *Sender);
  void __fastcall cbAddedFilesChange(TObject *Sender);
  void __fastcall sePropsChange(TObject *Sender);
  void __fastcall btnApplyDefaultClick(TObject *Sender);
  void __fastcall btnOkClick(TObject *Sender);
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall ShowProp(TInsertProp * Prop);
  void __fastcall PropToStruct(TInsertProp * P);
  void __fastcall FormDestroy(TObject *Sender);
private:	// User declarations
  TsgDXFImage *FCADFile;
  bool FIsInternalChanging;
  int FFilesCount;
  void __fastcall SetImage(TsgDXFImage * value);
  TsgDXFImage * __fastcall GetImage();
  void __fastcall SetFilesCount(int Value);
  int __fastcall GetFilesCount();
public:		// User declarations
  __fastcall TfmAddScaledFile(TComponent* Owner);
  __property int FilesCount  = { read = GetFilesCount, write = SetFilesCount };
  __property TsgDXFImage *CADFile = { read = GetImage, write = SetImage };
};

//---------------------------------------------------------------------------
extern PACKAGE TfmAddScaledFile *fmAddScaledFile;
//---------------------------------------------------------------------------
#endif
