// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'sgRectangle.pas' rev: 6.00

#ifndef sgRectangleHPP
#define sgRectangleHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <sgConsts.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Sgrectangle
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TsgMarkerTypes { rmidTL, rmidTM, rmidTR, rmidMR, rmidBR, rmidBM, rmidBL, rmidML, rmidMM };
#pragma option pop

typedef Set<TsgMarkerTypes, rmidTL, rmidMM>  TsgMarkerTypesSet;

class DELPHICLASS TsgMarker;
class DELPHICLASS TsgRectangle;
class PASCALIMPLEMENTATION TsgRectangle : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Controls::TControl* FControl;
	TsgMarker* FMarkers[9];
	bool FActive;
	bool FRectZooming;
	Graphics::TBrush* FBrush;
	Graphics::TPen* FPen;
	Graphics::TBrush* FBrushStore;
	Graphics::TPen* FPenStore;
	bool FCapture;
	TsgMarker* FMarker;
	Controls::THintWindow* FHint;
	bool FHintHiden;
	bool FOldCapture;
	bool FShowHint;
	int __fastcall DoRectChanging(System::TObject* Sender, const Types::TPoint &APoint);
	Controls::TCursor __fastcall GetCursor(void);
	Graphics::TCanvas* __fastcall GetCanvas(void);
	TsgMarker* __fastcall GetMarkers(TsgMarkerTypes Index);
	Types::TRect __fastcall GetRect();
	void __fastcall SetActive(const bool Value);
	void __fastcall SetControl(const Controls::TControl* Value);
	void __fastcall SetCursor(const Controls::TCursor Value);
	void __fastcall SetMarker(const TsgMarker* Value);
	void __fastcall SetRect(const Types::TRect &R);
	void __fastcall SetShowHint(const bool Value);
	
protected:
	void __fastcall ActivateHint(void);
	DYNAMIC int __fastcall DoMouseDown(System::TObject* Sender, const Types::TPoint &APoint);
	DYNAMIC int __fastcall DoMouseUp(System::TObject* Sender, const Types::TPoint &APoint);
	DYNAMIC int __fastcall DoMouseMove(System::TObject* Sender, const Types::TPoint &APoint);
	void __fastcall Draw(const Types::TRect &R, Graphics::TCanvas* ACanvas);
	void __fastcall DrawMarkers(void);
	void __fastcall HideHint(void);
	void __fastcall MouseHandler(Messages::TWMMouse &Message);
	void __fastcall PaintHandler(Messages::TWMPaint &Message);
	virtual void __fastcall Paint(void);
	virtual void __fastcall RestoreStyle(Graphics::TCanvas* ACanvas);
	virtual void __fastcall SetStyle(Graphics::TCanvas* ACanvas);
	__property bool Capture = {read=FCapture, write=FCapture, nodefault};
	
public:
	__fastcall TsgRectangle(Controls::TWinControl* AControl);
	__fastcall virtual ~TsgRectangle(void);
	virtual void __fastcall Dispatch(void *Message);
	void __fastcall InvalidateClipRect(void);
	Types::TPoint __fastcall GetPoint(const Sgconsts::TFPoint &ACoord);
	Sgconsts::TFPoint __fastcall GetCoord(const Types::TPoint &APoint);
	Sgconsts::TFPoint __fastcall GetSnapedCoord(const Types::TPoint &APoint);
	__property Controls::TCursor Cursor = {read=GetCursor, write=SetCursor, nodefault};
	__property Graphics::TCanvas* Canvas = {read=GetCanvas};
	__property Controls::TControl* Control = {read=FControl, write=SetControl};
	__property TsgMarker* Markers[TsgMarkerTypes Index] = {read=GetMarkers};
	__property bool Active = {read=FActive, write=SetActive, nodefault};
	__property Types::TRect Rect = {read=GetRect, write=SetRect};
	__property TsgMarker* Marker = {read=FMarker, write=SetMarker};
	__property bool ShowHint = {read=FShowHint, write=SetShowHint, nodefault};
};


class PASCALIMPLEMENTATION TsgMarker : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TsgRectangle* FRectangle;
	Sgconsts::TFPoint FPosition;
	TsgMarkerTypes FID;
	Graphics::TBrush* FBrush;
	Graphics::TPen* FPen;
	Graphics::TBrush* FBrushStore;
	Graphics::TPen* FPenStore;
	Sgconsts::TFRect FRect;
	void __fastcall SetPosition(const Sgconsts::TFPoint &Value);
	void __fastcall SetID(const TsgMarkerTypes Value);
	Graphics::TCanvas* __fastcall GetCanvas(void);
	Types::TRect __fastcall GetBoundsRect();
	Types::TPoint __fastcall GetPoint();
	void __fastcall SetPoint(const Types::TPoint &Value);
	void __fastcall PenChange(System::TObject* Sender);
	Controls::TCursor __fastcall GetCursor(void);
	
protected:
	void __fastcall MouseHandler(Messages::TWMMouse &Message);
	void __fastcall PaintHandler(Messages::TWMPaint &Message);
	virtual void __fastcall Paint(void);
	void __fastcall Draw(const Types::TRect &R, Graphics::TCanvas* ACanvas);
	void __fastcall SetStyle(Graphics::TCanvas* ACanvas);
	void __fastcall RestoreStyle(Graphics::TCanvas* ACanvas);
	void __fastcall Invalidate(void);
	__property TsgRectangle* Rectangle = {read=FRectangle};
	
public:
	__fastcall TsgMarker(TsgRectangle* ARectangle);
	__fastcall virtual ~TsgMarker(void);
	__property Controls::TCursor Cursor = {read=GetCursor, nodefault};
	virtual void __fastcall Dispatch(void *Message);
	__property Sgconsts::TFPoint Position = {read=FPosition, write=SetPosition};
	__property TsgMarkerTypes ID = {read=FID, write=SetID, nodefault};
	__property Graphics::TCanvas* Canvas = {read=GetCanvas};
	__property Types::TRect BoundsRect = {read=GetBoundsRect};
	__property Types::TPoint Point = {read=GetPoint, write=SetPoint};
	__property Graphics::TPen* Pen = {read=FPen};
};


//-- var, const, procedure ---------------------------------------------------

}	/* namespace Sgrectangle */
using namespace Sgrectangle;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// sgRectangle
