
#include "aux_glut.h"
#include <stdio.h>

typedef	void GLUTCALLBACK (*cbkff)(void);

unsigned char	AuKKey[64];
int		AuKSpc[16];
cbkff		AuFKey[64];
cbkff		AuFSpc[16];
int		AuCKey=0, AuCSpc=0;

void GLUTCALLBACK auxKey(unsigned char key, int x, int y)
{
    int	N;
    for(N=0; N < AuCKey; N++)
	if (AuKKey[N]==key && AuFKey[N]!=NULL)
		(*AuFKey[N])();
    glutPostRedisplay();
//    printf("key %03d at (%d,%d)\n",key,x,y);
}

void GLUTCALLBACK auxSpec(int key, int x, int y)
{
    int	N;
    for(N=0; N < AuCSpc; N++)
	if (AuKSpc[N]==key && AuFSpc[N]!=NULL)
	    	(*AuFSpc[N])();
    glutPostRedisplay();
//    printf("spec %03d at (%d,%d)\n",key,x,y);
}

void auxKeyFunc (int key, void (GLUTCALLBACK *func)(void))
{
    int	N;

    if (key >= 0x100) { /* special section */
	if (key == AUX_LEFT) key=GLUT_KEY_LEFT;
	else if (key == AUX_RIGHT) key=GLUT_KEY_RIGHT;
	else if (key == AUX_LEFT) key=GLUT_KEY_LEFT;
	else if (key == AUX_UP) key=GLUT_KEY_UP;
	else if (key == AUX_DOWN) key=GLUT_KEY_DOWN;
	else if (key == AUX_PAGE_UP) key=GLUT_KEY_PAGE_UP;
	else if (key == AUX_PAGE_DOWN) key=GLUT_KEY_PAGE_DOWN;
	else if (key == AUX_HOME) key=GLUT_KEY_HOME;
	else if (key == AUX_END) key=GLUT_KEY_END;
	else if (key == AUX_INSERT) key=GLUT_KEY_INSERT;
	else if (key == AUX_F1) key=GLUT_KEY_F1;
	else if (key == AUX_F2) key=GLUT_KEY_F2;
	else if (key == AUX_F3) key=GLUT_KEY_F3;
	else if (key == AUX_F4) key=GLUT_KEY_F4;
	else if (key == AUX_F5) key=GLUT_KEY_F5;
	else if (key == AUX_F6) key=GLUT_KEY_F6;
	else if (key == AUX_F7) key=GLUT_KEY_F7;
	else if (key == AUX_F8) key=GLUT_KEY_F8;
	else if (key == AUX_F9) key=GLUT_KEY_F9;
	else if (key == AUX_F10) key=GLUT_KEY_F10;
	else if (key == AUX_F11) key=GLUT_KEY_F11;
	else if (key == AUX_F12) key=GLUT_KEY_F12;
// printf ("speckeyins=%d, total=%d\n",key,AuCSpc);
	for(N=0; N < AuCSpc; N++)
	    if (AuKSpc[N]==key) break;
	if (N==AuCSpc) AuKSpc[N]=key, AuFSpc[AuCSpc++]=func;
	else AuFSpc[N]=func;
    } else { /* ordinary section */
// printf ("key insert=%d, total=%d\n",key,AuCKey);
	for(N=0; N < AuCKey; N++)
	    if (AuKKey[N]==key) break;
	if (N==AuCKey) AuKKey[N]=key, AuFKey[AuCKey++]=func;
	else AuFKey[N]=func;
    }
}

typedef GLenum (GLUTCALLBACK *cbkef)(AUX_EVENTREC*);

char	AuMevnt[16];
char	AuMstat[16];
cbkef	AuMMef[16];
int	AuMCKS=0, AuMCN=0;

void GLUTCALLBACK auxMouseButton(int button, int state, int x, int y) // change buttons
{ // GLUT_LEFT_BUTTON        GLUT_UP
    int	m;
    AUX_EVENTREC z;

//	printf("\rbutton %d,%d",x,y);
    m = 1 << button;
    z.event=0;
    if (state==GLUT_UP) { AuMCKS &= ~m; z.event = AUX_MOUSEUP; }
    else if (state==GLUT_DOWN) { AuMCKS |= m; z.event = AUX_MOUSEDOWN; }
    
    for(m = 0; m<AuMCN; m++)
	if (AuMevnt[m]==z.event && (m & AuMstat[m]) && AuMMef!=NULL) {
		z.data[AUX_MOUSEX]=x;
		z.data[AUX_MOUSEY]=y;
		z.data[AUX_MOUSESTATUS]=AuMCKS;
		(*AuMMef[m])(&z);
	}
}

void GLUTCALLBACK auxMouseMotion(int x, int y) // motion in button press
{
    int	m;
    AUX_EVENTREC z;

//	printf("\rmotion %d,%d",x,y);
    for(m = 0; m<AuMCN; m++)
	if (AuMevnt[m]==AUX_MOUSELOC && AuMCKS==AuMstat[m] && AuMMef!=NULL) {
		z.event = AUX_MOUSELOC;
		z.data[AUX_MOUSEX]=x;
		z.data[AUX_MOUSEY]=y;
		z.data[AUX_MOUSESTATUS]=AuMCKS;
		(*AuMMef[m])(&z);
	}
}

void GLUTCALLBACK auxMousePos(int x, int y) // release (free) motion
{
    // do nothing
//	printf("\rposition %d,%d",x,y);
}

void auxMouseFunc (int status, int type, GLenum (GLUTCALLBACK *func)(AUX_EVENTREC*))
{
    int m;
    for(m=0; m < AuMCN; m++)
	if (AuMevnt[m]==type && AuMstat[m]==status) break;
    AuMevnt[m]=type;
    AuMstat[m]=status;
    AuMMef[m]=func;
    if(m==AuMCN) AuMCN++;
}
