/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.value;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.Title;
import org.nakedobjects.object.ValueParseException;
import org.nakedobjects.object.value.AbstractNakedValue;
import org.nakedobjects.utility.NotImplementedException;

public class Currency
extends AbstractNakedValue
implements Externalizable {
    private static final NumberFormat CURRENCY_FORMAT = NumberFormat.getCurrencyInstance();
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("#,##0.00;-#,##0.00");
    private int amount;

    public Currency() {
        this.amount = 0;
    }

    public Currency(int n, int n2) {
        this.validateAmount(n, n2);
        this.amount = n * 100 + n2;
    }

    public Currency(String string) {
        try {
            this.parse(string);
        }
        catch (ValueParseException valueParseException) {
            // empty catch block
        }
    }

    public Currency(Currency currency) {
        this.amount = currency.amount;
    }

    public void add(int n, int n2) {
        this.validateAmount(n, n2);
        this.amount += n * 100 + n2;
    }

    public void add(Currency currency) {
        this.amount += currency.amount;
    }

    public int asInt() {
        return this.amount;
    }

    public void clear() {
        throw new RuntimeException();
    }

    public void copyObject(Naked naked) {
        if (!(naked instanceof Currency)) {
            throw new IllegalArgumentException("Can only copy the value of  a Currency object");
        }
        Currency currency = (Currency)naked;
        this.amount = currency.amount;
    }

    public void divideBy(double d) {
        this.amount = (int)((double)this.amount / d);
    }

    public String getObjectHelpText() {
        return "A Currency object stored as dollars/cents, pounds/pence, euro/cents.";
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isGreaterThan(Currency currency) {
        return this.amount > currency.amount;
    }

    public boolean isLessThan(Currency currency) {
        return this.amount < currency.amount;
    }

    public boolean isNegative() {
        return this.amount < 0;
    }

    public void multiplyBy(double d) {
        this.amount = (int)((double)this.amount * d);
    }

    public void parse(String string) throws ValueParseException {
        try {
            double d = CURRENCY_FORMAT.parse(string).doubleValue();
            this.amount = (int)(d * 100.0);
        }
        catch (ParseException parseException) {
            try {
                double d = NUMBER_FORMAT.parse(string).doubleValue();
                this.amount = (int)(d * 100.0);
            }
            catch (ParseException parseException2) {
                throw new ValueParseException(parseException2, "Invalid number");
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.amount = objectInput.readInt();
    }

    public void reset() {
        throw new NotImplementedException();
    }

    public void setValue(int n, int n2) {
        this.validateAmount(n, n2);
        this.amount = n * 100 + n2;
    }

    public void setValue(Currency currency) {
        this.amount = currency.amount;
    }

    public void subtract(int n, int n2) {
        this.add(-n, -n2);
    }

    public void subtract(Currency currency) {
        this.amount -= currency.amount;
    }

    public Title title() {
        double d = (double)this.amount / 100.0;
        return new Title(CURRENCY_FORMAT.format(d));
    }

    private void validateAmount(int n, int n2) {
        if (n < 0 && n2 > 0 || n > 0 && n2 < 0) {
            throw new IllegalArgumentException("whole and part must be same sign");
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.amount);
    }

    public boolean isSameAs(Naked naked) {
        throw new NotImplementedException();
    }

    public void restoreString(String string) {
        this.amount = Integer.valueOf(string);
    }

    public String saveString() {
        return String.valueOf(this.amount);
    }
}

