/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view.border;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.StatusColor;
import org.nakedobjects.basicgui.view.TextStyle;
import org.nakedobjects.basicgui.view.ViewBorder;
import org.nakedobjects.basicgui.view.ViewColor;
import org.nakedobjects.object.NakedObject;

public class RowBorder
extends ViewBorder {
    private boolean showLabel;
    private TextStyle style = TextStyle.getStyle(1);

    public RowBorder() {
        this(true);
    }

    public RowBorder(boolean bl) {
        this.showLabel = bl;
    }

    public Insets getBorderInsets(ObjectViewer objectViewer) {
        return new Insets(0, 0, 0, 0);
    }

    public int getHeaderWidth(NakedObject nakedObject) {
        Image image = nakedObject.iconImage(16);
        Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
        int n = dimension.width + 6;
        if (this.showLabel) {
            String string = "";
            if (nakedObject.contextualTitle() != null) {
                string = nakedObject.contextualTitle();
            }
            n += 6 + this.style.getMetrics().stringWidth(string);
        }
        return n;
    }

    public void paint(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        NakedObject nakedObject = objectViewer.getObject();
        Image image = nakedObject.iconImage(16);
        Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
        Color color = StatusColor.colorFor(objectViewer.getDisplayState(), ViewColor.textNormal);
        graphics.drawImage(image, rectangle.x, rectangle.y, null);
        if (this.showLabel) {
            String string = "";
            if (nakedObject.contextualTitle() != null) {
                string = nakedObject.contextualTitle();
            }
            int n = 6;
            if (color == ViewColor.textNormal) {
                graphics.setColor(ViewColor.outlineNormal);
            } else {
                graphics.setColor(color);
            }
            graphics.setFont(this.style.getFont());
            graphics.drawString(string, rectangle.x + dimension.width + n, rectangle.y + this.style.getMetrics().getAscent() + 2);
        }
    }
}

