/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view.border;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.StatusColor;
import org.nakedobjects.basicgui.view.TextStyle;
import org.nakedobjects.basicgui.view.ViewBorder;
import org.nakedobjects.basicgui.view.ViewColor;
import org.nakedobjects.basicgui.view.border.IconBorder;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.utility.Debug;

public class InternalIconBorder
extends IconBorder {
    public InternalIconBorder() {
        super(TextStyle.getStyle(1), null);
    }

    public InternalIconBorder(int n, int n2, TextStyle textStyle, ViewBorder viewBorder) {
        super(n, n2, textStyle, viewBorder);
    }

    public InternalIconBorder(TextStyle textStyle, ViewBorder viewBorder) {
        super(textStyle, viewBorder);
    }

    public InternalIconBorder(ViewBorder viewBorder) {
        super(TextStyle.getStyle(1), viewBorder);
    }

    protected String getTitle(NakedObject nakedObject) {
        if (nakedObject.title() == null) {
            return "";
        }
        return nakedObject.title().toString();
    }

    public Insets insets(NakedObject nakedObject) {
        Dimension dimension = this.getIconDimension(nakedObject);
        return new Insets(dimension.height + 4, dimension.width + 6, 0, 0);
    }

    public void paint(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        NakedObject nakedObject = objectViewer.getObject();
        Color color = StatusColor.colorFor(objectViewer.getDisplayState(), ViewColor.textNormal);
        Image image = nakedObject.iconImage(16);
        Dimension dimension = this.getIconDimension(nakedObject);
        String string = this.getTitle(nakedObject);
        if (image == null) {
            graphics.setColor(Color.gray);
            graphics.fillRect(rectangle.x + 1, rectangle.y, dimension.width - 1, dimension.height - 1);
        } else {
            graphics.drawImage(image, rectangle.x + 1, rectangle.y, null);
        }
        graphics.setColor(color);
        graphics.setFont(this.style.getFont());
        FontMetrics fontMetrics = this.style.getMetrics();
        int n = rectangle.y + dimension.height / 2;
        graphics.drawString(string, rectangle.x + dimension.width + 6, n + fontMetrics.getAscent() / 2);
        if (color == ViewColor.textNormal) {
            graphics.setColor(ViewColor.outlineNormal);
        } else {
            graphics.setColor(color);
        }
        this.paintBorder(graphics, rectangle, objectViewer);
        if (Debug.DISPLAY_OID) {
            graphics.setColor(ViewColor.debugLabel);
            graphics.setFont(TextStyle.getStyle(6).getFont());
            graphics.drawString(String.valueOf(objectViewer.getObject().getOid()), 5 + rectangle.x + dimension.width + 6 + this.style.getMetrics().stringWidth(string), n + fontMetrics.getAscent() / 2);
        }
    }

    public String toString() {
        return "InternalIconBorder" + super.toString();
    }
}

