; *****************************************************************************
; client.asm
; *****************************************************************************

client      segment     byte
    assume cs:client, ds:client, es:client
    org 100h

start:
    mov ah, 9                   ; print message
    lea dx, message
    int 21h

    push es                     ; turn off numlock
    xor ax, ax
    mov es, ax
    and byte ptr es:[417h], 0dfh
    pop es

    cmp byte ptr ds:[80h], 0    ; check if there is a parameter
    je no_parameter
    mov ax, ds:[82h]
    and ah, 0dfh                ; convert to upcase
    cmp ax, 'U/'                ; check /u
    je uninstall_client
    cmp ax, 'K/'                ; check /k
    je show_key
no_parameter:
    jmp install_or_update

uninstall_client:
    mov ax, 0ffffh              ; check presence
    int 10h
    cmp ax, 0eeeeh
    jne not_installed

    push ds                     ; restore int 10 and 16
    mov ax, 2510h
    lds dx, es:int_10
    int 21h
    mov ax, 2516h
    lds dx, es:int_16
    int 21h
    pop ds

    mov ah, 49h                 ; remove client from memory
    int 21h

    lea dx, removed             ; exit
    jmp exit_with_message

not_installed:                  ; exit
    lea dx, not_instalmsg
    jmp exit_with_message

show_key:
    mov ah, 9                   ; print message
    lea dx, show_key1
    int 21h

    xor ah, ah                  ; get key
    int 16h
    push ax

    mov ah, 9                   ; print message
    lea dx, show_key2
    int 21h

    pop dx                      ; write hexadecimal word
    mov cx, 4
write_hex_loop:
    push cx
    mov cl, 4
    rol dx, cl
    pop cx
    mov bx, dx
    and bx, 000fh
    push dx
    mov dl, hex_num[bx]
    mov ah, 2
    int 21h
    pop dx
    loop write_hex_loop

    mov ah, 9                   ; print message
    lea dx, show_key3
    int 21h
    jmp show_key

install_or_update:
    mov ax, 3d20h               ; open data file
    lea dx, datafile
    int 21h
    lea dx, data_error
    jc exit_with_message
    mov bx, ax

    mov ah, 3fh                 ; read to 64k boundary
    lea dx, data
    mov cx, 0ffffh
    sub cx, dx
    int 21h
    lea dx, data_error
    jc exit_with_message

    mov ah, 3eh                 ; close file
    int 21h

    call get_events             ; get events and actions

    mov ax, 3d20h               ; open key file
    lea dx, keyfile
    int 21h
    lea dx, key_error
    jc exit_with_message
    mov bx, ax

    mov ah, 3fh                 ; read to 64k boundary
    mov dx, di
    mov cx, 0ffffh
    sub cx, dx
    int 21h
    lea dx, key_error
    jc exit_with_message

    mov ah, 3eh                 ; close file
    int 21h

    call get_keys               ; get key and actions

    mov ax, 0ffffh              ; update or install client
    int 10h
    cmp ax, 0eeeeh
    jne install_client

update_client:
    mov cx, di                  ; copy data to old program
    lea si, start_block
    mov di, si
    sub cx, si
    rep movsb

    lea dx, data_copied         ; exit

exit_with_message:              ; print message and exit
    mov ah, 9
    int 21h
    int 20h

install_client:
    mov ah, 9                   ; print message
    lea dx, installed
    int 21h

    mov ax, ds:[2ch]            ; free environment
    mov es, ax
    mov ah, 49h
    int 21h

    mov ax, 3510h               ; get int 10
    int 21h
    mov word ptr int_10, bx
    mov bx, es
    mov word ptr int_10[2], bx

    mov ax, 3516h               ; get int 16
    int 21h
    mov word ptr int_16, bx
    mov bx, es
    mov word ptr int_16[2], bx

    mov ax, 2510h               ; set int 10
    lea dx, int_10_handler
    int 21h

    mov ax, 2516h               ; set int 16
    lea dx, int_16_handler
    int 21h

    mov dx, 0ffffh              ; stay resident
    int 27h

; *****************************************************************************
; function: get_events
; *****************************************************************************
get_events:
    lea si, data                ; point si and di to buffer, reset counter bx
    mov di, si
    xor bx, bx

search_event:
    mov al, '"'                 ; search for "
    call search_for

    cmp byte ptr [si], '"'      ; check end of file
    je end_of_data_file

    shl bx, 1                   ; initialize variables
    mov event_p[bx], di
    shr bx, 1
    mov event_c[bx], 0

search_first_char:              ; ignore leading wildcards
    cmp byte ptr [si], '*'
    jne copy_event
    inc si
    jmp search_first_char

copy_event:                     ; copy event to buffer
    lodsb
    call toupper
    cmp al, '"'
    je end_event
    stosb
    jmp copy_event
end_event:
    xor al, al
    stosb

    mov al, '"'                 ; search for next "
    call search_for

copy_action:                    ; copy action
    lodsb
    cmp al, '"'
    je end_action
    stosb
    jmp copy_action
end_action:
    mov al, 13                  ; terminate with CR
    stosb

    inc bx                      ; search for next event
    cmp bx, 201
    jne search_event

    lea dx, too_many_event      ; exit
    jmp exit_with_message

end_of_data_file:
    mov event_n, bx             ; save number of events stored
    ret

; *****************************************************************************
; function: get_keys
; *****************************************************************************
get_keys:
    mov si, di                  ; point si and di to buffer, reset counter bx
    xor bx, bx

search_key:
    mov al, '\'                 ; search for \
    call search_for

    cmp byte ptr [si], '\'      ; check end of file
    je end_of_key_file

    mov cx, 4
    xor dx, dx

convert_number:
    push cx                     ; shift nibble left
    mov cl, 4
    shl dx, cl
    pop cx

    lodsb                       ; load character
    call toupper

    cmp al, 'A'                 ; check letter
    jb not_letter
    cmp al, 'F'
    ja not_letter
    sub al, 'A'-0ah
    jmp end_conversion

not_letter:
    cmp al, '0'                 ; check number
    jb not_number
    cmp al, '9'
    ja not_number
    sub al, '0'
    jmp end_conversion

not_number:
    lea dx, not_hex             ; exit
    jmp exit_with_message

end_conversion:
    add dl, al                  ; add nibble
    loop convert_number

    shl bx, 1
    mov key_c[bx], dx           ; save keycode
    mov key_p[bx], di           ; save location
    shr bx, 1

    mov al, '"'                 ; search for "
    call search_for

copy_macro:                     ; copy macro for key
    lodsb
    cmp al, '"'
    je end_macro
    stosb
    jmp copy_macro
end_macro:
    mov al, 13                  ; terminate with CR
    stosb

    inc bx                      ; search for next key
    cmp bx, 201
    jne search_key

    lea dx, too_many_key        ; exit
    jmp exit_with_message

end_of_key_file:
    mov key_n, bx               ; save number of keys
    ret

; *****************************************************************************
; function: int_10_handler
; *****************************************************************************
int_10_handler:
    cmp ax, 0ffffh              ; handle test function
    jne not_test_function
    mov ax, cs
    mov es, ax
    mov ax, 0eeeeh
    iret
not_test_function:

    pushf                       ; push regs
    push ax
    push bx
    push cx
    push dx
    push si
    push di
    push ds
    push es

    mov dx, cs                  ; point ds and es to this segment
    mov ds, dx
    mov es, dx

    cld                         ; direction up

    cmp ah, 9                   ; check write char function
    jne normal_int_10
    cmp buffer, 0               ; check buffered input enabled
    je normal_int_10
    cmp trigger, 1              ; check triggering enabled
    jne normal_int_10
    cmp event_n, 0              ; check if there are events
    je normal_int_10

    call check_event            ; trigger

normal_int_10:
    pop es                      ; pop regs
    pop ds
    pop di
    pop si
    pop dx
    pop cx
    pop bx
    pop ax
    popf
    jmp cs:int_10

; *****************************************************************************
; function: int_16_handler
; *****************************************************************************
int_16_handler:
    pushf                       ; push regs
    push ax
    push bx
    push cx
    push dx
    push si
    push di
    push ds
    push es

    mov ax, cs                  ; point ds and es to this segment
    mov ds, ax
    mov es, ax

    cld                         ; direction up

    call buffer_on_off          ; check for Alt-B

    cmp buffer, 0               ; check if buffered input is enabled
    je no_key_scan

    call check_key              ; check if there is a new key in the buffer

    call write_line             ; write new line

no_key_scan:
    pop es                      ; pop regs
    pop ds
    pop di
    pop si
    pop dx
    pop cx
    pop bx
    pop ax
    popf

    cmp cs:buffer, 0            ; check if buffer is on or off
    je buffer_is_off

    or ah, ah                   ; check functions
    je get_key
    cmp ah, 10h
    je get_key
    cmp ah, 1
    je scan_key
    cmp ah, 11h
    je scan_key

buffer_is_off:
    jmp cs:int_16               ; do original int

get_key:
    push bx                     ; return key from buffer
    mov bx, cs:output_e
    sub bx, cs:output_b
    jnz key_in_buffer
    pop bx                      ; try again if there is no key
    jmp int_16_handler
key_in_buffer:
    mov bx, cs:output_b
    mov al, cs:output[bx]
    cmp al, 0ffh                ; check special code
    jne not_special_enter
    mov al, 13
not_special_enter:
    xor ah, ah
    inc bx
    and bx, 3ffh
    mov cs:output_b, bx
    or al, al
    pop bx
    sti
    retf 2

scan_key:
    push bx                     ; push regs
    push ds
    push es
    push cs                     ; point ds to this segment
    pop ds
    xor ax, ax                  ; point es to bios variables
    mov es, ax
    mov bx, output_e            ; check char in buffer
    sub bx, output_b
    jz exit_scan_key
    mov bx, output_b            ; get char
    mov al, output[bx]
    cmp al, 0ffh                ; check special code
    je special_enter_code
    xor ah, ah
    or al, al                   ; set NZ
exit_scan_key:
    pop es
    pop ds
    pop bx
    sti
    retf 2

special_enter_code:
    cmp wcount_h, -1            ; check if wait loop is active
    je wait_not_active
    mov ax, wcount_l            ; check if loop is finished
    mov bx, wcount_h
    sub ax, es:[46ch]
    sbb bx, es:[46eh]
    jc end_wait_loop
    xor al, al                  ; no key in buffer until then
    jmp exit_scan_key

end_wait_loop:                  ; key in buffer
    mov wcount_h, -1
    mov al, 13
    or al, al
    jmp exit_scan_key

wait_not_active:                ; initialize counter
    mov ax, es:[46ch]
    mov bx, es:[46eh]
    add ax, 4
    adc bx, 0
    mov wcount_l, ax
    mov wcount_h, bx
    xor al, al                  ; no key in buffer
    jmp exit_scan_key

; *****************************************************************************
; function: check_event
; *****************************************************************************
check_event:
    mov cx, event_n             ; check strings
    xor bx, bx
check_event_loop:
    shl bx, 1
    mov si, event_p[bx]
    shr bx, 1
    mov dl, event_c[bx]
    xor dh, dh
    add si, dx
    cmp byte ptr [si], '*'
    je dont_check_character
    call toupper
    cmp al, [si]
    jne not_equal_event
dont_check_character:
    inc event_c[bx]
    cmp byte ptr [si+1], 0
    jne end_this_event

clear_all_loop:                 ; clear all other events
    mov event_c[bx], 0
    inc bx
    loop clear_all_loop

    add si, 2                   ; copy string to buffer
    mov ah, 13
    call copy_in_buffer
    ret

not_equal_event:                ; reset counter
    cmp event_c[bx], 0
    je end_this_event
    mov event_c[bx], 0
    jmp check_event_loop

end_this_event:                 ; try next event
    inc bx
    loop check_event_loop
    ret

; *****************************************************************************
; function: check_key
; *****************************************************************************
check_key:
    mov ah, 1                   ; check keyboard buffer
    call do_int_16
    jz exit_check_key

    xor ah, ah                  ; remove key from buffer
    call do_int_16

    mov si, offset key_c - 2    ; check key table
    mov cx, key_n
    jcxz not_in_table
search_key_loop:
    add si, 2
    cmp [si], ax
    loopne search_key_loop
    jne not_in_table

    add si, offset key_p - offset key_c     ; copy data to output buffer
    mov si, [si]
    mov ah, 13
    call copy_in_buffer

exit_check_key:                 ; exit
    ret

not_in_table:
    cmp ax, 1400h               ; toggle trigger
    jne not_toggle_trigger
    xor trigger, 1
    call write_status
    ret
not_toggle_trigger:

    or al, al                   ; check extended key
    jz exit_check_key

    cmp al, 8                   ; check backspace
    jne not_backspace
    cmp input_c, 0
    je exit_check_key
    dec input_c
    ret
not_backspace:

    cmp al, 13                  ; check enter
    jne not_enter
    mov bx, input_c
    lea si, input
    mov byte ptr [si+bx], 13
    mov ah, 13
    call copy_in_buffer
    mov input_c, 0
    mov lastflag, 0             ; activate repeat command
    ret
not_enter:

    cmp al, 10                  ; check ctrl-enter
    jne not_ctrl_enter
    cmp lastflag, 1             ; check if repeat is possible
    je exit_check_key
    lea si, input               ; put string in buffer
    mov ah, 13
    call copy_in_buffer
    ret
not_ctrl_enter:

    cmp input_c, 512            ; check if buffer is full
    je exit_check_key

    mov lastflag, 1             ; deactivate repeat command

    lea si, input               ; put key in buffer
    add si, input_c
    mov [si], al
    inc input_c
    ret

; *****************************************************************************
; function: write_line
; *****************************************************************************
write_line:
    call get_address            ; point es:di to display memory

    lea si, input               ; get input buffer
    mov cx, input_c             ; get number of bytes in input buffer

    cmp cx, 79                  ; compensate for overflow
    jbe start_at_1st_pos
    sub cx, 79
    add si, cx
    mov cx, 79
start_at_1st_pos:

    mov dx, 80                  ; get number of characters to clear afterwards
    sub dx, cx
    dec dx

    jcxz no_string              ; write string
    mov ah, 70h
write_string:
    lodsb
    stosw
    loop write_string
no_string:

    mov ax, 0700h               ; write cursor
    stosw

    mov cx, dx                  ; clear other chars
    mov ah, 70h
    rep stosw

    ret

; *****************************************************************************
; function: clear_line
; *****************************************************************************
clear_line:
    call get_address            ; point es:di to display

    mov ax, 0720h               ; clear line
    mov cx, 80
    rep stosw

    ret

; *****************************************************************************
; function: write_status
; *****************************************************************************
write_status:
    call get_address            ; point es:di to display memory

    lea si, trigger_en          ; get string to print
    cmp trigger, 1
    je trigger_enabled
    lea si, trigger_dis
trigger_enabled:

    mov cx, 80                  ; write string and clear rest of line
    mov ah, 70h
copy_message:
    lodsb
    stosw
    or al, al
    loopnz copy_message
    rep stosw

    mov cx, 10000               ; wait for key or delay
wait_for_key:
    mov ah, 1
    call do_int_16
    loopz wait_for_key

    call write_line             ; print input line

    ret

; *****************************************************************************
; function: buffer_on_off
; *****************************************************************************
buffer_on_off:
    mov ah, 1                   ; scan key
    call do_int_16
    jz end_buffer_on_off
    cmp ax, 3000h               ; check alt-B
    jne end_buffer_on_off
    xor ah, ah                  ; remove key
    call do_int_16
    xor buffer, 1               ; toggle buffer on or off
    jnz end_buffer_on_off
    call clear_line             ; remove line
    xor ax, ax                  ; clear counters
    mov cx, 100
    lea di, event_c
    rep stosw
end_buffer_on_off:
    ret

; *****************************************************************************
; function: search_for
; *****************************************************************************
search_for:
    push di                     ; search for al in es:si
    mov di, si
    mov cx, -1
    repne scasb
    mov si, di
    pop di
    ret

; *****************************************************************************
; function: get_address
; *****************************************************************************
get_address:
    xor ax, ax
    mov es, ax
    mov di, es:[44eh]           ; get starting address of display buffer
    mov ax, es:[463h]           ; get CRT controller port
    mov bx, 0b800h              ; set es to b000h or b800h according to monitor
    cmp ax, 3d4h
    je color_monitor
    mov bh, 0b0h
color_monitor:
    mov es, bx
    ret

; *****************************************************************************
; function: copy_in_buffer
; *****************************************************************************
copy_in_buffer:
    mov bx, output_e
copy_data:
    lodsb                       ; get next char
    mov output[bx], al          ; store char

    cmp al, '\'                 ; check \
    jne not_slash

    lodsb                       ; get next char and convert to upcase
    call toupper

    cmp al, 'N'                 ; check \n
    jne not_slash_n
    mov output[bx], 13
    jmp not_slash

not_slash_n:
    cmp al, 'P'                 ; check \p
    jne not_slash
    mov output[bx], 0ffh        ; code for enter with wait

not_slash:
    inc bx                      ; next char in buffer
    and bx, 3ffh
    cmp al, ah                  ; check end loop
    jne copy_data
    mov output_e, bx
    ret

; *****************************************************************************
; function: do_int_16
; *****************************************************************************
do_int_16:
    pushf                       ; imitate normal interrupt
    call cs:int_16
    ret

; *****************************************************************************
; function: toupper
; *****************************************************************************
toupper:
    cmp al, 'a'
    jb is_upper
    cmp al, 'z'
    ja is_upper
    sub al, 20h
is_upper:
    ret

message         db  "CLIENT.COM, (C) 1993 Jorrit Rouw.",13,10,10,'$'
show_key1       db  "Press key or break . . . $"
show_key2       db  13,"To define this key use: \$"
show_key3       db  ", ""expression""",13,10,'$'
data_error      db  "Error reading from CLIENT.DAT",13,10,'$'
key_error       db  "Error reading from CLIENT.KEY",13,10,'$'
too_many_event  db  "More than 200 events in CLIENT.DAT",13,10,'$'
too_many_key    db  "More than 200 keys in CLIENT.KEY",13,10,'$'
not_hex         db  "Hexadecimal code is invalid in CLIENT.KEY.",13,10,'$'
installed       db  "Compiled on: 11 november 1993.",13,10,10
                db  "Client installed.",13,10,'$'
not_instalmsg   db  "Client not found in memory.",13,10,'$'
removed         db  "Client removed from memory.",13,10,'$'
data_copied     db  "New data copied to memory.",13,10,'$'
trigger_en      db  "Triggering now enabled.",0
trigger_dis     db  "Triggering now disabled.",0
hex_num         db  "0123456789ABCDEF"

datafile    db  "CLIENT.DAT",0
keyfile     db  "CLIENT.KEY",0

int_10      dd  ?
int_16      dd  ?

trigger     db  1
buffer      db  0

input_c     dw  0
input       db  512 dup (?)

lastflag    db  1

wcount_l    dw  ?
wcount_h    dw  -1

output_b    dw  0
output_e    dw  0
output      db  1024 dup (?)

start_block:

key_n       dw  ?
key_c       dw  200 dup (?)
key_p       dw  200 dup (?)

event_n     dw  ?
event_p     dw  200 dup (?)
event_c     db  200 dup (?)

data:

client      ends
    end     start
