(*--------------------------------------------------------------------------*)
(*                     PowerI -- raise real to integer power                *)
(*--------------------------------------------------------------------------*)

FUNCTION PowerI( x: REAL; i: INTEGER ) : REAL;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*      Function:  PowerI                                                   *)
(*                                                                          *)
(*      Purpose:   Performs exponentiation of real to integer power.        *)
(*                                                                          *)
(*      Calling Sequence:                                                   *)
(*                                                                          *)
(*         Powval := Power( x : REAL; i: INTEGER ) : REAL;                  *)
(*                                                                          *)
(*            x      --- base                                               *)
(*            i      --- power to raise base to                             *)
(*                                                                          *)
(*      Calls:     None                                                     *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

VAR
   Temp: REAL;
   AbsI: INTEGER;

BEGIN (* PowerI *)

   IF i < 0 THEN
      BEGIN
         i := -i;
         IF x <> 0.0 THEN x := 1.0 / x;
      END;

   Temp := 1.0;

   WHILE( i > 0 ) DO
      BEGIN

         WHILE ( NOT ODD( i ) ) DO
            BEGIN
               i := i DIV 2;
               x := x * x;
            END;

         i    := i - 1;
         Temp := Temp * x;

      END;

   PowerI := Temp;

END   (* PowerI *);

